#ifndef __W83977FA_H__
#define __W83977FA_H__

// define bit mapping
// On-Now Register 3(bank2, 0x4b)
#define W83977_PWRBTN_STS		0x20

// define the enable bit of wake-up event
// On-Now Register 2(bank2, 0x4a)
#define PSON_MOUSE_CLK			0x80
#define PSON_KEYBOARD_CLK		0x40
#define PSON_RIB			0x20
#define PSON_RIA			0x10
#define PSON_PHRI			0x08
#define PSON_WAKEUP_INPUT2		0x04
#define PSON_WAKEUP_INPUT1		0x02
#define PSON_ALARMB			0x01

// Define Alarm B Register Index
// On-Now Register (bank2)
#define ALARMB_SECOND_REG		0x41
#define ALARMB_MINUTE_REG		0x42
#define ALARMB_HOUR_REG			0x43
#define ALARMB_WDAY_REG			0x44	// Day of Week
#define ALARMB_MDAY_REG			0x45	// Date of Month
#define ALARMB_MONTH_REG		0x46
#define ALARMB_YEAR_REG			0x47
#define ALARMB_CENTURY_REG		0x48

// Declare Wake-up data structure
// All time related fields are stored in BCD format.
typedef struct {
	int mask;
	unsigned char century, year;
	unsigned char month, mday;
	unsigned char hour, minute, second;
	unsigned char wday;
} WAKE_UP_DATE;

// Determine which fields are valid.
#define ALARM_SECOND			0x01
#define ALARM_MINUTE			0x02
#define ALARM_HOUR			0x04
//#define ALARM_WDAY			0x08
//#define ALARM_MDAY			0x10
#define ALARM_MDAY			0x08
#define ALARM_WDAY			0x10
#define ALARM_MONTH			0x20
#define ALARM_YEAR			0x40
#define ALARM_CENTURY			0x80

#ifdef __KERNEL__
void Init_W83977FA();
void W83977_Get_Power_Button_Status(unsigned char *status);
void W83977_Get_Wake_Up_Event(unsigned char *event_src);
void W83977_Set_Wake_Up_Event(unsigned char event_src);
void W83977_Get_Wake_Up_Date(WAKE_UP_DATE *wakeup);
int  W83977_Set_Wake_Up_Date(WAKE_UP_DATE *wakeup);
#endif

#endif	// __W83977FA_H__
