#ifndef __W8378X_H__
#define __W8378X_H__

//  define hardware monitor chip id
#define W83781				0x10
#define W83782				0x30
#define W83783				0x40
#define W83627				0x21
#define W83697				0x60

// Define register index for ISA access
#define HWMON_ADDRESS			0x05
#define HWMON_DATA			0x06

// Define host interface for SMBus controller of PIIX4
#define SMB_HOST_STATUS		0
#define SMB_SLAVE_STATUS	1
#define SMB_HOST_CTRL		2
#define SMB_HOST_CMD		3
#define SMB_HOST_ADDR		4
#define SMB_HOST_DATA0		5
#define SMB_HOST_DATA1		6
#define SMB_BLOCK_DATA		7

#define SMB_FAILED		0x10
#define SMB_BUS_COLLISION	0x08
#define SMB_DEVICE_ERROR	0x04
#define SMB_INTERRUPT		0x02
#define SMB_HOST_BUSY		0x01

#define SMB_START		0x40
#define SMB_KILL		0x02

#define SMB_BYTE_DATA_RW	0x08

#define SMB_ERROR		SMB_FAILED | SMB_BUS_COLLISION | SMB_DEVICE_ERROR | SMB_INTERRUPT

#define PORTB			0x61
#define PORTB_REFRESH		0x10


// Define register index
#define HMREG_FAN_DIVISOR	0x47
#define HMREG_PIN_CTRL		0x4b
#define HMREG_BANK_SELECT	0x4e

// Bank 0
#define HMREG_CHIP_ID		0x58
#define HMREG_PWMOUT2_CTRL	0x5a
#define HMREG_PWMOUT1_CTRL	0x5b
#define HMREG_VBAT_CTRL		0x5d
#define HMREG_PWMOUT3_CTRL	0x5e	// available if the chip is configured as ISA access
#define HMREG_PWMOUT4_CTRL	0x5f	// available if the chip is configured as ISA access

// Bank 1
#define HMREG_TEMP2_HIGH	0x50
#define HMREG_TEMP2_LOW		0x51

// Bank 2
#define HMREG_TEMP3_HIGH	0x50
#define HMREG_TEMP3_LOW		0x51

// Bank 5
#define HMREG_5VSB		0x50

// Value RAM index
enum {
	VRAM_VCORE,
	VRAM_VINR0,
	VRAM_P33V,
	VRAM_P5V,
	VRAM_P12V,
	VRAM_N12V,
	VRAM_N5V,
	VRAM_TEMP,
	VRAM_FAN1,
	VRAM_FAN2,
	VRAM_FAN3,
	VRAM_END
};

// define abstract access interface
typedef unsigned char (*READ_BYTE)(int);
typedef void (*WRITE_BYTE)(int, unsigned char);

#ifdef __KERNEL__
// Declare function prototype for driver use.
int  Init_W78x();
void W8378X_Get_Hardware_Status(HARDWARE_STATUS *hwstatus);
void W83697_Get_Hardware_Status(HARDWARE_STATUS *hwstatus);
void W83627_Get_Hardware_Status(HARDWARE_STATUS *hwstatus); // added by Albert
#endif

#endif	// __W8378X_H__
