#ifndef NAS_USER_GROUP_H

#define NAS_USER_GROUP_H
#include "NAS.h"

#define PDC_GROUP_FILE		"/etc/config/pdcgroup"
#define NAS_USER_PDC_CMT	"pdc"	// a user imported from PDC
#define NAS_USER_LOCAL_CMT	"local"	// a local user
#define NAS_USER_BOTH_CMT	"both"	// a user exists in both local & PDC

typedef enum {
	NAS_USER_GROUP_NONE=0,
	NAS_USER_GROUP_LOCAL,
	NAS_USER_GROUP_PDC, 
	NAS_USER_GROUP_BOTH
} NAS_USER_GROUP_TYPE;

typedef struct tUSER_DATA {
	char			*name;		// user name
	char			*passwd;	// user password
	char			*group;		// user's primary group name
	char			*home_dir;	// user's home directory
	NAS_USER_GROUP_TYPE	type;		// user type: local/PDC/both
#ifdef __QNAP_NAS_ADS__
	uid_t			uid;		// if this value is not positive, then its generated automatically
#endif
} USER_DATA;

typedef struct tagGroupNode {
	char			groupname[GROUP_NAME_LENGTH];
	struct tagGroupNode	*next;
} GROUP_LIST;

typedef struct tGROUP_DATA {
	char			*name;
	NAS_USER_GROUP_TYPE	type;		// user type: local/PDC/both
	gid_t			gid;		// if this value is not positive, then its generated automatically
} GROUP_DATA;


NAS_USER_GROUP_TYPE NAS_Get_User_Type(char* user_name);
NAS_USER_GROUP_TYPE NAS_Get_Group_Type(char* grp_name);
int Create_System_User_Ex(USER_DATA *u);
int Get_NAS_User_List_Ex(char (**user_list_ptr)[USER_NAME_LENGTH]); // Get all non-hidden users no matter what type
int Get_NAS_Group_List_Ex(char (**group_list_ptr)[GROUP_NAME_LENGTH]); // Get all non-hidden groups no matter what type
void Release_List(void* list_ptr); // Release the memory allocated for list_ptr
int Get_NAS_Group_Info_Ex(NAS_GROUP_INFO *group_info_ptr);
int Get_NAS_User_List_Of_Group_Ex(char *group_name, char (**user_list_ptr)[USER_NAME_LENGTH]);
int Get_NAS_Group_List_Of_User_Ex(char *user_name, char (**group_list_ptr)[GROUP_NAME_LENGTH]);

#ifdef	LARGE_NO_OF_USERS_SUPPORT
int Create_System_User_Ex_2(USER_DATA *u, BOOL update_flash); 
#endif

#ifdef __QNAP_NAS_ADS__
int Create_System_Group_Ex(GROUP_DATA *g, BOOL update_flash);
#endif // __QNAP_NAS_ADS__

#endif
