#define SHMKEY		1123
#define SHMSIZE		20480

#define MAX_TIME	300
#define LOCK_TIMEOUT	5

#define SHM_FAIL		-1
#define SHM_SUCCESS		0
#define SHM_USER_NOT_FOUND	-2
#define SHM_SIZE_NOT_ENOUGH	-3
#define SHM_NO_USER		-4
#define SHM_ADD_FAIL		-5
#define SHM_NOT_ENOUGH		-6
#define SHM_LOCK_FAIL		-7
#define SHM_APP_REG_FULL	-8
#define SHM_FULL		-9

#define VALID		0
#define INVALID		1

#define USER_START	1
#define USER_NEXT	2

#define SCHEDULE_NONE		0
#define SCHEDULE_TIMEOUT	1
#define SCHEDULE_PID		2
#define SCHEDULE_NO_TIMEOUT	3

#define SHM_APP_ALL		-1

typedef struct
{
	// 2005.04.27, Johnson Cheng
	// For unicode support, at least 32/2*9+1 = 145
        //char            username[33];
        //char            sharename[33];
        char            username[256];
        char            sharename[256];
        char            ip[20];
        time_t          logintime;
        time_t          lasttime;
        int             index;
        int             app_id;
	int		schedule;
	int		pid;
} USER_INFO;

typedef struct
{
	char		regname[16];
	int		id;
} APP_INFO;

typedef struct
{
	int		lock;
	int		totalrecord;
	time_t		locktime;
	USER_INFO	tmpuser;
	int		sid;
	int		totalapp;
	APP_INFO	app[10];
} USER_HEADER;

/* define LIB API */
int init_userManager();
int shm_write_current_user(USER_INFO *user);
int shm_del_user(char *username, char *ip, int app_id);
int shm_get_user(USER_INFO *new, int where, int app_id);
int shm_get_all_user(USER_INFO *new, int size, int appid);
int shm_add_user(USER_INFO *new);
int shm_get_app_id(char *appname);
int shm_get_all_app(APP_INFO *app, int *cnt);

