//**************************************************************************
//
//	Copyright (c) 2001  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		storage.h
//
//	Abstract: 
//		Header for storage library functions.
//
//	HISTORY:
//		2002/08/06	Catherine Shen add "PARTITIONS_STAT_FILE"
//		2002/02/20	Catherine Shen
//					added 'VOLUME_CONF_EX' & 'VOLUME_INFO_EX'
//		2001/5/14	Louis Tsai created
//
//**************************************************************************
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "Util.h"

#ifndef NAS_STORAGE_LIB_H
#define NAS_STORAGE_LIB_H

#define IDE_UNKNOWN	0
#define IDE_PDC20262	1
#define IDE_PDC20265	2

#define BADBLOCKS_STOP			0
#define BADBLOCKS_SCANNING		1

//-------------------	Command string	------------------------------------//
#define CMD_FDISK	"/sbin/fdisk"
#define CMD_E2FSCK	"/sbin/e2fsck"
#define CMD_MKE2FS	"/sbin/mke2fs"
#define CMD_REIFSCK	"/sbin/reiserfsck"
#define CMD_REISERMKFS	"/sbin/mkreiserfs"
#define CMD_TUNE2FS	"/sbin/tune2fs"
#define CMD_MOUNT	"/bin/mount"
#define CMD_UMOUNT	"/bin/umount"
#define CMD_MKSWAP	"/sbin/mkswap"
#define CMD_SWAPON	"/sbin/swapon"
#define CMD_SWAPOFF	"/sbin/swapoff"
#define CMD_MKRAID	"/sbin/mkraid"
#define CMD_RAIDSTOP	"/sbin/raidstop"
#define CMD_RAIDSTART	"/sbin/raidstart"
#define CMD_RAIDHOTADD	"/sbin/raidhotadd"

//-------------------	Config file path -----------------------------------//
#define	MOUNT_TABLE_PATH	"/proc/mounts"
#define MTAB_PATH		"/etc/mtab"
#define RAID_CONF_FILE		"/etc/raidtab"
#define MDADM_CONF_FILE		"/etc/config/mdadm.conf"
#define	RAID_STAT_FILE		"/proc/mdstat"
#define SWAPON_FILE		"/proc/swaps"
#define EXT_STORAGE_CONF	"/etc/config/external_storage.conf"
#define STORAGE_CONF		"/etc/config/storage.conf"
#define STORAGE_CONF_BAK	"/etc/config/storage.conf.bak"
#define HOTPLUG_HD1_TMP_FILE	"/tmp/HDA"
#define HOTPLUG_HD2_TMP_FILE	"/tmp/HDB"
#define HOTPLUG_HD3_TMP_FILE	"/tmp/HDC"
#define HOTPLUG_HD4_TMP_FILE	"/tmp/HDD"
#define	PARTITIONS_STAT_FILE	"/proc/partitions"
#define BADBLOCKS_CONF_PATH		"/etc/config/badblocks.conf"
#define BADBLOCKS_LOG_PATH		"/mnt/HD%s_ROOT/badblocks.log"

//-------------------  define field name in uLinux.conf -------------------//
#define	SWAP_SESSION_NAME     	"Swap"
#define SWAP_ENABLE_FIELD_NAME  "Enable"
#define NASCONF_STORAGE_SECTION	"Storage"
#define NASCONF_DRIVE_NO_FIELD	"Disk Drive Number"
#define NASCONF_DIKS_CHECK_FIX	"Auto Fix Disk Check Errors"
#define NASCONF_DEBUG		"NAS DEBUG"
#define NASCONF_HOTSWAP		"SUPPORT HOTSWAP"
//Shone added Bad block definition 2005,11,01
#define BAD_BLACK_SECTION       "Bad Block"
#define BAD_BLACK_FIELD_HEAD    "Bad Block Count "
//-------------------- define reserved share name -----------------------//
#define SHARE_ESATA		"eSATA Disk 1"
#define SHARE_USB_PREFIX	"USB Disk "
//--------------------  Define Volume Status String--------------------------------//
#define S_QRAID1_FAILED		-14
#define S_STOPPING		-13
#define S_SATA_NOT_READY	-12
#define S_QRAID1_UNMATCH	-11
#define S_QRAID1_RUN		-10
#define S_RW_ERROR		-9
#define S_RAID_DIED		-8
#define S_DEGRADED		-7
#define S_INVALID		-6
#define S_NOT_EXIST		-5
#define S_UNKNOW_ERROR		-4
#define S_NOT_MOUNTED		-3
#define S_NOT_ACTIVE		-2
#define S_UNINITIALIZE		-1
#define S_READY			0
#define S_INITIALIZING		1
#define	S_FORMATTING		2
#define S_SCANNING		3
#define S_CREATING_RAID		4
#define S_REMOVING_RAID		5
#define S_REBUILDING_RAID	6
#define S_SWAPPABLE		7
#define S_NOT_SWAPPABLE		8
#define S_NO_MEDIUM_FOUND	9
#define S_QRAID1		10
#define S_QRAID1_RECOVER	11

//-------------------  Define Volume condition --------------------------------//
#define VOL_OK			0	
#define VOL_NONE_EXIST		1
#define VOL_RAID_FAILED		2
#define VOL_UNKNOW_ERROR	3

//------------------ File system type	--------------------------------------//
#define	EXT2_FS			101
#define REISER_FS		102
#define EXT3_FS			103

//-----------------------  e2fsck return value	-----------------------------//
#define FSCK_OK          0	/* No errors */
#define FSCK_NONDESTRUCT 1	/* File system errors corrected */
#define FSCK_REBOOT      2	/* System should be rebooted */
#define FSCK_UNCORRECTED 4	/* File system errors left uncorrected */
#define FSCK_ERROR       8	/* Operational error */
#define FSCK_USAGE       16	/* Usage or syntax error */
#define FSCK_LIBRARY     128	/* Shared library error */

//----------------------option of e2fsck ------------------------------------//
#define  CHECK_WITH_REPAIR     1
#define  CHECK_WITHOUT_REPAIR  2

//---------------------- define constant -------------------------------------//
#define MP_LENGTH		512
#define PARTITION_NAME_LENGTH 	20
#define HD_MODEL_NAME_LENGTH 	41
#define HD_VENDOR_NAME_LENGTH   50
#define	HD_DEVICE_NAME_LENGTH 	50	// LVM support
#define MAX_DRIVE_NO		32
#define MAX_VOLUME_NO		MAX_DRIVE_NO
#define MAX_PARTITION_NO	3		// ROOT_PART, SWAP_PART, DATA_PART
#define MAX_RAID_NO		MAX_DRIVE_NO	// (volume + swap) RAID device no#define MAX_RAID_NO		16	//redhat 6.2
#define MAX_CMDLINE_LENGTH	256
#define SECTOR_SIZE   		512     // for Clear_MBR()
#define	RAID_RESYNC_PER_BASE	200	// Catherine 2002/06/11 to tell resync from recovery
#define	FS_BLOCK_SIZE		4096	// bytes

//---------------------- define partition name constant ----------------------//
#define ROOT_PART 1
#define SWAP_PART 2
#define DATA_PART 3
#define EXT_PART 4 //KenChen 20060227
#define ROOT_MIRROR_PART 9 //KenChen 20060228
#define NO_PART	0

#define MP_ROOT_PATH_FORMAT "/mnt/HD%s_ROOT"
#define MP_SD_DATA_PATH_FORMAT "/share/HD%s_DATA"
#define MP_RD_DATA_PATH_FORMAT "/share/%s_DATA"
#define HD_HIDDEN_CONF	"/.conf"
#define SIZE_M	1
#define SIZE_G	2

#define HD_NAME_FLAG_START 8
#define HD_NAME_FLAG_LEN 16

#define TS201_MAX_SLOT		2
#define Set_RAID_Util_PATH		"/sbin/setRaid"
#define MDADM_PATH		"/sbin/mdadm"
#define MKNOD_PATH		"/bin/mknod"
#define CONFIG_Dev		"/dev/md9"
#define MDADM_CONF_DEFAULT_DEVICE_STRING "DEVICE /dev/sd*[1-4] /dev/sd*[1-4]"
#define MD0           "/dev/md0"

//---------------------- define RAID level strings ----------------------------//
#define SINGLE		-2
#define RAID5		5
#define MIRROR		1
#define STRIPING	0
#define LINEAR		-1
#define LEVEL_NONE 	-10

//-------------------------- define Model Name/Number ------------------------//
#define TS_101_MODEL_NAME		"TS-101"
#define TS_201_MODEL_NAME		"TS-201"

#define TS_101_MODEL_No		101
#define TS_201_MODEL_No		201

//-----------------------------------------------------------------------------//

#define ERROR_PATH_NOT_EXIST	-100
#define ERROR_CANT_UMOUNT	-101
#define ERROR_FORMAT_FAIL	-102

//-----------------------------------------------------------------------------//

typedef struct PARTITION_DATA {
	int	sys_id;
	BOOL	is_boot;	
	int	part_no;		// 1~4
	int	capacity_format;	// SIZE_M(mega) or SIZE_G(giga)
	int 	capacity_val;		
}PARTITION_DATA;

typedef struct PARTITION_ITEM {
	char 	part_name[PARTITION_NAME_LENGTH];
	BOOL	is_boot;
	unsigned long start_cylinder;
	unsigned long end_cylinder;
	unsigned long blocks;
	int	sys_id;	 
} PARTITION_ITEM;

typedef struct PARTITION_TABLE {
	unsigned long total_cylinders;
	unsigned long per_cylinder_size; //Kbytes
	int	item_cnt;
	PARTITION_ITEM item_list[MAX_PARTITION_NO];
}PARTITION_TABLE;

typedef struct DISK_INFO {
	char	model_name[HD_MODEL_NAME_LENGTH];
	int	type;
	union {
		struct {/* Host / Channel / SCSI ID / LUN */
			int	host;
			int	channel;
			int	id;
			int	lun;
		} scsi_dev_info;
		struct {/* Cylinder / Head / Sector */
			int	cylinder;
			int	head;
			int	sector;
		} ide_dev_info;
	} device_info;
	double	capacity;	/** unit is K bytes **/
	int	status;
}DISK_INFO;

typedef struct PARTITION_INFO {
       double   total_size;     /** unit is K bytes **/
       double   usage_size;     /** unit is K bytes **/
       double   free_size;      /** unit is K bytes **/
}PARTITION_INFO;


typedef struct VOLUME_CONF{
	int	vol_no;
	char	device_name[HD_DEVICE_NAME_LENGTH];//if not raid , = NULL
	int	raid_level;	//-2:single,-1:linear
	int	drive_no_list[MAX_DRIVE_NO]; //NAS drive number belong to this volume
	int	list_cnt; // member hd cnt
	int	status;
}VOLUME_CONF;

typedef struct VOLUME_INFO{
	VOLUME_CONF 	vol_data;
	double  	total_size;
	double  	free_size;
	int 		resync_per;
//	char 		mount_path[32];
}VOLUME_INFO;


typedef struct RAID_DEVICE {
   	char name[HD_DEVICE_NAME_LENGTH];
  	char raid_level[7];    // like as 0, 1, 5 or linear
  	int data_drive_cnt;
  	int data_drive_no[MAX_DRIVE_NO];        
  	int spare_drive_cnt;
  	int spare_drive_no[MAX_DRIVE_NO];     
}RAID_DEVICE;

typedef struct RAID_STATUS {
	char name[HD_DEVICE_NAME_LENGTH];
  	int  config_drive_cnt;
  	int  config_drive_no[MAX_DRIVE_NO];
  	int  active_drive_cnt;
  	int  active_drive_no[MAX_DRIVE_NO]; 
  	int  resync_per;  /*- if it=RAID_NO_RESYNC, represent no any resync actione doing -*/
} RAID_STATUS;

/*typedef struct MOUNT_VOL_INFO {	
	int raid_level;
  	int drive_no_list[MAX_DRIVE_NO]; //NAS drive number belong to this volume
  	int list_cnt; // member hd cnt
	char mount_path[32];	
}MOUNT_VOL_INFO;
*/
/* Catherine 2002/02/20 ==> */
typedef struct VOLUME_CONF_EX{
	int	vol_no;
	char	device_name[HD_DEVICE_NAME_LENGTH];//if not raid , = NULL
	int	raid_level;	//-2:single,-1:linear
	int	drive_no_list[MAX_DRIVE_NO]; //NAS drive number belong to this volume
	int	list_cnt; // member hd cnt
	int	spare_drive_list[MAX_DRIVE_NO]; // spare drive numbers
	int	spare_list_cnt; // spare disk count
	int	status;
}VOLUME_CONF_EX;

typedef struct VOLUME_INFO_EX{
	VOLUME_CONF_EX 	vol_data;
	double  	total_size;
	double  	free_size;
	int 		resync_per;
}VOLUME_INFO_EX;
/* <== Catherine 2002/02/20 */

//----------------------------------- Define avaiable disk name ---------------------//

#define	IDE		0x01
#define	SCSI		0x02
#define MY_BLKGETSIZE	_IO(0x12,96)

#define SERIAL_SIZE	8
#define SATA_PROC	"/proc/scsi/SiI3512"
#define USB_PROC	"/proc/scsi/qnap_usbdev"
#define USB_PROC_FOR_HOTSWAP	"/proc/scsi/qnap_usbdev_hotswap"

#define SATA		1
#define USB		2

typedef struct
{
	char 	*dev;
	long 	size;
} DISK;

//#endif

//----------------------------------------------------------------------------------//

#define	STORAGE_FILE_LOCK

#ifdef	STORAGE_FILE_LOCK
int Add_Volume_Record_Ex_2(VOLUME_CONF_EX *vol_data, BOOL file_lock);
#endif
//------------------------- Logical volume operation function ----------------------//

/*basic operation function*/
int Create_Storage_Conf(void);
int Init_Single_Disk_Volume(int vol_no);
int Create_Raid_Volume(int *vol_no_list,int list_cnt,int raid_level);
int Quick_Create_Raid_Volume(int vol_no, int raid_level);
int Delete_Raid_Volume(int vol_no);
int Quick_Delete_Raid_Volume(int vol_no, int *, int *);
int Format_Volume(int vol_no);
int Scan_Volume(int vol_no,int action);
int Mount_Volume(int vol_no);
int Umount_Volume(int vol_no);
/* Catherine 2002/02/20 ==> */
int Create_Raid_Volume_Ex(int *vol_no_list,int list_cnt,int *spare_vol_no_list,int spare_list_cnt,int raid_level);
int Delete_Raid_Volume_Ex(int vol_no);
int Add_Volume_Record_Ex(VOLUME_CONF_EX *vol_data);
/* <== Catherine 2002/02/20 */
int Restore_Storage_Conf(void); // Catherine 2002/02/27

/*get volume information*/
int Get_All_Volumes_Conf(VOLUME_CONF *vol_data_list,int list_cnt);
int Get_One_Volume_Conf(int vol_no,VOLUME_CONF *vol_data);
int Get_One_Volume_Info(int vol_no,VOLUME_INFO *vol_info);
int Get_All_Volumes_Info(VOLUME_INFO *vol_info_list,int list_cnt);
int Get_Uninit_Disk_Volumes_Conf(VOLUME_CONF *vol_data_list,int list_cnt);
int Get_Single_Disk_Volumes_Conf(VOLUME_CONF *vol_data_list,int list_cnt);
int Get_Raid_Disk_Volumes_Info(VOLUME_INFO *vol_info_list,int list_cnt);
int Get_All_Configured_Vol_For_Share(VOLUME_INFO *config_vol,int list_cnt);
int Get_Configured_Vol_No_For_Share(char *share_name);
int Get_All_Configured_Vol_For_Share_Ex(VOLUME_INFO **mount_vol_ptr);
int Get_All_Volumes_Info_Ex(VOLUME_INFO **vol_info_list_ptr);
int Get_All_Volumes_Conf_Ex(VOLUME_CONF **vol_data_list_ptr);
int Get_Uninit_Disk_Volumes_Conf_Ex(VOLUME_CONF **vol_data_list_ptr);
int Get_Single_Disk_Volumes_Conf_Ex(VOLUME_CONF **vol_data_list_ptr);
int Get_Raid_Disk_Volumes_Info_Ex(VOLUME_INFO **vol_info_list_ptr);
/* Catherine 2002/02/20 ==> */
int Get_All_Volumes_Info_Ex_2(VOLUME_INFO_EX **vol_info_list_ptr);
int Get_All_Configured_Vol_For_Share_Ex_2(VOLUME_INFO_EX **mount_vol_ptr);
int Get_All_Volumes_Conf_Ex_2(VOLUME_CONF_EX **vol_data_list_ptr);
int Get_One_Volume_Conf_Ex(int vol_no,VOLUME_CONF_EX *vol_data);
int Get_One_Volume_Info_Ex(int vol_no,VOLUME_INFO_EX *vol_info);
int Get_Raid_Disk_Volumes_Info_Ex_2(VOLUME_INFO_EX **vol_info_list_ptr);
/* <== Catherine 2002/02/20 */
int Quick_Config_All_Disks(int raid_level);

/*Volume configuration function*/
int Add_Volume_Record(VOLUME_CONF *vol_table);
int Remove_Volume_Record(int vol_no);
int Get_Volume_No_For_Drive(int drive_no);
int Get_Volume_Path_For_Drive(int drive_no, char* vol_path);


/*Status function*/
int Set_Volume_Status(int vol_no,int status);
int Get_Volume_Status(int vol_status);
BOOL Is_Volume_HD_Valid(int vol_no);
BOOL Is_Volume_HD_Exist(int vol_no);
BOOL Is_Spool_Partition_Ready();
BOOL Is_HD_Init();

/* ReiserFS functions */
int Get_Volume_FileSystem_Type(int vol_no);

int Get_System_HD_Type();

int Get_Disk_Sg_Map(int hdno, char* sg_name, int* host, int* channel, int* id, int* lun);
// valid only when no hotswap occurred after boot up

#ifdef DEBUG
int get_scsi_disk_info(int hdno, DISK_INFO* disk_info);
#endif

//------------------------- NAS disk operation function ----------------------------//
int Create_NAS_Partitions(int drive_no);
int Create_NAS_Partitions_Ex(char* dev_name);
int Delete_NAS_Partitions(int drive_no);
int Delete_NAS_Partitions_Ex(char* dev_name);
int Format_NAS_Partition(int drive_no,int which_part,int fs_type);
int Format_NAS_Partition_Ex(char* dev_name,int which_part,int fs_type);
int Mount_NAS_Partition(int drive_no,int which_part,int fs_type);
int Mount_NAS_Partition_Ex(char* dev_name,int which_part,int fs_type);
int Mount_NAS_Mirror_Root_Partition(int device_no,int which_part,int fs_type); //KenChen 20060227
int Unmount_NAS_Partition(int drive_no,int which_part);
int Unmount_NAS_Partition_Ex(char* dev_name,int which_part);
int Unmount_NAS_Mirror_Root_Partition(); //KenChen 20060227
int Start_Swapping(int drive_no);
int Start_Swapping_Ex(int drive_no, char* dev_name);
int Stop_Swapping(int drive_no);
int Stop_Swapping_Ex(char* dev_name);
int Init_NAS_Disk(int drive_no);
int Init_NAS_Disk_Ex(char* dev_name);
int Set_NAS_Disk_State(int drive_no);
int Clear_MBR(int drive_no);
int Clear_MBR_Ex(char* dev_name);
int Get_NAS_Disks_Info(DISK_INFO *disk_info_list,int buf_list_cnt);

int Get_One_NAS_Disk_Info(int driveno, DISK_INFO *disk_info);	// Catherine 2003/06/06

/* ReiserFS functions */
int Get_Device_FileSystem_Type(char* device);

BOOL Set_HD_RW_Error(int drvno);
BOOL Get_HD_RW_Error(int drvno);
//------------------------- Raid Operation Function --------------------------------//
int Get_RaidDev_Count(void);
int Create_RaidDev(RAID_DEVICE *rd_ptr);
int Create_Raid01Dev();
int Delete_RaidDev(char * rd_name);
int Get_All_RaidDev_Status(RAID_STATUS *rd_ptr,int rd_list_cnt);
int Get_One_RaidDev_Status(char *rd_name,RAID_STATUS *sts_rd);
BOOL Is_Raid_HD(int drive_no,char *raid_device_name,int buf_size);
BOOL Is_Active_Raid_HD(int drive_no, char *rd_name,int buf_size);
int Get_First_Available_RaidName(char *rd_name,int rd_name_len);
int Get_All_RaidDev_Conf(RAID_DEVICE *rd_list, int list_cnt);
int Get_Raid_Level(int drive_no);//-1:linear
BOOL Is_RaidDev_Exist(char *raid_name);
BOOL Is_RaidDev_Active(char *raid_name);
int Make_Raid(char *raid_name);
int MDADM_Make_Raid(char *rd_name,int *drive_no_list,int list_cnt,int raid_level); //KenChen 20060306
int MDADM_Make_Raid_Ex(char *rd_name,int *drive_no_list,int list_cnt,int *spare_drive_list,int spare_list_cnt,int raid_level); //KenChen 20060306
int Start_Raid(char *raid_name);
int Stop_Raid(char *raid_name);
int Create_NAS_RaidDev(char *rd_name,int *drive_no_list,int list_cnt,int raid_level);
int Raid_Hot_Add_Memeber_Disk(char *raid_name,char *device_name);
int Raid_Hot_Add_Force(char *raid_name,char *device_name); //KenChen20060316
int Raid_Hot_Remove_Force(char *raid_name,char *device_name); //KenChen20060323
BOOL Is_HD_Ready(int drive_no);
/* Catherine 2002/02/20 ==> */
int Create_NAS_RaidDev_Ex(char *rd_name,int *drive_no_list,int list_cnt,int *spare_drive_list,int spare_list_cnt,int raid_level);
/* <== Catherine 2002/02/20 */
BOOL Is_Raid_Busy(char* raid_name); // RAID is "resync" or "recovery"

int Set_Raid_Device_Faulty(char* md_name, char* bad_devname);

//------------------------- Interface function between logical and physical---------//
int Get_HD_DevName(int drive_no, char *device_name);//0:root_part,1:data_part,2:swap_part
int Get_Partition_Name(int drive_no, int which_part,char *part_name);
int Get_Partition_Name_Ex(char* dev_name, int which_part,char *part_name);
int Get_MP_String(int drive_no, int which_part,char *mp_name);
int Get_Drive_No(char *device_name);
int Create_Hidden_Conf_File(int drive_no);
int Create_Hidden_Conf_File_Ex(int drive_no, char* dev_name);
int Get_Hidden_Conf_File_Name(int drive_no, char *filename);
int Verify_Hidden_Conf_File(int drive_no);
BOOL Is_HD_Valid(int drive_no);
int Get_FileSystem_Type(); // 0:ext2,1:reiserfs
BOOL Is_Disk_Path_Ready( char *real_path);
int Get_Swap_RAID_No_Base(); // 2002/08/15 Catherine

//------------------------- Physical disk operation function -----------------------//
int Get_Available_Disk_Partitions(PARTITION_ITEM *partition_item_list, int list_cnt,int system_id);
int Get_Avaiilable_LVM_Partitions(PARTITION_ITEM *partition_item_list, int list_cnt);
int Create_Partitions(char *device_name,PARTITION_DATA *part_data_list,int list_cnt);
int Delete_Partitions(char *device_name, int *part_no_list,int list_cnt);
int Format_Partition(char *part_name, BOOL is_raid5,int fs_type);
int Scan_Partition(char *part_name, int action, int fs_type);
int Mount_Partition(char *part_name, char *mount_point,int fs_type);
int Unmount_Partition(char *part_name);
int Get_Disk_Info(char *device_name,DISK_INFO *disk_info);
int Get_Current_Partitions(char *device_name,PARTITION_TABLE *table);
int Get_Partition_Info(char *part_name,PARTITION_INFO *part_info);
BOOL Is_Mounted(char *part_name);
BOOL Is_HD_Exist(char *device_name);
BOOL Is_Partition_Exist(char *part_name);
int Get_Mount_Point(char *part_name,char *mp_name);
int Get_Mount_DevName(char *mount_path,char *dev_name);
BOOL Is_HD_DMA_Enabled(int drive_no);
int Enable_HD_DMA(int drive_no);
int Disable_HD_DMA(int drive_no);
int Hot_Unplug(int drive_no);
int Hot_Plug(int drive_no);
int Get_IDE_Chipset();
long Get_Dev_Blksize(char *dev);

BOOL Is_HD_ReadWrite_Safe(int drvno); // Catherine 2003/04/14
int Create_RW_Err_In_Ram(int);
BOOL Is_RW_Err_In_Ram(int);
long long sg_readcap_M(char *dev);
long long sg_readcap_M_ByNo(int no);
int Init_NAS_Single_Disk(int drive_no);
int Is_QRAID1_running();
//int Is_QRAID1_Enabled(int dev_type);
int Set_QRAID1_Disk_Status(int status);
int Init_NAS_QRAID1_Disk(int drive_no);
int Recover_NAS_QRAID1_Disk(int drive_no);
int Get_QRAID1_Disk_Status();
int Get_Disk_Status(int drive_no);
int Set_Disk_Status(int drv, int status);
int Create_Disk_Storage_Conf();

int HD_Get_Format_Progress(char *dev);
void HD_Reset_Format_Progress(char *dev);

void refresh_bus();
BOOL Is_Sata_Support();
BOOL Is_Sata_HD_Changed();
BOOL Is_Sata_HD_Exist(char *);
BOOL Is_Sata_HD_Exist_ByNo(int no);
char *SATA_Get_Model_Name();
int Have_Qnap_Flag(char*);//Shone added 

/********************************************************************/

typedef struct TS_DISK_INFO {
	int 		no;
        char    	device_name[HD_DEVICE_NAME_LENGTH];
        char    	vendor[HD_VENDOR_NAME_LENGTH];
        char    	model[HD_MODEL_NAME_LENGTH];
	int 		part_no;
        int     	sys_id;
	int 		speed;
        long long 	capacity;
	long long	free_capacity;
        int     	type;
        int     	qnap_disk;
        int     	status;
	char 		share[HD_VENDOR_NAME_LENGTH];
        struct TS_DISK_INFO *next;

} TS_DISK_INFO, *TS_DISK_INFO_P;

#ifndef MS_MGC_VAL
	#define MS_MGC_VAL              0xC0ED0000   /* magic flag number to indicate "new" flags */
#endif

#ifndef STORAGE_MAX_CNT
	#define STORAGE_MAX_CNT         8
#endif

#define SENSE_BUFF_LEN          32       /* Arbitrary, could be larger */
#define DEF_TIMEOUT             60000       /* 60,000 millisecs == 60 seconds */

#define INQUIRY_CMD             0x12
#define INQUIRY_CMDLEN          6
#define MX_ALLOC_LEN            255

#define EBUFF_SZ                256

#ifndef SCSI_IOCTL_GET_PCI
	#define SCSI_IOCTL_GET_PCI      0x5387
#endif

#define READCAP_TIMEOUT         60000   /* 60,000 milliseconds == 1 minute */
#define SENSE_BUFF_SZ           32
#define RCAP_REPLY_LEN          8
#define RCAP16_REPLY_LEN        12

#ifndef SERVICE_ACTION_IN
	#define SERVICE_ACTION_IN       0x9e
#endif
#ifndef SAI_READ_CAPACITY_16
	#define SAI_READ_CAPACITY_16    0x10
#endif

#define EBUFF_SZ                256
#define BSIZE                     64
#define NAME_LENGTH          256

#define FS_MSDOS	1
#define FS_FAT		2
#define FS_FAT16	3
#define FS_FAT32	4
#define FS_NTFS		5
#define FS_EXT2		6
#define FS_EXT3		7
#define FS_UNKNOWN	8

#define NO_FIELD	"drive no"
#define DEVICE_FIELD	"device name"
#define VENDOR_FIELD	"vendor"
#define MODEL_FIELD	"model"
#define CAPACITY_FIELD	"capacity"
#define F_CAPACITY_FIELD "free capacity"
#define STORAGE_GLOBAL_SECTION	"Global" 
#define AVAIL_FIELD	"Available Disk"
#define SPEED_FIELD	"speed"
#define TYPE_FIELD	"type"
#define	QNAPDISK_FIELD	"QNAP disk"
#define FS_FIELD	"file system"
#define PART_NO_FIELD	"partition number"
#define STATUS_FIELD	"status"
#define SHARE_FIELD	"share Name"
#define RAID_FIELD	"raid level"
#define MODE_FIELD	"mode"
#define RAID_DISKS	"raid disks"

#define USB_HIGH_SPEED  1
#define USB_LOW_SPEED   2
#define USB_FULL_SPEED  3

#define USB10	1
#define USB20	2

long long Get_Free_Disk_Size(char *filesys_path);
long long Get_NAS_Partition_Free_Size(int drive_no, int which_part);
long long Get_NAS_Data_Free_Size(int drive_no);
int Get_Sg_Serial_Number(char* device_name, char* serial_num);
int Get_Sg_Info(char* device_name, char* Vendor, char* Product, char* Revision);
int Is_USB_Host_Exist(int usb_host_no);
int Get_Disk_List_Info(TS_DISK_INFO **disk_list);
//TS_DISK_INFO **seek_entry_to_last(TS_DISK_INFO **disk_disk);
int show_list(TS_DISK_INFO *disk_disk);
void free_list(TS_DISK_INFO_P *disk_list, TS_DISK_INFO_P node);
int Mount_QNAP_Disk(int drive_no, int part, int fs);
int Get_FStype(const char *device);
int Write_Disk_Info_To_Config(TS_DISK_INFO_P disk_list);
int Get_Disk_Info_From_Config(TS_DISK_INFO_P *disk_list);
int Get_DriveNo_By_DevName(char* dev_nameP);
int get_fs_mounted(char *dev_name);
void Stop_And_Umount_Host(int drive_no);
int check_status_changed(int drive_no, int *status_array);
int Stop_And_Umount_By_Dev(char *);
void disk_opt(int drive_no, char *cmd_type);
int Set_HD_Exist(int drive_no, int exist);
int Get_HD_Exist(int drive_no);
int Get_TS_USB_Disk_Speed_Type(char *dev_name);
int add_mapping(char *dev);
int remove_mapping(char *dev);
int Main_Check_Disk();
int Stop_Check(int vol_no);
int Stop_Format(int vol_no);
float HD_Get_Check_Progress(char *dev);
void HD_Reset_Check_Progress(char *dev);
int Format_QNAP_Disk(int disk_no, int fs);
void Get_QNAP_Mount_Name(char *dev_name, char *mount_name, int part);
int Get_Share_Name(char *dev, char *share_name, int size);
int TS_Get_Sg_Map(char *vendor, char *model, int* host, int* channel, int* id, int* lun);
int TS_Eject_Disk(int disk_no);
//void Set_Host_Process_Done(int host, int finish);
//int Is_Host_Process_Done(int host);
int Plug_Dev_Action(int port, int host, int plugged_type);
void Get_TS_SATA_Model(char *model, int size);
void Get_TS_SATA_Model_Byno(int no, char *model, int size);
int atox(char *str);
//int check_usb(char *dev);
//int get_mode(char *);
//int set_mode(char *, int mode);
int sata_action(int host, int plugged_type);
void Add_Dev(char *dev_name);
int Write_One_Disk_Info_To_Config(TS_DISK_INFO_P disk_list, int disk_no);
void disconnect_samba_share_by_name(char *dev_name);
long Get_Available_Disk_Size( char *filesys_path );

int Restore_Default_Share(int device_no);
int Check_Default_Share(int drive_no);
int Is_Dir_Exist(const char *path);
int Get_Vols_Initialized();
int Get_Vol_Format_Status(int vol_no);
void Reset_Vol_Format_Status(int vol_no);
float Get_Vol_Check_Status(int vol_no);
void Reset_Vol_Check_Status(int vol_no);
void Storage_Write_Log(VOLUME_CONF vol_data, int type, void *arg);
char *Get_Volume_Message(VOLUME_CONF raid_vol_data);

int Create_RaidDev_MDADM_CONF(RAID_DEVICE *rd_ptr);
int Delete_RaidDev_MDADM_CONF(char *rd_name);

#define USB_PORT        1
#define USB_HUB_PORT1   1<<4
#define USB_HUB_PORT2   2<<4
#define USB_HUB_PORT3   4<<4
#define USB_HUB_PORT4   8<<4
#define USB_HUB_PORT5   1<<8
#define USB_HUB_PORT6   2<<8
#define USB_HUB_PORT7   3<<8

#define PLUG_IN		1
#define PLUG_OUT	2

#define FRONT	1
#define B_UPPER	2
#define B_LOWER	3

#define SHARE_MODE	1
#define RAID_MODE	2


//------------------------- Badblocks operation function ----------------------------//
int Get_Badblocks_Status(int dev_no);
int Get_Badblocks_Progress(int dev_no);
int Get_Badblocks_Num(int dev_no);
int Badblocks_Start(int dev_no);
int Badblocks_Stop(int dev_no);

int Set_Badblocks_Integer(int dev_no, char *field, int value);
int Set_Badblocks_Count(int dev_no, char *field, int value);

// -------------------Storage Event Log Management ---------------------//
enum {
        START_FORMAT=1,
        FORMAT_COMPLETE,
        FORMAT_UNKNOWN_FAIL,
	FORMAT_FAIL,
        STOP_FORMAT,

        START_INIT,
        INIT_COMPLETE,
        INIT_FAIL,

        START_REMOVE,
        REMOVE_FAIL,
        REMOVE_COMPLETE,

        SPACE_ALMOST_FULL,
        SPACE_FULL,

        START_CHECK,
        STOP_CHECK,
        CHECK_COMPLETE,
        CHECK_UNKNOWN_FAIL,
        CHECK_FAIL,

        START_SCAN,
        SCAN_COMPLETE_BAD_FOUND,
        SCAN_COMPLETE,
        STOP_SCAN,
        SCAN_FAIL,
        
        HD_INVALID_EVENT,
        
        RESTORE_DEFAULT_SHARE
};

void Storage_Write_Log(VOLUME_CONF vol_data, int type, void *arg);
#endif
