#define SHM_KEY		9998
#define SHM_SIZE	2048

typedef struct
{
	int	tag;
	char	section[256];
} SHM_MAP;

#define SHM_GET		1
#define SHM_SET		2

enum
{
	TAG_SYSTEM=0,
	TAG_STORAGE,
	TAG_MISC
};

typedef struct
{
	char	model[16];
	char	servername[16];
	char	servercomment[128];
	char	version[32];
	char	build[32];
	char	timezone[64];
	char	daylight[64];
	char	workgroup[32];
	char	system_dev[16];
	char	wan_access[16];
	char	lan_access[16];
	char	codepage[16];
	char	test_mode[16];
	char	auto_create_raid[16];
	char	www_port[16];
} TAG_SYSTEM_DATA;

typedef struct
{
	char	dev[4][16];
	char	check_on_boot[16];
	char	auto_init[16];
	char	disk_number[16];
	char	auto_fix_error[16];
	char	support_raid5[16];
	char	support_hotswap[16];
	char	dma[4][16];
	char	support_hotspare[16];
	char	nas_debug[16];
	char	debug_size[16];
} TAG_STORAGE_DATA;

typedef struct
{
	char	system_started[16];
	char	lcd[16];
	char	reset_pwd[16];
	char	disk_standby[16];
	char	buzzer[16];
} TAG_MISC_DATA;

typedef struct tagSHM_RECORD
{
	int	tag;
	int	size;
} SHM_RECORD;

typedef struct tagSHM_HEADER
{
	int	totalrecord;
} SHM_HEADER;

/* export functions	*/
int SHM_Debug_Section(char *section);
int SHM_Set_Field(char *section, char *item, char *result);
int SHM_Get_Field(char *section, char *item, char *result, int len);
int SHM_Destroy();
int SHM_Init();
