#ifndef SHM_CONF_H
#define SHM_CONF_H

#include <sys/shm.h>

//------------------------------------------------------------------------------------------------------------------------------

#define	SHM_KEY_CODEPAGE	1234
#define	SHM_CODEPAGE_SIZE	10
#define	SHM_KEY_HD1_EXIST	141
#define	SHM_KEY_HD2_EXIST	142
#define	SHM_KEY_HD3_EXIST	143
#define	SHM_KEY_HD4_EXIST	144
#define	SHM_HD_EXIST_SIZE	10
#define	MAX_WAIT_TIME		30	// the maximum time(seconds) to wait

//------------------------------------------------------------------------------------------------------------------------------
// get the value of a config item from shared memory, if exists; otherwise,
//	create a shared memory and get the item from the config file
int SHM_Get_Config(int key, int size, char* conf_file, char* section, char* field, char **value_ptr);

// set the value of a config item to both the shared memory and the config file
int SHM_Set_Config(int key, int size, char* path, char* section, char* field, char* value);

//destroy (free) the shared memory
int SHM_Free(int key, int size);

// refresh the shared memory data from the config file
int SHM_Refresh(int key, int size, char* conf_file, char* section, char* field);

#endif
