//**************************************************************************
//
//	Copyright (c) 2001  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		naspdc.h
//
//	Abstract: 
//		header file for naspdc library
//
//	HISTORY:
//		2001/7/12 Louis Tsai Created
//
//**************************************************************************

#include "NAS.h"
#include "Util.h"
#include "user_grp.h"
//#ifdef __QNAP_NAS_ADS__
//#include "nas_ldap.h"
//#endif
typedef struct
{
	char	domain[128];
	char	username[256];
	char	passwd[256];
} PDC;

#define PDC_SUCCESS	0
#define PDC_FAIL	-1

/* export functions */
#ifndef __QNAP_NAS_ADS__
int	PDC_Check_Valid(PDC *pdc);

#define CMD_NASRPC_PATH			"/usr/local/samba/sbin/nasrpc"
#endif // __QNAP_NAS_ADS__

#define CMD_USERMOD_PATH			"/usr/sbin/usermod"
#define PASS_FILE			"/etc/passwd"
#define GROUP_FILE			"/etc/group"
#define SMBPASS_FILE			"/etc/smbpasswd"
#define PASS_BACKUP_FILE		"/etc/config/passwd.bak"
#define GROUP_BACKUP_FILE		"/etc/config/group.bak"
#define SMBPASS_BACKUP_FILE		"/etc/config/smbpasswd.bak"

#define DOMAIN_NAME_LEN			128
#define SERVER_NAME_LEN			128

#ifndef __QNAP_NAS_ADS__
/* define configuration item name */
#define Conf_PDC_Section_Name 		"PDC"
#define Conf_PDC_Enable			"enable"
#define Conf_PDC_Domain_Name 		"domain name"
#define Conf_PDC_Server_Name		"server name"
#define Conf_PDC_User_Name		"legal user"
#define Conf_PDC_User_Password		"user password"
#define SAMBA_CONF_PASS_SERVER		"password server"
#define SAMBA_CONF_SECURITY		"security"
#endif // __QNAP_NAS_ADS__

/*define error value */
#define PDC_DISABLE 		-501
#define PDC_CONFDATA_ERROR 	-502
#define PDC_AUTH_FAIL 		-503
#define PDC_SYSTEM_CMD_FAILED 	-504
#define PDC_NO_SERVER		-505

/*start to declare naspdc function*/
#ifndef __QNAP_NAS_ADS__
//------------------------------- PDC basic function ----------------------------------------//
int  PDC_Find_Primary_Server(char *domain,char *server,int buf_size);
#endif // __QNAP_NAS_ADS__

int  PDC_Check_User_Password(char *user_name,char *password, int checklocal);

#ifndef __QNAP_NAS_ADS__
int  PDC_Get_Users_List(char (*user_list_buf)[USER_NAME_LENGTH], int list_cnt);
int  PDC_Get_Groups_List(char (*group_list_buf)[GROUP_NAME_LENGTH],int list_cnt);
int  PDC_Get_Group_Members(char *group_name,char (*user_list_buf)[USER_NAME_LENGTH], int list_cnt);
int  PDC_Get_User_Primary_Group(char *user_name, char *group_name);

// Catherine for new PDC
int  PDC_Get_Users_List_Ex(char (**)[USER_NAME_LENGTH]);
int  PDC_Get_Groups_List_Ex(char (**)[GROUP_NAME_LENGTH]);
int  PDC_Get_Group_Members_Ex(char *group_name,char (**)[USER_NAME_LENGTH]);
//------------------------------- PDC Conf function ----------------------------------------//
int  PDC_Set_Config(char *domain,char *user,char *passwd);
int  PDC_Get_Config(char *domain,char *server,char *user,char *passwd);
int  PDC_Enable(BOOL);
int PDC_Enable_Ex(BOOL bValue, char* stsfile);
#endif //__QNAP_NAS_ADS__
BOOL PDC_Is_Enabled();

#ifndef __QNAP_NAS_ADS__
int  PDC_Sync_Data();
int PDC_Sync_Data_Ex(char* stsfile);
//------------------------------- PDC user/group function ----------------------------------------//

int  Add_PDC_User_To_NAS(char *user_name,char *group_name);	// no longer in use (Catherine)
int  Remove_PDC_User_From_NAS(char *user_name);	// no longer in use (Catherine)
int  Remove_PDC_Group_From_NAS(char *group_name);	// no longer in use (Catherine)
int  Remove_All_PDC_Users_From_NAS();
int  Add_PDC_Group_Members_To_Nas(char *group_name);	// no longer in use (Catherine)
int  Remove_None_Exist_PDC_Users_Groups_From_NAS();	// no longer in use (Catherine)

int Create_PDC_User(char *user_name, char *group_name);	// Catherine for new PDC
int Create_PDC_Group(char *group_name);	// Catherine for new PDC
int Remove_PDC_Group(char *group_name);	// Catherine for new PDC
#endif // __QNAP_NAS_ADS__

int Remove_All_PDC_Groups();
int Remove_All_PDC_Users();

int Set_NAS_User_Type(char *user_name, NAS_USER_GROUP_TYPE type);
int Set_NAS_Group_Type(char *grp_name, NAS_USER_GROUP_TYPE type);

// 2004.12.09, Johnson Cheng Add
// For support AD with multi-domain
int IsLocalUser(char* username);
int IsLocalGroup(char* group);	
int Remove_Domain_User_Share_Privilege();
// End of Johnson Cheng Add

//------------------------------- PDC share function ----------------------------------------//

#ifdef __QNAP_NAS_ADS__
#define  PDC_Add_User_For_Share(a,b,c)		Add_NAS_User_For_Share(a,b,c)
#define  PDC_Add_Group_For_Share(a,b,c)		Add_NAS_User_For_Share(a,b,c)
#define  PDC_Remove_User_For_Share(a,b,c)	Remove_NAS_User_For_Share(a,b,c)
#define  PDC_Remove_Group_For_Share(a,b,c)	Remove_NAS_User_For_Share(a,b,c)

#else
int  PDC_Add_User_For_Share(char *share_name,char security_id, char *user_name);	// no longer in use (Catherine)
int  PDC_Add_Group_For_Share(char *share_name,char security_id, char *group_name);	// no longer in use (Catherine)
int  PDC_Remove_User_For_Share(char *share_name,char security_id, char *user_name);	// no longer in use (Catherine)
int  PDC_Remove_Group_For_Share(char *share_name,char security_id, char *group_name);	// no longer in use (Catherine)
#endif // __QNAP_NAS_ADS__

