//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		quota.h
//
//	Abstract:
//		Header for quota library functions.
//
//	HISTORY:
//
//	10/08/01	Kevin Liao created
//
//**************************************************************************
#ifndef NAS_QUOTA_LIB_H
#define NAS_QUOTA_LIB_H

#include "Util.h"

//#define SZ_QUOTA_CFG "/etc/config/quota.conf"
//#define SZ_QUOTA_SECTION "Quota"
#define SZ_USERENABLE_FIELD "User Enable"
#define SZ_GROUPENABLE_FIELD "Group Enable"
#define SZ_USERSIZE_FIELD "User Size"
#define SZ_GROUPSIZE_FIELD "Group Size"
#define SZ_SAMEQUOTA_FIELD "Use Same Quota"
#define SZ_USRQUOTAREPORT_PATH "/tmp/usr_quota.status"
#define SZ_GRPQUOTAREPORT_PATH "/tmp/grp_quota.status"
#define SZ_VOLQUOTAREPORT_PATH "/tmp/vol_quota.status"
#define SZ_USRQUOTACONF_PATH "/etc/config/usr_quota.conf"
#define SZ_GRPQUOTACONF_PATH "/etc/config/grp_quota.conf"


typedef struct {
	int vol;
	double b_used;
	double b_limit;
} QUOTA_STATUS_USER;

typedef struct {
	char name[BUF_SIZE];
	double b_used;
	double b_limit;
} QUOTA_STATUS_VOLUME;

int Stop_User_Quota(int volume);
int Start_User_Quota(int volume);
int Stop_Group_Quota(int volume);
int Start_Group_Quota(int volume);
int Set_One_User_Quota(char *user_name, unsigned long quota_size, int volume, int write);
int Set_One_Group_Quota(char *grp_name, unsigned long quota_size, int volume, int write);
BOOL Is_User_Quota_Enabled(unsigned long *quota_size);
BOOL Is_Group_Quota_Enabled(unsigned long *quota_size);
BOOL Is_User_Quota_Enabled_Disk(unsigned long *quota_size, int volume);
BOOL Is_Group_Quota_Enabled_Disk(unsigned long *quota_size, int volume);
int Set_User_Quota(int bEnable, unsigned long quota_size);
int Set_User_Quota_Disk(int bEnable, unsigned long quota_size, int volume);
int Set_Group_Quota(int bEnable, unsigned long quota_size);
int Set_Group_Quota_Disk(int bEnable, unsigned long quota_size, int volume);
int Enable_User_Quota();
int Enable_User_Quota_Disk(int volume);
int Enable_Group_Quota();
int Enable_Group_Quota_Disk(int volume);
int Check_User_Quota(int volume, int create);
int Check_Group_Quota(int volume, int create);
int Get_One_User_Quota(char *user_name, QUOTA_STATUS_USER *qsu, int count);
int Get_One_Group_Quota(char *grp_name, QUOTA_STATUS_USER *qsu, int count);
int Delete_One_User_Quota(char *user_name);
int Delete_One_Group_Quota(char *grp_name);
int Get_One_Volume_User_Quota(int volume, QUOTA_STATUS_VOLUME *qsv, int count);
int Get_One_Volume_Group_Quota(int volume, QUOTA_STATUS_VOLUME *qsv, int count);
int get_volume_from_dev(char* dev);
int write_log(char *,int);
#endif
