#ifndef	_QNAP_NAS_LDAP_H
#define	_QNAP_NAS_LDAP_H

/** if you don't want ldap function, turn this off */
#define	LDAP_SUPPORT_ENABLE

/** if you don't want utf-8 support, turn this off */
#define	UTF8_SUPPORT_ENABLE

#ifdef UTF8_SUPPORT_ENABLE
#include <iconv.h>	// for UTF8_Get_Encoding
#endif // UTF8_SUPPORT_ENABLE

#include <ldap.h>	// LDAP	*
#include <stdio.h>	// FILE	* need this
#include <assert.h>
#include "Util.h"
#include "NAS.h"

//**************************************************************************
// error numbers, constants
//**************************************************************************
/** the	error number to	start from */
#define	_START_FROM				-500

// inherit from	ldap api
#define	QNAP_NAS_LDAP_SUCCESS			0	/**< all function return this upon success. */
#define	QNAP_NAS_LDAP_OPERATIONS_ERROR		(_START_FROM-1)
#define	QNAP_NAS_LDAP_PROTOCOL_ERROR			(_START_FROM-2)
#define	QNAP_NAS_LDAP_TIMELIMIT_EXCEEDED		(_START_FROM-3)
#define	QNAP_NAS_LDAP_SIZELIMIT_EXCEEDED		(_START_FROM-4)
#define	QNAP_NAS_LDAP_COMPARE_FALSE			(_START_FROM-5)
#define	QNAP_NAS_LDAP_COMPARE_TRUE			(_START_FROM-6)
#define	QNAP_NAS_LDAP_STRONG_AUTH_NOT_SUPPORTED	(_START_FROM-7)
#define	QNAP_NAS_LDAP_STRONG_AUTH_REQUIRED		(_START_FROM-8)
#define QNAP_NAS_LDAP_PARTIAL_RESULTS		(_START_FROM-9)
#define QNAP_NAS_LDAP_REFERRL			(_START_FROM-10)
#define QNAP_NAS_LDAP_ADMINLIMIT_EXCEEDED		(_START_FROM-11)
#define QNAP_NAS_LDAP_UNAVAILABLE_CRITICAL_EXTENSION	(_START_FROM-12)
#define QNAP_NAS_LDAP_CONFIDENTIALITY_REQUIRED	(_START_FROM-13)
#define QNAP_NAS_LDAP_SASL_BIND_IN_PROGRESS		(_START_FROM-14)
#define	QNAP_NAS_LDAP_NO_SUCH_ATTRIBUTE		(_START_FROM-16)
#define	QNAP_NAS_LDAP_UNDEFINED_TYPE			(_START_FROM-17)
#define	QNAP_NAS_LDAP_INAPPROPRIATE_MATCHING		(_START_FROM-18)
#define	QNAP_NAS_LDAP_CONSTRAINT_VIOLATION		(_START_FROM-19)
#define	QNAP_NAS_LDAP_TYPE_OR_VALUE_EXISTS		(_START_FROM-20)
#define	QNAP_NAS_LDAP_INVALID_SYNTAX			(_START_FROM-21)
#define	QNAP_NAS_LDAP_NO_SUCH_OBJECT			(_START_FROM-32)
#define	QNAP_NAS_LDAP_ALIAS_PROBLEM			(_START_FROM-33)
#define	QNAP_NAS_LDAP_INVALID_DN_SYNTAX		(_START_FROM-34)
#define	QNAP_NAS_LDAP_IS_LEAF			(_START_FROM-35)
#define	QNAP_NAS_LDAP_ALIAS_DEREF_PROBLEM		(_START_FROM-36)
#define	QNAP_NAS_LDAP_INAPPROPRIATE_AUTH		(_START_FROM-48)
#define	QNAP_NAS_LDAP_INVALID_CREDENTIALS		(_START_FROM-49)
#define	QNAP_NAS_LDAP_INSUFFICIENT_ACCESS		(_START_FROM-50)
#define	QNAP_NAS_LDAP_BUSY				(_START_FROM-51)
#define	QNAP_NAS_LDAP_UNAVAILABLE			(_START_FROM-52)
#define	QNAP_NAS_LDAP_UNWILLING_TO_PERFORM		(_START_FROM-53)
#define	QNAP_NAS_LDAP_LOOP_DETECT			(_START_FROM-54)
#define	QNAP_NAS_LDAP_NAMING_VIOLATION		(_START_FROM-64)
#define	QNAP_NAS_LDAP_OBJECT_CLASS_VIOLATION		(_START_FROM-65)
#define	QNAP_NAS_LDAP_NOT_ALLOWED_ON_NONLEAF		(_START_FROM-66)
#define	QNAP_NAS_LDAP_NOT_ALLOWED_ON_RDN		(_START_FROM-67)
#define	QNAP_NAS_LDAP_ALREADY_EXISTS			(_START_FROM-68)
#define	QNAP_NAS_LDAP_NO_OBJECT_CLASS_MODS		(_START_FROM-69)
#define QNAP_NAS_LDAP_RESULTS_TOO_LARGE		(_START_FROM-70)
#define QNAP_NAS_LDAP_AFFECTS_MULTIPLE_DSAS		(_START_FROM-71)
#define	QNAP_NAS_LDAP_OTHER				(_START_FROM-80)
#define	QNAP_NAS_LDAP_SERVER_DOWN			(_START_FROM-81)
#define	QNAP_NAS_LDAP_LOCAL_ERROR			(_START_FROM-82)
#define	QNAP_NAS_LDAP_ENCODING_ERROR			(_START_FROM-83)
#define	QNAP_NAS_LDAP_DECODING_ERROR			(_START_FROM-84)
#define	QNAP_NAS_LDAP_TIMEOUT			(_START_FROM-85)
#define	QNAP_NAS_LDAP_AUTH_UNKNOWN			(_START_FROM-86)
#define	QNAP_NAS_LDAP_FILTER_ERROR			(_START_FROM-87)
#define QNAP_NAS_LDAP_USER_CANCELLED			(_START_FROM-88)
#define QNAP_NAS_LDAP_PARAM_ERROR			(_START_FROM-89)
#define QNAP_NAS_LDAP_NO_MEMORY			(_START_FROM-90)
#define QNAP_NAS_LDAP_CONNECT_ERROR			(_START_FROM-91)
#define QNAP_NAS_LDAP_NOT_SUPPORTED			(_START_FROM-92)
#define QNAP_NAS_LDAP_CONTROL_NOT_FOUND		(_START_FROM-93)
#define QNAP_NAS_LDAP_NO_RESULTS_RETURNED		(_START_FROM-94)
#define QNAP_NAS_LDAP_MORE_RESULTS_TO_RETURN		(_START_FROM-95)
#define QNAP_NAS_LDAP_CLIENT_LOOP			(_START_FROM-96)
#define QNAP_NAS_LDAP_REFERRAL_LIMIT_EXCEEDED	(_START_FROM-97)

// my own error	number
#define	QNAP_NAS_LDAP_CANT_WRITE_PARAM		(_START_FROM-128)	/**< cannot write parameter into config	file */
#define	QNAP_NAS_LDAP_CANT_READ_PARAM		(_START_FROM-129)	/**< cannot read parameter from	config file */
#define	QNAP_NAS_LDAP_NOT_UNIQUE			(_START_FROM-130)	/**< the required entry	in query result	are not	unique */
#define	QNAP_NAS_LDAP_RESULT_EMPTY			(_START_FROM-131)	/**< the query result is empty */
#define	QNAP_NAS_LDAP_NOT_ENABLED			(_START_FROM-132)	/**< ldap function not enabled.	*/
#define	QNAP_NAS_LDAP_SPECIAL_USER			(_START_FROM-133)	/**< special user. should be ignored. */
#define	QNAP_NAS_LDAP_NOT_IMPLEMENTED		(_START_FROM-134)	/**< objectClass or attribute not implemented */
#define	QNAP_NAS_LDAP_GET_LOCAL_ERROR		(_START_FROM-135)	/**< cannot get	local users */
#define	QNAP_NAS_LDAP_NO_SUCH_OPT			(_START_FROM-136)	/**< call set/get option with wrong option value */
#define	QNAP_NAS_LDAP_CONFIG_ERROR			(_START_FROM-137)	/**< cannot read or invalid slapd.conf */

// Ldap_Set_Option & Ldap_Get_Option
#define	QNAP_NAS_LDAP_OPT_ANONYMOUS			0x01	/**< enable/disable anonymous access to	ldap server. Value should be int *, 1 for enable, 0 for	disable. */
#define	QNAP_NAS_LDAP_OPT_BASE			0x02	/**< set the search base of ldap server	(in dn format like: iei.com.tw). Value should be char *. */
#define	QNAP_NAS_LDAP_OPT_BINDV2			0x03	/**< enable/disable allow bind via ldap	v2. Value should be int	*. (not implement yet)*/
#define	QNAP_NAS_LDAP_OPT_IDLETIMEOUT		0x04	/**< set the idletimeout. Value	should be int *	in seconds. */
#define	QNAP_NAS_LDAP_OPT_SIZELIMIT			0x05	/**< set sizelimit. Value should be int	*. */
#define	QNAP_NAS_LDAP_OPT_TIMELIMIT			0x06	/**< set timelimit. Value should be int	*. */
#define	QNAP_NAS_LDAP_OPT_REFERRALS			0x07	/**< set referrals. Value should be char **. */
#define QNAP_NAS_LDAP_OPT_SERVICE			0x08	/**< enable/disable slapd service. (accept outside linking or not). */
#define QNAP_NAS_LDAP_OPT_SYSTEMAB			0x09	/**< change systemab access privilige. cannot 'GET' */

// constants
#define QNAP_NAS_LDAP_PROTOCOL_VERSION	3	/**< Default support ldap v3 */
#define QNAP_NAS_LDAP_SBIN_LOCATION		"/usr/sbin"	/**< The openldap sbin location */
#define QNAP_NAS_LDAP_CONFIG_FILE		"/etc/config/slapd.conf"	/**< Slapd.conf location */
#define QNAP_NAS_LDAP_DEFAULT_LDIF		"/etc/openldap/default.ldif"	/**< this default ldif is used to create init database when init hd */
#define QNAP_NAS_LDAP_CONFIG_SECTION_NAME	"Ldap" 	/**< section name in config file */
#define QNAP_NAS_LDAP_DEFAULT_CFG_FILE	"/etc/config/wms_ldap.conf"	/**< the default config file */

//**************************************************************************
// structures
//**************************************************************************

/**
 * basically these parameters are read from config file, 
 * but for testing purpose, one	can still setup	it and
 * call	debugging functions such as Ldap_Test_Connection.
 * @see	Ldap_Test_Connection
 */
typedef	struct {
	char base[BUF_SIZE];	/**< search base for ldap server */
	char host[BUF_SIZE];	/**< ldap server address */
	int  port;		/**< ldap server port (default 389) */
	char userdn[BUF_SIZE];	/**< distinguished name	to bind	with */
	char userpasswd[BUF_SIZE];	/**< password */
	char uidattr[BUF_SIZE];		/**< the attribute name	that stores user login name */
	char filter[BUF_SIZE];	/**< search filter */
	int  enable;		/**< enable ldap support or not	*/
	int  reduce;
	/**< use "reduce sync" or not. reduce sync means if an user
	exist at local but not at remote ldap server, then delete
	this user. */
	int passwd_update;
	/**< if	enabled, each time an user logged in via ldap server,
	the system will	automatically update his local password. */
	int anonymous;		/**< anonymous login */
} LDAP_PARAMETER;

// client.c
int Ldap_Get_Parameter (LDAP_PARAMETER **param);
int LDAP_Get_Remote_User_Accounts (char (**acclist)[USER_GROUP_NAME_LENGTH]);
int LDAP_Get_Remote_Group_Accounts (char (**acclist)[USER_GROUP_NAME_LENGTH]);
int Check_Ldap_User_Password(char * username, char * password);
int LDAP_Get_Account_Name_By_Sid(char* sid, char* name);

// utf8.c
#ifdef UTF8_SUPPORT_ENABLE

enum {TO_UTF8=1,FROM_UTF8=2};

char *UTF8_Convert_String(const char *str, const int method);
iconv_t	UTF8_Get_Encoding(const int method);

#endif // UTF8_SUPPORT_ENABLE

#endif
