//**************************************************************************
//
//	Copyright (c) 2002  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		mail_webmail.h
//
//	Abstract: 
//		mail_webmail header file
//
//	HISTORY:
//		07/09/02	Tiger Fu created
//
//**************************************************************************
#ifndef	__MAIL_WEBMAIL__
#define	__MAIL_WEBMAIL__

typedef struct MAIL_FOLDER_LIST {
	char * folder;
	struct MAIL_FOLDER_LIST * next;
} MAIL_FOLDER_LIST, * pMAIL_FOLDER_LIST;

typedef	struct MAIL_MESSAGE {
	char	* message_id;	//  unique id
	char	* from;		//  sender
	char	* subject;	//  subject
	char	* date		//  date
	int 	bodysize;	//  size
} MAIL_MESSAGE, * pMAIL_MESSAGE;

typedef	struct MAIL_MESSAGE_LIST {
	MAIL_MESSAGE	message;
	struct MAIL_MESSAGE_LIST * next;
}MAIL_MESSAGE_LIST, * pMAIL_MESSAGE_LIST;

typedef struct MAIL_LOCAL_CONFIG {
	int	homepage;	//  which home page while login system
	int	page_message;	//  how many mail display on on page
	int	fontsize;	//  font size for reading
	int	browse_length;	//  ?
	int	write_length;	//  ?
	int	message_title	//  displayed normal title or complete title

int Mail_Set_Local_Config (MAIL_LOCAL_CONFIG * local, const char * owner);
int Mail_Get_Local_Config (MAIL_LOCAL_CONFIG * local, const char * owner);
int Mail_Create_Folder (const char * folder, const char * owner);
int Mail_Delete_folder (const char * folder, const char * owner);
int Mail_Modify_Folder (const char * new_folder, const char * old_folder, const char * owner);
MAIL_FOLDER_LIST * Mail_Get_Folder (const char * owner);
MAIL_FOLDER_LIST * Mail+Sort_Folder (MAIL_FOLDER_LIST * folder);
int Mail_Free_Folder (MAIL_FOLDER_LIST * folder);
MAIL_MESSAGE_LIST * Mail_Get_Message (const char * folder, const char * owner);
int Mail_Free_Message (MAIL_MESSAGE_LIST * message);
int Mail_Move_Message (const char * dest_folder, const char * source_folder, MAIL_MESSAGE * message, const char * owner);
int Mail_Copy_Message (const char * dest_folder, const char * source_folder, MAIL_MESSAGE * message, const char * owner);
MAIL_MESSAGE_LIST * Mail_Sort_Message (MAIL_MESSAGE_LIST * message_list, int msg_key);
int Mail_Set_Message_Property (MESSAGE_PROPERTY * property, const char * message_id, const char * folder, const char * owner);
int Mail_Get_Message_Property (MESSAGE_PROPERTY * property, const char * message_id, const char * folder, const char * owner);

#endif
