#ifndef __HWMON_H__
#define __HWMON_H__

#include <asm/ioctl.h>

#include <hwsts.h>
#include <w83977fa.h>
#include <devmon.h>

#define POWER_BUTTON_PRESSED		0x01

typedef struct {
	char	name[80];	// combine vendor name and model name
	int	cachesize;
} CPUINFO;

#define HWMON_DEV	"/dev/hwmon"

#define IOCTL_HWMON_MAGIC		'H'
#define	RTC_SUPPORT

// ICP NAS system
#define IOCTL_HWMON_GET_NASBP_HARDWARE_SIGNAL	_IOW(IOCTL_HWMON_MAGIC, 0, sizeof(unsigned char))

// Winbond 8378x hardware monitor
#define IOCTL_HWMON_GET_HARDWARE_STATUS_AVAIL	_IOW(IOCTL_HWMON_MAGIC, 10, sizeof(int))
#define IOCTL_HWMON_GET_HARDWARE_STATUS		_IOW(IOCTL_HWMON_MAGIC, 11, sizeof(HARDWARE_STATUS))

// Window 83977F/AF On-Now Control
#define IOCTL_HWMON_GET_POWER_BUTTON_STATUS	_IOW(IOCTL_HWMON_MAGIC, 20, sizeof(unsigned char))
#define IOCTL_HWMON_GET_WAKE_UP_EVENT		_IOW(IOCTL_HWMON_MAGIC, 21, sizeof(unsigned char))
#define IOCTL_HWMON_SET_WAKE_UP_EVENT		_IOR(IOCTL_HWMON_MAGIC, 22, sizeof(unsigned char))
#define IOCTL_HWMON_GET_WAKE_UP_DATE		_IOW(IOCTL_HWMON_MAGIC, 23, sizeof(WAKE_UP_DATE))
#define IOCTL_HWMON_SET_WAKE_UP_DATE		_IOR(IOCTL_HWMON_MAGIC, 24, sizeof(WAKE_UP_DATE))
#define IOCTL_HWMON_ENABLE_RTC_ALARM		_IOR(IOCTL_HWMON_MAGIC, 25, sizeof(int))

// Network Interface
#define IOCTL_HWMON_GET_ETHERNET_DEVICE_NUM	_IOW(IOCTL_HWMON_MAGIC, 30, sizeof(unsigned char))
#define IOCTL_HWMON_GET_ETHERNET_STATUS		_IOW(IOCTL_HWMON_MAGIC, 31, sizeof(NETWORKDEV))
// WLAN Detection
#define IOCTL_HWMON_IS_WLANCARD_EXIST			_IOW(IOCTL_HWMON_MAGIC, 32, sizeof(int))

// HD Interface
#if 0
#define IOCTL_HWMON_GET_HD_STATUS		_IOW(IOCTL_HWMON_MAGIC, 40, sizeof(unsigned long))
#endif
#define IOCTL_HWMON_GET_HD_POWER_STATUS		_IOW(IOCTL_HWMON_MAGIC, 41, sizeof(HDPOWERSTATUS))
#define IOCTL_HWMON_GET_HD_SMART_STATUS		_IOW(IOCTL_HWMON_MAGIC, 42, sizeof(HDSMARTSTATUS))
#define IOCTL_HWMON_GET_HD_MOUNT_STATUS		_IOW(IOCTL_HWMON_MAGIC, 43, sizeof(HDMOUNTSTATUS))
#define IOCTL_HWMON_RESCAN_HD_INFO		_IOW(IOCTL_HWMON_MAGIC, 44, sizeof(HDMOUNTSTATUS))

// System Information
#define IOCTL_HWMON_GET_CPU_INFO		_IOW(IOCTL_HWMON_MAGIC, 50, sizeof(CPUINFO))

// Force restart machine
#define IOCTL_HWMON_FORCE_RESTART_MACHINE	_IOR(IOCTL_HWMON_MAGIC, 60, 0)

#endif	// __HWMON_H__
