#ifndef DS_ERRCODE
#define DS_ERRCODE 1
/*---- Define Error Code ----*/
#define   PL_OK            0    /* PL: stand for Public Lib */
#define   PL_FAIL         -1    /* Action fail */
#define   PL_OPEN_FILE    -2    /*- open file fail -*/
#define   PL_OPEN_TEMP    -3    /*- open temp file fail -*/
#define   PL_WRITE_FILE   -4    /* write file fail -*/
#define   PL_READ_FILE    -5    /* read file fail -*/
#define   PL_NOT_FOUND    -6    /* cannot find the value on the specified file */
#define   PL_FUNC_FAIL    -7    /* call system or other internal function fail */
#define   PL_LESS_MEM     -8    /* you pass less memory to me */
#define   PL_OTH_ERR      -9    /*- other error -*/

#define   PL_LESS_FIELD  -11    /*  the line total fields is small than you specificed   */
#define   PL_ALLOC_MEM   -12     /*- alloc memory fail -*/
#define   PL_DEL_FILE    -13      /*- del  file fail  -*/
#define   PL_DEL_LINE    -14     /* remove one line fail */

//-- add 1/15/ 2000
#define   PL_FILE_NOEXIST -15    /*- the file doesn't exist -*/


/*---- warning code ------*/
#define   PL_ALREADY_EXIST   1    /* the user or group already exist */
#define   PL_NO_FILE         2    /* file not exist */
#define   PL_INVAL_PARA      3    /* input invalid parameter */
#define   PL_NOT_THIS_LINE   4    /* cannot find you pass in line no */
#define   PL_BUSY            5    /* maybe system busy, or other busy */
#define   PL_CANNOT_DEL      7    /* the item cannot been deleted */
#define   PL_EQUAL           8    /* some value is same as the other */
#define   PL_NON_EQUAL       9    /* reverse from above item */
#define   PL_FOUND          10    // find it

//-------- User_Grp Start base NO 101 ---------
#define UG_ADD_LOCAL_USER -101     /* add local user fail */
#define UG_DEL_LOCAL_USER -102     /* del local user fail */
#define UG_MOD_LOCAL_USER -103     /* Modify local user fail */
#define UG_ADD_LOCAL_GRP  -104     /* add local group fail */
#define UG_COPY_FILE      -105     /*- copy file fail  -*/


#define UG_NOT_MEM         101      /* the user not the grp member */
//-------- User_Grp End   -----------

/* ---------- NetWork Error Code Define start No. 201 ----------*/
#define NET_ENETMASK             -201     /* netmask invalid */
#define NET_ERR_OPEN_SOCKET      -202     /* open socket fail */
#define NET_ERR_GET_MACADDRESS   -203     /* get MAC Address fail */
#define NET_ERR_GET_IP           -204     /* get IP address fail */
#define NET_ERR_GET_NETMASK      -205     /* get NETMASK address fail */
#define NET_ERR_GET_GATEWAY      -206     /* get GATEWAY address fail */
#define NET_ERR_GET_BOOTPROTO    -207     /* get BOOTPROTO fail */
#define NET_ERR_GET_BROADCAST    -208     /* get BROADCAST fail */
#define NET_ERR_NETWORK_RESTART  -209     /* run ../network restart fial */
#define NET_ERR_GET_HOSTNAME     -210     /* get hostname fail  */
#define NET_ERR_SET_HOSTNAME     -211     /* set hostname fail  */

/*----- Define HD Error Code Start ------*/

#define SCAN_ERR_CORRECT              -301
#define SCAN_ERR_CORRECT_NEED_REBOOT  -302
#define SCAN_ERR_UNCORRECT            -303
#define SCAN_ERR_UNKNOW               -304
#define SCAN_ERR_OPERATIONAL          -305
#define RAID_OVER_MAXNO               -311
#define RAID_NO_DEVICE                -312
#define RAID_HD_NOEXIST               -313
#define RAID_START_FAIL               -314
#define RAID_STOP_FAIL                -315
#define RAID_ADD_CONF_FAIL            -316
#define RAID_REMOVE_CONF_FAIL         -317
#define RAID_GET_CONF_FAIL            -318  // get raid configure file fail
#define HD_NOEXIST                    -321
#define HD_EXIST_NOVALID              -322
#define HD_UMOUNT_FAIL                -323
#define HD_MOUNT_FAIL                 -324
#define HD_FORMAT_FAIL                -325
#define HD_CALL_SHARED_FUNC_FAIL      -326  // call shared memory realtional function fail
#define HD_CALL_MSGQUEUE_FUNC_FAIL    -327  // call send message queue realtional function fail

#define HD_CREATE_CONF_FILE_FAIL      -328 // create configure file fail
#define HD_EXIST_INCORRECT_LOCATION   -329 // 21 Feb 2001 add


#define PART_MOUNTED                  301  //- this partition is mounted 
#define PART_NOMOUNTED                302  //- this partition is not mounted 
#define PART_NOEXIST                  303  //- the partition not exist
#define SINGLE_HD                     304  //- it isn't belong any raid device

#define RAID_HD                       311  //- it is a member of one raid device
#define RAID_NO_RESYNC                312  // it must larger than 100
#define RAID_HD_EXIST_VALID           313
#define RAID_HD_EXIST_NOVALID         314
#define RAID_ACTIVE                   315 
#define RAID_NOACTIVE                 316 
#define RAID_NO_STARTUP               317 

#define HD_MSG_EMPTY                  321  //- the message queue is empty
#define HD_EXIST                      322
#define HD_EXIST_VALID                323
#define HD_BUSY                       324   // other already locking it
#define HD_ALREAY_ACTIVE              325   // for Is_Active_RaidHD()
/*----- Define Eror Code End    ------*/


//-------   Define Lock Error Code Start  ----------------
#define     LOCK_INVALID_TARGET         -401    // others our defined target
#define     LOCK_CALL_SHARED_FUNC_FAIL  -402    // call shred function fail
#define     LOCK_INVALID_TYPE           -403    // input invalid lock type 
#define     LOCK_OVER_TARGET            -404

#define     LOCK_BUSY                    401    // someone locking it
//-------   Define Lock Error Code End    ----------------

//-------   Define PID Code Start  ----------------
#define PID_ACTIVE                       501
#define PID_DIE                          502
//-------   Define PID Code End    ----------------


#endif
