#ifndef __DEVMON_H__
#define __DEVMON_H__

#ifdef __KERNEL__
#include <linux/types.h>
#else
#include <sys/types.h>
#endif

enum {
	ETHERNET_SPEED10,
	ETHERNET_SPEED100,
	ETHERNET_SPEED1000,
};

#define MAX_ETHERNET_DEV	6

// IN: devno
// OUT: others
typedef struct {
	unsigned int	devno:6;	// network device number
	unsigned int	linkup:1;
	unsigned int	speed:2;
	unsigned int	fullduplex:1;
} NETWORKDEV;

// IN: driveno
// OUT: powerstatus
typedef struct {
	unsigned char	driveno;	// 0:HDE, 1:HDF, 2:HDG, 3:HDH
	unsigned char	powerstatus;	// Standby:0x00, Active:0xff
} HDPOWERSTATUS;

// define SMART related structure
#ifdef __KERNEL__
#define NR_ATTRIBUTES		30

typedef struct {
	__u8		id;
	__u8		threshold;
	__u8		reserved[10];
} __attribute__ ((packed)) SMARTTHRESHOLD;


typedef struct {
	__u16		revision;
	SMARTTHRESHOLD	thresholds[NR_ATTRIBUTES];
	__u8		reserved[18];
	__u8		vendor[131];
	__u8		checksum;
} __attribute__ ((packed)) SMARTTHRESHOLDS;


typedef struct {
	__u8		id;
	__u16		status;
	__u8		value;
	__u8		vendor[8];
} __attribute__ ((packed)) SMARTVALUE;


typedef struct {
	__u16		revision;
	SMARTVALUE	values[NR_ATTRIBUTES];
	__u8		offline_status;
	__u8		vendor1;
	__u16		offline_timeout;
	__u8		vendor2;
	__u8		offline_capability;
	__u16		smart_capability;
	__u8		reserved[16];
	__u8		vendor[125];
	__u8		checksum;
} __attribute__ ((packed)) SMARTVALUES;
#endif // __KERNEL__

#define SMART_PASSED		0
#define SMART_FAILED		1

typedef struct {
	char	devname[3];
	int	status;
} HDSMARTSTATUS;

#define HD_MOUNTED		0
#define HD_UNMOUNTED		1

typedef struct {
	char	devname[3];
	int	status;
} HDMOUNTSTATUS;

#ifdef __KERNEL__
int  Get_Ethernet_Device_Num(unsigned char *devs);
int  Get_Ethernet_Status(NETWORKDEV *netdev);
//	Add by Egbert 2002/02/21
#define PCIVENDOR_INTERSIL	0x1260UL
#define PCIDEVICE_ISL3874	0x3873UL

int IsWLANCardExist();
#if 0
int  Get_HD_Status(unsigned long *);
#endif
int  Get_HD_Power_Status(HDPOWERSTATUS *hdpwr);
int  Get_HD_SMART_Status(HDSMARTSTATUS *hdsmart);
int  Get_HD_Mount_Status(HDMOUNTSTATUS *hdmount);
int  Rescan_HD_Info(HDMOUNTSTATUS *hdmount);
int  Init_Misc();
#endif

#endif	// __DEVMON_H__
