//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		NAS.h
//
//	Abstract: 
//		Header for uLinux config access library functions.
//
//	HISTORY:
//		12/22/00	Meiji Chang - created
//      	02/21/01	Johnson Hsu - add logo functions
//
//**************************************************************************

#include "../uLinux/uLinux.h"
//#include "../util/Util.h"


#ifndef	__ULINUX_CONFIG__
#define	__ULINUX_CONFIG__


#define UPDATE_CFG_FILE		"/sbin/update_cfg_file"
#define MAILOG		"/etc/logs/mailog"
#define MAILOG_LCK	"/etc/logs/mailog.LCK"
//	Constant Definition	//
#define MISC_SECTION            "MISC"
#define MISC_NETSTOP            "Stop Network Services"
#define MISC_FREE_SIZE_ALERT_FIELD            "Disk Free Size Alert"
#define MISC_FREE_SIZE_ALERT_ENABLE_FIELD            "Disk Free Size Alert Enable"

/*
#define	SHARE_NOACCESS		0

#define USER_NAME_LENGTH	16


#ifdef XXX
//	Structure Definition	//
typedef  struct NAS_USER_INFO 
	{
		char	user_name[USER_NAME_LENGTH];
		char	password[PASSWORD_LENGTH];
		char	primary_group[GROUP_NAME_LENGTH];  // for add user use, the primary grp 
		ULONG	uid;
		ULONG	gid;      // for get user info use 
		//int    grp_no;
		//string (*grp_list_ptr)[GROUP_NAME_LENGTH];
		//string *home_dir;
	}	NAS_USER_INFO;
#endif
*/



/* 
 * Migrate from Nick Ho's DS_network.h and few modifications
 * Structure Declaration
 */
#define 	NET_DEVICE_LEN	17	/* linux support up to 16 */
#define 	IPADDR_STR_LEN	16
#define 	HWADDR_STR_LEN	18
#define		MAIL_SUBJECT_MAX	50
#define		MAIL_MSG_MAX		256
#define		MAIL_LEVEL_MAX		30
typedef struct {
        char device_name[NET_DEVICE_LEN];  /* eth0 or eth1... */
		int  use_dhcp;
        char hw_addr[HWADDR_STR_LEN];    /* convert to string with : char */
        char ip_addr[IPADDR_STR_LEN];
        char net_mask[IPADDR_STR_LEN];
        char gateway[IPADDR_STR_LEN];
        char broadcast[IPADDR_STR_LEN];
} IFInfo;

typedef struct {
	char Subject[MAIL_SUBJECT_MAX];
	char Msg[MAIL_MSG_MAX];
	char Level[MAIL_LEVEL_MAX];
} MAILINFO;

#define LCD_DAEMON_PROGRAM_NAME				"sysmond"
#define LCD_DAEMON_PROGRAM_PATH				"/sbin/sysmond"

//	Function Prototype	//

// cfg_alert.c
int Get_Alert_Level(int *alert_level);
int Set_Alert_Level(int alert_level);
int Get_Alert_SMTP_Server_IP(char *smtp_ip, int buf_size);
int Set_Alert_SMTP_Server_IP(char *smtp_ip);
int Get_Alert_Mail_Address(char *alert_mail, int buf_size);
int Set_Alert_Mail_Address(char *alert_mail);
int Send_Alert_Mail(char *Subject, char *Msg, char *Level);
int Send_Alert_Mail_To_Queue(char *Subject, char *Msg, char *Level);
int Read_Alert_Mail_From_Queue(MAILINFO *mail_info_list,int list_cnt);
// Shone added 2005,09,29
int Get_Alert_SMTP_Auth(char *buf, int buf_size);
int Set_Alert_SMTP_Auth(char *buf);
int Get_Alert_SMTP_Username(char *buf, int buf_size);
int Set_Alert_SMTP_Username(char *buf);
int Get_Alert_SMTP_Password(char *buf, int buf_size);
int Set_Alert_SMTP_Password(char *buf);
// Shone Added end


// cfg_appletalk.c
BOOL Is_Appletalk_Enabled();
int Enable_Appletalk(int bEnable);
int Get_Appletalk_Default_Zone(char *default_zone, int buf_size);
int Set_Appletalk_Default_Zone(char *default_zone);
int set_appletalk_codepage(char *cp_str);

// cfg_netware.c
BOOL Is_Netware_Enabled();
int Enable_Netware(int bEnable);

// cfg_network.c
int Get_Network_Interface_Number(int *in);
int Get_Network_Interface_Name(int index, char *buf, int buf_size);
int Get_Network_Interface_Volatile(int index, IFInfo *pif);
int Get_Network_Interface_MAC_Address(int index, char *, int len);
int Get_Network_Interface_Config(int index, IFInfo *pif);
int Set_Network_Interface_Config(IFInfo *pif, int restart_now);
int Get_WINS_Server_IP(char *wins_ip, int buf_size);
int Set_WINS_Server_IP(char *wins_ip);

BOOL Is_Network_Started();
int Restart_Network();
BOOL Is_Network_Interface_Configured(int index);

// cfg_snmp.c
/*-----SNMP server---------*/
BOOL Is_SNMP_Enable();
int Enable_SNMP();
int Disable_SNMP();
int Set_SNMP_Conf(char *community,char *contact,char *location);
int Get_SNMP_Conf(char *community,char *contact,char *location);

/*-----SNMP trap----------*/
BOOL Is_SNMPTrap_Enable();
int Enable_SNMPTrap();
int Disable_SNMPTrap();
int Set_SNMPTrap_Conf(char *community,char *ip);
int Get_SNMPTrap_Conf(char *community,char *ip);
int SNMPTrap_Send_Alert(char *msg,int trap_type);

// nasnfs.c
int Remove_All_NFS_Users( void );

// cfg_nfs.c
BOOL Is_NFS_Enabled();
int Enable_NFS(int bEnable);
BOOL Is_NFS_Port_Enabled();
BOOL Is_NFS_Port_Set_Enabled();
char* Get_NFS_Port();
int Set_NFS_Port(char *port_number);
int Enable_NFS_PORT(int bEnable);

// cfg_samba.c
BOOL Is_Samba_Enabled();
int Enable_Samba(int bEnable);
int set_samba_WINS_support(int bEnable);
int set_samba_WINS_server(char *ip);

// Add by DavidYang 2001/8/24
int Refresh_Samba();
//End of Add

// cfg_smtp.c
int Send_Mail(char *Subject, char *Msg, char *mailaddrs, char *SMTP_IP, char *Level);
// cfg_system.c
void Restart_System();
void Shutdown_System();
int Get_Server_Name(char *svr_name, int buf_size);
int Set_Server_Name(char *svr_name, int restart_now);
int Get_Server_Comment(char *svr_comment, int buf_size);
int Set_Server_Comment(char *svr_comment);
int Get_System_Time_Zone(char *win_timezone, int buf_size);
int Set_System_Time_Zone(char *win_timezone);
int Get_Current_Date_Time(char *date_time);
int Set_Current_Date_Time(char *date_time);
BOOL Is_Day_Light_Saving_Time_Enabled();
BOOL Is_Fan_Support();
int Enable_Day_Light_Saving_Time(int bEnable);
int Get_System_Codepage();
int Set_System_Codepage(int cp);
int Get_System_Version(char *version, int buf_size);
int Set_System_Version(char* version);
int Get_Workgroup_Name(char *workgroup, int buf_size);
int Set_Workgroup_Name(char *workgroup);
int Get_Build_Number(char *build_no,int buf_size) ;
int Get_Model_Name(char *model_name,int buf_size) ;
int Get_Internal_Model_Name(char *model_name,int buf_size) ;
int Get_SubModel_Name(char *model_name, int buf_size);
int Get_Netware_Server_Name(char *svr_name, int buf_size);
int Set_Netware_Server_Name(char *svr_name, int restart_now);
BOOL Reset_Netware();


// cfg_webfs.c
BOOL Is_Webfs_Enabled();
int Enable_Webfs(int bEnable);
 

// cfg_display.c
int Update_LCD_Display();
int Update_System_Display();


BOOL Get_System_Clean_Status();
int  Set_System_Clean_Status();


BOOL Get_Admin_Configured_Status();
int Set_Admin_Configured_Status(BOOL bConfigured);

#define MISC_KEYNAME_DISK_TIMEOUT_ENABLE "Disk StandBy Timeout Enable"
#define MISC_KEYNAME_DISK_TIMEOUT "Disk StandBy Timeout"

#define	SECURITY_NO_ACCESS			'X'
#define	SECURITY_READ_ONLY			'R'
#define	SECURITY_FULL_ACCESS			'W'

/*
int Get_Guest_Access_Right();
int Set_Guest_Access_Right(int right);
int Get_Quota_Limit();
int Set_Quota_Limit(int quota);
*/


// Return TRUE if "CREATE PRIVATE HOME" option is enabled, the root path will be put in 'path'.
BOOL Get_Private_Home_Root_Path(char *path, int buf_size);
// If "CREATE PRIVATE HOME" option is disabled, pass the path as NULL or empty string.
int Set_Private_Home_Root_Path(char *path);

BOOL Is_LCD_Panel_Setting_Control_Enabled();
int Enable_LCD_Panel_Setting_Control(BOOL bEnable);
BOOL Is_Reset_Password_Switch_Enabled();
int Enable_Reset_Password_Switch(BOOL bEnable);

char *Get_System_Update_Working_Directory();
int Update_System_Software(char *fullname);

// function prototype of cfg_misc.c
int  Show_LCD_Message(char **message, int msg_count);
int  Hide_LCD_Message();
int  Switch_LCD_Main_Display();
void Set_Speaker(BOOL bEnable);

// declaration of hardware.c
#include "devmon.h"
#include "hwmon.h"


enum {
	HWERR_NO_DISKS,
	HWERR_DISK_FULL,
};

int Get_Network_Connection_Status(NETWORKDEV *ethdev);
int Get_CPU_Info(CPUINFO *cpuinfo);
int Enable_WOL(BOOL enable);
int Get_HD_Power_Saving_Mode(HDPOWERSTATUS *hdpwr);
int Set_Hardware_Error(int type, int set, int parm, char *str_parm);

//void Update_Flash_Data(char *filename);

//void Update_Flash_Data_Ex(char *filename, BOOL force);	// Catherine

// cfg_system_recover.c
int Recover_System_Config(void);
int Backup_System_Config(void);

int is_netstop_enabled();
int set_netstop_enable(int value);
void Enable_Check_HD_Size(int sec, long max_avail_size);
void Disable_Check_HD_Size();
int GetStandbyTimeout();
int IsStandbyEnable();
int  SetStandbyTimeout(char *, int);
#endif
