#ifndef		_UPS_SETTING
#define		_UPS_SETTING

#define		UPS_SECTION		"UPS"
#define		UPS_SUPPORT		"Support"
#define		UPS_ENABLE		"Enable"
#define		UPS_TYPE		"UPS Type"
#define		UPS_SHUTDOWN_IN		"Shutdown System In"
#define		UPS_VALID_COM		"ValidCOM"
#define		UPS_AC_POWER		"AC Power"
#define		UPS_BATTERY_POWER	"Battery Power"
#define		UPS_SERIAL_UPS		"Serial UPS"
#define		UPS_SNMP_UPS		"SNMP UPS"
#define		UPS_USB_UPS		"USB UPS"
#define		UPS_DAEMON_TYPE		"Daemon Type"
#define		UPS_UPS_IP		"UPS IP"
#define		UPS_DEV_NAME		"UPS Name"
#define		UPS_APCUPSD		"Apcupsd"
#define		UPS_USE_APCUPSD		"Use Apcupsd"


#define		SET_UPS_TYPE_ERROR		-1
#define		SET_UPS_SHUDOWN_ERROR		-2
#define		SET_UPS_VALID_COM		-3

#define		GET_UPS_TYPE_ERROR		-4

#define		UNKNOWN_STATUS			-1
#define		POWER_OK			1
#define		POWER_FAIL			0
#define		BATTERY_OK			1
#define		BATTERY_LOW			0


#define		GET_STATUS_POWER_OK		0x00
#define		GET_STATUS_BATTERY_OK		0x00
#define 	GET_STATUS_POWER_FAIL		0x01
#define 	GET_STATUS_BATTERY_LOW		0x02
#define 	GET_STATUS_CONNECTION_FAIL	0x04

typedef struct UPS_Information {
  
	int   Support;
	int   Enable;
	char  UPS_Type[80];
	int   UPS_Shutdown_In;
	char  UPS_Valid_COM[8];
	int   AC_Power;
	int   Battery_Power;
	int   Daemon_Type;
	char  UPS_IP[30];
	
}*PUPS_Information;

BOOL Has_Serial_UPS_Support();
BOOL Has_SNMP_UPS_Support();
BOOL Is_UPS_Support (void); // TRUE = support
BOOL Is_UPS_Enable (void);  // TRUE = enable
int  Enable_UPS (BOOL Enable);
int  Get_UPS_Info (struct UPS_Information * UPS_info);
BOOL Set_UPS_Type (char * type);
int  Set_UPS_Shutdown_In (int Shutdown_time);
int  Get_Power_Status (void);
int  Set_Power_Status (int status);
int  Get_Battery_Status (void);
int  Set_Battery_Status (int status);

BOOL Has_Serial_UPS_Support();
BOOL Has_SNMP_UPS_Support();
BOOL Has_USB_UPS_Support();
void a(int type);
int  Get_Daemon_Type();

BOOL Set_UPS_IP(char* IP);
int get_apcaccess_status(char* field, char* value);
int rw_apcupsd_conf (char * field, char *val, int func);


#endif
