//**************************************************************************
//
//      Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//      FILE:
//              cfg_tape.h
//
//      Abstract:
//              Tape Function Library.
//
//      FUNCTIONS:      TBD.
//
//      COMMENTS:       N/A
//
//      HISTORY:
//      03/01/2002      Johnson Hsu created
//
//**************************************************************************

#ifndef CFG_TAPE_H

#define CFG_TAPE_H
								
//#define _DEBUG
#undef	_DEBUG									//if you need test
#include "naslvm.h"
#define LSTR_LENGTH 			1024
#define MSTR_LENGTH 			254
#define SSTR_LENGTH 			64
#define TAPE_TIME 			60
#define TAPE_LINE 			200
#define TAPE_HISTORY_LOG_PER_PAGE_NUM	10
#define TAPE_READY_DELAY_TIME		1
#define TAPE_LABEL_NAME_LENGTH		50
#define TAPE_MAX_SCHEDULE_NUMBER	300
#define TAPE_JOB_DEFAULT_PID		-1
#define TAPE_write_log_error		1
#define TAPE_write_log_warn		2
#define TAPE_write_log_info		4
#define TAPE_NULL_WEEKLY		"8" //legal: 0~6
#define TAPE_CRONTAB_FILE 		"/etc/config/tape/crontab.tape"
#define TAPE_CRONTAB_TMP_FILE 		"/etc/config/tape/crontab.tape.tmp"
#define TAPE_CRON_CMD_DIR 		"/etc/config/tape/scripts"
#define TAPE_REWIND_DEV			"/dev/st0"
#define TAPE_NON_REWIND_DEV		"/dev/nst0"
#define TAPE_ROOT_DISK_PATH		"/mnt/HD%s_ROOT"
#define TAPE_TAR_PATH			"/bin/tar"
//#define TAPE_TAR_PATH			"/bin/icptar"
#define TAPE_SHELL_PATH			"/bin/sh"
#define TAPE_RM_PATH			"/bin/rm"
#define TAPE_CP_PATH			"/bin/cp"
#define TAPE_MKDIR_PATH			"/bin/mkdir"
#define TAPE_CHMOD_PATH			"/bin/chmod"
#define TAPE_SRC_DEST_ALL_PATH		"/share"

#ifdef _DEBUG										// for test
	#define TAPE_DEFAULT_DEV	"/share/HDC_DATA/backup/1"		// backup dest, define by programmer
	#define TAPE_TAR_FLAG_L_CMD	"-L100000" 					// 5M-data, define by programmer
#else
	#define TAPE_DEFAULT_DEV	"/dev/st0"
	#define TAPE_TAR_FLAG_L_CMD	""
#endif

#define TAPE_INCREMENTAL_DIR		"tape"
#define TAPE_FILE			"/etc/config/tape/tape.conf"
#define TAPE_TIME_FILE			"/etc/config/tape/tape.time"
#define TAPE_MOUNTS_FILE		"/proc/mounts"
#define TAPE_TAR_FLAG_a_FILE		"-a/etc/config/tape/tape.flag_a"
#define TAPE_TAR_FLAG_e_FILE		"-e/etc/config/tape/tape.flag_e"	
#define TAPE_TAR_FLAG_j_FILE		"-j/etc/config/tape/tape.flag_j"
#define TAPE_TAR_FLAG_n_FILE		"-n/etc/config/tape/tape.flag_n"
#define TAPE_TAR_FLAG_q_FILE		"-q/etc/config/tape/tape.flag_q"
#define TAPE_TAR_FLAG_t_FILE		"-q/etc/config/tape/tape.flag_t"	
#define TAPE_TAR_FLAG_H_FILE		"-H/etc/config/tape/tape.flag_H"
#define TAPE_TAR_FLAG_Q_FILE		"-Q/etc/config/tape/tape.flag_Q"
#define TAPE_TAR_FLAG_D_FILE		"-D/etc/config/tape/tape.flag_D"
#define TAPE_MOUNTS_FILE		"/proc/mounts"
#define TAPE_TAR_a_FILE			"/etc/config/tape/tape.flag_a"
#define TAPE_TAR_e_FILE			"/etc/config/tape/tape.flag_e"	
#define TAPE_TAR_j_FILE			"/etc/config/tape/tape.flag_j"		
#define TAPE_TAR_n_FILE			"/etc/config/tape/tape.flag_n"
#define TAPE_TAR_q_FILE			"/etc/config/tape/tape.flag_q"
#define TAPE_TAR_t_FILE			"/etc/config/tape/tape.flag_t"
#define TAPE_TAR_H_FILE			"/etc/config/tape/tape.flag_H"
#define TAPE_TAR_Q_FILE			"/etc/config/tape/tape.flag_Q"
#define TAPE_TAR_D_FILE			"/etc/config/tape/tape.flag_D"
#define TAPE_EXIST_FILE                               "/etc/config/tape/TapeExistency"//Shone 2004,12,28
#define TAPE_PROC_DIR			"/proc"
#define TAPE_SESSION			"Status Info"
#define TAPE_STATUS_FIELD		"Status"
#define TAPE_MSG_TIME_FIELD		"Message Time"
#define TAPE_TAPE_NUM_FIELD		"Current Tape Number"
#define TAPE_SOURCE_FIELD		"Backup Source"
#define TAPE_DESTINATION_FIELD		"Restore Destination"
#define TAPE_LABEL_FIELD		"Backup Label"
#define TAPE_TYPE_FIELD			"Backup Type"
#define TAPE_COMPRESSION_FIELD		"Data Compression"
#define TAPE_VERIFY_FIELD		"Verify Backup"
#define TAPE_FILES_FIELD		"Files Processed"
#define TAPE_MEGABYTES_FIELD		"Megabytes Processed"
#define TAPE_NULL_STR			""
#define TAPE_DEFAULT_STR		"--"
#define TAPE_COMPRESS_TAG		"Compression data"
#define TAPE_NON_COMPRESS_TAG		"Non-compression data"
#define TAPE_VERIFY_TAG			"Verify tape"
#define TAPE_NON_VERIFY_TAG		"Non-verify tape"
#define TAPE_FULL_TAG			"Full backup"
#define TAPE_INCREMENTAL_TAG		"Incremental backup"

//#define TAPE_JOB_READY_STATUS		"ready"
//#define TAPE_JOB_EXECUTE_STATUS	"execute"
//#define TAPE_JOB_WAIT_STATUS		"wait"
#define TAPE_JOB_READY_STATUS		"ready"
#define TAPE_JOB_FINISH_STATUS		"finished"
#define TAPE_JOB_FAIL_STATUS		"failed"
#define TAPE_JOB_STOP_STATUS		"stopped"
#define TAPE_JOB_EXECUTE_STATUS		"executing"
#define TAPE_JOB_WAIT_STATUS		"waiting"

#define TAPE_STATUS_DESTINATION_FILE	"/etc/config/tape/tape.destination"	
#define TAPE_STATUS_SWITCH_FILE		"/etc/config/tape/tape.status"
#define TAPE_RESTORE_SWITCH_FILE	"/etc/config/tape/tape.restore"
#define TAPE_NEXT_VOLUME_SWITCH_FILE	"/etc/config/tape/tape.next_volume"
#define TAPE_BACKUP_SWITCH_FILE		"/etc/config/tape/tape.backup"
#define TAPE_TVF_SWITCH_FILE		"/etc/config/tape/tape.tvf"
#define TAPE_PIDOF_PROG_PATH		"/sbin/pidof"
#define TAPE_MT_PROG_TEST_FILE		"/etc/config/tape/mt.pid"
#define TAPE_GZIP_PROG_TEST_FILE	"/etc/config/tape/gzip.pid"
#define TAPE_write_log_prog		"/sbin/write_log"
#define	TAPE_APP_ULINUX			"Tape"
#define TAPE_KEY_ULINUX			"Support"
#define TAPE_BOOL_DEFUALT_ULINUX	TRUE
#define TAPE_FILEPATH_ULINUX		"/etc/config/uLinux.conf"
#define TAPE_DEVICE_READY_TEST_FILE	"/etc/config/tape/tape.ready"
#define TAPE_DEVICE_NOT_READY_MSG	"No such device"
#define TAPE_MT_COMMAND_NOT_FOUND	"command not found"
#define TAPE_DEVICE_NOT_FONND		"No such file or directory"
#define TAPE_NULL_DEVICE		"/dev/null"
#define TAPE_SP_CHARACTER		' '
#define TAPE_INSTEAD_SP_CHARACTER	'^'
#define TAPE_CONFIG_PATH		"/etc/config/tape"
#define TAPE_CONFIG_DEFAULT_FILE	"/etc/default_config/tape/tape.conf"
#define TAPE_DIR_PREMISSIONS		"755"

#define	BACKUP_FROM_SNAPSHOT		1	// Catherine 2003/04/17	for backup-from-snapshot

typedef struct tagTAPE_SCHEDULE_INFO
{
	int				id;
	char				task_name[SSTR_LENGTH];
	char				source[MSTR_LENGTH];
	char				type[SSTR_LENGTH];
	int				compress; // (0/1)
	int				verify; // (0/1)
	int				day; //(0~31), 0-N/A
	char				weekly[SSTR_LENGTH]; //(0~7), 0-N/A	
	int				monthly; //(0~12), No used		
	int				hh; //(0~23)
	int				mm; //(0~59)
	char				tape_cmd[SSTR_LENGTH];
	char				status[SSTR_LENGTH];
	int				pid;
	struct tagTAPE_SCHEDULE_INFO	*next;		

#if	BACKUP_FROM_SNAPSHOT	// Catherine 2003/04/17
	int				backup_from_snap;
	char				snapname[LV_PATH_MAX_LEN];
#endif
} TAPE_SCHEDULE_INFO;

typedef struct tagTAPE_SCHEDULE_TASK_NAME_INFO
{
	char				task_name[SSTR_LENGTH];
	struct tagTAPE_SCHEDULE_TASK_NAME_INFO	*next;		
} TAPE_SCHEDULE_TASK_NAME_INFO;

typedef struct tagTAPE_STATUS_INFO
{
	char				status[MSTR_LENGTH];
	char				msg_time[MSTR_LENGTH];	
	int				tape_num;
	char				source[MSTR_LENGTH];
	char				destination[MSTR_LENGTH];	
	char				label[SSTR_LENGTH];
	char				type[SSTR_LENGTH];	
	int				compression; // (0/1)
	int				verify; // (0/1)	
	double				files_processed;
	double				megabytes_processed;
} TAPE_STATUS_INFO;

typedef struct tagTAPE_INFO
{
	char				timestamp[SSTR_LENGTH];
	char				label[SSTR_LENGTH];
	char				volume[SSTR_LENGTH];
	char				compress[SSTR_LENGTH];
	char				source[MSTR_LENGTH];
	char				servername[SSTR_LENGTH];	
	struct tagTAPE_INFO	*next;			
} TAPE_INFO;

typedef struct tagTAPE_LOG_INFO
{
	int				id;
	char				type[SSTR_LENGTH];
	char				time_stamp[SSTR_LENGTH];
	char				msg[SSTR_LENGTH];
	struct tagTAPE_LOG_INFO		*next;		
} TAPE_LOG_INFO;

typedef struct tagTAPE_MOUNTS_INFO
{
	char				dev_path[SSTR_LENGTH];
	char				mount_path[SSTR_LENGTH];
	struct tagTAPE_MOUNTS_INFO	*next;	
} TAPE_MOUNTS_INFO;

typedef struct tagTAPE_MOUNTS_SHARE_VOLUME_INFO
{
	int					vol_no;
	int					raid_level;
	int					drive_no_list[MAX_DRIVE_NO];
	int					list_cnt;
// Catherine 2003/03/19	==>
	int					spare_drive_list[MAX_DRIVE_NO];
	int					spare_list_cnt;
// <== Catherine 2003/03/19
	int					status;
	char					dev_path[SSTR_LENGTH];
	char					mount_path[SSTR_LENGTH];
	double					total_size;
	double  				free_size;
	struct tagTAPE_MOUNTS_SHARE_VOLUME_INFO	*next;	
} TAPE_MOUNTS_SHARE_VOLUME_INFO;

typedef struct tagTAPE_BACKUP_SHARE_DIR_INFO
{
	char					share_type[SSTR_LENGTH];
	char					share_name[MSTR_LENGTH];
	char					share_path[MSTR_LENGTH];
	struct tagTAPE_BACKUP_SHARE_DIR_INFO	*next;	
} TAPE_BACKUP_SHARE_DIR_INFO;

typedef struct tagTAPE_BACKUP_SHARE_DIR_REVERSE_INFO
{
	char					share_type[SSTR_LENGTH];
	char					share_name[MSTR_LENGTH];
	struct tagTAPE_BACKUP_SHARE_DIR_REVERSE_INFO	*next;	
} TAPE_BACKUP_SHARE_DIR_REVERSE_INFO;


TAPE_MOUNTS_INFO *Tape_Get_Mounts_Info();
void Tape_Free_Mounts_Info(TAPE_MOUNTS_INFO *tape_mounts_info);
TAPE_MOUNTS_INFO *Tape_Get_Mounts_Root_Info();
TAPE_MOUNTS_INFO *Tape_Get_Mounts_Share_Info();
char *find_incremented_file(char *src, char *incremented_file);
void Tar_Cmd_Cvf(char *dest, char *src, char *label, char *compress, char *verify, char *incremented, char *tape_length);
void Tar_Cmd_Xvf(char *src, char *dest, char *keep_old_files);
void Tar_Cmd_Tvf(char *src);
void Tar_Cmd_Tvf_For_Compress(char *src);
TAPE_LOG_INFO *Tape_Get_Log_Info();
void Tape_Free_Log_Info(TAPE_LOG_INFO *tape_log_info);
TAPE_MOUNTS_SHARE_VOLUME_INFO *Tape_Get_Mounts_Share_Volume_Info();
void Tape_Free_Mounts_Share_Volume_Info(TAPE_MOUNTS_SHARE_VOLUME_INFO *tape_mounts_share_volume_info);
void Tape_Clear_Status_Info();
//void erase_char(char *origin);
void Tape_Set_Status_Info_Status_Field();
void Tape_Set_Status_Info_Count_Size_Field();
void Tape_Set_Status_Info_Source_Label_Field();
void Tape_Set_Status_Info_Compress_Verify_Type_Field(char *type, char *compress, char *verify);
void Tape_Set_Status_Info_Num_Field();
void Tape_Set_All_Status_Info();
TAPE_BACKUP_SHARE_DIR_INFO *Tape_Backup_Share_Dir_Info();
void Tape_Free_Backup_Share_Dir_Info(TAPE_BACKUP_SHARE_DIR_INFO *tape_backup_share_dir_info);
void Tape_Set_New_Cron_Job(char *task_name, char *source, char *type, 		
int compress, int verify, int day, char *weekly, int monthly, int hh, int mm);
BOOL Tape_Test_Included_Sp (char *str);
BOOL Tape_Delete_Cron_Job(int cid, char *ctask_name);
BOOL Tape_Test_Duplicate_Name(char *ctask_name);
int Tape_Find_Unoccupied_Id();
BOOL Tape_Set_Confirm_Next_Volume_Yes();
BOOL Tape_Set_Confirm_Next_Volume_No();
void Tape_Set_Confirm_Next_Volume_Create_Empty_File();
int Tape_Get_Confirm_Next_Volume_File_Value();
BOOL Tape_Do_Next_Volume_Job();
BOOL Tape_Check_Need_Next_Volume();
int Tape_Get_Next_Volume_No();
BOOL Tape_Check_Job_Finish();
BOOL Tape_User_Abort_Next_Volume_Job();
void Tape_Eject_Tape();
void Tape_Rewind_Tape();
void Tape_Erase_Tape();
void Tape_Forward_Count_Tape(int count);
TAPE_SCHEDULE_INFO *Tape_Get_Schedule_Info();
void Tape_Free_Schedule_Info(TAPE_SCHEDULE_INFO *tape_schedule_info);
BOOL Make_Sh_Tar_Cmd_Cvf(int id, char *dest, char *src, char *label, char *compress, char *verify, char *incremented);
TAPE_BACKUP_SHARE_DIR_REVERSE_INFO *Tape_Get_Backup_Share_Dir_Reverse_Info(char *compare);
char *find_incremented_file_ex_1(char *src, char *incremented_file);
int Tape_Get_Job_Pid();
BOOL Tape_Clear_History_Log();
BOOL Tape_Set_Cron_Job_Srcipt(char *ctask_name);
void Tape_Set_All_Status_Info_Except_Compress_Verify_Type_Field();
TAPE_INFO *Tape_Get_All_Tape_Info();
TAPE_INFO *Tape_Get_Assign_Tape_Info(int count);
BOOL Tape_Info_Test(TAPE_INFO *tape_info);
BOOL Tape_Test_Source_Compress(char *src);
BOOL Tape_Test_Log_Occur_Error(char *log_src);
TAPE_LOG_INFO *Tape_Get_Test_Log_Info();
BOOL Tape_Weekly_Num_To_Weekly_Alp(char *num_str, char *alp_str, int length);
TAPE_LOG_INFO *Tape_Get_History_Log_Info_By_Case(char *condition);
int Tape_Get_History_Log_Info_Total();
int Tape_Get_History_Log_Info_Total_By_Case(char *condition);
TAPE_LOG_INFO *Tape_Get_History_Log_Info_By_Case_and_Page(char *condition, int page);
TAPE_LOG_INFO *Tape_Get_History_Log_Info();
void Tape_Free_History_Log_Info(TAPE_LOG_INFO *tape_log_info);
TAPE_LOG_INFO *Tape_Get_History_Log_Info_By_Page(int page);
int Tape_Get_History_Log_Info_Total_Page_By_Case(char *condition);
void Tape_Free_Backup_Share_Dir_Reverse_Info(TAPE_BACKUP_SHARE_DIR_REVERSE_INFO *tape_info);
TAPE_STATUS_INFO *Tape_Get_Status_Info();
void Tape_Free_Status_Info(TAPE_STATUS_INFO *tape_status);
TAPE_INFO *Tape_Get_Tape_Info();
void Tape_Free_Tape_Info(TAPE_INFO *tape_info);
void Tar_Cmd_Tvf_Test(char *src);
TAPE_SCHEDULE_TASK_NAME_INFO *Tape_Set_Schedule_Task_Name_Info(TAPE_SCHEDULE_TASK_NAME_INFO *p, char *task_name);
void Tape_Free_Schedule_Task_Name_Info(TAPE_SCHEDULE_TASK_NAME_INFO *tape_schedule_task_name_info);
BOOL Tape_Restore_Switch(int cmd);
void Tape_Set_All_Restore_Status_Info();
BOOL Tape_Test_Restore_Switch();
BOOL Tape_User_Abort_Job();
BOOL Tape_Next_Volume_Switch(int cmd);
BOOL Tape_Test_Next_Volume_Switch();
BOOL Tape_Compare_Status_Info_Status_Field();
BOOL Tape_Test_Is_Sp_For_Status_Info_Status_Field();
BOOL Tape_Tvf_Switch(int cmd);
BOOL Tape_Tvf_Test_Switch();
BOOL Tape_Clear_Cron_Job_List();
BOOL Tape_Check_Mt_Finish();
BOOL Tape_User_Abort_Mt();
BOOL Tape_Check_Gzip_Finish();
void Tape_Set_Status_Info_Status_Time_Field();
int Tape_Get_Default_Restore_Dir(char *src, char *retdir, int length);
BOOL Tape_Exist_Default_Restore_Dir(char *source);
void Tape_Clear_Tape_Info();
BOOL Tape_Status_Switch(int cmd);
BOOL Tape_Status_Test_Switch();
void Tape_Set_Status_Info_Time_Field();
void Tape_Set_Status_Info_Time_File();
int Tape_Get_Schedule_Count();
int Tape_In_Drive();//Shone added
BOOL Is_Tape_Support();
BOOL Tape_Conf_File_Is_Null();
BOOL Tape_Device_Ready();
BOOL Tape_Set_Destination_Label_Field();
BOOL Tape_Set_Destination_Temp_File(char *dest);
void Tape_Transfer_Sp_Char(char *src, char *dest);
char *Tape_Transfer_Instead_Sp_Char(char *src);
char *Tape_Invert_Sp_Char(char *src);
int Reset_Tape();

#if	BACKUP_FROM_SNAPSHOT	// Catherine 2003/04/17 for "backup-from-snapshot" ==>
void Tape_Set_New_Cron_Job_Ex(char *task_name, char *source, char *type,
	 int compress, int verify, int day, char *weekly, int monthly, int hh, int mm,
	 int from_snapshot);

int Tape_Edit_Cron_Job_Fields(TAPE_SCHEDULE_INFO* jobinfo);
void Tar_Cmd_Cvf_Ex(char *dest, char *src, char *label, char *compress,
	 char *verify, char *incremented, char *tape_length, int is_from_snap);

#endif	// <== Catherine 2003/04/17
#endif

