#ifndef __CFG_SYSTEM_H__
#define __CFG_SYSTEM_H__

#include "NAS.h"
#define SYSTEM_WAN_ACCESS	1
#define SYSTEM_LAN_ACCESS	2

#define SYSTEM_ERROR_TYPE	-100

/* for uLinux.conf [System] section */
#define SZ_WAN_ACCESS_FIELD		"Wan Access"
#define SZ_LAN_ACCESS_FIELD		"Lan Access"
#define SZ_WEB_ACCESS_PORT_FIELD	"Web Access Port"

/* export function */
int	Set_Web_Access(int type, int bEnable);
int	Get_Web_Access(int type);
int	Set_Web_Access_Port(int port);
int	Get_Web_Access_Port();
int     Web_Server_Restart();

/* for uLinux.conf [Router] section */
#define SZ_ROUTER_SECTION               "Router"
#define SZ_ROUTER_USAGE_FIELD           "Usage"

#define ROUTER_USE_DEFAULT		1
#define ROUTER_USE_STATIC		2
#define ROUTER_USE_DYNAMIC		3

/* export function */
int	Set_Routing_Table_Type(int type);
int	Get_Routing_Table_Type();

int System_Reset_Admin();
int System_Reset_Network(int restart);
int System_Reset_Firewall();
int System_Reset_Disk();
int System_Reset_Hardware();
int System_Reset_System();
int System_Reset_User_Group();
int System_Reset_All();
int System_Reset_Network_Share(NAS_SHARE_INFO *s_info);
int Stop_Services();
int Start_Services();

#endif

BOOL Is_Disk_Free_Size_Alert_Enabled();
int Enable_Disk_Free_Size_Alert(int bEnable);
int Set_Disk_Free_Size_Alert(int value);
int Get_Disk_Free_Size_Alert();

