#ifndef __CFG_SAMBA_H__
#define __CFG_SAMBA_H__

#define SETUP_SMB_SH "/usr/bin/setup_smb.sh"
#define MS_TYPE_STANDALONE	"STANDALONE"
#define MS_TYPE_NTDC		"NT DOMAIN CONTROLLER"
#define MS_TYPE_NTDM		"NT DOMAIN MEMBER"
#define MS_TYPE_ADDM		"AD DOMAIN MEMBER"

#define SMB3_SUCCESS			0
#define SMB3_USAGE_ERROR		1
#define SMB3_UNKNOWN_ERROR		2
#define SMB3_KDC_SRV_ERROR		3
#define SMB3_KDC_REALM_ERROR		4
#define SMB3_KDC_TIME_DIFF_ERROR	5
#define SMB3_AD_JOIN_ERROR		6
#define	SMB3_NTD_JOIN_ERROR		7

typedef enum {
	STANDALONE,
	NTDC,
	NTDM,
	ADDM
} MS_Net_Type;

int Run_Samba3(MS_Net_Type type, char* Domain_Name, char* username, char* passwd);
int Get_Samba3_WINS_Srv(BOOL *Srv_Enable);
int Set_Samba3_WINS_Srv(BOOL Srv_Enable);
int Get_Samba3_WINS(BOOL *checked, char *WINS_IP);
int Set_Samba3_WINS(BOOL checked, char *WINS_IP);
int Get_Samba3_Domain_Name(char *Dname);
int Set_Samba3_Domain_Name(char *Dname);
int Set_Samba3_Domain_User_Passwd(char *Uname, char *Passwd);
int Get_Samba3_Domain_User_Passwd(char *Uname, char *Passwd);
int Get_Samba3_Workgroup_Name(char *Wname);
int Set_Samba3_Workgroup_Name(char *Wname);
int Get_Samba3_Description(char *Dstr);
int Set_Samba3_Description(char *Dstr);
int Get_MS_Server_Type(MS_Net_Type *type);
int Set_MS_Server_Type(MS_Net_Type type);

#endif
