//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		cfg_printer.h
//
//	Abstract: 
//		Header for printer configuring functions.
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		12/06/00	David Yang created
//
//**************************************************************************
#include "../uLinux/uLinux.h"
#ifndef CFG_PRINTER_H
#define CFG_PRINTER_H

#define PRN_PARALLEL	1
#define PRN_USB		2

#define WBINFO_CMD	"/usr/bin/wbinfo"
#define CMD_LENGTH	1024
#define TMP_LOG		"/tmp/print_log"

int Prn_Get_Type();
int Prn_Set_Type(int type);
BOOL Is_Support_Printer();
BOOL Is_Support_Usb_Printer();
BOOL Is_Support_Parallel_Printer();
BOOL Is_Spool_Initialized();
BOOL Is_Printer_Enabled();
int Install_Lpd(int bEnable);
int Install_PAPD(int bEnable);
int Enable_Printer(int bEnable, BOOL refresh_now);
int Get_Printer_Name(char *printer_name, int buf_size);
int Set_Printer_Name(char *printer_name, BOOL refresh_now);
int Get_Printer_Comment(char *printer_comment, int buf_size);
int Set_Printer_Comment(char *printer_comment, BOOL refresh_now);
BOOL Reset_Printer();
int Add_Printer_Admin();

#define VENDOR_LENGTH	64
#define PRODUCT_LENGTH	64
#define CLASS_LENGTH	64
#define CMD_LSUSB	"/usr/sbin/lsusb"

#define MSG_READY	0
#define MSG_START	1
#define MSG_FINISH	2
#define MSG_ERROR	3

#define SZ_PRINTER_SECTION              "Printers"
#define SZ_STATUS_FIELD			"Status"

typedef unsigned char u32;
typedef struct lp_info {
	int	bus;					//Bus no.
	int 	device;					//Device no.
	u32  	idvendor;				//Vendor id
	u32  	idproduct;				//Product id
	char 	idvendor_str[VENDOR_LENGTH];		//Vendor 
	char 	idproduct_str[PRODUCT_LENGTH];		//Product
	char 	manufacturer[VENDOR_LENGTH];		//Manufacturer by interface
	char 	product[PRODUCT_LENGTH];		//Product by interface	
	char	InterfaceClass[CLASS_LENGTH];		//Interface class
	char	InterfaceProtocol[CLASS_LENGTH];	//Interface protocol
} Lp_info;
int Get_Printer_Info_From_Config(char *manufacturer, int manu_size, char *model, int model_size);
void Refresh_Printer(int plugged_type, int refresh_now);
int Is_Printer_Exist();
int Get_Printer_Status();
void CleanUpSpool();
#endif // CFG_PRINTER_H
