#define HOSTS			"/etc/hosts"
#define BRIDGE_DEV		"br0"
#define BONDING_DEV             "bond0"

#define NIC_DEV_LEN		17      /* linux support up to 16 */
#define NIC_IPADDR_LEN		16
#define NIC_HWADDR_LEN		18

#define NIC_USE_OTHER		0
#define NIC_USE_DHCP		1
#define NIC_USE_STATIC		2
#define NIC_USE_PPPOE		3
#define NIC_USE_PPTP		4
#define NIC_USE_LOAD_BALANCE    100
#define NIC_USE_FAIL_OVER       101

#define NIC_SUCCESS		0
#define NIC_FAIL		-1
#define NIC_RESTART		1

#define NIC_LINE		1024

#define DNS_CONF_FILE		"/etc/resolv.conf"

#define NIC_TMP_FILE		"/tmp/nic.dev"
#define NIC01_TMP_FILE		"/tmp/nic01.tmp"
#define NIC02_TMP_FILE		"/tmp/nic02.tmp"
#define NIC03_TMP_FILE          "/tmp/nic03.tmp"
#define NIC04_TMP_FILE          "/tmp/nic04.tmp"

#define SZ_CONFIGURED_FIELD             "Configure"
#define SZ_USE_DHCP_FIELD               "Use DHCP"
#define SZ_USAGE_FIELD                  "Usage"
#define SZ_HWADDR_FIELD                 "MAC2 Address"
#define SZ_VHWADDR_FIELD                "VHWADDR"
#define SZ_VHWADDR_ENABLE_FIELD         "VHWADDR Enable"
#define SZ_IPADDR_FIELD                 "IP Address"
#define SZ_NETMASK_FIELD                "Subnet Mask"
#define SZ_BROADCAST_FIELD              "Broadcast"
#define SZ_GATEWAY_FIELD                "Gateway"
#define SZ_NIC_NUM_FIELD                "Interface Number"
#define SZ_WINS_FIELD                   "WINS IP"
#define SZ_WINS_ENABLE_FIELD            "WINS Enable"
#define SZ_WAN_DHCP_FIELD               "Wan DHCP"
#define SZ_WINS_SUPPORT_FIELD           "WINS Support"
#define SZ_BONDING_SUPPORT_FIELD        "BONDING Support"
#define SZ_BONDING_FIELD                "Bonding"
#define SZ_BONDING01_FIELD              "BONDING01"
#define SZ_BONDING02_FIELD              "BONDING02"
#define SZ_BONDING03_FIELD		"BONDING03"
#define SZ_BONDING04_FIELD		"BONDING04"

#define SZ_DNS_FIELD		"DNS"
#define SZ_WAN_FIELD		"Wan"
#define SZ_LAN01_FIELD		"Interface1"
#define SZ_LAN02_FIELD          "Interface2"
#define SZ_LAN03_FIELD          "Interface3"
#define SZ_LAN04_FIELD		"Interface4"

#define NIC_WAN                 1
#define NIC_LAN01               2
#define NIC_LAN02               3
#define NIC_LAN03               4
#define NIC_LAN04               5
#define NIC_WAN_DEFAULT         10
#define NIC_LAN01_DEFAULT       11
#define NIC_LAN02_DEFAULT       12
#define NIC_LAN03_DEFAULT       13
#define NIC_LAN04_DEFAULT	14

#define	NIC_MAC_DNS_COUNT	2
#define	DHCP_SECTION		"DHCP Server"

typedef struct
{
	char dev[NIC_DEV_LEN];  /* eth0 or eth1... */
        char hwaddr[NIC_HWADDR_LEN];    /* convert to string with : char */
        char ipaddr[NIC_IPADDR_LEN];
        char netmask[NIC_IPADDR_LEN];
        char gateway[NIC_IPADDR_LEN];
        char broadcast[NIC_IPADDR_LEN];
	char dstaddr[NIC_IPADDR_LEN];
} NIC_INFO;

typedef struct
{
	NIC_INFO	ifconfig;
	int		usage;
	int		bonding_type;
} NIC_NAS_INFO;

typedef struct
{
	char	dns[NIC_IPADDR_LEN];
	char	wins[NIC_IPADDR_LEN];
	char	wan[NIC_DEV_LEN];
	char	lan01[NIC_DEV_LEN];
	char	lan02[NIC_DEV_LEN];
	char	lan03[NIC_DEV_LEN];
	char	lan04[NIC_DEV_LEN];
} NIC_TCPIP;

/* export DEBUG functions */
void NIC_Debug_Info(NIC_INFO *p);
void NIC_Debug_NAS_Info(NIC_NAS_INFO *p);
void NIC_Debug_Tcpip(NIC_TCPIP *p);

/* export functions for network.sh use */
void NIC_Gen_Ifinfo();

/* export functions */
int	NIC_Info_Comp(NIC_NAS_INFO *info1, NIC_NAS_INFO *info2);
int	NIC_Get_Info(NIC_INFO *pif, int type);
int	NIC_Get_Tcpip(NIC_TCPIP *tcpip);
int	NIC_Set_Tcpip(NIC_TCPIP *tcpip);
int	NIC_Get_Info_From_uLinux(NIC_NAS_INFO *nic_nas_info, int type);
int	NIC_Set_Info_To_uLinux(NIC_NAS_INFO *nic_nas_info);
int	NIC_Count_Interface();
int	NIC_Set_DNS(char *ipaddr);
int	NIC_Get_DNS(char *ipaddr, int len);
int 	NIC_Set_DNS_DHCP(int index, char *ipaddr);
int	NIC_Set_DNS_Ex(int index, char *ipaddr);
int	NIC_Get_DNS_Ex(char *ipaddr_list, int buf_size, int array_size);
int	NIC_Create_Resolv();
int	NIC_Get_Resolv(char *ipaddr, int len);
int	NIC_Get_Resolv2(char *ipaddr1, int len1, char *ipaddr2, int len2);
int	NIC_Is_WINS_Enabled();
int	NIC_Is_DHCP_Server_Enabled();
int	NIC_Is_Support_NAT();
int	NIC_Is_Support_Router();
int	NIC_Enable_WINS(int bEnable);
int	NIC_Set_WINS(char *ipaddr);
int	NIC_Get_WINS(char *ipaddr, int len);
int	NIC_Set_WINS_Support(int bEnable);
int	NIC_Get_WINS_Support();
int	NIC_Is_Started(int type);
int	NIC_Restart();
int	NIC_Get_Dev(char *dev, int len, int type);
int	NIC_Get_Default_Dev(char *dev, int len, int type);
int	NIC_Get_HWADDR(char *hwaddr, int addr_len, int type);
int	NIC_Get_Default_HWADDR(char *hwaddr, int addr_len, int type);
int	NIC_Set_HWADDR(int type);
int	NIC_Set_VHWADDR(char *hwaddr, int type);
int	NIC_Get_VHWADDR(char *hwaddr, int addr_len, int type);
int	NIC_Enable_VHWADDR(int bEnable, int type);
int	NIC_Is_VHWADDR_Enabled(int type);
int	NIC_Parse_HWADDR (char * mac_addr, int index);
void	NIC_Reset(int mode);

//===================================================================
//	pppoe define
//===================================================================
typedef struct
{
	char	username[128];
	char	passwd[32];
	int	connect_on_boot;
	int	keep_alive;
	int	idle;
	int	fail_use_dhcp;
} PPPOE;

#define SZ_PPPOE_SECTION		"PPPOE"
#define SZ_PPPOE_SUPPORT_FIELD		"Support"
#define SZ_PPPOE_USERNAME_FIELD		"Username"
#define SZ_PPPOE_PASSWORD_FIELD		"Password"
#define SZ_PPPOE_CONNECT_FIELD		"Connect On Boot"
#define SZ_PPPOE_KEEP_ALIVE_FIELD	"Keep Alive"
#define SZ_PPPOE_IDLE_TIME_FIELD	"Idle Timeout"
#define SZ_PPPOE_FAIL_USE_DHCP_FIELD	"Fail Use DHCP"

#define PPPOE_CONNECT_BOOT		1
#define PPPOE_CONNECT_NONE		0

#define PPPOE_CONF		"/etc/config/ppp/pppoe.conf"
#define PPPD_PAP_CONF		"/etc/config/ppp/pap-secrets"
#define PPPD_CHAP_CONF		"/etc/config/ppp/chap-secrets"
#define PPPD_OPTIONS_CONF	"/etc/config/ppp/options"

#define PPPOE_STATUS_DISABLE		1
#define PPPOE_STATUS_CONNECT		2
#define PPPOE_STATUS_CONNECTING		3
#define PPPOE_STATUS_READY		4
#define PPPOE_STATUS_DHCP		5

/* export pppoe functions */
int     NIC_Get_PPPOE(PPPOE *pppoe);
int     NIC_Set_PPPOE(PPPOE *pppoe);
int	NIC_Get_PPPOE_Latest_Error();
int	NIC_Is_Support_PPPOE();
int	NIC_Get_PPPOE_Status();
int	NIC_Restart_PPPOE();
int	NIC_Start_PPPOE();
int	NIC_Stop_PPPOE();

//=============================================
//	pptp definition
//=============================================
typedef struct
{
	char	serveraddr[NIC_IPADDR_LEN];
	char    username[128];
        char    passwd[32];
        int     keep_alive;
        int     idle;
	int	fail_use_dhcp;
} PPTP;

#define SZ_PPTP_SECTION			"PPTP"
#define SZ_PPTP_SUPPORT_FIELD		"Support"
#define SZ_PPTP_SERVER_FIELD		"Server IP"
#define SZ_PPTP_LOCAL_FIELD		"Local IP"
#define SZ_PPTP_USERNAME_FIELD		"Username"
#define SZ_PPTP_PASSWORD_FIELD		"Password"
#define SZ_PPTP_KEEP_ALIVE_FIELD	"Keep Alive"
#define SZ_PPTP_IDLE_TIME_FIELD		"Idle Timeout"
#define SZ_PPTP_FAIL_USE_DHCP_FIELD	"Fail Use DHCP"

#define PPTP_STATUS_DISABLE		11
#define PPTP_STATUS_CONNECT		12
#define PPTP_STATUS_CONNECTING		13
#define PPTP_STATUS_READY		14
#define PPTP_STATUS_DHCP		15

/* export pptp functions */
int	NIC_Is_Support_PPTP();
int	NIC_Get_PPTP(PPTP *pptp);
int	NIC_Set_PPTP(PPTP *pptp);
int	NIC_Get_PPTP_Status();
int	NIC_Restart_PPTP();
int	NIC_Start_PPTP();
int	NIC_Stop_PPTP();

#define DHCP_STATUS_READY		21
#define DHCP_STATUS_DISABLE		22
#define DHCP_STATUS_CONNECTING		23

/* export wan dhcp functions */
int	NIC_Restart_DHCP(int type);
int	NIC_Stop_DHCP(int type);
int	NIC_Start_DHCP(int type);
int	NIC_Is_WAN_Use_Tmp_DHCP();
int	NIC_Get_DHCP_Status(int type);

#define NIC_CONNECT		1
#define NIC_CONNECTING		2
#define NIC_DISCONNECT		3

int	NIC_Get_Status(int type);
int	NIC_Check_Status(int type);
int	NIC_Check_Status_By_Dev(char *dev);

/////////////////////////////////////////////////////////////////////////////
//	Add by Egbert Chen in 2002/02/19
//		Define the value of wlan's parameters
#define WLAN_UNSUPPORTED	0
#define WLAN_SUPPORTED		1

#define WLAN_DISABLED		0
#define WLAN_ENABLED		1

#define WLAN_WEP_DISABLE	0
#define WLAN_WEP64UP		1
#define WLAN_WEP128UP		2

#define WLAN_STRBUFF_SIZE	64

#define WLAN_SECTION				"WLAN"
#define WLAN_KEY_SUPPORT			"Support"
#define WLAN_KEY_ENABLE				"Enable"
#define WLAN_KEY_SSID				"SSID"
#define WLAN_KEY_CHANNELID			"Channel"
#define WLAN_KEY_RTSTHRESHOLD		"RTSThreshold"
#define WLAN_KEY_FRAGMENTTHRESHOLD		"FragmentThreshold"
#define WLAN_KEY_WEPENCYPTION		"WEPEncyption"
#define WLAN_KEY_WEPDEFAULTKEYID	"WEPDefaultKeyID"
#define WLAN_KEY_KEYVALUE			"Key"


//		Define the new section and field of uLinux.conf for wlan usage

typedef struct 
{
	int		nEnabled;							//	WLAN_DISABLE:0 ; WLAN_ENABLE:1
	char	szSSID[WLAN_STRBUFF_SIZE];			// string ; end of NULL;
	int		nChannelID;							//	1 to 14
	int		nRTSThreshold;						//	0 to 2432
	int		nFragmentThreshold;					//	255 to 2432
	int		nWEPEncyption;						//	WLAN_WEP_DISABLE:0; WLAN_WEP64UP:1
												//	WLAN_WEP128UP:2;

	int		nWEPDefaultKeyID;					//	0 to 3
	char	szKeyValue[4][WLAN_STRBUFF_SIZE];	//  WEP key value in string form.
}	WLAN, *PWLAN;

int Is_WLAN_Supported();			// return value: WLAN_UNSUPPORTED:0 or WLAN_SUPPORTED:1
int Is_WLAN_Enabled();			// return value: WLAN_DISABLE:0 or WLAN_ENABLE:1
int Get_WLAN_Data(PWLAN pwlan);	// pwlan; point to struct WLAN to get data
								//		return value: 0: failure or 1: success
int Set_WLAN_Data(PWLAN pwlan);	// pwlan; point to struct WLAN to set data
								//		return value: 0: failure or 1: success
typedef enum {  Bin, Oct, Dec, Hex } CodeType;

int Int2Str(int value, char* buff, int buff_size, CodeType type);
int Is_WLAN_Card_Exist();
//
/////////////////////////////////////////////////////////////////////////////
//=============================================
//      bonding definition
//=============================================
#define BONDING_STANDALONE      0
#define BONDING_LOAD_BALANCE    1
#define BONDING_FAIL_OVER       2

#define BONDING_VALUE_STANDALONE        "STANDALONE"
#define BONDING_VALUE_LOAD_BALANCE      "LOAD BALANCE"
#define BONDING_VALUE_FAIL_OVER         "FAIL OVER"

typedef struct
{
        char    nic01[NIC_DEV_LEN];
        char    nic02[NIC_DEV_LEN];
	char	nic03[NIC_DEV_LEN];
	char	nic04[NIC_DEV_LEN];
} BONDING;

int     NIC_Is_Bonding_Support();
int     NIC_Get_Bonding_Interface(BONDING *bonding);
int     NIC_Get_Bonding_Type();
int     NIC_Set_Bonding_Type(int bonding_type);
int	NIC_Bonding_Cfg_Copy(NIC_NAS_INFO *nic_nas_info);

// Catherine 2003/08/05 ==>
int     NIC_Is_Switch_Support();
int	NIC_Count_Bonding_Interface();
int	NIC_Is_Bonding_Device(char* nic_name);
// <== Catherine

#define NLK_NAME_LEN		32
#define NLK_DEV_CNT		16
#define NLK_DEV_LEN		17      /* linux support up to 16 */
#define NLK_IPADDR_LEN		16

#define NETLINKS_CONF_FILE		"/etc/config/NetLinks.conf"

#define NLK_LLN_FIELD             	"Logical Link Number"
#define NLK_PIN_FIELD               	"Physical Interface Number"
#define NLK_ALWAYS_BONDING_FIELD        "Always Bonding"
#define NLK_BONDING_TYPE_FIELD          "Bonding Type"
#define NLK_LINK_ENABLE_FIELD           "Enable"
#define NLK_LINK_USAGE_FIELD         	"Usage"
#define NLK_LINK_IPADDR_FIELD           "IP Address"
#define NLK_LINK_NETMASK_FIELD          "Subnet Mask"
#define NLK_BROADCAST_FIELD             "Broadcast"
#define NLK_GATEWAY_FIELD               "Gateway"
#define NLK_DHCP_SERVER_ENABLE_FIELD    "DHCP Server Enable"
#define NLK_DHCP_START_RANGE_FIELD      "DHCP Start Range"
#define NLK_DHCP_END_RANGE_FIELD        "DHCP End Range"
#define NLK_DHCP_MAX_LEASE_TIME_FIELD   "DHCP Max Lease Time"
#define NLK_DHCP_PRIMARY_DNS_FIELD	"DHCP Primary DNS"
#define NLK_DHCP_SECONDARY_DNS_FIELD	"DHCP Secondary DNS"

#define NLK_TRUE_STR			"TRUE"
#define NLK_FALSE_STR			"FALSE"
#define NLK_DHCP_STR			"DHCP"

#define	GLOBAL_SECTION		"global"

#define NLK_SUCCESS		0
#define NLK_FAIL		-1
#define NLK_RESTART		1

#define NLK_LINE		1024

/*typedef struct NLK_INFO
{
	char dev[NLK_DEV_CNT][NIC_DEV_LEN];  // eth0 or eth1... 
        char ipaddr[NLK_IPADDR_LEN];
        char netmask[NLK_IPADDR_LEN];
        char gateway[NLK_IPADDR_LEN];
        char broadcast[NLK_IPADDR_LEN];
} NLK_INFO; */

typedef struct NLK_DHCP_INFO
{
	int nOperate;		// 0 = off, 1 = on
	char sStartAddress[16];
	char sEndAddress[16];
	int nMax_lease_time_day;
	int nMax_lease_time_hour;
	char sLocalIP[16];
	char sSubnet[16];
	char sSubnet_web[16];
	char sNetmask[16];
	char sDomain_name_server[16];
	char sDomain_name_server2[16];
	char sRouter[16];
	int nHowmany;
} NLK_DHCP_INFO;

typedef struct
{
	char name[NLK_NAME_LEN];
	int pin;
	int enable;
	int usage;
	NIC_INFO ifconfig;
} NLK_LINK_INFO;

int	NLK_Get_Link_Cnt(); // YF
int	NIC_Get_New_Link_Num();
int	NLK_Get_Nic_Cnt();  //YF
int     NLK_Get_Link_Name(char *link_section, char *name);  //YF
int     NLK_Get_Link_Nic_Cnt(int link_num);
int     *NLK_Get_Available_NIC();
int     NLK_Get_Available_NIC_cnt();
int	*NLK_Get_Link_Assigned_NIC(int link_num);
int	NLK_Get_Link_Num(char *name);
int     Get_NLK_Links_info(NLK_LINK_INFO nlk_link_info, int lnk_num);
int     Set_NLK_Links_info(NLK_LINK_INFO nlk_link_info, int lnk_num);
int     NIC_Get_Info_From_NetLinks(NIC_NAS_INFO *nic_nas_info, int link_num);
int     NIC_Set_Info_To_NetLinks(NIC_NAS_INFO *nic_nas_info, int link_num);
int	NIC_Get_Bonding_Type_NetLinks();
int     NIC_Set_Bonding_Type_NetLinks(int bonding_type);
int     NIC_Set_Info_To_NetLinks(NIC_NAS_INFO *nic_nas_info, int link_num);
int	NIC_Is_Bonding_Support_NetLinks();

int	NIC_Get_Switch_Speed(char *speed);
int     NIC_Set_Switch_Speed(char *speed);
int	NIC_Get_Default_Link(char *Gateway);
int	NIC_Set_Default_Link(char *Gateway);
