//**************************************************************************
//
//      Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//      FILE:
//              cfg_logo.h
//
//      Abstract:
//              LOGO configuration Access Functions.
//
//      FUNCTIONS:      TBD.
//
//      COMMENTS:       N/A
//
//      HISTORY:
//      02/04/2002      Johnson Hsu created
//      2002/02/23      Kent re-formated, change algorithm of logo function
//
//**************************************************************************

#define LOGO_SHELL			"/etc/init.d/logo.sh"
#define DEVNULL				"2>/dev/null 1>/dev/null"
#define SHOW_IMG			"show_logo_img.gif"
#define DEFAULT_IMG			"default_logo_img.gif"
#define UPLOAD_IMG			"upload_logo_img.gif"
#define PIC_INDEX			6
#define LOGO_FILESIZE_DEFAULT		"20480"
#define LOGO_SHOW_PIC_DEFAULT		"0"		//disable show pic
#define CONFIG_FILE_NAME                "uLinux.conf"
#define CONFIG_FILE_PATH                "/etc/config"

#define FLASH_IMG_LOC			"/etc/config/logo"
#define HTTPD_IMG_LOC			"/v3_menu/images"
#define LOGO_IMG			"pic%d_logo_img.gif"
#define UPLOAD_LOGO_IMG			"upload%d_logo_img.gif"

#define PATH_STR_LEN			255
#define BUF_STR_LEN			128
#define STR_LENGTH			64

#define ULINUX_CONF_LOC                 "/etc/config/uLinux.conf"
#define LOGO_SHOW_PIC_IDX_FIELD         "Show PIC Index"
#define LOGO_DEFAULT_FIELD              "Default LOGO Image Path"
#define LOGO_UPLOAD_FIELD               "Upload LOGO Image Path"
#define LOGO_PIC1_FIELD                 "PIC1 LOGO Image Path"
#define LOGO_PIC2_FIELD                 "PIC2 LOGO Image Path"
#define LOGO_PIC3_FIELD                 "PIC3 LOGO Image Path"
#define LOGO_PIC4_FIELD                 "PIC4 LOGO Image Path"
#define LOGO_PIC5_FIELD                 "PIC5 LOGO Image Path"
#define LOGO_PIC6_FIELD                 "PIC6 LOGO Image Path"
#define LOGO_PIC_COUNTER_FIELD          "PIC Counter"
#define LOGO_IMG_LIMIT_FIELD            "LOGO Image Size Limitation"
#define LOGO_SESSION_NAME               "LOGO"

// function prototype of cfg_logo.c
BOOL	LOGO_Start();
int	LOGO_Init();
int	LOGO_Set_PIC(char *filename, int index);
BOOL	LOGO_Check_Session_Exist();
int	LOGO_Get_Preview_PIC(char *filename, int length, int index);
int	LOGO_Get_PIC(char *filename, int length, int index);
int	LOGO_Get_Counter();
int	LOGO_Set_Counter(int value);
void	LOGO_Remove(int index);
void	LOGO_Replace_PIC();
int	LOGO_Set_Index();
int	LOGO_Get_Index();
int 	LOGO_Set_Default(char *value);
int 	LOGO_Set_Upload(char *value);
int 	LOGO_Set_Limit(char *value);
BOOL 	Is_Logo_Support();

