//#ifndef _CFG_DVD_H_
//#define _CFG_DVD_H_



#define E_DVD_DEVICE			-1
#define E_DVD_MEDIA               	-2
#define E_BURNING_DETECT_EXIT	  	64256
#define E_MEDIA_DETECT_CANCEL	  	2
#define E_GET_PROCESS		  	-4
#define E_OUTSPACE			39936
#define E_CD_CLOSED             	2304
#define E_DIR_NOT_EXIST         	34048
#define E_NO_DISC               	-3
#define E_LOAD				-5
#define E_OUT_DISK_SIZE			-6
#define E_CD_BURNING			-7



#define MEDIA_UNUSED			12001		

#define GET_MEDIA_INFO  1
#define GET_DEVICE_INFO 2

#define CD_R        1
#define CD_RW       2
#define DVD_PLUS_R  3
#define DVD_R       4
#define DVD_PLUS_RW 5
#define DVD_RW      6
#define DVD_R_DL    7
#define SUPPORT_ALL 8

#define CMD_DVD_MKISO	"/usr/bin/mkisofs"
#define CMD_DVD_INFO	"/usr/bin/dvd+rw-mediainfo"
#define CMD_DVD_BURN	"/usr/bin/growisofs"
#define CMD_CD_BURN	"/usr/bin/cdrecord"
#define CMD_CD_DETECT	"/usr/bin/detectCD.sh"
#define CMD_PS		"/bin/ps"
#define CMD_KILL	"/bin/kill -9"
#define CMD_KILL_SIG	"/bin/kill -USR"
#define CMD_EJECT	"/usr/bin/eject"
#define CMD_WRITE_LOG	"/sbin/write_log"

#define DEV_COUNT		3
char	DVD_USB_DEV[3][10]={"/dev/scd0", "/dev/scd1", "/dev/scd2"};

#define SPEED_DESCRIPT_1	0
#define SPEED_DESCRIPT_2	1
#define SPEED_DESCRIPT_3	2

#define VOL_NAME_LENGTHEN	12
#define VOL_CONTENT_MAX  	100
#define TYPE_MSG_LENGTH   	100
#define MEDIA_INFO_LENGTH 	33
#ifndef BUF_SIZE
	#define BUF_SIZE          	64
#endif
#define CMD_LENGTH        	255
#define DESCRIPT_LENGTH		64
#define SUPPORT_SPEED_DESCRIPT	5
#define LABEL_LENGTH		32

#define MED_LOG_FILE 		"/home/httpd/cgi-bin/misc/med_log"
#define PROCESS_LOG		"/home/httpd/cgi-bin/misc/process_log"
#define LOAD_PROCESS_LOG	"/home/httpd/cgi-bin/misc/load_process_log"
#define IMAGE			"/share/HDA_DATA/cd_image"
#define ERROR_FILE		"/home/httpd/cgi-bin/misc/error"
#define COPYING			"/home/httpd/cgi-bin/misc/coping"

#define SZ_DVD_SECTION "Dvd"
#define SZ_STATUS_FIELD "Status"

#define OVERWRITE_MODE 0
#define SKIP_MODE 1

#define STATUS_BURNING		"Burning"
#define STATUS_READY		"Ready"
#define STATUS_EMPTY		"Empty"
#define STATUS_ERASING		"Erasing"
#define STATUS_COPYING		"Copying"

#define CD		1
#define NO_CD		0

#define DVD_CONFIG              "/etc/config/dvd.conf"
#define DVD_SECTION             "Dvd"
#define DVD_DEV_FIELD		"Device Type"
#define DVD_MED_FIELD           "Media Type"
#define DVD_SPEED_FIELD         "Maximum Write Speed"
#define DVD_STATUS_FIELD        "Status"
#define DVD_VOL_FIELD		"Volume"
#define DVD_LABEL_FIELD         "Volume Label"
#define DVD_SOURCE_VOL_FIELD    "Source Vol"
#define DVD_SOURCE_PATH_FIELD   "Source Path"
#define DVD_DEV_NO_FIELD        "DEV_NO"
#define DVD_BPATH		"bpath"
#define DVD_LOAD_PATH_FIELD	"Load Path"
#define DVD_CD_DEV_NO_FIELD	"cd_dev_no"
#define DVD_LOADTYPE_FIELD	"Load Type"

typedef struct VOL_TYPE {
	char name[VOL_NAME_LENGTHEN];
	char content[VOL_CONTENT_MAX];
	long int vol_size;
	long int count_of_files;
	struct VOL_TYPE *next;
} VOL_TYPE;

typedef struct DEVICE_TYPE {
	char dev_type[TYPE_MSG_LENGTH];
} DEVICE_TYPE;

typedef struct MEDIA_TYPE {
	int type;
	char	type_msg[TYPE_MSG_LENGTH];
	float	speed;
	char	label[LABEL_LENGTH];
	char	w_speed_descript[SUPPORT_SPEED_DESCRIPT][DESCRIPT_LENGTH];
} MEDIA_TYPE;



int DVD_Is_Device_Exist(int dev);
int DVD_Is_Media_Exist(int,int);
int DVD_Get_Device_Info(DEVICE_TYPE *dev,int usbdev);
int DVD_Get_Media_Info(MEDIA_TYPE *, int, int);
int DVD_Burn_DVD(char *vollabel,int speed,int usbdev,char *src_file);
int DVD_Get_Burning_Process(char *filename, char *percent_buf);
int DVD_Get_Status(char *status_buf);
int DVD_Set_Status(char *status_buf);
int DVD_Eject_Rom(int usbdev);
int DVD_Load_Data(char *src_path,char *dest,int option);
int DVD_Erase_Rom(int dev);
int DVD_BurnCD(char *,int,int);
int DVD_Clear_Conf();
int DVD_Get_Copy_Status();
int DVD_Get_Cd_Dev_no(int);
char *itoa(int);
int check_size(char *,int *);
int get_media_label(char *,int);
int check_path(char *);
int translate(char *,char *);
BOOL Is_DVD_Support();
