#ifndef		_CFG_DHCP
#define		_CFG_DHCP

#define		START_POSITION		0
#define		END_POSITION		1

#define		RESERVE_RANGE_1		0
#define		RESERVE_RANGE_2		1

#define		ETH_0			0
#define		ETH_1			1
#define		ETH_2			2
#define		ETH_3			3
#define		ETH_4			4
#define		ETH_5			5
#define		ETH_6			6
#define		ETH_7			7

#define		_USE_NEW_FUNCTION
//#define		_USE_PRIVATE_CONF

#ifdef		_USE_PRIVATE_CONF
  #define	DHCP_CONF			"/etc/config/dhcp.conf"
#endif
					 
#ifdef		_USE_NEW_FUNCTION
  #define	GET_PROFILE_STRING		Get_Profile_String
  #define	GET_PRIVATE_PROFILE_STRING	Get_Private_Profile_String
  #define	SET_PROFILE_STRING		Set_Profile_String
  #define	SET_PRIVATE_PROFILE_STRING	Set_Private_Profile_String
  #define	GET_PROFILE_INTEGER		Get_Profile_Integer
  #define	GET_PRIVATE_PROFILE_INTEGER	Get_Private_Profile_Integer
#else
  #define	GET_PROFILE_STRING		GetProfileString
  #define	GET_PRIVATE_PROFILE_STRING	GetPrivateProfileString
  #define	SET_PROFILE_STRING		WriteProfileString
  #define	SET_PRIVATE_PROFILE_STRING	WritePrivateProfileString
  #define	GET_PROFILE_INTEGER		GetProfileInteger
  #define	GET_PRIVATE_PROFILE_INTEGER	GetPrivateProfileInteger
  
  #ifdef	_USE_PRIVATE_CONF
    int GetPrivateProfileInteger (char * lpAppName, char * lpKeyName,
					 int default_value, char * filename);
  #else
    int GetProfileInteger (char * lpAppName, char * lpKeyName,
					 int default_value);
  #endif  
  BOOL GetProfileBOOL (char * section_name, char * key_name, 
						BOOL default_value);
#endif

//  public function
BOOL Is_DHCP_Enable (void);
BOOL Enable_DHCP (BOOL Enable);
int Get_DHCP_Range (int pos, char * buf, int size);
BOOL Set_DHCP_Range (int pos, char * range);
unsigned long Get_Max_Lease_Time (void);
unsigned long Get_Max_Lease_Time_Day (void);
unsigned long Get_Max_Lease_Time_Hour (void);
BOOL Set_Max_Lease_Time (unsigned long time);
BOOL Set_Max_Lease_Time_Day (unsigned long time);
BOOL Set_Max_Lease_Time_Hour (unsigned long time);
int Get_DHCP_Device (void);
BOOL Set_DHCP_Device (int device);
int Get_Reserve_Range (int index, int pos, char * buf, int size);
BOOL Set_Reserve_Range (int index, int pos, char * range);
int Reload_DHCP_Config (void);

//  private function
int get_dns (char * buf, int size);
int get_dns2 (char * buf, int size);
BOOL set_dns (char * buf);
BOOL set_dns2 (char * buf);

int get_ex_dns (char * buf, int size);
int get_ex_dns2 (char * buf, int size);
BOOL set_ex_dns (char * buf);
BOOL set_ex_dns2 (char * buf);

//   dhcpdconf.h about dhcpd.conf's function
#define		DHCP_BUF_SIZE			1024
#define		DHCPD_CONF			"/etc/dhcpd.conf"
#define		RESOLV_CONF			"/etc/resolv.conf"

#define		DHCP_OFF			0
#define		DHCP_ON				1

#define		SUCCESS				0
#define		OPEN_CONFIG_FILE_ERROR		1
#define		WRITE_CONFIG_FILE_ERROR 	2

//enum SERVER_ACTION {DISABLE, ENABLE};

struct address_range_link
{
	char sStartadd[16];
	char sEndadd[16];
	struct address_range_link * next;
};

struct range
{
	char sStartadd[16];
	char sEndadd[16];
};

struct dhcp_conf
{
	int nOperate;		// 0 = off, 1 = on
	char sStartAddress[16];
	char sEndAddress[16];
	int nMax_lease_time_day;
	int nMax_lease_time_hour;
	char sLocalIP[16];
	char sSubnet[16];
	char sSubnet_web[16];
	char sNetmask[16];
	struct range ReserveRange1;
	struct range ReserveRange2;
	char sDomain_name_server[16];
	char sDomain_name_server2[16];
	char sRouter[16];
	int nHowmany;
};

int create_dhcpd_conf (struct dhcp_conf DHCP_conf);
void read_dhcp_conf (struct dhcp_conf *);
void read_dhcp_conf_netlinks (struct dhcp_conf *, int link_num);
void release_link (struct address_range_link *);
void add_to_link (struct address_range_link **, struct address_range_link *);
int convert_range (char *, char *, struct range *, struct range *, struct address_range_link **);
int get_default_nameserver (char *, int);
int parser_ip (char *, int);
int get_subnet(char *, char *, char *, int);
int get_max_range (char * natmask, char * ip, int index);
int get_min_range (char * natmask, char * ip, int index);
int get_usage ();
char * combine_ip (char * head, char * tail, int pos);
int nic_dns_setting (char * buf1, int size1, char * buf2, int size2);
char * get_local_ip_from_uLinux ();
char * get_wan_hwaddr ();
char * get_dhcp_device ();

#endif
