#ifndef		_DDNS_SETTING
#define		_DDNS_SETTING

#define		DDNS_SECTION			"DDNS"
#define		DDNS_SUPPORT			"Support"
#define		DDNS_ENABLE			"Enable"
#define		DDNS_USER			"User Name"
#define		DDNS_PASSWORD			"Password"
#define		DDNS_HOST_NAME			"Host Name"
#define		DDNS_MX				"Mail Exchanger"
#define		DDNS_BACKUPMX			"Backup MX"
#define		DDNS_WILDCARD			"Wildcard Support"
#define		DDNS_DEVICE			"Device"
#define		DDNS_TYPE			"DDNS Type"
#define		DDNS_SERVER_TYPE		"Server Type"
#define		DDNS_SUPPORTED_SERVER		"Supported Server"
#define		DDNS_CONFIG_FILE		"Config File"
#define		DDNS_IP_ADDRESS			"IP Address"

#define		DDNS_MAX_BUF_SIZE		256
#define		DDNS_DEV_BUF_SIZE		32
#define		DDNS_IPADDR_BUF_SIZE		32
#define		MAX_SUPPORT_SERVER_NUM		4

#define		DDNS_ERROR_UPDATE		1
#define		DDNS_ERROR_SHUTDOWN		2
#define		DDNS_ERROR_STRANGE_RESPOND	3
#define		DDNS_ERROR_INVLAID_HOST		4
#define		DDNS_ERROR_MALFORMED_HOST	5
#define		DDNS_ERROR_HOST_NOT_CONTROL	6
#define		DDNS_ERROR_HOST_ABUSE		7
#define		DDNS_ERROR_AUTHENTICATION	8
#define		DDNS_ERROR_INVALID_ARAMETER	9
#define		DDNS_ERROR_USERAGENT_BLOCKED	10
#define		DDNS_ERROR_NUMBER_OF_HOSTS	11
#define		DDNS_ERROR_INTERNAL_FAIL	12
#define		DDNS_ERROR_IP_RESOLV		13

#define		DDNS_ERROR_USER_NAME		14
#define		DDNS_ERROR_PASSWORD		15
#define		DDNS_ERROR_HOST_NAME		16


#define		DDNS_ERROR_SET_USER_NAME	-4
#define		DDNS_ERROR_SET_PASSWORD		-5
#define		DDNS_ERROR_SET_HOST_NAME	-6
#define		DDNS_ERROR_SET_WILDCARD		-7
#define		DDNS_ERROR_SET_MX		-8
#define		DDNS_ERROR_SET_BACKMX		-9
#define		DDNS_ERROR_SET_DEIVCE		-10
#define		DDNS_ERROR_SET_DDNS_TYPE	-11
#define		DDNS_ERROR_SET_DDNS_SERVER	-12
#define		DDNS_ERROR_GET_INFO		-13
#define		DDNS_ERROR_SET_IP_ADDR		-14

#define		DDNS_ERROR_WRITING		-17

#define		DISABLE_DDNS			FALSE
#define		ENABLE_DDNS			TRUE

enum {
	DYNDNS,
	OBS,
	DNS,
	DYNS
};

struct ServerInfo {
	int TypeID;
	char ServerName[DDNS_MAX_BUF_SIZE];
	char Web_Side[DDNS_MAX_BUF_SIZE];
};

/* Ricky remark it, not used
static struct ServerInfo serverinfo[] = 
{
	{DYNDNS, 	"DynDNS", "www.dyndns.org"},
	{OBS, 		"ods", 	"update.ods.org"},
	{DNS, 		"dhs", 	"members.dhs.org"},
	{DYNS, 		"dyns", "www.dyns.cx"}
};
*/

enum {
	DDNS_DYNAMIC,
	DDNS_STATIC
};

struct DDNS_Information {
	int Support;
	int Enable;
	int Wildcard;
	int BackupMX;
	int DDNS_Type;
	int DDNS_Server;
	char UserName[DDNS_MAX_BUF_SIZE];
	char Password[DDNS_MAX_BUF_SIZE];
	char HostName[DDNS_MAX_BUF_SIZE];
	char MailExchanger[DDNS_MAX_BUF_SIZE];
	char Device[DDNS_DEV_BUF_SIZE];
	char ConfigFile[DDNS_MAX_BUF_SIZE];
	char IP_Address[DDNS_IPADDR_BUF_SIZE];
};

BOOL Is_DDNS_Support (void); // TRUE = support
BOOL Is_DDNS_Enable (void);  // TRUE = enable
int  Enable_DDNS (BOOL Enable);
BOOL Get_DDNS_Info (struct DDNS_Information * ddns_info);
int  Set_DDNS_Info (struct DDNS_Information * ddns_info);
int  Check_DDNS_Info (struct DDNS_Information * ddns_info);

int  Get_DDNS_User_Name (char * user_name, int size);
BOOL Set_DDNS_User_Name (char * user_name);
int  Get_DDNS_User_Password (char * password, int size);
BOOL Set_DDNS_User_Password (char * password);
int  Get_DDNS_Host (char * host, int size);
BOOL Set_DDNS_Host (char * host);
BOOL Is_Wildcard_Support (void);
BOOL Wildcard_Support (int action);  //  0 = disable, 1 = enable
int  Get_DDNS_MX (char * mx, int size);
BOOL Set_DDNS_MX (char * mx);
BOOL Is_DDNS_BackupMX (void);
BOOL DDNS_BackupMX (int action);  //  0 = disable, 1 = enable
int  Get_DDNS_Device (char * device, int size);
BOOL Set_DDNS_Device (char * device);
int  Get_DDNS_Type (void); //  0 = dynamic, 1 = static
BOOL Set_DDNS_Type (int type); //  0 = dynamic, 1 = static
int  Get_DDNS_Server (void);
BOOL Set_DDNS_Server (int type);
int  Get_DDNS_Config_File (char * config_file, int size);
int  Get_DDNS_IP_Address (char * ip_addr, int size);
BOOL Set_DDNS_IP_Address (char * ip_addr);
int  Restore_DDNS_Info (struct DDNS_Information * ddns_info);

#endif
