#include <time.h>
#define BACKUP_SUCCESS			0
#define BACKUP_FAIL			-1

#define BACKUP_SCHEDULE_CONF		"/etc/config/backup_schedule.conf"
#define BACKUP_VERSION			1
#define BACKUP_SN_VERSION		2

//#define BACKUP_AUTH_FAIL		-5
//#define BACKUP_DIR_FAIL			-6

#define ERROR_SCHEDULE_DUPLICATE	-10
#define ERROR_SCHEDULE_NOT_FOUND	-11

#define ADD_BK_SNAP_OPTION_INVALID	-501
#define ADD_BK_SNAP_CREATE_FAIL		-502
#define EDIT_BK_SNAP_OPTION_INVALID	-503
#define EDIT_BK_SNAP_CREATE_FAIL	-504


#define MAX_PATH			1024

#define	__SNAPSHOT__			// Catherine 2003/04/22
					// for creating a new snapshot before RR

enum
{
	BACKUP_GET=1,
	BACKUP_PUT
};

enum
{
	BK_VIA_FTP=1,
	BK_VIA_CIFS,
	BK_VIA_NFS,
};

enum
{
	BK_IMMEDIATELY=1,
	BK_DAY,
	BK_WEEK,
	BK_MONTH,
	BK_ARR_SYNC,
};

/* for schedule->status use	*/
enum
{
	BK_ACTION=1,
	BK_NONE_ACTION,
	BK_SERVER_NOT_FOUND,
	BK_SERVER_ERROR,
	BK_AUTH_FAIL,
	BK_DIR_FAIL,
	BK_COPY_FAIL,
	BK_COMPRESS_FAIL,
	BK_NOW,
	//add by John for Backup_Copy API error codes
	BK_SRC_DIR_FAIL,
	BK_DEST_DIR_FAIL,
	BK_REMOVE_FAIL,
	//add end
#ifdef	__SNAPSHOT__
	BK_SNAP_OPTION_INVALID,
	BK_SNAP_CREATE_FAIL,
#endif
	BK_NAS_SAME,
};

typedef struct
{
	char	path[MAX_PATH];
} BK_PATH;

typedef struct
{
	char	location[64];
} BK_SERVER;

typedef struct
{
	char	name[32];
	char	passwd[16];
} BK_USER;

typedef struct
{
	BK_SERVER	server;
	BK_USER		user;
	int		port;
} BK_FTP_INFO;

typedef struct
{
	BK_SERVER	server;
	BK_USER		user;
} BK_CIFS_INFO;

typedef struct
{
	BK_SERVER	server;
} BK_NFS_INFO;

typedef struct
{
	int	version;
	int	bodysize;
	int	total;
	int	reserved;
} BACKUP_HEADER;

typedef struct
{
	char	path[MAX_PATH];
	char	volume[64];
} BACKUP_NAS;

typedef struct
{
	char				name[32];
	int				policy;		/* backup from NAS, or backup to NAS	*/
	int				usage;		/* BK_VIA_FTP, BK_VIA_CIFS, BK_VIA_NFS	*/
	BACKUP_NAS			remote;		/* remote volume and path		*/
	BACKUP_NAS			local;		/* local volume and path		*/

	BK_FTP_INFO			ftp;
	BK_CIFS_INFO			cifs;
	BK_NFS_INFO			nfs;

	int				t_type;		/* BK_IMMEDIATELY, BK_DAY, BK_WEEK, BK_MONTH	*/
	int				week;
	int				month;
	int				t_hour;
	int				t_min;
	int				bk_pid;
	int				status;		/* BK_ACTION, BK_NONE_ACTION			*/
	time_t				latest_time;
	int				bcompress;
	int 				option;                /*BACKUP_COPY_TIMESTAMP, BACKUP_COPY_COMPRESS, BACKUP_COPY_SYNC from backup.h*/
	struct	BACKUP_SCHEDULE		*next;

#ifdef	__SNAPSHOT__
	int				rr_from_snapshot;
//	char				rr_snap_name[MAX_PATH];
#endif
} BACKUP_SCHEDULE;

typedef struct
{
        char                            name[32];
        int                             policy;         /* backup from NAS, or backup to NAS    */
        int                             usage;          /* BK_VIA_FTP, BK_VIA_CIFS, BK_VIA_NFS  */
        BACKUP_NAS                      remote;         /* remote volume and path               */
        BACKUP_NAS                      local;          /* local volume and path                */

        BK_FTP_INFO                     ftp;
        BK_CIFS_INFO                    cifs;
        BK_NFS_INFO                     nfs;

        int                             t_type;         /* BK_IMMEDIATELY, BK_DAY, BK_WEEK, BK_MONTH    */
        int                             week;
        int                             month;
        int                             t_hour;
        int                             t_min;
        int                             bk_pid;
        int                             status;         /* BK_ACTION, BK_NONE_ACTION                    */
        time_t                          latest_time;
        int                             bcompress;                                                                          int                             option;                /*BACKUP_COPY_TIMESTAMP, BACKUP_COPY_COMPRESS, BACKUP
_COPY_SYNC from backup.h*/
        struct  BACKUP_SCHEDULE         *next;

} BACKUP_SCHEDULE_V1;

/* export functions	*/
void DEBUG_Schedule(BACKUP_SCHEDULE *schedule);
int Backup_Upgrade_Schedule();
//int Backup_Get_Server(char *ipaddr, int len, char *source);
BACKUP_SCHEDULE	*Backup_Get_Schedule();
void Backup_Free_Schedule(BACKUP_SCHEDULE *schedule);
int Backup_Add_Schedule(BACKUP_SCHEDULE *new);
int Backup_Ren_Schedule(BACKUP_SCHEDULE *new, BACKUP_SCHEDULE *old);
int Backup_Del_Schedule(BACKUP_SCHEDULE *del);
int Backup_Now(BACKUP_SCHEDULE *schedule);
int Backup_Update_Status(BACKUP_SCHEDULE *schedule, int status);
int BACKUP_Get_Volume_Path(char *buf, int len, char *volume);
int write_log(char *str, int type);
void backup_write_schedule(BACKUP_SCHEDULE *schedule);
