//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		Util.h
//
//	Abstract: 
//		Header for uLinux utility library functions.
//
//	HISTORY:
//			
//      03/23/01	Louis Tsai make untility function to share library
//	02/21/01	Meiji Chang created
//
//**************************************************************************

#include "uLinux.h"

#ifndef UTIL_H
	#define UTIL_H
#define	SECTION_NAME_MAX_LENGTH	128
#define	FIELD_NAME_MAX_LENGTH	128
#define FILE_NAME_MAX_LENGTH	1024

#define LOCK_FILE_PATH		"/var/lock/uLinux"
#define	DEFAULT_CFG_FILE	"/etc/config/uLinux.conf"
#define	NETLINKS_CFG_FILE	"/etc/config/NetLinks.conf"
#define LOCK_RETRY_TIMES	3
#define LOCK_TIME_OUT		10
#define	SPACE			0x20	// Space Char 
#define TAB			0x9	// TAB Char

char *File_Fgets(FILE *fptr);
int Conf_Get_Field(char *conf_file, char *section, char *field, char *result, int buf_size);
int Conf_Enum_Section(char *conf_file, char *section_name, int buf_size);
int Conf_Remove_Section(char *conf_file, char *section_name);
int Conf_Remove_Field(char *conf_file, char *section_name, char *field_name);
int Conf_Set_Field(char *conf_file, char *section_name, char *field_name, char *field_data); 
void Conf_Case_Sensitive(BOOL flag); //default is case insensitive
int Conf_Lock_File(char *lock_file_name,char type,int time_to_live);
int Conf_Unlock_File(char *lock_file_name,char type);

//-------- Window like Configuration Access Function --------------

int GetPrivateProfileString(
  char* lpAppName,        // section name
  char* lpKeyName,        // key name
  char* lpDefault,        // default string
  char* lpReturnedString,  // destination buffer
  int   nSize,              // size of destination buffer
  char* lpFileName        // initialization file name
);

BOOL WritePrivateProfileString(
  char *lpAppName,  // section name
  char *lpKeyName,  // key name
  char *lpString,   // string to add
  char *lpFileName  // initialization file
);

int GetProfileString(char *lpAppName, char *lpKeyName, char * lpDefault, char * lpReturnedString, int nSize);
BOOL WriteProfileString(char * lpAppName, char * lpKeyName, char * lpString);

int GetProfileStringNetLinks(char *lpAppName, char *lpKeyName, char * lpDefault, char * lpReturnedString, int nSize); //for NetLinks.conf YF
BOOL WriteProfileStringNetLinks(char * lpAppName, char * lpKeyName, char * lpString);  //for NetLinks.conf YF

int Get_String_Field(char *in_str,int field_no,char delimiter,char *out_str_buf,int buf_size);
int Set_String_Field(char *in_str,int field_no,char delimiter,char *field_value,char *new_str_buf,int buf_size);
int Insert_String_Field(char *in_str,int field_no,char delimiter,char *field_value,char *new_str_buf,int buf_size);
int Remove_String_Field(char *in_str,int field_no,char delimiter);
char *Parse_String_Field(char *str, char *delimiters);

int SYS_Get_One_String(char *sysfile,int field_no,char delimiter,char *s_value,char *out_str_buf,int buf_size);
int SYS_Set_One_String(char *sysfile,int field_no,char delimiter,char *s_value,char *set_str);

char *String_To_Upper_Case(char *src);

//NasWare v2.0 new function
int  Get_Profile_String(char *lpAppName, char *lpKeyName, char * lpDefault, char * lpReturnedString, int nSize);
BOOL Set_Profile_String(char * lpAppName, char * lpKeyName, char * lpString);
BOOL Get_Profile_Boolean(char *lpAppName, char *lpKeyName,BOOL default_value);
BOOL Set_Profile_Boolean(char *lpAppName, char *lpKeyName,BOOL bValue);
int  Get_Profile_Integer(char *lpAppName, char *lpKeyName,int default_value);
BOOL  Set_Profile_Integer(char *lpAppName, char *lpKeyName,int nValue);

int  Get_Private_Profile_String( char* lpAppName,char* lpKeyName,char* lpDefault,char* lpReturnedString,int nSize,char* lpFileName);
BOOL Set_Private_Profile_String(char *lpAppName,char *lpKeyName,char *lpString,char *lpFileName);
BOOL Get_Private_Profile_Boolean(char *lpAppName, char *lpKeyName,BOOL default_value,char *lpFileName);
BOOL Set_Private_Profile_Boolean(char *lpAppName, char *lpKeyName,BOOL bValue,char *lpFileName);
int  Get_Private_Profile_Integer(char *lpAppName, char *lpKeyName,int default_value,char *lpFileName);
BOOL Set_Private_Profile_Integer(char *lpAppName, char *lpKeyName,int nValue,char *lpFileName);

// multi-bytes handling
BOOL Is_Mb_Word(char* ch);
BOOL Is_Mb_String(char* str);
BOOL Is_Legal_String(char* str);
int mb_strcasecmp(char *s1, char *s2);
int mb_strcmp(char *s1, char *s2);
int compare_string(char* str1, char* str2);
int compare_case_string(char* str1, char* str2);

//instance handling
BOOL Is_Exist_Another_Instance(char *program);
BOOL Become_Daemon();

char *Skip_White_Space_Ex(char *str);
BOOL is_tc_word(char *ch);
BOOL is_jis_word(char *ch);
BOOL is_korea_word(char *ch);
#endif
