//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		NAS.h
//
//	Abstract: 
//		Header for uLinux user/group management library functions.
//
//	HISTORY:
//      03/21/01	Louis Tsai	- modified
//	12/12/00	Meiji Chang - re-formated
//	11/01/00	Nick Ho - created
//
//**************************************************************************

#include "../uLinux/uLinux.h"
#include "config.h"

#ifndef	__ULINUX_NAS__
#define	__ULINUX_NAS__

#define CASE_FLAG		0

#define GET_RESET_PWD		1
#define GET_CONSOLE_PWD		2

#define	SHARE_NOACCESS		0
#define	SHARE_READONLY		1
#define	SHARE_READWRITE		2

#define	LARGE_NO_OF_USERS_SUPPORT	// Catherine 2003/06/18


#define	SERVER_NAME_LENGTH	15  /*- include null string -*/ 
#define	USER_NAME_LENGTH	33  /*- include null string -*/ 
#define	GROUP_NAME_LENGTH	257 /*- include null string -*/
#if USER_NAME_LENGTH>GROUP_NAME_LENGTH
#define	USER_GROUP_NAME_LENGTH	USER_NAME_LENGTH+5
#else
#define	USER_GROUP_NAME_LENGTH	GROUP_NAME_LENGTH+5
#endif
#define	PASSWORD_LENGTH		17  /*- include null string -*/

#define	SHARE_NAME_LENGTH	33  /*- include null string -*/
#define	SHARE_COMMENT_LENGTH	129  /*- include null string -*/
#define	SHARE_PATH_LENGTH	257  /*- include null string -*/

#define	MAX_USER_NUMBER		512
//#define	MAX_USER_NUMBER		3072
#define	MAX_GROUP_NUMBER	1024
#define	MAX_SECTION_NUMBER	1024	/*- define the MAX Session No,include the global session -*/
#define	MAX_SHARE_NUMBER	1024	/*- define the MAX Session No,include the global session -*/


#define	USER_ROOT		"root"
#define	USER_ADMINISTRATOR	"administrator"
#define	USER_GUEST		"guest"
#define	USER_ANONYMOUS		"anonymous"
#define	GROUP_ADMINISTRATORS	"administrators"
#define	GROUP_GUEST		"guest"
#define	GROUP_EVERYONE		"everyone"

#define PASS_CONF_FILE		"/etc/passwd"
#define	GROUP_CONF_PATH		"/etc/group"
#define	SAMBA_CONF_PATH		"/etc/smb.conf"
#define SAMBA_PASS_PATH		"/etc/config/smbpasswd"
#define SAMBA_TOOL_PATH		"/sbin/smbtools"

#define	SHARE_ROOT		"/share"
#define ILLEGAL_CHAR		"\"/\\+=.:|*?<>[];,%"
#define PDC_PREFIX_NAME			"PDC_"

//------- Define Code Page -------------
#define CODE_Traditional_Chinese	950

//------- for NasWare v4
#define	__QNAP_NAS_ADS__

//------ Structure definition ------
typedef  struct NAS_USER_INFO 
	{
		char	user_name[USER_NAME_LENGTH];
		char	password[PASSWORD_LENGTH];
		char	primary_group[GROUP_NAME_LENGTH];  // for add user use, the primary grp 
		ULONG	uid;
		ULONG	gid;      // for get user info use 
		//int    grp_no;
		//string (*grp_list_ptr)[GROUP_NAME_LENGTH];
		//string *home_dir;
	}	NAS_USER_INFO;

typedef  struct NAS_GROUP_INFO 
	{	
		char	group_name[GROUP_NAME_LENGTH];
		ULONG	gid;
		char	(*user_list)[USER_NAME_LENGTH];
		int	list_count;	// list count of user_list
		int	user_count;	// user count of user_list
	}	NAS_GROUP_INFO;



typedef  struct SAMBA_STATUS_INFO 
	{
		char	service[SHARE_NAME_LENGTH];
		char	pid[10];
		char	user_name[USER_NAME_LENGTH];
		char	from_name[USER_NAME_LENGTH];
		char	login_time[BUF_SIZE];
		char	ip[USER_NAME_LENGTH];
	}	SAMBA_STATUS_INFO;



//struct session_info {
typedef  struct SECTION_INFO 
	{
		char	section_name[SHARE_NAME_LENGTH];
		int	line_post;	// the session line no of specified file
	}	SECTION_INFO;

//typedef	SECTION_INFO	SHARE_NAME_INFO;
typedef  struct SHARE_NAME_LIST
	{
		char	share_name[SHARE_NAME_LENGTH];
	}	SHARE_NAME_LIST;


//struct share_info {
typedef  struct NAS_SHARE_INFO 
{
		char	share_name[SHARE_NAME_LENGTH];
		char	comment[SHARE_COMMENT_LENGTH];
		char	path[SHARE_PATH_LENGTH];
		int	read_list_cnt;
		char	(*read_list_ptr)[USER_GROUP_NAME_LENGTH];
		int	write_list_cnt;
		char	(*write_list_ptr)[USER_GROUP_NAME_LENGTH];
}	NAS_SHARE_INFO;

typedef struct tagUser_List
{
	char			username[USER_NAME_LENGTH];
	struct tagUser_List	*next;
} USER_LIST;

typedef struct tagUserGroup_List
{
	char			name[USER_GROUP_NAME_LENGTH];
	struct tagUserGroupList	*next;
} USER_GROUP_LIST;

typedef struct tagSMB_SHARE_INFO
{
	char			sharename[SHARE_NAME_LENGTH];
	char			path[SHARE_PATH_LENGTH];
	char                    comment[SHARE_COMMENT_LENGTH];
	USER_GROUP_LIST		*invalid;
	USER_GROUP_LIST		*read;
	USER_GROUP_LIST		*write;
	USER_GROUP_LIST         *valid;
	struct tagSMB_SHARE_INFO	*next;
} SMB_SHARE_INFO;

typedef struct tagMUTIPLE_EXIST_USER{
	char exist_user[USER_NAME_LENGTH];
	struct tagMUTIPLE_EXIST_USER* next;
}MUTIPLE_EXIST_USER;	
// security.c
int trim_chars_from_string(char* string, char c);
int insert_headntail_into_string(char* string, int string_max_len);
int Get_NAS_User_Security_For_Share(char *user_name, char *share_name);
int Get_NAS_User_List_For_Share(char *share_name, char security_id, char (*user_list)[USER_GROUP_NAME_LENGTH], int list_cnt);
int Add_NAS_User_List_For_Share(char *share_name,char security_id, char (*u_list)[USER_GROUP_NAME_LENGTH], int u_cnt);
int Remove_NAS_User_List_For_Share(char *share_name,char security_id, char (*u_list)[USER_GROUP_NAME_LENGTH], int u_cnt);
int Add_NAS_User_For_Share(char *share_name,char security_id, char *user_name);
int Remove_NAS_User_For_Share(char *share_name,char security_id, char *user_name);

int Remove_User_Share_Privilege(char *usr_name);
int Remove_Multiple_User_Share_Privilege(char (*usr_list)[USER_NAME_LENGTH], int count);
int Remove_Group_Share_Privilege(char *grp_name);
int Remove_Multiple_Group_Share_Privilege(char (*grp_list)[GROUP_NAME_LENGTH], int count);
int Remove_Connection_For_NAS_Share(char *share_name);
int Refresh_Connection_For_NAS_Share(char *share_name);
int Get_Nas_Share_List_For_Path(char *path, SHARE_NAME_LIST *share_name_list,int list_cnt,int file_flag);

int Get_NAS_Share_Info_Ex(NAS_SHARE_INFO *share_ptr);
int Get_NAS_User_List_For_Share_Ex(char *share_name, char security_id, char (**user_list_ptr)[USER_GROUP_NAME_LENGTH]);
int Get_Nas_Share_List_For_Path_Ex(char *path, SHARE_NAME_LIST **share_name_list,int file_flag);
int Get_NAS_User_Accessible_Share_List_Ex(char *user_name, SHARE_NAME_LIST **share_name_list_ptr);

int Clear_Invalid_NAS_Shares(void);	// Catherine 2003/01/25
int Repair_Invalid_NAS_Shares(void);	// Catherine 2003/03/05
int Get_NAS_User_Count(void);		// Catherine 2003/08/14

// user_grp.c
int Get_Exact_System_User_Name(char *user_name);
int Get_Exact_System_Group_Name (char *group_name);
int Get_Exact_NAS_User_Name(char *user_name);
int Get_Exact_NAS_Group_Name (char *group_name);

BOOL Is_System_User(char *user_name); 
BOOL Is_Hidden_User(char *user_name); 
BOOL Is_Reserved_User(char *user_name);
BOOL Is_System_Group(char *group_name);
BOOL Is_Hidden_Group(char *group_name);
BOOL Is_Reserved_Group(char *group_name);
BOOL User_Belongs_To_Group(char *user_name, char *group_name); 
int Create_System_User(char *user_name, char *passwd, char *group_name, char *home_dir);
int Create_Samba_User(char *user_name, char *pass_wd); 
int Remove_System_User(char *user_name); 
int Remove_Samba_User(char *user_name); 
int Change_System_User_Password(char *user_name, char *pass_wd); 
int Change_Samba_User_Passwd(char *user_name, char *pass_wd); 
int Create_System_Group(char *group_name); 
int Remove_System_Group(char *group_name); 
int Change_System_Group_Name(char *old_group_name, char *new_group_name); 
int Change_File_Attribute(char *path, char *owner, char *group); 
int Get_Samba_Status(SAMBA_STATUS_INFO *u_list, int list_cnt);
int change_netware_user_password(char* username, char* passwd);

//
int Get_All_SubDIR_Cnt_Len(char *top_dir, char *dir, int *cnt, int *max_len);
int Get_All_SubDIR(char *top_dir, char *dir, char *ptr, int ptr_cnt, int array_len);
int Is_My_SubDIR(char *search_DIR, char *target_DIR);
//
int Create_NAS_User(char *user_name, char *pass_wd); 
int Remove_NAS_User(char *user_name); 
int Change_NAS_User_Password(char *user_name, char *pass_wd); 
int Get_NAS_User_Info(NAS_USER_INFO *user_info_ptr); 
int Create_NAS_Group(char *group_name); 
int Remove_NAS_Group(char *group_name); 
int Change_NAS_Group_Name(char *old_group_name, char *new_group_name); 
int Add_NAS_Group_To_User(char *group_name, char *user_name); 
int Add_NAS_User_To_Group(char *user_name, char *grp_name); 
int Remove_NAS_Group_From_User(char *group_name, char *user_name); 
int Remove_NAS_User_From_Group(char *user_name, char *grp_name);
int Get_NAS_Group_Info(NAS_GROUP_INFO *group_info_ptr);
int Get_NAS_User_List(char (*user_list)[USER_NAME_LENGTH], int list_cnt);
int Get_NAS_User_List_Ex(char (**user_list_ptr)[USER_NAME_LENGTH]);
int Get_NAS_Group_List(char (*group_list)[GROUP_NAME_LENGTH], int list_cnt);
int Get_NAS_Group_List_Ex(char (**group_list_ptr)[GROUP_NAME_LENGTH]);
int Get_NAS_Group_List_Of_User(char *user_name, char (*group_list)[GROUP_NAME_LENGTH], int list_cnt); 
int Get_NAS_User_List_Of_Group(char *group_name, char (*user_list)[USER_NAME_LENGTH], int list_cnt);
// 2004.12.09, Johnson Cheng, for multi-domain AD
char* Get_Group_Name_By_User_Name(char* user_name);

int Sort_Name_List(char **name_list, int name_length, int list_cnt);
void Release_List(void* list_ptr);
MUTIPLE_EXIST_USER* Create_NAS_Mutiple_Users(char* prefix_name, char* account, char* passwd, int num, int* ret);
void Free_Mutiple_Exist_user(MUTIPLE_EXIST_USER* user);
/// Return the uid of the specified user name.
// Return:
//	uid			on success
//	ERROR_BAD_USERNAME	not valid username
int Get_System_User_ID(char *name);

// Check the username & password to see if it's valid for the local system
// Return:
//	0			pass
//	ERROR_BAD_USERNAME	not valid username
//	ERROR_BAD_PASSWORD	not correct password
int Check_System_User_Password(char *user_name, char *password);

// Check the username & password to see if it's valid and with administrator privilege
// To have administrator privilege, the uid has to be zero...
// Return:
//	0			pass
//	ERROR_BAD_USERNAME	not valid username
//	ERROR_BAD_PASSWORD	not correct password
//	ERROR_NO_PRIVILEGE	no admin privilege
int Check_NAS_Administrator_Password(char *user_name, char *password);
int Check_NAS_User_Password(char *user_name, char *password);

// share.c
void Remove_Blank_From_String(char* str);
BOOL Is_Existing_Directory(char *dir_name);
BOOL Is_Reserved_Share(char *share_name);
int Get_NAS_Share_List(SECTION_INFO *list, int list_cnt);
int Create_NAS_Share(NAS_SHARE_INFO *share_ptr);
int Remove_NAS_Share(char *share_name);
int Get_NAS_Code_Page(void);

//Add by john 2001-10-12
int Create_NAS_Share_From_Volume(char* share_name, int volume, char* path, char* comment);
//Add end

int Get_NAS_Share_Info(NAS_SHARE_INFO *share_ptr);
int Get_NAS_User_Accessible_Share_List(char *user_name, SHARE_NAME_LIST *share_name_list, int list_cnt);
int Get_Active_Connection_For_Nas_Share(char *share_name, char (*user_list)[USER_NAME_LENGTH],int list_cnt);
BOOL Check_Share_Name_Legal(char *share_name);

int Get_NAS_Share_List_Ex(SECTION_INFO **list_ptr);
int Get_NAS_Shares(SECTION_INFO **list_ptr, BOOL snapshot_included);

SMB_SHARE_INFO *SMB_Get_Share_Info();
void SMB_Free_Share_Info(SMB_SHARE_INFO *smb_share_info);
void SMB_Reset_User_Group();
SMB_SHARE_INFO *Remove_User_From_Section(SMB_SHARE_INFO *, char *); 
void Remove_User_From_Section_Ex(char *username); 
void DEBUG_One_Smb_Share_Info(SMB_SHARE_INFO *, char *); 

int Create_Default_Share(char *share_name,int type);//Shone added 2005,09,28
enum {
        SHARE_ADMINISTRATOR,
        SHARE_EVERYONE,
        SHARE_EVERYONE_GUEST,
};

//////////////////////////////////////////////////////////////////
// NFS related declaration
//////////////////////////////////////////////////////////////////

#include <netinet/in.h>

#define NFSCONF_FILE	"//etc//nfs.conf"

enum {
	NFSIP_SINGLE,
	NFSIP_RANGE,
	NFSIP_WILDCARD,
	NFSIP_END,
};

typedef struct {
	//unsigned short	uid;
	unsigned int	uid;	//By Andy Wu 03/14/2003
	int		type;
	struct in_addr	ipaddr, netmask;
} NFS_USER;

typedef struct {
	//unsigned short	uid;
	unsigned int	uid;	//By Andy Wu 03/14/2003
	int		type;
	struct in_addr	ipaddr, netmask;
	char		username[USER_NAME_LENGTH];
} NFS_USER_EX;


//	Function Prototype
int Load_All_NFS_Users(NFS_USER_EX *pusers, int *size);
int Add_NFS_Config(const char *username, NFS_USER *nfs_user);
int Remove_NFS_Config(const char *username, NFS_USER *nfs_user);
int Remove_NFS_User_Config(const char *username);
int Get_NFS_Users(const char *username, NFS_USER *nfs_user, int *size);

int NAS_Get_Serurity_Pwd(char *pwd, int len, char *input_hwaddr, char *input_server, char *input_version, int type);

int Str_Trans_CmdStr(const char *in_str, char *out_str);

#ifdef	LARGE_NO_OF_USERS_SUPPORT	// Catherine

#define	S_PROCESSING	1

typedef struct t_plist {
	int		progress;	// from 0 ~ 100
	struct t_plist*	next;
} PROGRESS_LIST;

typedef	struct t_Progress_Status {
	int		status;
	PROGRESS_LIST	*plist;
} PROGRESS_STATUS;

int Report_Progress_To_File(char* stsfile, PROGRESS_STATUS* pslist);
int Get_Progress_From_Status_File(char* stsfile, PROGRESS_STATUS* psts);

// user_grp.c
int Create_NAS_User_Ex(char *user_name, char *pass_wd, BOOL update_flash); 
int Remove_NAS_User_Ex(char *user_name, BOOL update_flash); 
int Change_NAS_User_Password_Ex(char *user_name, char *pass_wd, BOOL update_flash); 
int Create_NAS_Group_Ex(char *group_name, BOOL update_flash); 
int Remove_NAS_Group_Ex(char *group_name, BOOL update_flash); 
int Change_NAS_Group_Name_Ex(char *old_group_name, char *new_group_name, BOOL update_flash); 
int Add_NAS_Group_To_User_Ex(char *group_name, char *user_name, BOOL update_flash); 
int Add_NAS_User_To_Group_Ex(char *user_name, char *grp_name, BOOL update_flash); 
int Remove_NAS_Group_From_User_Ex(char *group_name, char *user_name, BOOL update_flash); 
int Remove_NAS_User_From_Group_Ex(char *user_name, char *grp_name, BOOL update_flash);
MUTIPLE_EXIST_USER* Create_NAS_Multiple_Users_Ex(
	char* prefix_name, char* account, char* passwd,
	int num, int* ret, BOOL update_flash, char* stsfile);
MUTIPLE_EXIST_USER* Remove_NAS_Multiple_Users(
	char (*ulist)[USER_GROUP_NAME_LENGTH], int ucnt,
	int *errcode, BOOL update_flash, char* stsfile);
MUTIPLE_EXIST_USER* Add_NAS_User_List_To_Group(
	char *grp_name, char (*ulist)[USER_GROUP_NAME_LENGTH], int ucnt,
	int *errcode, BOOL update_flash, char* stsfile);
MUTIPLE_EXIST_USER* Remove_NAS_User_List_From_Group(
	char *grp_name, char (*ulist)[USER_GROUP_NAME_LENGTH], int ucnt,
	int* errcode, BOOL update_flash, char* stsfile);

// share.c
int Create_NAS_Share_Ex(NAS_SHARE_INFO *share_ptr, BOOL update_flash);
int Remove_NAS_Share_Ex(char *share_name, BOOL update_flash);
int Create_NAS_Share_From_Volume_Ex(char* share_name, int volume, char* path,
	char* comment, BOOL update_flash);
int Clear_Invalid_NAS_Shares_Ex(BOOL update_flash);
int Create_Storage_Share(char *share_name, int type, char *dev_name);

// nasnfs.c
int Add_NFS_Config_Ex(const char *username, NFS_USER *nfs_user, BOOL update_flash);
int Remove_NFS_Config_Ex(const char *username, NFS_USER *nfs_user, BOOL update_flash);
int Remove_NFS_User_Config_Ex(const char *username, BOOL update_flash);

// security.c
int Add_NAS_User_List_For_Share_Ex(char *share_name, char security_id,
	char (*u_list)[USER_GROUP_NAME_LENGTH], int u_cnt, BOOL update_flash);
int Remove_NAS_User_List_For_Share_Ex(char *share_name,char security_id,
	char (*u_list)[USER_GROUP_NAME_LENGTH], int u_cnt, BOOL update_flash);
int Add_NAS_User_For_Share_Ex(char *share_name,char security_id,
	char *user_name, BOOL update_flash);
int Remove_NAS_User_For_Share_Ex(char *share_name,char security_id,
	char *user_name, BOOL update_flash);
int Remove_User_Share_Privilege_Ex(char *usr_name, BOOL update_flash);
int Remove_Multiple_User_Share_Privilege_Ex(
	char (*usr_list)[USER_NAME_LENGTH], int count, BOOL update_flash, char* sts_file);
int Remove_Group_Share_Privilege_Ex(char *grp_name, BOOL update_flash);
int Remove_Multiple_Group_Share_Privilege_Ex(char (*grp_list)[GROUP_NAME_LENGTH],
	int count, BOOL update_flash, char* sts_file);
int Create_Default_Share_From_Drive(int drive_no, char *share_name,int type);
int Create_Share_SLink(int drive_no, char *share_name);
int Create_Default_Share_SLink(int drive_no);
int Check_Share_Folder(char *folder_path); //KenChen 20060322
void Killusers_Delshare_On_Volume(int vol_no,int del_share);

USER_GROUP_LIST *Remove_User_From_List(USER_GROUP_LIST *, char *);

#endif	// LARGE_NO_OF_USERS_SUPPORT

#endif

