//=============================================================================
//--                    History                                    
// 2001 /3 /5 Modify the Data mount point root shared directory from
// /mnt to /share
// 2001/3/7: Modify Create_Hidden_Conf_File(), add it will append the HD string
//           (HDA..) to /etc/config/uLinux.conf file
// 2001/4/3: Add one function cliear_MBR 
// 2001/6/18: Add log message at in Create_RaidDev() & Delete_RaidDev()
//=============================================================================

#include <stdio.h>
#include <ctype.h>
#include <unistd.h>    /*- for access() -*/
#include <errno.h>
#include <stdlib.h>    // for atoi()
#include <string.h>
#include <sys/shm.h>   // for shmget()...
#include <sys/types.h> // for msgget()
#include <sys/stat.h>  // for open()
#include <fcntl.h>     // for open()
#include <sys/ipc.h>   // for msgget()
#include <sys/msg.h>   // for msgget()
#include <asm/page.h>  // for swapon()
#include <sys/swap.h>  // for swapon()
#include <dirent.h>    // for scandir()

#include "soft-raid.h"
#include "ds_fdisk-ext.h"

#include "public_lib.h"
#define ICPNAS 1 
#include "uLinux.h"   // copy form MEIJEI 
#include "config.h"   // copy form MEIJEI 
//#include "../config/eventlog.h"   // copy form MEIJEI 
//#include "cfg_util.h"
#include "Util.h"

#define	ReadCFGData	Conf_Get_Field
#define	WriteCFGData	Conf_Set_Field

#define SECTOR_SIZE   512    // for Clear_MBR()

//=========  Define Some Array Start =========
#ifdef PROMISE
char *HD_DevName_STR[MAX_RHD_NO]=
{"/dev/hde","/dev/hdf","/dev/hdg","/dev/hdh",
 "/dev/sda","/dev/sdb","/dev/sdc","/dev/sdd","/dev/sde","/dev/sdf",
 "/dev/sdg","/dev/sdh","/dev/sdi","/dev/sdj","/dev/sdk","/dev/sdl",
 "/dev/sdm","/dev/sdn","/dev/sdo",
 "/dev/md0","/dev/md1","/dev/md2","/dev/md3","/dev/md4","/dev/md5",
 "/dev/md6","/dev/md7","/dev/md8"};

#else
char *HD_DevName_STR[MAX_RHD_NO]=
{"/dev/hda","/dev/hdb","/dev/hdc","/dev/hdd",
 "/dev/sda","/dev/sdb","/dev/sdc","/dev/sdd","/dev/sde","/dev/sdf",
 "/dev/sdg","/dev/sdh","/dev/sdi","/dev/sdj","/dev/sdk","/dev/sdl",
 "/dev/sdm","/dev/sdn","/dev/sdo",
 "/dev/md0","/dev/md1","/dev/md2","/dev/md3","/dev/md4","/dev/md5",
 "/dev/md6","/dev/md7","/dev/md8"};
#endif

char *HD_STR[MAX_RHD_NO]=
{"HDA","HDB","HDC","HDD",
 "SDA","SDB","SDC","SDD","SDE","SDF","SDG","SDH","SDI","SDJ","SDK",
 "SDL","SDM","SDN","SDO",
 "MD0","MD1","MD2","MD3","MD4","MD5","MD6","MD7","MD8"};

char *HD_ROOT_MP[MAX_RHD_NO]=
{"/mnt/HDA_ROOT","/mnt/HDB_ROOT","/mnt/HDC_ROOT","/mnt/HDD_ROOT",
 "/mnt/SDA_ROOT","/mnt/SDB_ROOT","/mnt/SDC_ROOT","/mnt/SDD_ROOT",
 "/mnt/SDE_ROOT","/mnt/SDF_ROOT","/mnt/SDG_ROOT","/mnt/SDH_ROOT",
 "/mnt/SDI_ROOT","/mnt/SDJ_ROOT","/mnt/SDK_ROOT","/mnt/SDL_ROOT",
 "/mnt/SDM_ROOT","/mnt/SDN_ROOT","/mnt/SDO_ROOT",
 "/mnt/MD0_ROOT","/mnt/MD1_ROOT","/mnt/MD2_ROOT","/mnt/MD3_ROOT",
 "/mnt/MD4_ROOT","/mnt/MD5_ROOT","/mnt/MD6_ROOT","/mnt/MD7_ROOT",
 "/mnt/MD8_ROOT"};

char *HD_DATA_MP[MAX_RHD_NO]=
{"/share/HDA_DATA","/share/HDB_DATA","/share/HDC_DATA","/share/HDD_DATA",
 "/share/SDA_DATA","/share/SDB_DATA","/share/SDC_DATA","/share/SDD_DATA",
 "/share/SDE_DATA","/share/SDF_DATA","/share/SDG_DATA","/share/SDH_DATA",
 "/share/SDI_DATA","/share/SDJ_DATA","/share/SDK_DATA","/share/SDL_DATA",
 "/share/SDM_DATA","/share/SDN_DATA","/share/SDO_DATA",
 "/share/MD0_DATA","/share/MD1_DATA","/share/MD2_DATA","/share/MD3_DATA",
 "/share/MD4_DATA","/share/MD5_DATA","/share/MD6_DATA","/share/MD7_DATA",
 "/share/MD8_DATA"};
//=========  Define Some Array End   =========


//----------------------------------
//- Get RAIDDEV Number
// return: PL_OK           --> successful
//         PL_FILE_NOEXIST --> File no exist
//         >=0             --> the raid number
//       Others            --> fail
//----------------------------------
int Get_RaidDev_No(void) {
    FILE *fp;
    char buff[512];
    int  raid_no=0;

    fp = fopen(RAID_CONF_FILE,"r");
    if (fp==NULL ) {
      if ( errno == ENOENT)
         return PL_FILE_NOEXIST;
      else {
         #ifdef DEBUG
           printf("open %s fail ! \n",RAID_CONF_FILE);
         #endif
         return PL_OPEN_FILE;
      }
    }

    while(1) {
      if (fgets(buff,sizeof(buff),fp)==NULL)  break;   /*- EOF or Error -*/

      if ( buff[0]=='#')  continue;        /*- skip comment line -*/
      if (strstr(buff,"raiddev") == NULL) continue;
      raid_no++;
    }

    fclose(fp);
    return raid_no;
}
/*--------------------------------------------------------*/
/*- get all raid dev configure content                   -*/
/*- It will get /etc/raidtab all content which           -*/
/*- specified in the soft-raid.h struct defined          -*/
/*- You first should call Get_RaidDev_No() to get        -*/
/*- the raid device No. now system has, then alloc       -*/
/*- enough struct size (must be array) & pass in its     -*/
/*- start pointer                                        -*/
/*- note link the every struct pointer by its next field -*/
/*- rd_ptr: the start pointer of struct raid_device      -*/
/*- num   : the num * sizeof(struct raid_device)         -*/
/*--------------------------------------------------------*/
int Get_All_RaidDev_Conf(struct raid_device *rd_ptr, int num) {
    char line[512],value[30],device_name[30], *s_ptr;
    FILE *fp;
    int  i,j,ret, c_raid_dev=0;
    struct raid_device *c_raid_ptr;

    fp = fopen(RAID_CONF_FILE,"r");
    if (fp==NULL) {
       #ifdef DEBUG
         printf("open %s fail ! \n",RAID_CONF_FILE);
       #endif
       return PL_OPEN_FILE;
    }

    c_raid_ptr = rd_ptr;

    while(1) {
      if (fgets(line,sizeof(line),fp)==NULL) break;

      /*- skip comment, CR, LF line -*/
      if ( line[0]=='#'|| line[0]==CR || line[0]==LF)  continue;

      /*-- skip the line to first seeable character --*/
      for (i=0; i<strlen(line); i++) {
        if (line[i]==SPACE || line[i]==TAB) continue;
        else break;
      }
      s_ptr = &line[i];

      #ifdef DEBUG
        printf("After skip space char., line=%s, len=%d \n",s_ptr,strlen(s_ptr));
        //getchar();
      #endif

      /*----- get device name ----*/
      if ( strncasecmp(s_ptr,"raiddev",strlen("raiddev")) == 0) { /*- find it -*/
        c_raid_ptr = (rd_ptr+c_raid_dev);
        c_raid_dev++;

        if ( c_raid_dev > num)   break;    // Larger than pass in memory

        if ( (ret=get_field_value(s_ptr,strlen(s_ptr),TAB,2,
            c_raid_ptr->name,sizeof( c_raid_ptr->name))) != PL_OK) {
            if ((ret=get_field_value(s_ptr,strlen(s_ptr),SPACE,2,
                                     c_raid_ptr->name,
                                     sizeof(c_raid_ptr->name))) !=PL_OK){
              printf("get field 2 in line=%s, fail \n",line);
              fclose(fp);
              return ret;
            }
        }

        #ifdef DEBUG
        printf("c_raid_ptr->name=%s, c_raid_ptr=%lx \n",c_raid_ptr->name,c_raid_ptr);
        #endif

      }
      /*----- get raid level ----*/
      else if ( strncasecmp(s_ptr,"raid-level",strlen("raid-level")) == 0) { /*- find it -*/

           if ( (ret=get_field_value(s_ptr,strlen(s_ptr),TAB,2,
              c_raid_ptr->raid_level,sizeof(c_raid_ptr->raid_level))) != PL_OK) {
              if ((ret=get_field_value(s_ptr,strlen(s_ptr),SPACE,2,
                                     c_raid_ptr->raid_level,
                                     sizeof(c_raid_ptr->raid_level))) !=PL_OK){
                 printf("get field 2 in line=%s, fail \n",line);
                 fclose(fp);
                 return ret;
              }
           }

           #ifdef DEBUG
             printf("c_raid_ptr->raid_level=%s \n",c_raid_ptr->raid_level);
           #endif
      }

      /*----- get data disk number ----*/
      else if ( strncasecmp(s_ptr,"nr-raid-disks",strlen("nr-raid-disks")) == 0) { /*- find it -*/

        if ( (ret=get_field_value(s_ptr,strlen(s_ptr),TAB,2,
            value,sizeof(value))) != PL_OK) {
            if ((ret=get_field_value(s_ptr,strlen(s_ptr),SPACE,2,
                                     value,
                                     sizeof(value))) !=PL_OK){
              printf("get field 2 in line=%s, fail \n",line);
              fclose(fp);
              return ret;
            }
            else c_raid_ptr->data_hd_no = atoi(value);
        }
        else c_raid_ptr->data_hd_no=atoi(value);

        #ifdef DEBUG
          printf("c_raid_ptr->data_hd_no=%d \n",c_raid_ptr->data_hd_no);
        #endif
      }

      /*----- get spare disk number ----*/
      else if ( strncasecmp(s_ptr,"nr-spare-disks",strlen("nr-spare-disks")) == 0) { /*- find it -*/

        if ( (ret=get_field_value(s_ptr,strlen(s_ptr),TAB,2,
            value,sizeof(value))) != PL_OK) {
            if ((ret=get_field_value(s_ptr,strlen(s_ptr),SPACE,2,
                                     value,
                                     sizeof(value))) !=PL_OK){
              printf("get field 2 in line=%s, fail \n",line);
              fclose(fp);
              return ret;
            }
            else c_raid_ptr->spare_hd_no=atoi(value);
        }
        else c_raid_ptr->spare_hd_no=atoi(value);

        #ifdef DEBUG
         printf("c_raid_ptr->spare_hd_no=%d \n",c_raid_ptr->spare_hd_no);
        #endif
      }

      /*----- get device name ----*/
      else if ( strncasecmp(s_ptr,"device",strlen("device")) == 0) { /*- find it -*/

        if ( (ret=get_field_value(s_ptr,strlen(s_ptr),TAB,2,
            device_name,sizeof(device_name))) != PL_OK) {
            if ((ret=get_field_value(s_ptr,strlen(s_ptr),SPACE,2,
                                     device_name,
                                     sizeof(device_name))) !=PL_OK){
              printf("get field 2 in line=%s, fail \n",line);
              fclose(fp);
              return ret;
            }
        }

        #ifdef DEBUG
          printf("A. device_name=%s \n",device_name);
        #endif

      }
      /*----- get data HD Name ----*/
      /*---- First find the data HD -----*/
      else if ( strncasecmp(s_ptr,"raid-disk",strlen("raid-disk")) == 0) { /*- find it -*/

        if ( (ret=get_field_value(s_ptr,strlen(s_ptr),TAB,2,
            value,sizeof(value))) != PL_OK) {
            if ((ret=get_field_value(s_ptr,strlen(s_ptr),SPACE,2,
                                     value,
                                     sizeof(value))) !=PL_OK){
              printf("get field 2 in line=%s, fail \n",line);
              fclose(fp);
              return ret;
            }
            else i=atoi(value);
        }
        else i=atoi(value);


        #ifdef DEBUG
         printf("B. device_name=%s, i=%d \n",device_name,i);
        #endif

	if ( (ret=RW_Lock(LOCK_DISK, LOCK_READ)) !=PL_OK)  return ret;
        if ( ReadCFGData(DS_CONF_FILE, STORAGE_SESSION_NAME, DISK_DRVNO_FIELD_NAME,value,sizeof(value))==SUCCESS) {
           ret = atoi(value);
        }

        for (j=0; j<ret; j++) {
            sprintf(value, "Drive %d", (j+1));
            if ( ReadCFGData(DS_CONF_FILE, STORAGE_SESSION_NAME, value, line,sizeof(line))==SUCCESS) {

               if ( strstr(device_name, line) != NULL)
               c_raid_ptr->data_hd[i]=HDA+j;
            }
        }
        RW_Unlock(LOCK_DISK);

        #ifdef DEBUG
          printf("c_raid_ptr->data_hd[%d]=%d \n",i,c_raid_ptr->data_hd[i]);
        #endif

      }
      /*---- Second find the spare HD -----*/

      if ( strncasecmp(s_ptr,"spare-disk",strlen("spare-disk")) == 0) { /*- find it -*/

        if ( (ret=get_field_value(s_ptr,strlen(s_ptr),TAB,2,
            value,sizeof(value))) != PL_OK) {
            if ((ret=get_field_value(s_ptr,strlen(s_ptr),SPACE,2,
                                     value,
                                     sizeof(value))) !=PL_OK){
              printf("get field 2 in line=%s, fail \n",line);
              fclose(fp);
              return ret;
            }
            else i=atoi(value);
        }
        else i=atoi(value);

        if ( (ret=RW_Lock(LOCK_DISK, LOCK_READ)) !=PL_OK)  return ret;
        if ( ReadCFGData(DS_CONF_FILE, STORAGE_SESSION_NAME, DISK_DRVNO_FIELD_NAME,value,sizeof(value))==SUCCESS) {
           ret = atoi(value);
        }
        for (j=0;j<ret;j++) {
            sprintf(value, "Drive %d", (j+1));
            if ( ReadCFGData(DS_CONF_FILE, STORAGE_SESSION_NAME, value, line,sizeof(line))==SUCCESS) {
               if ( strstr(device_name, line) != NULL)
               c_raid_ptr->spare_hd[i]=HDA+j;
            }
        }
        RW_Unlock(LOCK_DISK);

        #ifdef DEBUG
          printf("c_raid_ptr->spare_hd[%d]=%d \n",i,c_raid_ptr->spare_hd[i]);
        #endif

      }
      else  continue;

    }

    fclose(fp);

    return PL_OK;
}

/*-------------------------------------------------------*/
/*- Create one new raid device                          -*/
/*- Mar 15 2001: Add check pass in parameter is valid ? -*/
/*-------------------------------------------------------*/
int Create_RaidDev(struct raid_device *rd_ptr)
{
    int  i,ret,rd_no;
    char buff[1024],d_name[100], tmp_str[21];

    if ( rd_ptr->data_hd_no <=0 )     return PL_INVAL_PARA;
    
    rd_no = Get_RaidDev_No();
    if ( rd_no < 0 && rd_no != PL_FILE_NOEXIST) {
       #ifdef DEBUG
         printf("rd_no=%d \n",rd_no);
       #endif
       return rd_no;
    }

    if ( rd_no >= MAX_RAID_NO)  return RAID_OVER_MAXNO;

    if ( strlen(rd_ptr->name)==0)   return PL_INVAL_PARA;
    /*-- fill the device name --*/
    sprintf(buff,"raiddev %s\n",rd_ptr->name);

    /*-- fill raid level --*/
    sprintf(d_name,"\traid-level\t%s\n",rd_ptr->raid_level);
      strcat(buff,d_name);

    /*-- fill data disk No. ---*/
    sprintf(d_name,"\tnr-raid-disks\t%d\n",rd_ptr->data_hd_no);
      strcat(buff,d_name);

    /*-- fill spare disk No. ---*/
    sprintf(d_name,"\tnr-spare-disks\t%d\n",rd_ptr->spare_hd_no);
      strcat(buff,d_name);

   /*-- fill chunk size ---*/
    sprintf(d_name,"\tchunk-size\t4\n");
      strcat(buff,d_name);

   /*-- fill super-block ---*/
    sprintf(d_name,"\tpersistent-superblock\t1\n");
      strcat(buff,d_name);

   /*-- fill data HD Name ---*/
   for (i=0; i<rd_ptr->data_hd_no; i++) {
       Get_Partition_Name(rd_ptr->data_hd[i],tmp_str,DATA_PART);
       sprintf(d_name,"\tdevice\t%s\n\traid-disk\t%d\n",tmp_str,i);
       strcat(buff,d_name);
   }

   /*-- fill spare HD Name ---*/
   for (i=0; i<rd_ptr->spare_hd_no; i++) {
       Get_Partition_Name(rd_ptr->spare_hd[i],tmp_str,DATA_PART);
       sprintf(d_name,"\tdevice\t%s\n\tspare-disk\t%d\n",tmp_str,i);
       strcat(buff,d_name);
   }

   #ifdef DEBUG
     printf("buff=%s \n",buff);
   #endif

   //- Check the file is exist or not
   if ( access(RAID_CONF_FILE,F_OK)==0 ) { // file exist
     if ( (ret=write_to_file(RAID_CONF_FILE,buff,strlen(buff),2)) !=PL_OK)
       return ret;
   }
   else { // file not exist
     if ( (ret=write_to_file(RAID_CONF_FILE,buff,strlen(buff),1)) !=PL_OK)
       return ret;
   }
   //- Update RAM data to flash immeditelly
   //Update_Flash_Data(RAID_CONF_FILE);  // call Louis's function June 4 2001

   //- Log message
   /*********
   rd_no = Get_HD_Integer(rd_ptr->name);
   if ( rd_no < MD0 )  return PL_NOT_FOUND;
   
   
   if ( Get_RaidDev_Web_String(rd_no, d_name, sizeof(d_name) ) != PL_OK)
     return PL_NOT_FOUND;

   sprintf(buff,"/sbin/report_log -t Information \"%s had been created.\"", d_name);
   //Set_Log(EVENTLOG_INFORMATION_TYPE, buff, strlen(buff));
   system(buff);
   //fprintf(stderr,"Msg=%s \n", buff);
   ****************/
   return PL_OK;
}

/*-------------------------------------------*/
/*- Delete one raid device                  -*/
/*-------------------------------------------*/
int Delete_RaidDev(char * rd_name) {
    FILE *fp;
    int  delete_flag=0, find_flag=0, ret, hd_no;
    char buff[1024],line[255], web_str[51];

    
    //-- First get the raid web_string for Log Using
    hd_no = Get_HD_Integer(rd_name);
    if ( hd_no < MD0 )  return PL_NOT_FOUND;
   
    if ( Get_RaidDev_Web_String(hd_no, web_str, sizeof(web_str) ) != PL_OK)
      return PL_NOT_FOUND;
    //- Get web_string finish

    fp = fopen(RAID_CONF_FILE,"r");
    if (fp==NULL) {
       #ifdef DEBUG
         printf("open %s fail ! \n",RAID_CONF_FILE);
       #endif
       return PL_OPEN_FILE;
    }

    memset(buff,'\0',sizeof(buff) );

    while(1) {
      if (fgets(line,sizeof(line),fp)==NULL)  break;   /*- EOF or Error -*/

      if ( delete_flag==1 && strstr(line,"raiddev") != NULL)
        delete_flag = 0;

      if ( strstr(line,rd_name) !=NULL) {        /*-- find it --*/
         find_flag = 1; delete_flag=1;
      }

      if ( delete_flag==0) strcat(buff,line);   /*- append the file -*/

    }

    fflush(fp);  /*- force write buffered data to Disk -*/
    fclose(fp);

    if ( find_flag) {
       ret=write_to_file(RAID_CONF_FILE,buff,strlen(buff),1);
       if ( ret == PL_OK) {
	 //- Update RAM data to flash immeditelly
	 //Update_Flash_Data(RAID_CONF_FILE);  // call Louis's function June 4 2001
	 /*****************
	 sprintf(buff,"/sbin/report_log -t Information \"%s had been removed.\"", web_str);

	 //Set_Log(EVENTLOG_INFORMATION_TYPE, buff, strlen(buff));
	 system(buff);
	 *****************/
	 return PL_OK;
       }
       else
	 return ret;
    }
    else return PL_NOT_FOUND;
}

/*-------------------------------------------*/
/*- Modify one raid device Configuration    -*/
/*- The rd_ptr->name must exist in Raid Conf-*/
/*-------------------------------------------*/
int Modify_RaidDev_Conf(struct raid_device *rd_ptr) {
    FILE *fp;
    int  i, ret, replace_flag=0;
    char buff[1024],line[255], tmp_str[21];

    fp = fopen(RAID_CONF_FILE,"r");
    if (fp==NULL) {
       #ifdef DEBUG
         printf("open %s fail ! \n",RAID_CONF_FILE);
       #endif
       return PL_OPEN_FILE;
    }

    memset(buff,'\0',sizeof(buff) );

    while(1) {
      if (fgets(line,sizeof(line),fp)==NULL)  break;   /*- EOF or Error -*/

      if ( (strncasecmp(line,"raiddev",7)==0) &&
           (strstr(line,rd_ptr->name)!=NULL) ) {        /*-- find it --*/
           replace_flag = 1;
           break;
      }
      strcat(buff,line);  //-- Write to Buffer --
    }

    #ifdef DEBUG
      printf("1.buff=%s \n",buff);
      getchar();
    #endif

    if ( !replace_flag) {
       fclose(fp);
       return  PL_NOT_FOUND; //- not found this RAID Device
    }
    else { // Write modified value to buff
       sprintf(line,"raiddev %s\n",rd_ptr->name);
       strcat(buff,line);

       /*-- fill raid level --*/
       sprintf(line,"\traid-level\t%s\n",rd_ptr->raid_level);
       strcat(buff,line);

       /*-- fill data disk No. ---*/
       sprintf(line,"\tnr-raid-disks\t%d\n",rd_ptr->data_hd_no);
       strcat(buff,line);

       /*-- fill spare disk No. ---*/
       sprintf(line,"\tnr-spare-disks\t%d\n",rd_ptr->spare_hd_no);
       strcat(buff,line);

      /*-- fill chunk size ---*/
       sprintf(line,"\tchunk-size\t4\n");
       strcat(buff,line);

      /*-- fill super-block ---*/
       sprintf(line,"\tpersistent-superblock\t1\n");
       strcat(buff,line);

      /*-- fill data HD Name ---*/
      for (i=0; i<rd_ptr->data_hd_no; i++) {
          Get_Partition_Name(rd_ptr->data_hd[i], tmp_str, DATA_PART);
          sprintf(line,"\tdevice\t%s\n\traid-disk\t%d\n",tmp_str,i);
          strcat(buff,line);
      }

      /*-- fill spare HD Name ---*/
      for (i=0; i<rd_ptr->spare_hd_no; i++) {
          Get_Partition_Name(rd_ptr->spare_hd[i], tmp_str, DATA_PART);
          sprintf(line,"\tdevice\t%s\n\tspare-disk\t%d\n",tmp_str,i);
          strcat(buff,line);
      }
    } // Write modified value to buff--END

    #ifdef DEBUG
      printf("2.buff=%s \n",buff);
    #endif

    //-- Read Next Raid Device Configuration & append them
    replace_flag = 0;

    while(1) {
      if (fgets(line,sizeof(line),fp)==NULL)  break;   /*- EOF or Error -*/

      if ( strncasecmp(line,"raiddev",7)==0 ) { //- find it
           strcat(buff,"\n");  /*- append line feed -*/
           strcat(buff,line);
           replace_flag = 1;
           break;
      }
    }

    if (replace_flag) { //-- append rest lines
      while(1) {
        if (fgets(line,sizeof(line),fp)==NULL)  break;   /*- EOF or Error -*/
        strcat(buff,line);
      }
    }

    #ifdef DEBUG
      printf("3.buff=%s \n",buff);
    #endif

    fclose(fp);

    ret=write_to_file(RAID_CONF_FILE,buff,strlen(buff),1); //-- overwrite
    if ( ret==PL_OK)
      //- Update RAM data to flash immeditelly
      //Update_Flash_Data(RAID_CONF_FILE);  // call Louis's function June 4 2001

    return ret;
}


/*-------------------------------------------------------------*/
/*- Ckeck specified HD is Exist & Valid                       -*/
/*- The d_name is HDA, HDB..MDX... etc.                       -*/
/*- If you pass in MDX, now just judge it is active or not    -*/
/*- from /proc/mdstat file, others judge it is active or not  -*/
/*- from the file ..ROOT/RAID_HIDDEN_FILE exist or not        -*/
/*- & its content some fields should be matched by pass in    -*/
/*- value, like as mac_address & hd_name which created by     -*/
/*- after created partition & mount pointer action.           -*/
/*-  not judge its configuration file content                 -*/
/*- Its content like as                                       -*/
/*-  hw_addr=00:c0:02:98:dc                                   -*/
/*-  hd_name=/dev/hdc                                         -*/
/*- opt = 1 (CHECK_MAC) :  check MAC address is match or not  -*/
/*- opt = 2 (CHECK_HDNAME): check hd_name    is match or not  -*/
/*- opt = 3 (CHECK_BOTH):  check both        are match or not -*/
/*- if the HD is single HD (Non-RAID), its opt should=2       -*/
/*- if the HD is RAID HD, its opt should=3                    -*/
/*- June 26 2001: If the [Storage] "Use Flash Disk" = True, don't -*/
/*- need the swap area, so just reture SUCCESS                    -*/
/*- Return HD_EXIST_VALID: It is exist & valid                -*/
/*-        HD_EXIST_NOVALID: It just exist but not valid      -*/
/*-        HD_NOEXIST: It hasn't exist                        -*/
/*-        Other     : Error                                  -*/
/*-------------------------------------------------------------*/
int Check_HD_Valid(int d_name, int opt) {
    struct disk_info d_info;
    char   embed_conf_file[50];
    IFInfo eth0;
    char   hw_addr[31],hd_name[31],line[256], hd_str[21];
    char   *s_name;
    int    ret;

    ret = Get_Hidden_Conf_File_Name(d_name,embed_conf_file);
    if ( ret != PL_OK )  {
       #ifdef DEBUG
         printf(" Get_Hidden_Conf_File_Name() fail, ret=%d \n",ret);
       #endif
       return ret;
    }
    
    #ifdef  DEBUG
      printf(" embed_conf_file=%s\n", embed_conf_file);
    #endif

    if ( (ret=Get_HD_DevName(d_name,d_info.device_name)) != PL_OK) {
       #ifdef DEBUG
         printf(" Get_HD_DevName() fail, ret=%d \n",ret);
       #endif
       return ret;
    }

    if ( (ret=Get_HD_String(d_name,hd_str)) != PL_OK) {
       #ifdef DEBUG
         printf(" Get_HD_String() fail, ret=%d \n",ret);
       #endif
       return ret;
    }

    #ifdef DEBUG
      printf(" In Check_HD_Valid(), get HD_String=%s \n",d_info.device_name);
    #endif

    /*-- If the is RAID Device, then check its active from /proc/mdstat --*/
    /*--- parser /proc/mdstat see it is active or not ---*/
    if ( (d_name>=MD0) && (d_name<=MD9) ) {
       int  ret;
       char buff[512],r_name[30];

       if (d_name==MD0) strcpy(r_name,"md0");
       else strcpy(r_name,"md1");

       ret=find_conf(RAID_MDSTAT_FILE,NULL,':',1,r_name,buff,sizeof(buff));

       if ( ret <= 0) {
          if ( ret==PL_NOT_FOUND )  return HD_NOEXIST;
          else {
            #ifdef DEBUG
              printf(" find_conf() fail, ret=%d \n",ret);
            #endif
            return ret;
          }
       }

       return HD_EXIST_VALID;

    }
    else{ // check non-raid device
      if ( (ret=DiskInfo(&d_info)) != PL_OK) {
         #ifdef DEBUG
           printf("DiskInfo() fail, ret=%d \n",ret);
         #endif
         return HD_NOEXIST;
      }
    }

    if ( Use_Flash_Disk() )
      s_name=hd_str;
    else
      s_name=NULL;

    #ifdef  DEBUG
      printf("s_name=%s \n", s_name);
    #endif

    /*- HD is exist, Now check it is valid, to read partition 1 .conf file -*/
    switch (opt) {
      case CHECK_MAC: // check its mac address is match by me
           if ( (ret=find_conf(embed_conf_file,s_name,'=',1,CONF_FILE_HW_ADDR_FIELD,line,sizeof(line))) <=0) {
              #ifdef DEBUG
                printf("A.find hw_addr= fail in %s file, ret=%d \n",embed_conf_file, ret);
              #endif
              return HD_EXIST_NOVALID;
           }
           else {
             if (get_field_value(line,strlen(line),'=',2,hw_addr,
                                 sizeof(hw_addr)) !=PL_OK) {
                #ifdef DEBUG
                  printf("Get field 2 in the [%s] fail \n",line);
                #endif
                return HD_EXIST_NOVALID;
             }
             else { /*---- compare the hw address is same ?, if not record  -----*/
	         Skip_Front_SPACE_TAB(hw_addr);
                 //strcpy(eth0.device_no, "eth0");
                 if ( Get_Network_Interface_Volatile(0, &eth0) != PL_OK) {
                    #ifdef DEBUG
                      printf("Check_HD_Valid(), Get_Network_Interface_Volatile() fail \n");
                    #endif
                    return HD_EXIST_NOVALID;
                 }
                 #ifdef DEBUG
                 printf(" hw_addr from Get..()=%s, hw_addr=%s \n",eth0.hw_addr,hw_addr);
                 #endif

                 if (strncasecmp(hw_addr,eth0.hw_addr,strlen(hw_addr))!=0) {
                   // syslog the condition
                   #ifdef DEBUG
                   printf(" HW Address mismatch ! \n");
                   #endif
                   return HD_EXIST_NOVALID;
                 }
                 else return HD_EXIST_VALID;
              }

           }
           break;
      case CHECK_HDNAME: // check its hd_name is matched or not
           if ( find_conf(embed_conf_file,s_name,'=',1,CONF_FILE_HD_NAME_FIELD,line,
                                                sizeof(line)) <=0) {
              return HD_EXIST_NOVALID;
           }
           else {
              if (get_field_value(line,strlen(line),'=',2,hd_name,sizeof(hd_name)) !=PL_OK)
                 return HD_EXIST_NOVALID;
              else { /*---- compare the hw address is same ?, if not record  -----*/
		 Skip_Front_SPACE_TAB(hd_name);
                 #ifdef DEBUG
                 printf("hd_name=%s, d_info.device_name=%s \n",hd_name,d_info.device_name);
                 #endif
                 if (strncasecmp(d_info.device_name,
                                hd_name,strlen(d_info.device_name) ) != 0) {
                   // syslog the condition
                   #ifdef DEBUG
                   printf(" HD Name mismatch ! \n");
                   #endif
                   return HD_EXIST_NOVALID;
                 }
                 else  return HD_EXIST_VALID;
              }
           }

           break;
      case CHECK_BOTH:
           //- First, check MAC Address is match ?
           if ( (ret=find_conf(embed_conf_file,s_name,'=',1,CONF_FILE_HW_ADDR_FIELD,line,sizeof(line))) <=0) {
              #ifdef DEBUG
                printf("B. find hw_addr= fail in %s file, ret=%d \n",embed_conf_file, ret);
              #endif
              return HD_EXIST_NOVALID;
           }
           else {
             if (get_field_value(line,strlen(line),'=',2,hw_addr,
                                 sizeof(hw_addr)) !=PL_OK) {
                #ifdef DEBUG
                  printf("Get field 2 in the [%s] fail \n",line);
                #endif
                return HD_EXIST_NOVALID;
             }
             else { /*-- compare the hw address is same ?, if not record  --*/
	         Skip_Front_SPACE_TAB(hw_addr);
		 //strcpy(eth0.device_no, "eth0");
                 if ( Get_Network_Interface_Volatile(0, &eth0) != PL_OK) {
                    #ifdef DEBUG
                      printf("Check_HD_Valid(), Get_Network_Interface_Volatile() fail \n");
                    #endif
                    return HD_EXIST_NOVALID;
                 }
                 #ifdef DEBUG
                 printf(" hw_addr from Get..()=%s, hw_addr=%s \n",eth0.hw_addr,hw_addr);
                 #endif

                 if (strncasecmp(hw_addr,eth0.hw_addr,strlen(hw_addr))!=0) {
                   // syslog the condition
                   #ifdef DEBUG
                     printf(" HW Address mismatch ! \n");
                   #endif
                   return HD_EXIST_NOVALID;
                 }
              }

           }
           //- Second, check HD Name is match ?
           if ( find_conf(embed_conf_file,s_name,'=',1,CONF_FILE_HD_NAME_FIELD,line, sizeof(line)) <=0) {
	      #ifdef DEBUG
                printf(" find_conf(%s, hd_name) fail \n", s_name);
              #endif
              return HD_EXIST_NOVALID;
           }
           else {
	     if ( (ret=get_field_value(line,strlen(line),'=',2,hd_name,sizeof(hd_name))) !=PL_OK) {
	       #ifdef DEBUG
	       printf("get_field_value()  fail,  ret=%d \n",  ret);
	       printf("line=%s, hd_name=%s \n", line, hd_name);
	       #endif
	       return HD_EXIST_NOVALID;
	     }
	     else { /*---- compare the hw address is same ?, if not record  -----*/
                 Skip_Front_SPACE_TAB(hd_name);
                 #ifdef DEBUG
                 printf("hd_name=%s, d_info.device_name=%s \n",hd_name,d_info.device_name);
                 #endif
                 if (strncasecmp(d_info.device_name,
                                hd_name,strlen(d_info.device_name) ) != 0) {
                   // syslog the condition
                   #ifdef DEBUG
                   printf(" HD Name mismatch ! \n");
                   #endif
                   return HD_EXIST_NOVALID;
                 }
                 else  return HD_EXIST_VALID;
              }
           }
           break;
      default: return PL_INVAL_PARA;
    }
}

/*-------------------------------------------------------------*/
/*- Get RAID Device First available HD, that is Exist & Valid -*/
/*- Mar 16 2001: It previously version just check the data    -*/
/*-  disks, this is wrong, add check the spare disks & this   -*/
/*-  check must after the data disks check.		      -*/
/*- Return HDX: It is exist & valid                           -*/
/*-        RAID_HD_NOEXIST: It hasn't any avail & valid HD    -*/
/*-        Other     : Error                                  -*/
/*-------------------------------------------------------------*/
int Get_First_RaidHD(struct raid_device *rd_ptr) {
    int  i,ret;
    //struct disk_info d_info;

    #ifdef DEBUG
      printf(" Name=%s \n",rd_ptr->name);
      printf(" rd_ptr->data_hd_no=%d \n",rd_ptr->data_hd_no);
    #endif

    //----------  Check Data Disks  -------------
    for (i=0; i<rd_ptr->data_hd_no; i++) {
        #ifdef DEBUG
          printf("%02d: HD_NO=%d \n",i,rd_ptr->data_hd[i]);
        #endif
        ret = Check_HD_Valid(rd_ptr->data_hd[i], CHECK_BOTH);

        #ifdef DEBUG
          printf("Check_HD_Valid(), ret=%d \n",ret);
        #endif
        if ( ret==HD_EXIST_VALID)
          return rd_ptr->data_hd[i];
    }//-- end of for(i=0.....)

    //----------  Check Spare Disks  -------------
    for (i=0; i<rd_ptr->spare_hd_no; i++) {
        #ifdef DEBUG
          printf("%02d: HD_NO=%d \n",i,rd_ptr->spare_hd[i]);
        #endif
        ret = Check_HD_Valid(rd_ptr->spare_hd[i], CHECK_BOTH);

        #ifdef DEBUG
          printf("Check_HD_Valid(), ret=%d \n",ret);
        #endif
        if ( ret==HD_EXIST_VALID)
          return rd_ptr->spare_hd[i];
    }//-- end of for(i=0.....)

    return RAID_HD_NOEXIST;
}

/*-----------------------------------------------------------------*/
/*- Get RAID Device current status, include which HD had enjoied  -*/
/*- to the RAID Array, you must passin the raid name by -> name   -*/
/*-  field (/dev/mdx)                                             -*/
/*- Note: if resync= RAID_NO_RESYNC represent it hasn't do resync -*/
/*- Feb 2 2001: Add it to record the raid's configure HD No. &    -*/
/*-             its HD's Name                                     -*/
/*- June 18 2001: If Raid1 one disk has bad sector, it will       -*/
/*-  rebuilding fail & the /proc/mdstat message like as           -*/
/*-   mdx: active hde3[0] hdf3[1] (F) 945096 blocks [2/1] [_U]    -*/
/*-   so add to verify the "(F)" string is exist or not, if exist -*/
/*-   doesn't add the disk as active disk.                        -*/       
/*- Return PL_OK: It is exist in the mdstat file                  -*/
/*-        RAID_NO_DEVICE: It hasn't appeared in the mdstat file  -*/
/*-        RAID_NO_STARTUP: The Raid device hasn't start up       -*/
/*-        Other     : Error                                      -*/
/*-----------------------------------------------------------------*/
int Get_Current_Raid_Status(struct raid_status *rd_ptr) {
    char buff[512], value[64], *r_name, *str1;
    int  i,j,ret, rd_no, find_it=FALSE;
    struct raid_device *rd1;

    if ( (r_name=strstr(rd_ptr->name,"/dev/"))==NULL) return RAID_NO_DEVICE;
    r_name = r_name + strlen("/dev/");

    #ifdef DEBUG
      printf("r_name=%s \n",r_name);
    #endif

    //-- Get All Raid Configure start, for to pick this specified
    //- Raid HD members & No.
    rd_no = Get_RaidDev_No();

    rd1=calloc(rd_no,sizeof(struct raid_device));

    ret = Get_All_RaidDev_Conf(rd1, rd_no);

    for (i=0; i<rd_no; i++) {
      if ( strcasecmp( (rd1+i)->name, rd_ptr->name)==0) { // find it
        int con_no=0;

        find_it = TRUE;
        rd_ptr->config_hd_no = (rd1+i)->data_hd_no + (rd1+i)->spare_hd_no;

        // record data hd members
        for (j=0; j<(rd1+i)->data_hd_no; j++) {
          rd_ptr->config_hd[con_no] = (rd1+i)->data_hd[j];
          con_no++;
        }

        // record spare hd members
        for (j=0; j<(rd1+i)->spare_hd_no; j++) {
          rd_ptr->config_hd[con_no] = (rd1+i)->spare_hd[j];
          con_no++;
        }
        break;
      }
    }
    
    free (rd1);
    if ( ! find_it )       
      return RAID_NO_DEVICE;
   

    //----  Get All Raid Configure End  -----


    ret=find_conf(RAID_MDSTAT_FILE,NULL,':',1,r_name,buff,sizeof(buff));
    if ( ret <= 0) {
       #ifdef DEBUG
         printf(" find_conf() fail, ret=%d \n",ret);
       #endif

       if ( ret == PL_NOT_FOUND ) return RAID_NO_STARTUP;
       else                       return ret;
    }

    rd_ptr->active_hd_no = 0;

    //- to pick the active HD  -
    for(i=1; i<MAX_HD_NO; i++) {
      ret=get_field_value(buff,strlen(buff),' ',i,value,sizeof(value));
      if ( ret==PL_LESS_FIELD ) break;
      else if (ret != PL_OK) {
           #ifdef DEBUG
             printf("get_field_value() fail, ret=%d \n",ret);
           #endif
           return ret;
      }

      /*- if find the blocks keyword,represent all active HD be processed finish -*/
      if ( strstr(value,"blocks") != NULL)   break;


      /*--- process the '[' keyword to regard it is the active HD ----*/
      if ( (str1=strstr(value,"[")) != NULL) {  /*- find it -*/
         int  k;
         char dev_name[21], tmp_str[31];

         //*str1 = '\0';

         #ifdef DEBUG
           printf("active_hd_no=%d, value=%s \n",rd_ptr->active_hd_no,value);
         #endif

        if ( (ret=RW_Lock(LOCK_DISK, LOCK_READ)) !=PL_OK)  return ret;
        if ( ReadCFGData(DS_CONF_FILE, STORAGE_SESSION_NAME, DISK_DRVNO_FIELD_NAME,tmp_str,sizeof(tmp_str))==SUCCESS) {
           ret = atoi(tmp_str);
	   #ifdef DEBUG
           printf("In Get_Current_Raid_Status(), Drive NO=%d \n", ret);
           #endif
        }
	for (k=0; k<ret; k++) {
	    sprintf(dev_name, "Drive %d", (k+1));
	    #ifdef DEBUG
             printf("In Get_Current_Raid_Status(), dev_name=%s \n", dev_name);
            #endif
	    if ( ReadCFGData(DS_CONF_FILE, STORAGE_SESSION_NAME, dev_name, tmp_str,sizeof(tmp_str))==SUCCESS) {

	       #ifdef DEBUG
                 printf("In Get_Current_Raid_Status(), value=%s,
                       tmp_str=%s \n",value, tmp_str);
               #endif
	       if ( strncasecmp(value, tmp_str, strlen(tmp_str) )==0) {
	          int m;
	          //- Check it next seeable character is (F) or not 
	          //- If it is, don't add the disk as active hd

                  #ifdef DEBUG
                    printf("In Get_Current_Raid_Status(), A. str1=%s \n",str1);
                  #endif

	          str1 = strstr(str1,"]");
	          str1++;
	      
	          // skip SPACE & TAB character
		  for(m=0; m<20; m++) {
		    if ( (*(str1+m)==SPACE) || (*(str1+m)==TAB) ) str1++;
		    else break; 
		  }

                  #ifdef DEBUG
                    printf("In Get_Current_Raid_Status(), B. str1=%s \n",str1);
                  #endif

                  if ( (*str1=='(') &&
		       ( (*(str1+1)=='F') || (*(str1+1)=='f') ) && 
		       (*(str1+2)==')') ) {
                     #ifdef DEBUG
                       printf("In Get_Current_Raid_Status(),The Disk rebuilding fail  \n");
                    #endif
		  }
		  else{
		    #ifdef DEBUG
                      printf("In Get_Current_Raid_Status(),rebuilding OK, k=%d  \n",k);
                      #endif
		      rd_ptr->active_hd[rd_ptr->active_hd_no]= k+HDA;
		      rd_ptr->active_hd_no++;
		  }

	       }//end of if ( strncasecmp(value, tmp_str
	    } // end of if ( ReadCFGData(DS_CONF_FILE, STORAGE_SESSION_NAME,
	}//end of for (k=0; k<ret; k++) {  
	RW_Unlock(LOCK_DISK);

      }
    } /*- end of for -*/
    

    /*- pick up the resync or recovery -*/
    if ( (str1=strstr(buff,"resync")) != NULL) {
       char  *str_s, *str_e;

        str_e = strstr(str1,"%");
       *str_e='\0';
       str_s = strstr(str1,"="); str_s++;
       rd_ptr->resync=atoi(str_s);

    }
    else if ( (str1=strstr(buff,"recovery")) != NULL) {
         char *str_s, *str_e;

         str_e = strstr(str1,"%");
         *str_e='\0';
         str_s = strstr(str1,"="); str_s++;
         rd_ptr->resync=atoi(str_s);
    }
    else rd_ptr->resync = RAID_NO_RESYNC;

    return PL_OK;

}

/*-----------------------------------------------------------------*/
/*- Verify the HD is belong one RAID Device's member or it just a -*/
/*- single HD                                                     -*/
/*- May 17 2001: Remove the check HD is exist                     -*/
/*- Return SINGLE_HD:  It is a single HD                          -*/
/*-        RAID_HD  :  It is a member of specified raid device    -*/
/*-        HD_NOEXIST: The HD isn't exist Feb. 2 2001 add         -*/
  /*-                                    (Mark May 17 2001        -*/
/*-        Other    :  Error                                      -*/
/*-----------------------------------------------------------------*/
int Is_Raid_HD(int hd_num)
{ int  i, j, rd_no, ret;
  struct raid_device *rd1;

  //--- First, judge the HD is really exist ?
  //if (Is_Exist(hd_num)==HD_NOEXIST)  return HD_NOEXIST;  // mark May 17 2001

  rd_no = Get_RaidDev_No();

  if ( rd_no == PL_FILE_NOEXIST || rd_no==0)
     return SINGLE_HD;

  if ( rd_no < 0)  return rd_no;

  rd1=calloc(rd_no,sizeof(struct raid_device));

  ret = Get_All_RaidDev_Conf(rd1, rd_no);
  if ( ret != PL_OK) {
     #ifdef DEBUG
       printf("Get_All_RaidDev_Conf() fail, ret=%d \n",ret);
     #endif
     free(rd1);
     return ret;
  }

  for(i=0; i<rd_no; i++) {
    for(j=0; j<(rd1+i)->data_hd_no; j++)
      if ( hd_num == (rd1+i)->data_hd[j]) {
        free(rd1);
        return RAID_HD;
      }


    for(j=0; j<(rd1+i)->spare_hd_no; j++)
      if ( hd_num == (rd1+i)->spare_hd[j]) {
         free(rd1);
         return RAID_HD;
      }  
  }
  free(rd1);
  return  SINGLE_HD;
}

/*-----------------------------------------------------------------*/
/*- Verify it is active RAID HD of specified RAID Device          -*/
/*- The raid_name is string of raid device name, like as /dev/md0 -*/
/*- Return RAID_ACTIVE:   It is active                            -*/
/*-        RAID_NOACTIVE: It isn't active                         -*/
/*-        RAID_NO_STARTUP: The RAID Device hasn't start up       -*/
/*-        HD_NOEXIST:      The hd_no no exist                    -*/
/*-----------------------------------------------------------------*/
int Is_Active_RaidHD(int hd_no, char *raid_name)
{
    struct raid_status rds;
    int  ret;


    //--- First, judge the HD is really exist ?
    if (Is_Exist(hd_no)==HD_NOEXIST)  return HD_NOEXIST;

    strcpy(rds.name,raid_name);

    ret=Get_Current_Raid_Status(&rds);
    if (ret == PL_OK) {
       int  m;

       #ifdef DEBUG
       printf("In Is_Active_RaidHD(%s), active_hd_no=%d \n",
	      rds.name, rds.active_hd_no);
       #endif

       for (m=0; m<rds.active_hd_no; m++) {
	 #ifdef DEBUG
	 printf("In Is_Active_RaidHD(), hd_no=%d, active_hd[%d]=%d \n",
		hd_no, m, rds.active_hd[m]);
	 #endif
         if ( hd_no==rds.active_hd[m])   return RAID_ACTIVE;
       }

       return RAID_NOACTIVE;

    }
    else if ( ret==RAID_NO_STARTUP)  return RAID_NO_STARTUP;
    else                             return RAID_NOACTIVE;

    //return PL_FAIL;
}

/*-----------------------------------------------------------------*/
/*- Get HD Device Name                                            -*/
/*- Return PL_OK:  Get Successful                                 -*/
/*-        Other     : Error                                      -*/
/*-----------------------------------------------------------------*/
int Get_HD_DevName(int hd_no, char *o_str)
{
  int  ret;
  char value[31], buff[31];

  //--- If it is MDx, just find it in PUBLIC Array
  if ( hd_no >=MD0 ) {
    strcpy(o_str,HD_DevName_STR[hd_no-HDA]);
    return PL_OK;
  }

  //-- If not MDx, find it in uLinux.conf
  if ( (ret=RW_Lock(LOCK_DISK, LOCK_READ)) !=PL_OK)  return ret;

  sprintf(value, "Drive %d", (hd_no-HDA+1) );
  ret = ReadCFGData(DS_CONF_FILE, STORAGE_SESSION_NAME, value, buff,sizeof(buff)); 
  if (  ret !=SUCCESS && ret !=ERROR_NOT_FOUND) {
     RW_Unlock(LOCK_DISK);
     return PL_FAIL;
  }
  
  if ( ret==SUCCESS) {  // has find it
     strcpy(o_str,"/dev/");
     strcat(o_str, buff);
  }
  else { // not found, use default value
    strcpy(o_str,HD_DevName_STR[hd_no-HDA]);
  }

  RW_Unlock(LOCK_DISK);
  return PL_OK;

}

/*-----------------------------------------------------------------*/
/*- Get HD String                                                 -*/
/*- Return PL_OK:  Get Successful                                 -*/
/*-        Other     : Error                                      -*/
/*-----------------------------------------------------------------*/
int Get_HD_String(int hd_no, char *o_str)
{

  strcpy(o_str, HD_STR[hd_no-HDA]);
  return PL_OK;

}

/*-----------------------------------------------------------------*/
/*- Get Partition Name                                            -*/
/*- If you pass in d_name isnot raid device, it will return the   -*/
/*- return value which return from Get_HD_DevName()               -*/
/*- May 15 2001: The DATA Partition Change to Partition 3         -*/
/*- which_part: ROOT_PART,DATA_PART or SWAP_PART                  -*/
/*- May 15 2001: In soft_raid.h add a SWAP_PART constant          -*/
/*- June 26 2001: If the [Storage] "Use Flash Disk" = True,       -*/
/*- fill the o_str with FLASH_ROOT & reture SUCCESS               -*/
/*- Return PL_OK:  Get Successful                                 -*/
/*-        Other     : Error                                      -*/
/*-----------------------------------------------------------------*/
int Get_Partition_Name(int d_name, char *o_str, int which_part)
{
  int  ret;
  
  if ( (Use_Flash_Disk() ) && which_part==ROOT_PART ) {
    strcpy(o_str, FLASH_ROOT_PART_NAME);
    return PL_OK;
  }

  if ( (ret=Get_HD_DevName(d_name, o_str)) != PL_OK)  return ret;

  //-- If the HD is not raid device then append part. no.
  if ( d_name < MD0) {
    if ( which_part == ROOT_PART )
      strcat(o_str,"1");
    else if ( which_part == SWAP_PART )
      strcat(o_str,"2");
    else // data part
      strcat(o_str,"3");
  }

  return PL_OK;
}


/*-----------------------------------------------------------------*/
/*- Get Mount Point String                                        -*/
/*- part_no: 1 (ROOT_PART) : Get Partition 1                      -*/
/*- part_no: 2 (DATA_PART) : Get Partition 2                      -*/
/*- Return PL_OK:  Get Successful                                 -*/
/*-        Other     : Error                                      -*/
/*-----------------------------------------------------------------*/
int Get_MP_String(int hd_no, char *o_str, int part_no)
{

  if (part_no==ROOT_PART)
     strcpy(o_str, HD_ROOT_MP[hd_no-HDA]);
  else
     strcpy(o_str, HD_DATA_MP[hd_no-HDA]);


  return PL_OK;

}


/*-----------------------------------------------------------------*/
/*- Get HD Integer                                                -*/
/*- The i_str like as /dev/hda or hda                             -*/
/*- Return HDA, HDB...MD0:   Successful                           -*/
/*-        PL_NOT_FOUND : Cannot find it                          -*/
/*-----------------------------------------------------------------*/
int Get_HD_Integer(char *i_str) {
    int i, find_flag=FALSE, ret;
    char value[31], buff[31];

    if ( (ret=RW_Lock(LOCK_DISK, LOCK_READ)) !=PL_OK)  return ret;
    if ( ReadCFGData(DS_CONF_FILE, STORAGE_SESSION_NAME, DISK_DRVNO_FIELD_NAME,value,sizeof(value))==SUCCESS) {
       ret = atoi(value);
    }
    else {
       RW_Unlock(LOCK_DISK);
       return  PL_FAIL;
    }

    for (i=0; i<ret; i++) {
        sprintf(value, "Drive %d", (i+1));
        if ( ReadCFGData(DS_CONF_FILE, STORAGE_SESSION_NAME, value, buff,sizeof(buff))==SUCCESS) {
	  if (strstr(i_str, buff) != NULL){
	    find_flag = TRUE;
	    ret = i+HDA;
	    break;
	  }
	}
    }
    RW_Unlock(LOCK_DISK);

    if ( find_flag )   return ret;
    else  { //-- Not found in uLinux.conf(may be is MDx), try to find PUBLIC Array
      for (i=0; i<MAX_RHD_NO; i++) {
        if (strstr(HD_DevName_STR[i],i_str) != NULL) {
           ret = i+HDA;
           return ret;
        }
      }
      return PL_NOT_FOUND;
    }
}
//------------------------------------------------------------------
// Purpose: If you want to create one raid device, you should
// call this function to get first available raid device name
// rd_no: Output parameter, record the first available raid device
//        name's integer
// May 14 2001: Add code for check the MDx is locked by others, if it's
//              to get next available MDy.
// return: PL_OK --> Successful
//        Others --> Fail
//------------------------------------------------------------------
int Get_First_Available_RaidName(int *rd_number)
{
  int rd_no, ret, i, j, status;
  struct raid_device *rd1;

  rd_no = Get_RaidDev_No();
  if ( rd_no > 0 ) {
    int find_flag;
    char buf[20];

    rd1=calloc(rd_no,sizeof(struct raid_device));
    ret = Get_All_RaidDev_Conf(rd1, rd_no);
    if ( ret != PL_OK) {
        free(rd1);
        return ret;
    }   

    for (i=MD0; i<MD9; i++) {
        Get_HD_DevName(i,buf);

        find_flag = FALSE;
        for(j=0; j<rd_no; j++) {
          if ( strstr((rd1+j)->name,buf) != NULL ){  //  find it
             // if find it don't need to check its lock status
	     find_flag = TRUE;
	     break;
          }
        }//- end of for(j)
        if ( !find_flag) {
           *rd_number = i;
           free(rd1);
           return PL_OK;
        }
    } //- end of for(i)
    free(rd1);
    return RAID_OVER_MAXNO;
  } //- end of if (rd_no > 0)
  else if (rd_no==0 || rd_no==PL_FILE_NOEXIST) {  // rd_no <=0
       // May 14 2001 added, check it's locked by other
       for (i=MD0; i<MD9; i++) {
	   if ( Get_HD_Lock_Status(i, &status) == PL_OK) {
	      if ( status == HD_UNLOCKING) {
		*rd_number = i;
		return PL_OK;
	      }
	   }
       }
       return RAID_OVER_MAXNO;
  }
  else return rd_no;   // return error code
}

//---------------------------------------------------------------
// Before call this function, you should mount specified device
// The file's content like as
//  hw_addr=00:c0:02:98:dc
//  hd_name=/dev/hdc
// June 26 2001: If it use Flash Disk, the conf file will been created
// at /etc/config/.conf & it contain all disk informat, its content like as
// [HDA]
//  hw_addr=xx:xx:xx:xx:xx:xx
//  hd_name=/dev/hde
// [HDB] .....
//---------------------------------------------------------------
int Create_Hidden_Conf_File(int hd)
{
  char hd_name[31], embed_conf_file[50], line[256];
  IFInfo eth0;
  int  ret;

  /*---------   Get MAC Address  -------------*/
  //strcpy(eth0.device_no, "eth0");
  if ( Get_Network_Interface_Volatile(0, &eth0) != PL_OK) {
     #ifdef DEBUG
       printf("Create_Hidden_Conf_File(), Get_Network_Interface_Volatile() fail \n");
     #endif
     return NET_ERR_GET_MACADDRESS;
  }

  #ifdef DEBUG
    printf("  hw_addr=%s \n",eth0.hw_addr);
  #endif

  /*------  Get HD Device Name --------*/
  if ( (ret=Get_HD_DevName(hd, hd_name)) != PL_OK ) {
     #ifdef DEBUG
       printf(" Get_HD_DevName() fail, ret=%d \n",ret);
     #endif
     return ret;
  }

  /*-----  Create & Write to Hidden Conf File --------*/
  ret = Get_Hidden_Conf_File_Name(hd,embed_conf_file);
  if ( ret != PL_OK )  {
     #ifdef DEBUG
       printf(" Get_Hidden_Conf_File_Name() fail, ret=%d \n",ret);
     #endif
     return ret;
  }

  #ifdef DEBUG
  printf("Get_Hidden_Conf_File() Successful, CONF_FILE=%s \n", embed_conf_file);
  #endif

  if ( Use_Flash_Disk() ) {
    char hd_str[11], s_name[13];
    //- Because WriteCFGData(), need the config file exist, otherwose it will
    //- fail, but it can create the new session if it's not exist
    #ifdef DEBUG
    printf("Flash Disk  \n");
    #endif
    if ( access (embed_conf_file, F_OK) !=0) { // file not exist
      if (creat(embed_conf_file, S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP)==-1)
	return PL_OPEN_FILE;
    }
    
    if ( (ret = Get_HD_String(hd, hd_str)) !=PL_OK) return ret;
    strcpy(s_name, hd_str);
    ret=WriteCFGData(embed_conf_file, s_name, CONF_FILE_HW_ADDR_FIELD, eth0.hw_addr);
    if ( ret!=SUCCESS ) {
       #ifdef DEBUG
         printf("WriteCFGData(%s, %s, hw_addr \n", embed_conf_file, hd_str );
       #endif
       return  ret;
    }
    ret=WriteCFGData(embed_conf_file, s_name, CONF_FILE_HD_NAME_FIELD, hd_name);
    if ( ret!=SUCCESS ) {
       #ifdef DEBUG
         printf("WriteCFGData(%s, %s, hd_name\n", embed_conf_file, hd_str );
       #endif
       return  ret;
    }

  }
  else {  // Non-Flash Disk
    //--  prepare & write data  --
    sprintf(line,"%s=%s\n%s=%s\n",CONF_FILE_HW_ADDR_FIELD,eth0.hw_addr,CONF_FILE_HD_NAME_FIELD,hd_name);
    #ifdef DEBUG
    printf("Non-Flash Disk, line=%s \n", line);
    #endif
    //-- re-create a new file
    ret = write_to_file(embed_conf_file, line, strlen(line), 1); 
    if ( ret != PL_OK) {
       #ifdef DEBUG
         printf("write_to_file() fail, ret=%d \n",ret);
       #endif
	 return ret;
    }
  }
  
  
  //-------  Append it to DS_CONF_FILE --------------------------
  //-- I don't care it is exist or, just to write it, it will
  //-- create a new one or overwrite it ( if it exist)
  //-------------------------------------------------------------
  Get_HD_String(hd, hd_name);
  strcat(hd_name,"_NOEXIST");
  strcpy(line,"0");
  ret=WriteCFGData(DS_CONF_FILE, DISK_SESSION_NAME, hd_name, line);
  if ( ret!=SUCCESS ) {
    #ifdef DEBUG
      printf("WriteCFGData(File=%s, Session_Name=%s, Field=%s \n", DS_CONF_FILE, DISK_SESSION_NAME, hd_name);
    #endif
    return  ret;
  }
  //- Update RAM data to flash immeditelly
   //Update_Flash_Data(DS_CONF_FILE);  // call Louis's function June 4 2001

  return PL_OK;
}

//-------------------------------------------------------------
// June 26 2001: If use Flash Disk, the file (all disks reference)
// is locate on /etc/config/.conf file
// return PL_OK: Successful
//      others : Fail
//-------------------------------------------------------------
int Get_Hidden_Conf_File_Name(int hd_no, char *op_name) {

  if (Use_Flash_Disk() ) {
    strcpy(op_name, FLASH_DISK_HD_CONF_FILE);
    return PL_OK;
  }
  else {
    sprintf(op_name,"%s/%s",HD_ROOT_MP[hd_no-HDA],RAID_HIDDEN_CONF_FILE);
    return  PL_OK;
  }
}

//----------------------------------------------------------------------
// m_ptr: the pointer of struct configured_hd
// m_cnt: the numbers of stuct configured_hd
// Feb 2 2001: Add record its status
// May 17 2001: Add the has configured HD but not exist
// It is consider for Volume not the Physical HD
// return nnn: n arrays be getted
//      others : Fail
//-----------------------------------------------------------------------
int Get_All_Configured_HD_String(struct configured_hd *m_ptr, int m_cnt)
{
  int    i, rd_no, hd_no, ret, active_raid_no, find_cnt=0;
  char   buff[256], value[31];
  struct raid_device *rd1;
  struct raid_status rd_ptr;
  char   web_str[21];   // like as Drive x

  /*=========   Check The valid single HDs Start  ========*/
  /*--- Process IDE HDs  ------*/
  if ( (ret=RW_Lock(LOCK_DISK, LOCK_READ)) !=PL_OK)  return ret;
  for (i=HDA; i<=HDD; i++) {
      if ( (ret=Get_Physical_HD_Web_String(i, web_str, sizeof(web_str)) )
	   != PL_OK)   continue;

        //if ( Is_Raid_HD(i) == SINGLE_HD &&
	//Check_HD_Valid(i, CHECK_HDNAME) == HD_EXIST_VALID) {
        if ( Is_Raid_HD(i) == SINGLE_HD ) {  // may be HD exist or non-exist
	   if ( Get_HD_String(i, value) != PL_OK)   continue;
	   sprintf(buff, "%s_NOEXIST", value);
           if ( ReadCFGData(DS_CONF_FILE, DISK_SESSION_NAME, buff,value,
			    sizeof(value))==SUCCESS) {
	      if ( atoi(value) >= 0) {
		 sprintf((m_ptr+find_cnt)->hd_web_string,"Single Disk: %s", 
			 web_str);
                 (m_ptr+find_cnt)->hd_intno = i;
		 find_cnt++;
	      }
	   }
	}
  }// end of for(i=HDA....)
  RW_Unlock(LOCK_DISK);

  /*=========   Check The valid single HDs END    ========*/

  /*========= Check Valid RAID HD Start =============*/
  rd_no = Get_RaidDev_No();

  if ( rd_no <=0 )  return find_cnt;

  rd1=calloc(rd_no,sizeof(struct raid_device));


  ret = Get_All_RaidDev_Conf(rd1, rd_no);

  active_raid_no = 0;
  for (i=0; i<rd_no; i++) {
    //if ( Get_HD_Lock_Status(i, &j)==PL_OK) {
    //if (j==HD_LOCKING)  continue;
    //}
    //- add 2001/3/5 to check its status, if it's not in HD_READY
    //- don't add it to configured list
    //tmp_str[0] = Get_HD_Integer((rd1+i)->name);
    //if ( Get_HD_Status(tmp_str[0],&j) != PL_OK)  continue;
    //if ( j != HD_READY )   continue;
    //--- add 2001/3/5 End 

    strcpy(rd_ptr.name, (rd1+i)->name);
    /***************
    // Mark start by May 17 2001
    if ( (ret=Get_Current_Raid_Status(&rd_ptr)) !=PL_OK) {
       #ifdef DEBUG
         printf("Get_Current_Raid_Status(),ret=%d \n",ret);
       #endif
       continue; //the raid not active
    }
    //  Mark End by May 17 2001 
    ****************/

    active_raid_no++;
    hd_no = Get_HD_Integer((rd1+i)->name);
    if ( hd_no==PL_NOT_FOUND)   return PL_NOT_FOUND;
    
    if ( (ret=Get_RaidDev_Web_String(hd_no, buff, sizeof(buff))) !=PL_OK){
       #ifdef DEBUG
         printf("Get_RaidDev_Web_String(),ret=%d \n",ret);
       #endif
       free(rd1);
       return ret;
    }
                
    strcpy((m_ptr+find_cnt)->hd_web_string,buff);
    //(m_ptr+find_cnt)->hd_intno = MD0+i;
    (m_ptr+find_cnt)->hd_intno = hd_no;  //Get_HD_Integer((rd1+i)->name);
    find_cnt++;

  } // end of for(i=0....)
  /*========= Check Valid RAID HD END   =============*/
  free(rd1);
  return find_cnt;

}
//------------------------------------------
// It will get all new or invalid disks
// Return nn: the numbers it has get
//       OTHER: error
//------------------------------------------
int Get_All_Invalid_HD(int *ptr, int ptr_cnt) {
  int  i, ret, total_no=0;

  //- to get IDE HDs
  for ( i=HDA; i<=HDD; i++) {
    if ( (ret=Check_HD_Valid(i, CHECK_BOTH))==HD_EXIST_NOVALID) {
      if (total_no < ptr_cnt) {
         *(ptr+total_no)=i;
         total_no++;
      }
      else return PL_LESS_MEM;
    }
    // Mar 14 2001 add 
    else if ( ret == HD_EXIST_VALID) {
      Get_HD_Status(i, &ret);
      if ( ret == HD_MOUNT_FAIL) {
        if (total_no < ptr_cnt) {
         *(ptr+total_no)=i;
         total_no++;
      }
      else return PL_LESS_MEM;
      }
    }
  } // end of for(i);

  //- to get SCSI HDs
  for ( i=SDA; i<=SDO; i++) {
    if ( Check_HD_Valid(i, CHECK_BOTH)==HD_EXIST_NOVALID) {
      if ( total_no < ptr_cnt) {
        *(ptr+total_no)=i;
        total_no++;
      }
      else  return PL_LESS_MEM;
    }
    // Mar 14 2001 add 
    else if ( ret == HD_EXIST_VALID) {
      Get_HD_Status(i, &ret);
      if ( ret == HD_MOUNT_FAIL) {
        if (total_no < ptr_cnt) {
         *(ptr+total_no)=i;
         total_no++;
      }
      else return PL_LESS_MEM;
      }
    }

  } // end of for(i);

  return total_no;
}

//-----------------------------------------
// Check the partition is mounted ?
// which_part: ROOT_PART  or  DATA_PART
// If it is Use_Flash_Disk with ROOT_PART,
// just return PART_NOMOUNTED
// return PART_MOUNTED
//        PART_NOMOUNTED
//        other: error
//-----------------------------------------
int Is_Mounted(int hd_no, int which_part)
{
  char mp[20], line[81];
  int  ret;

  if ( (Use_Flash_Disk()) && (which_part==ROOT_PART))  return PART_NOMOUNTED;

  if ( (ret=Get_MP_String(hd_no, mp, which_part)) !=PL_OK ) {
     #ifdef DEBUG
       printf("In Is_Mounted(), Get_MP_String(hd=%d, which_part=%d) fail,ret=%d\n",hd_no,which_part,ret);
     #endif
     return ret;
  }

  if ( find_conf(MOUNTED_CONF_FILE,NULL,SPACE,2,mp, line, sizeof(line)) <=0 ){
     if ( (ret=find_conf(MOUNTED_CONF_FILE,NULL,TAB,2,mp, line, sizeof(line))) <=0 ){
       if ( ret == PL_NOT_FOUND)  return PART_NOMOUNTED;
       else  return ret;
     }
     else { // find it by TAB ideentifer
       return PART_MOUNTED;
     }
  }
  else { // find it by SPACE identifer
    return PART_MOUNTED;
  }

}

//============================================================
//Judge HD is exist
//============================================================
int Is_Exist(int hd)
{
  char hd_name[11];
  int  fd;

  Get_HD_DevName(hd, hd_name);

  fd = open (hd_name, O_RDONLY);
  if ( fd < 0 ) {
     #ifdef DEBUG
       printf(" open %s fail !\n",hd_name);
     #endif
     return HD_NOEXIST;
  }

  close(fd);

  return HD_EXIST;

}

//======================================================================
// All shmget() will alloc 5 bytes memory
// Each HD use itself semaphore key (BASE_KEY + hd_no)
// Lock Flag use the first byte
// ResultCode use the first byte+HD_RESULTCODE_OFFSET (current value=1)
//======================================================================


//-----------------------------------------------------
// hd_no: which HD you want to lock, like as HDA
// It use HD_LOCK_OFFSET Byte of shared memory
// return: PL_OK --> successful
//        OTHERS --> fail
//-----------------------------------------------------
int Lock_HD(int hd_no)
{
  int  shared_mem_id;
  int  *ptr;
  void *shared_mem = (void *)0;

  shared_mem_id = shmget((key_t) SEMAPHORE_KEY+hd_no,SHARED_MEM_SIZE,IPC_CREAT | 0666);
  if ( (int)shared_mem_id == -1) {
     #ifdef DEBUG
       printf("shmget() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  shared_mem = shmat(shared_mem_id, (void *) 0, 0);
  if ( (int)shared_mem == -1) {
     #ifdef DEBUG
       printf(" shmat() fail \n");
     #endif
     shmdt(shared_mem);
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  ptr = (int *)shared_mem + HD_LOCK_OFFSET;

  if ( *(ptr)==HD_LOCKING ) {
     shmdt(shared_mem);
     return HD_BUSY;
  }
  else {
    *(ptr)=HD_LOCKING;
    shmdt(shared_mem);
    return PL_OK;
  }

}

//----------------------------------------------
// It use HD_LOCK_OFFSET Byte of shared memory
//----------------------------------------------
int Unlock_HD(int hd_no)
{
  int  shared_mem_id;
  int  *ptr;
  void *shared_mem = (void *)0;

  shared_mem_id = shmget((key_t) SEMAPHORE_KEY+hd_no,SHARED_MEM_SIZE,IPC_CREAT | 0666);
  if ( shared_mem_id == -1) {
     #ifdef DEBUG
       printf("shmget() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  shared_mem = shmat(shared_mem_id, (void *) 0, 0);
  if ( (int)shared_mem == -1) {
     #ifdef DEBUG
       printf(" shmat() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  ptr = (int *)shared_mem + HD_LOCK_OFFSET;
  *(ptr)=HD_UNLOCKING;

  shmdt(shared_mem);
  return PL_OK;
}
//----------------------------------------------
// Get HD Status Status
//----------------------------------------------
int Get_HD_Lock_Status(int hd_no, int *status)
{
  int  shared_mem_id;
  int  *ptr;
  void *shared_mem = (void *)0;

  shared_mem_id = shmget((key_t) SEMAPHORE_KEY+hd_no,SHARED_MEM_SIZE,IPC_CREAT | 0666);
  if ( shared_mem_id == -1) {
     #ifdef DEBUG
       printf("shmget() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  shared_mem = shmat(shared_mem_id, (void *) 0, 0);
  if ( (int) shared_mem == -1) {
     #ifdef DEBUG
       printf(" shmat() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  ptr = (int *)shared_mem + HD_LOCK_OFFSET;
  *status = *(ptr);

  shmdt(shared_mem);
  return PL_OK;
}

//-----------------------------------------------------
// Set specified HD's status
// It use HD_STATUS_SHM_OFFSET byte of shared memory
//-----------------------------------------------------
int Set_HD_Status(int hd_no, int status_code)
{
  int  shared_mem_id;
  int  *ptr;
  void *shared_mem = (void *)0;

  shared_mem_id = shmget((key_t) SEMAPHORE_KEY+hd_no,SHARED_MEM_SIZE,IPC_CREAT | 0666);
  if ( shared_mem_id == -1) {
     #ifdef DEBUG
       printf("shmget() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  shared_mem = shmat(shared_mem_id, (void *) 0, 0);
  if ( (int)shared_mem == -1) {
     #ifdef DEBUG
       printf(" shmat() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  ptr = (int *)shared_mem+HD_STATUS_SHM_OFFSET;
  *(ptr)=status_code;

  shmdt(shared_mem);
  return PL_OK;
}

//-----------------------------------------------------
// Get specified HD's status
// It use HD_STATUS_SHM_OFFSET byte of shared memory
//-----------------------------------------------------
int Get_HD_Status(int hd_no, int *status_code)
{
  int  shared_mem_id;
  int  *ptr;
  void *shared_mem = (void *)0;

  shared_mem_id = shmget((key_t) SEMAPHORE_KEY+hd_no,SHARED_MEM_SIZE,IPC_CREAT | 0666);
  if ( shared_mem_id == -1) {
     #ifdef DEBUG
       printf("shmget() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  shared_mem = shmat(shared_mem_id, (void *) 0, 0);
  if ( (int)shared_mem == -1) {
     #ifdef DEBUG
       printf(" shmat() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  ptr = (int *)shared_mem+HD_STATUS_SHM_OFFSET;

  *status_code = *(ptr);
  shmdt(shared_mem);
  return PL_OK;
}

//----------------------------------------------------
// Transfer HD status code from integer to string
// which will show on user's browser
//-----------------------------------------------------
int Tran_Status_Code_To_String(int status_code, char *status_str, int str_size)
{
    if ( str_size < STATUS_CODE_STR_LEN)  return PL_LESS_MEM;

    switch (status_code) {
           case HD_READY:
                strcpy(status_str,"Ready");
                break;

           case HD_NOEXIST:
                strcpy(status_str,"HD not exist");
                break;

           case HD_MOUNT_FAIL:
                strcpy(status_str,"HD mount fail");
                break;

           case RAID_NOACTIVE:
                strcpy(status_str,"Raid not active");
                break;

           case RAID_OK_DEGRADEMODE:
                strcpy(status_str,"Raid Ready: In degrade mode");
                break;

           case HD_WAIT_TO_INITIALIZE:
                strcpy(status_str,"HD wait to initialize");
                break;

           case HD_REBUILDING:
                strcpy(status_str,"Raid is rebuilding");
                break;

           case HD_FORMATTING:
                strcpy(status_str,"HD is formatting");
                break;

           case HD_SCANNING:
                strcpy(status_str,"HD is scanning");
                break;

           case HD_INVALID:
                strcpy(status_str,"Invalid ");
                break;

        default: //not define this status code
               return PL_NOT_FOUND;

    }

    return PL_OK;

}

//-------------------------------------------------------------------------
// May 4 2001:
// It will put max two byte pid code to the shared memory by you specified
// It usually use by CGI Parent process to check the child process is still
// exist or not.
//-------------------------------------------------------------------------
int Put_Child_Pid(int hd_no, int pid)
{
  int  shared_mem_id;
  int  *ptr;
  void *shared_mem = (void *)0;

  shared_mem_id = shmget((key_t) SEMAPHORE_KEY+hd_no,SHARED_MEM_SIZE,IPC_CREAT | 0666);
  if ( shared_mem_id == -1) {
     #ifdef DEBUG
       printf("shmget() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  shared_mem = shmat(shared_mem_id, (void *) 0, 0);
  if ( (int)shared_mem == -1) {
     #ifdef DEBUG
       printf(" shmat() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  ptr = (int *)shared_mem + HD_CHILDPID_OFFSET;
  *(ptr) = pid;

  return PL_OK;

}

//-----------------------------------------------------------------------------
// See the Put_Child_Pid()
//-----------------------------------------------------------------------------
int Get_Child_Pid(int hd_no, int *pid)
{
  int  shared_mem_id;
  int  *ptr;
  void *shared_mem = (void *)0;

  shared_mem_id = shmget((key_t) SEMAPHORE_KEY+hd_no,SHARED_MEM_SIZE,IPC_CREAT | 0666);
  if ( (int)shared_mem_id == -1) {
     #ifdef DEBUG
      printf("shmget() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  shared_mem = shmat(shared_mem_id, (void *) 0, 0);
  if ( (int)shared_mem == -1) {
     #ifdef DEBUG
       printf(" shmat() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  ptr = (int *)shared_mem + HD_CHILDPID_OFFSET;
  *pid = *(ptr);

  return PL_OK;
}

//-------------------------------------------------------------------------
// Its place putting result code which locate after one byte from the Lock
// It use Second Byte of shared memory
// flag location which start at shared memory
//-------------------------------------------------------------------------
int Put_HD_Tmp_Str(int hd_no, char *put_str, int str_size)
{
  int  shared_mem_id;
  char *ptr;
  void *shared_mem = (void *)0;

  if ( str_size > HD_TMPSTR_MAXLEN)  return PL_LESS_MEM;

  shared_mem_id = shmget((key_t) SEMAPHORE_KEY+hd_no,SHARED_MEM_SIZE,IPC_CREAT | 0666);
  if ( shared_mem_id == -1) {
     #ifdef DEBUG
       printf("shmget() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  shared_mem = shmat(shared_mem_id, (void *) 0, 0);
  if ( (int)shared_mem == -1) {
     #ifdef DEBUG
       printf(" shmat() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  ptr = (char *)shared_mem + HD_TMPSTR_OFFSET;
  
  //--- clear the area
  memset(ptr, 0, HD_TMPSTR_MAXLEN);

  strncpy(ptr, put_str, str_size);

  return PL_OK;

}
//----------------------------------------------------------------
// hd_no: pass in the HD No. which you want to get, like as HDA
// It use Second Byte of shared memory
// r_code: it return result code place
// return: PL_OK --> successful
//         OTHERs -> fail
//----------------------------------------------------------------
int Get_HD_Tmp_Str(int hd_no, char *get_str, int str_size)
{
  int  shared_mem_id, i;
  char  *ptr;
  void *shared_mem = (void *)0;

  shared_mem_id = shmget((key_t) SEMAPHORE_KEY+hd_no,SHARED_MEM_SIZE,IPC_CREAT | 0666);
  if ( shared_mem_id == -1) {
     #ifdef DEBUG
      printf("shmget() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  shared_mem = shmat(shared_mem_id, (void *) 0, 0);
  if ( (int)shared_mem == -1) {
     #ifdef DEBUG
       printf(" shmat() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  ptr = (char *)shared_mem + HD_TMPSTR_OFFSET;

  if ( str_size > HD_TMPSTR_MAXLEN)
    i = HD_TMPSTR_MAXLEN;
  else 
    i = str_size;

  strncpy(get_str, ptr, i);

  return PL_OK;
}

//-------------------------------------------------------------------------
// Its place putting result code which locate after one byte from the Lock
// It use Second Byte of shared memory
// flag location which start at shared memory
//-------------------------------------------------------------------------
int Put_HD_Process_ResultCode(int hd_no, int r_code)
{
  int  shared_mem_id;
  int  *ptr;
  void *shared_mem = (void *)0;

  shared_mem_id = shmget((key_t) SEMAPHORE_KEY+hd_no,SHARED_MEM_SIZE,IPC_CREAT | 0666);
  if ( shared_mem_id == -1) {
     #ifdef DEBUG
       printf("shmget() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  shared_mem = shmat(shared_mem_id, (void *) 0, 0);
  if ( (int)shared_mem == -1) {
     #ifdef DEBUG
       printf(" shmat() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  ptr = (int *)shared_mem + HD_RESULTCODE_OFFSET;
  *(ptr) = r_code;

  return PL_OK;

}
//----------------------------------------------------------------
// hd_no: pass in the HD No. which you want to get, like as HDA
// It use Second Byte of shared memory
// r_code: it return result code place
// return: PL_OK --> successful
//         OTHERs -> fail
//----------------------------------------------------------------
int Get_HD_Process_ResultCode(int hd_no, int *r_code)
{
  int  shared_mem_id;
  int  *ptr;
  void *shared_mem = (void *)0;

  shared_mem_id = shmget((key_t) SEMAPHORE_KEY+hd_no,SHARED_MEM_SIZE,IPC_CREAT | 0666);
  if ( (int)shared_mem_id == -1) {
     #ifdef DEBUG
      printf("shmget() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  shared_mem = shmat(shared_mem_id, (void *) 0, 0);
  if ( (int)shared_mem == -1) {
     #ifdef DEBUG
       printf(" shmat() fail \n");
     #endif
     return HD_CALL_SHARED_FUNC_FAIL;
  }

  ptr = (int *)shared_mem + HD_RESULTCODE_OFFSET;
  *r_code = *(ptr);

  return PL_OK;
}
//----------------------------------------------------------------------------
// Usually the Parent process will cal Lock_HD() to lock this HD
// & then call Unlock_HD() to unlock it
// The child process just put result code to shared memory.
// But it parent hasn't call Unlock_HD() will result in the HD always be locked
// So I implement receive message function which will receive the parent's
// message if the parent has receive the result code, if parent isn't it will
// not send out any message to child, this time child counter down n seconds
// after it has putted the result code, if it still hasn't received the
// parent's message, the child will call Unlock_HD() to unlock this HD
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
// If the parent process has received the child result code, it should call
// this function to tell child I have received your result code
// If the child hasn't received its message, child will clear any shared
// memory function in specified timeout value
// msg_type: If you are in child your Send_RecultCode() message's
// msg_type=CHILD_MSG
// If you in child process & expect to receive parent's response message, your
// Receive_ResultCode() msg_type=PARENT_MSG
//----------------------------------------------------------------------------
int Send_ResultCode(int hd_no,int msg_type, int ret_code)
{
    //int ret;
    struct hd_msg_st s_msg;
    int  msgid;

    msgid = msgget((key_t)(SEMAPHORE_KEY+hd_no), 0666 | IPC_CREAT);

    if (msgid == -1) {
       #ifdef DEBUG
         printf( "msgget(%d) failed errno=%d\n", hd_no,errno);
       #endif
       return HD_CALL_MSGQUEUE_FUNC_FAIL;
    }

    strcpy(s_msg.text,"Receive");
    s_msg.result_code = ret_code;
    s_msg.msg_type = msg_type;

    if (msgsnd(msgid, (void *)&s_msg, MAX_MSG_LEN, 0) == -1) {
       #ifdef DEBUG
         printf("msgsnd(%d) fail, errno=%d \n",hd_no, errno);
       #endif
       return HD_CALL_MSGQUEUE_FUNC_FAIL;
    }

    return PL_OK;

}

//----------------------------------------------------------------------------
// The child process use this function to received the parent response message
// after child had putted the result code to message queue's memory
// It will return HD_MSG_EMPTY, if no messages in this queue
// msg_type: If you are in child your Send_RecultCode() message's
// msg_type=CHILD_MSG
// If you in child process & expect to receive parent's response message, your
// Receive_ResultCode() msg_type=PARENT_MSG
//-----------------------------------------------------------------------------
int Receive_ResultCode(int hd_no, int *ret_code, int msg_type)
{
    int msgid;
    struct hd_msg_st r_msg;
    //long int msg_to_receive = 0; //- 0: read first message in this queue

    msgid = msgget((key_t)(SEMAPHORE_KEY+hd_no), 0666 | IPC_CREAT);

    if (msgid == -1) {
       #ifdef DEBUG
         printf("msgget(%d) failed error=%d\n",hd_no, errno);
       #endif
       return HD_CALL_MSGQUEUE_FUNC_FAIL;
    }


    if (msgrcv(msgid, (void *)&r_msg, MAX_MSG_LEN,
                   msg_type, IPC_NOWAIT) == -1) {
      if(errno==EAGAIN || errno==ENOMSG) {
         #ifdef DEBUG
          printf("msgrcv() fail, errno=%d, HD_MSG_EMPTY=%d \n", errno, HD_MSG_EMPTY);
         #endif
         return HD_MSG_EMPTY;
      }
       else {
         #ifdef DEBUG
           printf("msgrcv(%d) failed error=%d\n",hd_no, errno);
         #endif
         return HD_CALL_MSGQUEUE_FUNC_FAIL;
       }
    }

    //---- put result code
    *ret_code = r_msg.result_code;


    return PL_OK;

}



//----------------------------------------------------------------------------
// Delete a specified message queue which used by Send_ResultCode &
// Receive_ResultCode
//-----------------------------------------------------------------------------
int Del_MsgQueue(int hd_no)
{
    int msgid;


    msgid = msgget((key_t)(SEMAPHORE_KEY+hd_no), 0666 | IPC_CREAT);

    if (msgid == -1) {
       #ifdef DEBUG
         printf("msgget(%d) failed error=%d\n",hd_no, errno);
       #endif
       return HD_CALL_MSGQUEUE_FUNC_FAIL;
    }

    if (msgctl(msgid, IPC_RMID, 0) == -1) {
       #ifdef DEBUG
         printf( "msgctl(IPC_RMID) failed\n");
       #endif
       return HD_CALL_MSGQUEUE_FUNC_FAIL;
    }

    return PL_OK;

}
//==========================================================================
// Purpose: It will get the hidden conf file MAC address or Location
// I/P:  GET_MAC_ADDRESS --> to get it MAC address string
//       GET_HD_NAME     --> to get its location hd name
// O/P:  result = xx:xx:xx:xx:xx:xx  or "HDA", "HDB" 
// return: PL_OK           --> Successful
//         PL_FILE_NOEXIST --> the conf file not exist
//         PL_NOT_FOUND    --> Not found the field in the Hidden Conf File 
//         PL_LESS_MEM     --> You pass in result is too small
//===========================================================================
int Get_Hidden_Conf_File_Content(int hd_no, int target, char *result, int result_size)
{
  char  file_name[31], buff[256], target_str[51];
  int   i, ret;

  Get_Hidden_Conf_File_Name(hd_no, file_name);
  if ( access(file_name, F_OK) !=0 )   return PL_FILE_NOEXIST;

  //- Lock File
  if ( (ret=RW_Lock(LOCK_DISK, LOCK_READ)) !=PL_OK)  return ret;
  if ( target==GET_MAC_ADDRESS) {
    if ( find_conf(file_name,NULL,'=',1,CONF_FILE_HW_ADDR_FIELD,buff,sizeof(buff) ) <=0 ) {
      RW_Unlock(LOCK_DISK);
      return PL_NOT_FOUND;
    }
    else { // find it
      get_field_value(buff, strlen(buff), '=', 2, target_str, sizeof(target_str));
      if ( result_size < (strlen(target_str)+1) ) {
         RW_Unlock(LOCK_DISK);
         return PL_LESS_MEM;
      }
      strcpy(result, target_str);
      RW_Unlock(LOCK_DISK);
      return PL_OK;
    }
  }
  else {  //- Get HD Name
    if ( find_conf(file_name,NULL,'=',1,CONF_FILE_HD_NAME_FIELD,buff,sizeof(buff) ) <=0 ) {
      RW_Unlock(LOCK_DISK);
      return PL_NOT_FOUND;
    }
    else { // find it
      get_field_value(buff, strlen(buff), '=', 2, target_str, sizeof(target_str));
      i = Get_HD_Integer(target_str);
      if ( i<HDA)   return PL_NOT_FOUND;

      if ( Get_HD_String(i, target_str) !=PL_OK)   return PL_NOT_FOUND;

      if ( result_size < (strlen(target_str)+1) ) {
         RW_Unlock(LOCK_DISK);
         return PL_LESS_MEM;
      }
      strcpy(result, target_str);
      RW_Unlock(LOCK_DISK);
      return PL_OK;
    }
  }

}
//-----------------------------------------------------------------------------
// It will parser raidtab file & pick out its data HD & spare HD to generate
// its web string name like as Mirror: HDA HDB
// Currently it function is same as Get_Configured_HD_String()
// Maybe the Get_Configured_HD_String() will call it in the furture
// Mar 15 2001: It hasn't check the pass in hd_no, just pick first Raid Device
// So fix its bug
//----------------------------------------------------------------------------
int Get_RaidDev_Web_String(int hd_no, char *web_str, int web_str_len)
{
  int    i, j, ret, rd_no, find_flag = FALSE;
  struct raid_device *rd1;
  char   buff[256], tmp_str[51];

  /*========= Check Valid RAID HD Start =============*/
  rd_no = Get_RaidDev_No();

  if ( rd_no <=0 )  return PL_NOT_FOUND;

  rd1 = calloc(rd_no,sizeof(struct raid_device));
  ret = Get_All_RaidDev_Conf(rd1, rd_no);

  for (i=0; i<rd_no; i++) {
          if ( hd_no != Get_HD_Integer((rd1+i)->name) )   continue;
          find_flag = TRUE;
          
      if ( strncasecmp((rd1+i)->raid_level,"linear",7)==0) 
//           strcpy(buff,"Linear: ");
           strcpy(buff,"Spanning Disks: ");
      else if ( strncasecmp((rd1+i)->raid_level,"0",1)==0) 
//           strcpy(buff,"Stripe: ");
           strcpy(buff,"Striping Disks: ");
      else if ( strncasecmp((rd1+i)->raid_level,"1",1)==0) 
//           strcpy(buff,"Mirror: "); 
           strcpy(buff,"Mirroring Disks: "); 
      else if ( strncasecmp((rd1+i)->raid_level,"5",1)==0) 
//           strcpy(buff,"Raid 5: ");
           strcpy(buff,"RAID 5 Disks: ");
      else { 
           free(rd1);
           return PL_NOT_FOUND;
      }          
       
      // append data disks 
      for(j=0; j<(rd1+i)->data_hd_no; j++) {
//         Get_HD_String( (rd1+i)->data_hd[j], tmp_str);
//         strcat(buff,tmp_str);
//         strcat(buff," ");
         if (j == 0) 
         	sprintf(tmp_str, "Drive %d", ((rd1+i)->data_hd[j] - HDA) + 1);
         else
         	sprintf(tmp_str, ", %d", ((rd1+i)->data_hd[j] - HDA) + 1);
         strcat(buff, tmp_str);
      }

      // append spare disks
      for(j=0; j<(rd1+i)->spare_hd_no; j++) {
//         Get_HD_String( (rd1+i)->spare_hd[j], tmp_str);
//         strcat(buff,tmp_str);
//         strcat(buff," ");
       	 sprintf(tmp_str, ", [%d]", ((rd1+i)->spare_hd[j] - HDA) + 1);
         strcat(buff, tmp_str);
      }
  }// end of for(i=0...)
  
  free(rd1);

  if ( find_flag) {
        //- add 1 is the NULL String char.
        if ( (strlen(buff)+1) > web_str_len)   return PL_LESS_MEM;
        strcpy(web_str, buff);
        return PL_OK;
  }
  else   return PL_NOT_FOUND;

}

//--------------------------------------------------------
//
//--------------------------------------------------------
int Clear_MBR(int hd_no)
{
  int  fd, ret;
  char hd_name[21], buff[SECTOR_SIZE];

  if ( (ret=Get_HD_DevName(hd_no, hd_name)) != PL_OK )  return ret;
  fd = open(hd_name, O_RDWR);
  if (fd==-1) {
    #ifdef DEBUG
      printf("Open %s fail \n", hd_name);
    #endif
    return PL_OPEN_FILE;
  }

  //---- Clear buff to zero
  memset(buff, 0, sizeof(buff));
  ret = write(fd, buff, sizeof(buff));
  if ( ret == -1) {
    #ifdef DEBUG
     printf(" Write data to hd fail \n");
    #endif
    return PL_WRITE_FILE;
  }

  close (fd);
  sync();

  return PL_OK;
}

/*-----------------------------------------------------------------*/
/*- Get HD Swap File Name                                         -*/
/*- The Swap file name which like as /mnt/HDA_ROOT/swap_file      -*/
/*- Return PL_OK:  Get Successful                                 -*/
/*-       PL_LESS_MEM: Less memory                                -*/
/*-        Other     : Error                                      -*/
/*-----------------------------------------------------------------*/
/********************************************
int Get_HD_Swap_File_Name(int hd_no, char *o_str, int size)
{
  char mp[31],buff[81];
  int  ret;

  ret = Get_MP_String(hd_no, mp, ROOT_PART);
  if ( ret != PL_OK)  return ret;

  sprintf(buff, "%s/%s",mp,SWAPFILE_NAME);
  if ( strlen(buff) > size)  return PL_LESS_MEM;

  strcpy(o_str, buff);
  return PL_OK;

}
************************/
/*-----------------------------------------------------------------*/
/*- Initial on one specified swap file                            -*/
/*- The Swap file name which like as /mnt/HDA_ROOT/swap_file      -*/
/*- It will read uLinux.conf [Swap] Enable = True / False field   -*/
/*-  Its  default value is True if you haven't assigned           -*/
/*- If it is FALSE issue swapoff the swap file if it exist & then -*/
/*-  return PL_OK                                                 -*/
/*- Return PL_OK:  Successful                                     -*/
/*-        PL_FAIL: Fail                                          -*/
/*- Swapoff will get errno=EINVAL if the swap file not active     -*/
/*- Swapon will get errno=EBUSY if the swap file already active   -*/
/*- Even the [Swap] Enable=False, you still need do initial action-*/
/*- There will for forture its value changed to True that will    -*/
/*- result in its swap function work normally                     -*/
/*- May 15 2001: The swap area have been changed from one file to -*/
/*-              the swap partition                               -*/
/*- June 26 2001: If the [Storage] "Use Flash Disk" = True, don't -*/
/*- need the swap area, so just reture SUCCESS                    -*/
/*-----------------------------------------------------------------*/
int Initial_Swapping(int hd_no)
{
  char swap_part[31], cmd_line[255];
  int  ret;

  if ( Use_Flash_Disk() )   // Just return OK
    return PL_OK;

  ret=Get_Partition_Name(hd_no, swap_part, SWAP_PART );
  if ( ret != PL_OK) {
    return ret;
  }

  
  /***********  
  // Mkswap doesn't need to judge its enable swap field value in uLinux.conf. 
  if ( ReadCFGData(DS_CONF_FILE, SWAP_SESSION_NAME, SWAP_ENABLE_FIELD_NAME, value, sizeof(value))==SUCCESS) {
    if (strncasecmp(value,"TRUE",4) !=0) { // False
      if ( access(swap_file, F_OK)==0) { //swap file exist
	swapoff(swap_file);   // maybe hasn't swapon it so will get error
      } 
      //return PL_OK;  // even its value is false still do initial action
    }
  }
    ************/
  
  /*************
  //- Enable=TRUE or FALSE,  Initial the swap file
  //- First if the swap file exist, swapoff it first
  if ( access(swap_file, F_OK)==0) { //swap file exist
     swapoff(swap_file);   // maybe hasn't swapon it so will get errorno=EINVAL
  }
  *********/

  //- First check the swap part is active, if it's first swapoff it
  if (find_conf(SWAPON_FILE,NULL,SPACE,1,swap_part,cmd_line,
	sizeof(cmd_line)) >0) { //find it's swapon already, swapoff it first
     Stop_Swapping(hd_no);
      
  }
  else {
    if (find_conf(SWAPON_FILE,NULL,TAB,1,swap_part,cmd_line,
	 sizeof(cmd_line)) >0)// find it's swapon already, swapoff it first 
      Stop_Swapping(hd_no);
  }


  //- Initial the swap file use by mkswap command
  //sprintf(cmd_line, "/bin/dd if=/dev/zero of=%s bs=1k count=64000", swap_file);
  //system(cmd_line);
  sprintf(cmd_line, "/sbin/mkswap %s", swap_part);
  system(cmd_line);

  return PL_OK;
}

/*-----------------------------------------------------------------*/
/*- Swap on one specified swap file                               -*/
/*- The Swap file name which like as /mnt/HDA_ROOT/swap_file      -*/
/*- It will read uLinux.conf [Swap] Enable = True / False         -*/
/*-   default is True                                             -*/
/*- If it is FALSE issue swapoff the swap file if it exist & then -*/
/*-  return PL_OK                                                 -*/
/*- Return PL_OK:  Successful                                     -*/
/*-        PL_FAIL: Fail                                          -*/
/*- Swapoff will get errno=EINVAL if the swap file not active     -*/
/*- Swapon will get errno=EBUSY if the swap file already active   -*/
/*- May 15 2001: change the swap file to a swap partition         -*/
/*- June 26 2001: If the [Storage] "Use Flash Disk" = True, don't -*/
/*- need the swap area, so just reture SUCCESS                    -*/
/*-----------------------------------------------------------------*/
int Start_Swapping(int hd_no)
{
  char swap_part[31], value[21], cmd_line[255];
  int  ret;


  if ( Use_Flash_Disk() )   // Just return OK
    return PL_OK;

  ret=Get_Partition_Name(hd_no, swap_part, SWAP_PART );
  if ( ret != PL_OK) {
    return ret;
  }

  //- First check the swap part is active, if it's first swapoff it
  if (find_conf(SWAPON_FILE,NULL,SPACE,1,swap_part,cmd_line,
	sizeof(cmd_line)) >0) { //find it's swapon already, swapoff it first
    Stop_Swapping(hd_no);
  }
  else {
    if (find_conf(SWAPON_FILE,NULL,TAB,1,swap_part,cmd_line,
	 sizeof(cmd_line)) >0)// find it's swapon already, swapoff it first 
      Stop_Swapping(hd_no);
  }


  //- If the [Swap] Enable==false, just return Success
  if ( ReadCFGData(DS_CONF_FILE, SWAP_SESSION_NAME, SWAP_ENABLE_FIELD_NAME, value, sizeof(value))==SUCCESS) {
    if (strncasecmp(value,"TRUE",4) !=0)  return PL_OK;   
  }
  
  //- Enable=TRUE, enable Swap Function

  //- swapon it
  if ( swapon(swap_part,0)==-1)  return PL_FAIL;  // has error
  
  return PL_OK;
}

/*-----------------------------------------------------------------*/
/*- Swap off one specified swap file                              -*/
/*- The Swap file name which like as /mnt/HDA_ROOT/swap_file      -*/
/*- It will read the /proc/swaps to judge which swap file has     -*/
/*- on already                                                    -*/
/*-   default is True                                             -*/
/*- Return PL_OK:  Successful                                     -*/
/*-        PL_FAIL: Fail                                          -*/
/*- May 15 2001: change the swap file to a swap partition         -*/
/*- June 26 2001: If the [Storage] "Use Flash Disk" = True, don't -*/
/*- need the swap area, so just reture SUCCESS                    -*/
/*-----------------------------------------------------------------*/
int Stop_Swapping(int hd_no)
{
  char swap_part[31], line[256];
  int  ret;

  if ( Use_Flash_Disk() )   // Just return OK
    return PL_OK;

  ret=Get_Partition_Name(hd_no, swap_part, SWAP_PART );
  if ( ret != PL_OK) {
    return ret;
  }

  if (find_conf(SWAPON_FILE,NULL,SPACE,1,swap_part,line,sizeof(line))<=0) {
    if (find_conf(SWAPON_FILE,NULL,TAB,1,swap_part,line,sizeof(line))<=0) 
      printf("Not Find it is swapon \n");
      return PL_OK;  // not found it
  }
  // find it
  if ( swapoff(swap_part)==-1)  return PL_FAIL;  // has error

  return PL_OK;
}


//---------------------------------------------------------------------
// Check the pid is active or not
// It will scan the proc directory try to find out the pid is in it
// return PID_ACTIVE:   It is active
//        PID_DIE   : It is non-active
//        Others    : Error
//---------------------------------------------------------------------
int Pid_Active(int pid)
{
  struct dirent **namelist;
  int  n;
  char buff[41];

  
  sprintf(buff,"%d",pid);

  n = scandir("/proc", &namelist, 0, alphasort);
  if ( n<0 )
    return PL_FAIL;
  else {
    while(n--) {
      if ( strcasecmp(namelist[n]->d_name, buff)==0)  return PID_ACTIVE;
      //printf("%s  ", namelist[n]->d_name);
    }
    return PID_DIE;
  }
} 

//-----------------------------------------------------------------------------
// It will parser uLinux.conf [Storage] Drive 1 ...... n
// The n=max physical hd it has, now its value is = 4
// its web string will like as "Drive 1"
// May 16 2001 Created
//----------------------------------------------------------------------------
int Get_Physical_HD_Web_String(int hd_no, char *web_str, int web_str_len)
{
  int    i, ret;
  char   buff[81],value[21], hd_name[21];


  if ( (ret=Get_HD_DevName(hd_no, hd_name)) != PL_OK)  return ret;
  //== hd_name = /dev/hdx


  if ( (ret=RW_Lock(LOCK_DISK, LOCK_READ)) !=PL_OK)  return ret;
  for (i=1; i<= MAX_HD_NO; i++) {
      sprintf(buff,"Drive %d",i);
      if ( ReadCFGData(DS_CONF_FILE, STORAGE_SESSION_NAME, buff,value,
			 sizeof(value))==SUCCESS) { // value=hdx
	  if ( strstr(hd_name, value) !=NULL) {  // find it
	     RW_Unlock(LOCK_DISK);
	     if ( strlen(buff) > web_str_len) return PL_LESS_MEM;
	     else { 
	       strcpy(web_str, buff);
	       return PL_OK;
	     }
	     
	  }
      }
      //else   break;   //== don't need process next hd again
  } // end of for(i=1....)
  RW_Unlock(LOCK_DISK);
  // not found in the uLinux.conf, use default value
 
  for (i=0; i< MAX_HD_NO; i++) {
    if ( strstr(hd_name, HD_DevName_STR[i]) !=NULL ) { // find it
      sprintf(value, "Drive %d", i+1);
      if ( strlen(value) > web_str_len)  return PL_LESS_MEM;
      else {
	strcpy(web_str, value);
	return PL_OK;
      }
    }
  }
 
  return  PL_FAIL;
}

//=================================================================
// May 23 2001 created
// It will read the [Storage] "Flash Disk=xx" field value
// if its value=True, it use flash disk as data disk (model 168..)
// otherwise it use real disks
// Return  TRUE or FALSE
//         Others  Function Fail
//==================================================================
int Use_Flash_Disk(void)
{
  char  buff[21];

  if ( ReadCFGData(DS_CONF_FILE, STORAGE_SESSION_NAME, FLASH_DISK_FIELD_NAME, buff, sizeof(buff))==PL_OK) {
       if ( strcasecmp(buff, "TRUE") ==0 ) return TRUE;
  }


  // if read fail use_flash_disk value is still false
  return FALSE;

}

//================================================
// return TRUE: The path is exist
//        FALSE: It's not exist
//================================================
BOOL Is_Disk_Path_Ready( char *real_path)
{
  int  j;
  char mp[31], 
  
  ret = Is_Existing_Directory(real_path);
  if ( ret == FALSE )  return FALSE;  // path not exist

  //== Real Path is exist !, Check It's belong our share folder Mount Point
  //== and the Mount Point has been mounted
  for (j=0; j<MAX_RHD_NO; j++) {
    if ( Get_MP_String(j+HDA, mp, DATA_PART) !=PL_OK)  continue;
    if ( strncmp(mp, real_path, strlen(mp))==0 ) { // equal
      if ( Is_Mounted(j+HDA, DATA_PART) !=PART_MOUNTED) return FALSE;
      else  return TRUE;
    } 
  } // end of for(j=...)
  
  //= The real_path not belong any shared Folder Mount Point
  return TRUE;
}

//=======================================================
// May 31 2001 Created
// I/P: hd_name like as /dev/hde 
// mt_data_part: 1 mount the data part, 0: not mounted
//=======================================================
int init_disk(char *hd_name, int mt_data_part)
{
  char root_part_name[31], data_part_name[31];
  char root_mp_name[31], data_mp_name[31];
  int  ret = 0, hd_no;
	
  //-- Get HD Integer
  if ( (hd_no=Get_HD_Integer(hd_name)) == PL_NOT_FOUND) {
    #ifdef DEBUG
      fprintf(stderr, "Get_HD_Integer(%s), cannot find it \n", hd_name);
    #endif
    return PL_FAIL;
  }
  
  //- Get ROOT PART Name
  if ( (ret=Get_Partition_Name(hd_no, root_part_name,
				 ROOT_PART)) != PL_OK) {
     #ifdef DEBUG
        fprintf(stderr, "Get_Partition_Name(%d, ROOT_PART) fail,
                                 ret=%d \n", hd_no, ret);
     #endif
     return (ret);
  }

  //- Get DATA PART Name
  if ( (ret=Get_Partition_Name(hd_no, data_part_name, DATA_PART)) != PL_OK) {
     #ifdef DEBUG
    fprintf(stderr, "Get_Partition_Name(%d, DATA_PART) fail, ret=%d \n", hd_no, ret);
    #endif
    return (ret);
  }

  //- Get ROOT MP Name
  if ( (ret=Get_MP_String(hd_no, root_mp_name, ROOT_PART)) != PL_OK) {
     #ifdef DEBUG
       fprintf(stderr, "Get_MP_String(%d, ROOT_PART) fail,
                    ret=%d \n", hd_no, ret);
     #endif
     return (ret);
  }

  //- Get DATA MP Name
  if ( (ret=Get_MP_String(hd_no, data_mp_name, DATA_PART)) != PL_OK) {
    #ifdef DEBUG
    fprintf(stderr, "Get_MP_String(%d, DATA_PART) fail, ret=%d \n", hd_no, ret);
    #endif
    return (ret);
  }
  
  //- swap off swap file First
  if ( (ret=Stop_Swapping(hd_no)) !=PL_OK)  return ret;
    
  //- Check the ROOT Part is mounted?, if yes umount it first
  if ( Is_Mounted(hd_no, ROOT_PART) == PART_MOUNTED ) {//
    if ( (ret=Umount_Partition(root_part_name)) != PL_OK) {
       #ifdef DEBUG
	fprintf(stderr, "Umount_Partition(%s) fail,
                      ret=%d \n", root_part_name, ret);
       #endif
       return (ret);
    }
  }

  
  //- Check the DATA Part is mounted?, if yes umount it first
  if ( Is_Mounted(hd_no, DATA_PART) == PART_MOUNTED ) {//
    if ( (ret=Umount_Partition(data_part_name)) != PL_OK) {
      #ifdef DEBUG
      fprintf(stderr, "Umount_Partition(%s) fail,
                          ret=%d \n", data_part_name, ret);
      #endif
      return (ret);
    }
  }
                   
  //---  Delete All Partitions  ---
  if ( (ret=Delete_All_Partition(hd_name)) !=PL_OK) {
    #ifdef DEBUG
    fprintf(stderr, "Delete_All_Partition(%s) fail, ret=%d \n", hd_name, ret);
    #endif
    return (ret);
  }      

  if ( (ret=Clear_MBR(hd_no)) !=PL_OK) {
    #ifdef DEBUG
    fprintf(stderr, "Clear_MBR(%d) fail, ret=%d \n", hd_no, ret);
    #endif
    return (ret);
  }
                   
  //---  Create MAX Partition  ---
  if ( (ret=Create_Max_Partition(hd_name)) !=PL_OK) {
    #ifdef DEBUG
    fprintf(stderr, "Create_Max_Partition(%s) fail, ret=%d \n", hd_name, ret);
    #endif
    return (ret);
  }  
    
  //--- Format ROOT Partition ---
  if ( (ret=Format_Partition(root_part_name, HD_NONRAID5)) != PL_OK) {
     #ifdef DEBUG
      fprintf(stderr, "Format_Partition(%s) fail, 
                     ret=%d \n", root_part_name, ret);
     #endif
     return (ret);
  }

  
  // Format data partition
  if ( (ret=Format_Partition(data_part_name, HD_NONRAID5)) != PL_OK) {
    #ifdef DEBUG
    fprintf(stderr, "Format_Partition(%s) fail, ret=%d \n", data_part_name, ret);
    #endif
    return (ret);
  }
  
  //--- Mount ROOT Part ---
  //- check this partition has clear ?, before mount it
  //sprintf(cmd_line,"/sbin/fsck -T -a -C %s",part_name);
  //system(cmd_line);
  
  if ( (ret=Mount_Partition(root_part_name, root_mp_name)) != PL_OK) {
     #ifdef DEBUG
      fprintf(stderr, "Mount_Partition(%s, %s) fail,
                     ret=%d \n", root_part_name, root_mp_name, ret);
     #endif
     return (ret);
  }

  //--- Create Hidden Conf File ---
  if ( (ret=Create_Hidden_Conf_File(hd_no)) !=PL_OK) {
     #ifdef DEBUG
       fprintf(stderr, "Create_Hidden_Conf_File(%d) fail,
                     ret=%d \n", hd_no, ret);
     #endif
     return (ret);
  }

  //--- Initial Start swap file
  Initial_Swapping(hd_no);
  Start_Swapping(hd_no);
  
  //--- Mount DATA Part -----
  if ( mt_data_part) {
    if ( (ret=Mount_Partition(data_part_name, data_mp_name)) != PL_OK) {
       #ifdef DEBUG
       fprintf(stderr, "Mount_Partition(%s, %s) fail, ret=%d \n", data_part_name,
	    data_mp_name, ret);
       #endif
       return (ret);
    }

    //-- Set Status to READY
    if ( (ret=Set_HD_Status(hd_no, HD_READY)) !=PL_OK) {
       #ifdef DEBUG
       fprintf(stderr, "Set_HD_Status(%d) fail, ret=%d \n", hd_no, ret);
       #endif
       return (ret);
    }
  }
	
  return PL_OK;
}


//=============================================================================
// It will parser the /proc/mdstat file each line which first two character
// is md, otherwise I will discard it
// Return >= 0 : numbers it has found 
//        
//=============================================================================
int Get_Current_Active_RaidDev(int *hd_no_ptr, int hd_no_ptr_cnt)
{

  FILE *fp;
  char line[256], value[21], hd_name[21];
  int  i, hd_cnt = 0;   // record the hd it found

  fp = fopen (RAID_MDSTAT_FILE,"r");
  if ( fp == NULL) {
     #ifdef DEBUG
       fprintf(stderr,"Open %s fail \n", RAID_MDSTAT_FILE);
     #endif
     return PL_OPEN_FILE;
  }

  //===== Read the file unless EOF or Error ==========
  while ( fgets(line, sizeof(line), fp) != NULL ) {
        if ( strncasecmp(line,"md",2)==0) {  // find the md device
           if(get_field_value(line,strlen(line),SPACE,1,value,sizeof(value))
	                               != PL_OK) { // not found
	     if(get_field_value(line,strlen(line),TAB,1,value,sizeof(value))
		                       != PL_OK) { // not found 
	       continue;
	     }
	     else { // find it
	       for(i=MD0; i<MD9; i++) {
		 Get_HD_String(i, hd_name);
		 if ( strncasecmp(value, hd_name, strlen(hd_name))==0) {
                    if ( hd_no_ptr_cnt <= hd_cnt) { // mem too small
		      fclose(fp);
		      return PL_LESS_MEM;
		    }
                    *(hd_no_ptr + hd_cnt) = i;
		    hd_cnt++;
		    break;
		 }
	       }// end of for (i=MD0..)
	     }	
	   } 
           else { // find it
	     for(i=MD0; i<MD9; i++) {
		 Get_HD_String(i, hd_name);
		 if ( strncasecmp(value, hd_name, strlen(hd_name))==0) {
		    if ( hd_no_ptr_cnt <= hd_cnt) { // mem too small
		      fclose(fp);
		      return PL_LESS_MEM;
		    }
                    *(hd_no_ptr + hd_cnt) = i;
		    hd_cnt++;
		    break;
		 }
	       }// end of for (i=MD0..)
	   }
        }// end of if ( strncasecmp(line,"md",2)==0)
  }// end of while(..
	   
  fclose(fp);
  return hd_cnt;
}



