#include <stdio.h>
#include <errno.h>
#include "../public_lib/public_lib.h"
#include "soft-raid.h"

#define	ReadCFGData	Conf_Get_Field
#define	WriteCFGData	Conf_Set_Field

extern int errno;

main(int argc, char** argv[] )
{
  struct disk_info hda;
  struct partition_info parta;
  struct raid_device *rd1, rd2;
  struct raid_status rds;
  int ret,i,pid;
  char value[31], buff[100];
  struct configured_hd all_hd[12];
  int hd_no[9];


  //=== Get_Current_Raid_Status() ====
  strcpy(rds.name,"/dev/md0");
  ret = Get_Current_Raid_Status(&rds);
  if ( ret==PL_OK) {
    printf("Config_hd_no=%d, Active_hd_no=%d \n", rds.config_hd_no, rds.active_hd_no);

    for (i=0; i<rds.config_hd_no; i++)
      printf("Config_HD[%d]=%d \n",i, rds.config_hd[i]);

    for (i=0; i<rds.active_hd_no; i++)
      printf("Active_HD[%d]=%d \n",i, rds.active_hd[i]);

    printf("sync=%d \n", rds.resync);
  }
  else 
    printf("ret=%d \n",ret);

  exit (0);
  
  //=== Test Create_Hidden_Conf_File()  ====
  ret = Create_Hidden_Conf_File(HDA);
  printf("Create_Hidden_Conf_File(), ret=%d \n", ret);

  exit (0);

  //=== Test get_field_value() ===
  strcpy(buff,"hw_addr = 00:01:02:03:04:05:06");
  ret=get_field_value(buff, strlen(buff),'=',2,value,sizeof(value));
  if (ret == PL_OK) {
    Skip_Front_SPACE_TAB(value);
    printf("value=%s \n", value);
  }
  else
    printf("get_field_value(), ret=%d \n", ret);

  exit(0);

  //=== Test Skip_Front_SPACE_TAB() ===
  strcpy(value, " pig");
  Skip_Front_SPACE_TAB(value);
  printf("value=%s \n", value);

  exit (0);

  //=== Test Check_HD_Valid() ===
  ret = Check_HD_Valid(HDA,CHECK_BOTH);
  printf(" Check_HD_Valid(), ret=%d \n", ret);


  exit (0);
  //=== Test Create Raid Device ====
  strcpy(rd2.name, "/dev/md3");
  strcpy(rd2.raid_level, "1");
  rd2.data_hd_no = 2;
  rd2.spare_hd_no = 0;
  rd2.data_hd[0] = HDA;
  rd2.data_hd[1] = HDB;  
  
  ret=Create_RaidDev(&rd2);
  
  printf("After Create_RaidDev(), ret=%d \n", ret);

  exit(0);
    
  //=== Test Get_Current_Active_RaidDev() ======
  ret = Get_Current_Active_RaidDev(&hd_no,9);
  if ( ret > 0 ){
    for(i=0; i<ret; i++)
      printf("MD%d=%d \n",i, hd_no[i]);
  }
  else 
    printf("Get_Current_Active_RaidDev() fail, ret=%d \n", ret);


  exit (0);
  //=== Test Get_Current_Raid_Status() =====
  strcpy(rds.name,"/dev/md0");

  ret=Get_Current_Raid_Status(&rds);
  if (ret == PL_OK) {
    printf("Successful, resync=%d \n", rds.resync);
  }
  else printf("ret=%d, errno=%d \n", ret, errno);
  exit (0);
  //=== Test Is_Disk_Path_Ready ====
  if ( argc != 2) {
    printf("Usage main path_name \n");
    exit (-1);
  }
  ret = Is_Disk_Path_Ready(argv[1]);
  if ( ret==TRUE)
    printf("Path=%s exist ! \n", argv[1]);
  else
    printf("Path=%s not exist ! \n", argv[1]);

  exit(0);

  //=== Test Get_Physical_HD_Web_String() ======
  ret = Get_Physical_HD_Web_String(HDD, value, sizeof(value) );
  if ( ret != PL_OK) {
    printf(" Fail, ret=%d \n",ret);
    exit (-1);
  }
  
  printf("value=%s \n", value);
  goto PRG_END;

  //======== Create_Max_Partition =========
  Delete_All_Partition("/dev/hdc");
  Create_Max_Partition("/dev/hdc");
  goto PRG_END;

  //======== Lock HD =======
  Lock_HD(MD0);
  printf("MD0 already been locked...\n");
  printf("Press enter key to unlock it.. \n");
  getchar();
  Unlock_HD(MD0);

  goto PRG_END;

  //======== Test Get_First_Avail_RaidName()   =======
  ret = Get_First_Available_RaidName(&i);
  if ( ret==PL_OK)
    printf(" Get_First_Available_RaidName(), hd_no=%d \n", i);
  else
    printf("Get_First_Available_RaidName() fail, ret=%d \n",ret);

  goto PRG_END;

  //======== Test Pid_Active =============
  i = 5956;
  ret = Pid_Active(i);
  printf("Pid_Active(), ret=%d \n", ret);
  
  Put_Child_Pid(HDA, 1212);
  
  Get_Child_Pid(HDA, &pid);

  printf("Get Pid=%d \n", pid);
  //goto PRG_END;

 PRG_END:
  exit (0);

}
