#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include "sem.h"

//#include "semun.h"
union semun {
	int val;
	struct semid_ds	*buf;
	unsigned short int *array;
	struct seminfo *__buf;
};

static  int sem_id;

int creat_sem(void)
{
	if((sem_id = semget((key_t)3210, 1, 0666|IPC_CREAT)) < 0)
		return 0;
	return 1;
}


int set_semvalue(void)
{
	union semun sem_union;

	sem_union.val = 1;
	if(semctl(sem_id, 0, SETVAL, sem_union) == -1) return 0;
	return 1;
}

void del_semvalue(void)
{
	union semun sem_union;
	if(semctl(sem_id, 0, IPC_RMID, sem_union) == -1)
		fprintf(stderr, "Failed to delete semaphore\n");
}

int semaphore_p(void)
{
	struct sembuf sem_b;

	sem_b.sem_num = 0;
	sem_b.sem_op = -1;
	sem_b.sem_flg = SEM_UNDO;
	if(semop(sem_id, &sem_b, 1) == -1) {
		return 0;
	}
	return 1;
}

int semaphore_v(void)
{
	struct sembuf sem_b;

	sem_b.sem_num = 0;
	sem_b.sem_op = 1;
	sem_b.sem_flg = SEM_UNDO;
	if(semop(sem_id, &sem_b, 1) == -1) {
		return 0;
	}
	return 1;
}
