//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		hardware.c
//
//	Abstract: 
//		Provide hardware related library.
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		05/29/2001	Ethan Wang -- Created
//
//**************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#include "config.h"
#include "Util.h"

#include "msg.h"
#include "sysmgrd.h"
#include "hwmon.h"
#include "w83977fa.h"

int Get_Network_Connection_Status(NETWORKDEV *ethdev)
{
	int		fd, status;

	if ( (fd=open(HWMON_DEV, O_RDWR)) < 0 )
		return fd;

	if ( (status=ioctl(fd, IOCTL_HWMON_GET_ETHERNET_STATUS, &ethdev)) < 0 )
	{
		close(fd);
		return status;
	}

	close(fd);

	return status;
}

int Get_CPU_Info(CPUINFO *cpuinfo)
{
	int		fd, status;

	if ( (fd=open(HWMON_DEV, O_RDWR)) < 0 )
		return fd;

	if ( (status=ioctl(fd, IOCTL_HWMON_GET_CPU_INFO, cpuinfo)) < 0 )
	{
		close(fd);
		return status;
	}

	close(fd);

	return status;
}

int Enable_WOL(BOOL enable)
{
	int	fd, status;
	unsigned char	pson_event;

	if ( (fd=open(HWMON_DEV, O_RDWR)) < 0 )
		return fd;

	if ( (status=ioctl(fd, IOCTL_HWMON_GET_WAKE_UP_EVENT, &pson_event)) < 0 )
	{
		close(fd);
		return status;
	}

	if ( enable )
	{
		pson_event |= PSON_PHRI;
	}
	else
	{
		pson_event &= ~PSON_PHRI;
	}

	status = ioctl(fd, IOCTL_HWMON_SET_WAKE_UP_EVENT, &pson_event);

	close(fd);
	return status;
}

int Get_HD_Power_Saving_Mode(HDPOWERSTATUS *hdpwr)
{
	int		fd, status;

	if ( (fd=open(HWMON_DEV, O_RDWR)) < 0 )
		return fd;

	if ( (status=ioctl(fd, IOCTL_HWMON_GET_HD_POWER_STATUS, hdpwr)) < 0 )
	{
		close(fd);
		return status;
	}

	close(fd);

	return status;
}

int Set_Hardware_Error(int type, int set, int parm, char *str_parm)
{
	int	status;

	status = 0;
	switch ( type )
	{
	case HWERR_NO_DISKS:
		status = SendMessage(LCD_DAEMON_PROGRAM_NAME, MSG_SYSMGR, SYSMGR_NO_DISKS, parm);
		break;
	case HWERR_DISK_FULL:
		status = ( set ) ?
			SendMessageEx(LCD_DAEMON_PROGRAM_NAME, MSG_SYSMGR, SYSMGR_DISK_FULL, parm, str_parm) :
			SendMessageEx(LCD_DAEMON_PROGRAM_NAME, MSG_SYSMGR, SYSMGR_DISK_NOT_FULL, parm, str_parm);
		break;
	}

	return status;
}
