#include <eventlog.h>
#include <storage.h>
#include <config.h>

void Storage_Write_Log(VOLUME_CONF vol_data, int type, void *arg){

        char vol_msg[512], msg[512], all_msg[1024];
        int event_type;

	char model[64];

	Get_Model_Name(model,sizeof(model));
	
	if(!strcmp(model, "TS-201")){
        	strcpy(vol_msg, Get_Volume_Message(vol_data));
	}
	else{
		strcpy(vol_msg, "[SATA Disk]");
	}

        switch(type){
        case START_FORMAT:
                strcpy(msg,"Start formatting.");
                event_type = EVENTLOG_INFORMATION_TYPE;
                break;
        case FORMAT_COMPLETE:
                strcpy(msg,"Formatting completed.");
                event_type = EVENTLOG_INFORMATION_TYPE;
                break;
        case FORMAT_UNKNOWN_FAIL:
                strcpy(msg,"Formatting failed(Cannot unmount disk).");
                event_type = EVENTLOG_ERROR_TYPE;
                break;
	case FORMAT_FAIL:
		strcpy(msg,"Formatting failed.");
		event_type = EVENTLOG_ERROR_TYPE;
		break;
        case STOP_FORMAT:
                strcpy(msg,"User stop formatting.");
                event_type = EVENTLOG_WARNING_TYPE;
                break;
        case START_INIT:
                strcpy(msg,"Start initialization.");
                event_type = EVENTLOG_INFORMATION_TYPE;
                break;
        case INIT_COMPLETE:
                strcpy(msg,"Initialization completed.");
                event_type = EVENTLOG_INFORMATION_TYPE;
                break;
        case INIT_FAIL:
                strcpy(msg,"Initialization failed.");
                event_type = EVENTLOG_ERROR_TYPE;
                break;
        case START_REMOVE:
                strcpy(msg,"Start removal");
                event_type = EVENTLOG_INFORMATION_TYPE;
                break;
        case REMOVE_FAIL:
                strcpy(msg,"Removal failed.");
                event_type = EVENTLOG_ERROR_TYPE;
                break;
        case REMOVE_COMPLETE:
                strcpy(msg,"Removal completed.");
                event_type = EVENTLOG_INFORMATION_TYPE;
                break;
        case SPACE_ALMOST_FULL:
                strcpy(msg,"Disk space is almost full.");
                event_type = EVENTLOG_WARNING_TYPE;
                break;
        case SPACE_FULL:
                strcpy(msg,"Disk space is full.");
                event_type = EVENTLOG_WARNING_TYPE;
                break;
        case START_CHECK:
                strcpy(msg,"Start examination.");
                event_type = EVENTLOG_INFORMATION_TYPE;
                break;
        case STOP_CHECK:
                strcpy(msg,".");
                event_type = EVENTLOG_WARNING_TYPE;
                break;
        case CHECK_COMPLETE:
                strcpy(msg,"Examination completed.");
                event_type = EVENTLOG_INFORMATION_TYPE;
                break;
        case CHECK_UNKNOWN_FAIL:
                strcpy(msg,"Examination failed.");
                event_type = EVENTLOG_ERROR_TYPE;
                break;
        case CHECK_FAIL:
                strcpy(msg,"Examination failed(Cannot unmount disk).");
                event_type = EVENTLOG_ERROR_TYPE;
                break;
        case START_SCAN:
                strcpy(msg,"Start Scanning bad blocks.");
                event_type = EVENTLOG_INFORMATION_TYPE;
                break;
        case SCAN_COMPLETE_BAD_FOUND:
                if(arg!=NULL){
                        int *blocks = arg;
                        sprintf(msg,"Bad Blocks Scan completed. %d bad block(s) found.", *blocks);
                }
                else
                        sprintf(msg,"Bad Blocks Scan completed.");
                event_type = EVENTLOG_WARNING_TYPE;
                break;
        case SCAN_COMPLETE:
                strcpy(msg,"Bad Blocks Scan completed.");
                event_type = EVENTLOG_INFORMATION_TYPE;
                break;
        case STOP_SCAN:
                if(arg!=NULL){
                        int *blocks = arg;
                        sprintf(msg, "The scanning is stopped by user. %d bad block(s) found.", *blocks);
                }
                else
                        sprintf(msg, "The scanning is stopped by user.");
                event_type = EVENTLOG_WARNING_TYPE;
                break;
        case SCAN_FAIL:
                strcpy(msg,"Bad Blocks Scan failed.");
                event_type = EVENTLOG_ERROR_TYPE;
                break;
        case HD_INVALID_EVENT:
                if(arg!=NULL){
                        int *invalid_hd_no = arg;
                sprintf(msg," Invalid Disk %d: Wrong HD serial number/Slot number.", *invalid_hd_no);
                event_type = EVENTLOG_WARNING_TYPE;
                break;
              }
        case RESTORE_DEFAULT_SHARE:
                sprintf(msg,"Restore system default shares.");
                event_type = EVENTLOG_INFORMATION_TYPE;
                break;
        default:
                return;
        }

        sprintf(all_msg, "%s %s", vol_msg, msg);
        Write_Log(all_msg, event_type);
        return;
}

