//**************************************************************************
//
//	Copyright (c) 2000-2001  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		eventlog.c
//
//	Abstract: 
//		Win NT/2K like event log functions
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		01/02/01	kw lee created
//		04/25/02	add sync function for cnt file, the file is so
//				small, so better sync after all operations
//
//**************************************************************************
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>
#include <string.h>
#include "config.h"
#include "eventlog.h"
#include "sem.h"

#define LOG_FILE			"/etc/logs/nas4000.log"
#define LOG_FILE_CNT		"/etc/logs/nas4000.cnt"
#define HANDLE_READ		0x2319
#define HANDLE_WRITE	0x2336

static int write_lock = 0;
static int sem_first = 1;
static int gfd = 0;
static int write_bank = 0, read_bank = 1;
static int read_rec_idx = -1;
static unsigned long bank_size = 0;

void sync_cnt_file();
int read_bank_data(int bank, int *cnt, unsigned long *pos);
int write_bank_data(int bank, int cnt, unsigned long pos);
int set_writebank_index(int bank) ;
int get_writebank_index(int *bank) ;
int read_event_cnt(int event, int bank, int *cnt);
int write_event_cnt(int event, int bank, int cnt);
int set_guid(unsigned long guid);
int get_guid(unsigned long *guid);
int validate_write_pos(int, int *cnt, unsigned long *pos, int reclen);
void validate_read_bank();
void switch_bank(int *bank);

BOOL Get_Number_Of_Event_Log_Records(int fd, int *num)
{
	int	ret = 1, cnt = 0, cnt2 = 0;
	unsigned long pos = 0;

	*num = 0;
	if(fd != HANDLE_READ && fd != HANDLE_WRITE)
		return 0;

	if(read_bank_data(0, &cnt, &pos))
		if(cnt > 0)
			*num += cnt;
	if(read_bank_data(1, &cnt2, &pos))
		if(cnt2 > 0)
			*num += cnt2;
	return ret;
}

BOOL Get_Number_Of_Single_Events(int LogType, int fd, int *num)
{
	int	ret = 1, cnt = 0, cnt2 = 0;
	int	event = 0;

	*num = 0;
	if(fd != HANDLE_READ && fd != HANDLE_WRITE)
		return 0;

	if(LogType & EVENTLOG_INFORMATION_TYPE) 
		event = 0;
	else if(LogType & EVENTLOG_WARNING_TYPE) 
		event = 1;
	else if(LogType & EVENTLOG_ERROR_TYPE) 
		event = 2;

	if(read_event_cnt(event, 0, &cnt))
		if(cnt > 0)
			*num += cnt;
	if(read_event_cnt(event, 1, &cnt2))
		if(cnt2 > 0)
			*num += cnt2;
	return ret;
}

BOOL Open_Event_Log(int flag)
{
	int fd;
	int cnt,i;
	unsigned long pos;

	if(flag) {		// write lock
		if(sem_first) {
			creat_sem();
			set_semvalue();		// added by Ethan
			sem_first = 0;
		}
		semaphore_p();
		write_lock = 1;
	}
        for(i=0;i<=1;i++)//Try twice, Shone modified 2005,09,20 ,fd gets 0 some first time calling this function, not knowing why...
	{
		if((fd = open(LOG_FILE, O_CREAT|O_RDWR)) > 0) {
			gfd = fd;
			if(flag)
				fd = HANDLE_WRITE;
			else
				fd = HANDLE_READ;

			get_writebank_index(&write_bank);
			validate_read_bank();
			bank_size = lseek(gfd, 0, SEEK_END) / 2;
			if(flag) {
				read_bank_data(write_bank, &cnt, &pos);
			}
			else {
				pos = read_bank * bank_size;
			}
			lseek(gfd, pos, SEEK_SET);
			read_rec_idx = -1;
		}
		if(fd>0) break;//Open file successfully
	}

        if(fd<=0&&flag)//Shone added 2005,09,15 to recover sem setting when fd <= 0(some function would't call Close_Event_Log() when fd<=0)
        {
                semaphore_v();
                usleep(1);
                write_lock = 0;
        }

//	printf("open=0x%x\n", fd);
	return fd;
}


BOOL Close_Event_Log(int fd)
{
	int ret = 1;

	close(gfd);
	gfd = 0;
	if(write_lock) {
		semaphore_v();
		usleep(1);		// a necessary call to make this process release current CPU slice
		write_lock = 0; // then other process's semaphore_p() will work
	}
	return ret;
}


BOOL Read_Event_Log(int fd, int ReadFlags, int RecordOffset, char *buffer, int nNumberOfBytesToRead, int *pnBytesRead)
{
	int	i, ret = 0;
	long	total = 0, len = 0;
	int 	cnt, total_cnt;
	unsigned long pos = 0;
	unsigned short l;
	char	*ptr;
	PEVENTLOGRECORD plog;

#ifdef DEBUG
	printf("Read_Event_Log: flags=%d, Offset=%d\n", ReadFlags, RecordOffset);
#endif

	Get_Number_Of_Event_Log_Records(fd, &total_cnt);

	if(ReadFlags & EVENTLOG_SEEK_READ) {
		if(RecordOffset > (total_cnt - 1))		// out of range
			return 0;
		// check which bank will be hit!
		validate_read_bank();
		if(write_bank == 0 && read_bank == 0) {	// not reused yet!!
			read_bank_data(read_bank, &cnt, &pos);
		}
		else {
			read_bank_data(read_bank, &cnt, &pos);
			if(RecordOffset > (cnt - 1)) {	// switch to another bank
				RecordOffset -= cnt;
				switch_bank(&read_bank);
			}
		}
		pos = read_bank * bank_size;
		lseek(gfd, pos, SEEK_SET);
		for(i = 0; i < RecordOffset; i++) {
			if(read(gfd, &len, sizeof(len)) <= 0)
				goto end_of_read;
			len -= sizeof(len);
			if(len <= 0)
				goto end_of_read;
			lseek(gfd, len, SEEK_CUR);
		}
		read_rec_idx = RecordOffset;
	}
	else { // EVENTLOG_SEQUENTIAL_READ
		read_bank_data(read_bank, &cnt, &pos);
#ifdef DEBUG
		printf("Step 1: read_bank=%d, count=%d, read_rec_idx=%d\n",
				read_bank, cnt, read_rec_idx);
#endif
		if (cnt<=0) {
			switch_bank(&read_bank);
			read_bank_data(read_bank, &cnt, &pos);
#ifdef DEBUG
			printf("Step 1.1: read_bank=%d, count=%d\n",
				read_bank, cnt);
#endif

			if (cnt<=0)
				goto end_of_read;

			read_rec_idx=-1;
		}

		if (ReadFlags & EVENTLOG_BACKWARDS_READ) {
			if (read_rec_idx<0) { //not initialized yet
#ifdef DEBUG
				printf("Step 2.1: Backwards initialize\n");
#endif
				// the latest record is in the another bank ?
				if (total_cnt > cnt) {
#ifdef DEBUG
					printf("\ttotal_cnt = %d > cnt = %d ==> switch bank!\n",
						total_cnt, cnt);
#endif
					switch_bank(&read_bank);
					read_bank_data(read_bank, &cnt, &pos);
#ifdef DEBUG
					printf("\tnew read bank cnt = %d!\n", cnt);
#endif
					if (cnt<=0)
						goto end_of_read;
				}

				read_rec_idx = cnt-1;

				pos = read_bank * bank_size;
				lseek(gfd, pos, SEEK_SET);
				for(i = 0; i < cnt-1; i++) {
					if(read(gfd, &len, sizeof(len)) <= 0) {
#ifdef DEBUG
						printf("Step 2.1.1\n");
#endif
						goto end_of_read;
					}

					len -= sizeof(len);
					if(len <= 0) {
#ifdef DEBUG
						printf("Step 2.1.2\n");
#endif
						goto end_of_read;
					}
					lseek(gfd, len, SEEK_CUR);
				}
			}
		}
		else { // Forward
			if(read_rec_idx > (cnt-1)) {
#ifdef DEBUG
				printf("Step 2.2: Switch to another bank\n");
#endif
				switch_bank(&read_bank);
				read_rec_idx = 0;
				pos = read_bank * bank_size;
				lseek(gfd, pos, SEEK_SET);
			} else if (read_rec_idx<0) { // not initialized
#ifdef DEBUG
				printf("Step 2.3: Backwards initialize\n");
#endif
				read_rec_idx = 0;
				pos = read_bank * bank_size;
				lseek(gfd, pos, SEEK_SET);
			}
		}
	}
#ifdef DEBUG
	printf("Read_Event_Log Step 3\n");
#endif
	
	if(nNumberOfBytesToRead < sizeof(EVENTLOGRECORD))
		goto end_of_read;
	plog = (PEVENTLOGRECORD) buffer;
	ptr = buffer + sizeof(EVENTLOGRECORD);
	if((len = read(gfd, plog, sizeof(EVENTLOGRECORD))) <= 0)
		goto end_of_read;
	total += len;
	total += sizeof(unsigned short);
	if(total > nNumberOfBytesToRead)
		goto end_of_read;
	if(read(gfd, &l, sizeof(unsigned short)) <= 0)
		goto end_of_read;
	memcpy(ptr, &l, sizeof(unsigned short));
	ptr += sizeof(unsigned short);
	if(total + l > nNumberOfBytesToRead)
		goto end_of_read;
	// read string
	if((len = read(gfd, ptr, l)) <= 0)
		goto end_of_read;
	total += len;
	// skip record length
	len = read(gfd, &pos, sizeof(long)) ;
	*pnBytesRead = total;

	if(ReadFlags & EVENTLOG_BACKWARDS_READ) {
#ifdef DEBUG
		printf("Read_Event_Log Step 4.1\n");
#endif
		read_rec_idx--;
		if (read_rec_idx<0) { // switch bank
#ifdef DEBUG
			printf("Read_Event_Log Step 4.1.1: switch bank\n");
#endif
			switch_bank(&read_bank);
			read_bank_data(read_bank, &cnt, &pos);
			if (cnt<=0) {
#ifdef DEBUG
				printf("Read_Event_Log Step 4.1.1.1\n");
#endif
				read_rec_idx=0;
			}
			else {
				read_rec_idx = cnt-1;
				pos = read_bank * bank_size;
				lseek(gfd, pos, SEEK_SET);
				for(i = 0; i < cnt-1; i++) {
					if(read(gfd, &len, sizeof(len)) <= 0) {
#ifdef DEBUG
						printf("Step 4.1.1.2\n");
#endif
						goto end_of_read;
					}
					len -= sizeof(len);
					if(len <= 0) {
#ifdef DEBUG
						printf("Step 4.1.1.3\n");
#endif
						goto end_of_read;
					}
					lseek(gfd, len, SEEK_CUR);
				}
			}
		} else {
#ifdef DEBUG
			printf("Read_Event_Log Step 4.1.2\n");
#endif
			lseek(gfd, -(plog->Length + sizeof(long)), SEEK_CUR);
			read(gfd, &len, sizeof(long));
			lseek(gfd, -len, SEEK_CUR);
		}
	}
	else {
#ifdef DEBUG
		printf("Read_Event_Log Step 4.2\n");
#endif
		read_rec_idx++;
	}
	ret = 1;
end_of_read:
	return ret;
}



BOOL Report_Event(int fd, int LogType, int NumStrings, char *Strings[])
{
	int	ret = 0;
	EVENTLOGRECORD log;
	int	i, cnt = 0, ec, switched = 0;
	unsigned short l;
	unsigned long len = 0, pos = 0, guid = 0;
	time_t 	t;
	char 	subject[128], level[128];
	int	alert = 0;
	int 	sendmail = 0;
	int	event = 0;

	if(fd != HANDLE_WRITE)		// not for write
		return 0;

	memset(subject, 0, sizeof(subject));
	memset(level, 0, sizeof(level));
	Get_Alert_Level(&alert);
	Get_Server_Name(subject, 128);
	if((LogType & EVENTLOG_ERROR_TYPE) && alert >= 1) {
		strcpy(level, " Error");
		sendmail = 1;
	}
	else if(LogType & EVENTLOG_WARNING_TYPE && alert == 2) {
		strcpy(level, " Warning");
		sendmail = 1;
	}
/*	else if(LogType & EVENTLOG_INFORMATION_TYPE && alert == 2) {
		strcpy(level, " Information");
		sendmail = 1;
	}*/
	strcat(subject, level);

	if(sendmail) {
		Send_Alert_Mail(subject, Strings[0], level);
		SNMPTrap_Send_Alert(Strings[0],alert);
	}

	if(LogType & EVENTLOG_INFORMATION_TYPE) 
		event = 0;
	else if(LogType & EVENTLOG_WARNING_TYPE) 
		event = 1;
	else if(LogType & EVENTLOG_ERROR_TYPE) 
		event = 2;
	
	// Count the write length
	len += sizeof(EVENTLOGRECORD);
	for(i = 0; i < NumStrings; i++) {
		len += strlen(Strings[i]) + sizeof(unsigned short);
	}
	len += sizeof(long);			// length of whole record

	// seek end between banks
	read_bank_data(write_bank, &cnt, &pos);
	read_event_cnt(event, write_bank, &ec);
//	printf("-- 1.write cnt=%d, pos = %ld\n", cnt, pos);
	switched = validate_write_pos(event, &cnt, &pos, len);
//	printf("-- 2.write cnt=%d, pos = %ld\n", cnt, pos);

	get_guid(&guid);
	time(&t);
	memset(&log, 0, sizeof(EVENTLOGRECORD));
	log.Length = len;
	log.RecordNumber = guid;
	log.EventType = LogType;
	log.NumStrings = NumStrings;
	log.TimeGenerated = t;
	// write event log record
	write(gfd, &log, sizeof(EVENTLOGRECORD));
	// write strings
	for(i = 0; i < NumStrings; i++) {
		l = strlen(Strings[i]);
		write(gfd, &l, sizeof(unsigned short));
		write(gfd, Strings[i], l);
	}
	// write number bytes of whole record
	write(gfd, &len, sizeof(len));
	// write record number in the log cnt file
	cnt++;
	pos += len;
	write_bank_data(write_bank, cnt, pos);
	// write record number of each event type
	if(switched) {
		write_event_cnt(0, write_bank, 0);
		write_event_cnt(1, write_bank, 0);
		write_event_cnt(2, write_bank, 0);
		write_event_cnt(event, write_bank, 1);
	}
	else {
		ec++;
		write_event_cnt(event, write_bank, ec);
	}
	guid++;
	set_guid(guid);
	return ret;

}


BOOL Clear_Event_Log(int fd)
{
	int ret = 1;

	if(fd != HANDLE_WRITE)
		return 0;
	set_writebank_index(0);
	set_guid(0);
	write_bank_data(0, 0, 0);	
	write_bank_data(1, -1, 0);	
	write_event_cnt(0, 0, 0);	
	write_event_cnt(0, 1, 0);	
	write_event_cnt(1, 0, 0);	
	write_event_cnt(1, 1, 0);	
	write_event_cnt(2, 0, 0);	
	write_event_cnt(2, 1, 0);	
	sync_cnt_file();
	return ret;
}

void sync_cnt_file()
{
	int fd;

	if((fd = open(LOG_FILE_CNT, O_CREAT|O_RDWR)) > 0) {
		fdatasync(fd);
		close(fd);
	}
}

int read_bank_data(int bank, int *cnt, unsigned long *pos)
{
	int  fd;
	int ret = 0;

	*cnt = 0;
	*pos = 0;

//printf("read_bank_data 1\n") ;
	if((fd = open(LOG_FILE_CNT, O_CREAT|O_RDONLY)) > 0) {
		long p;
		p = sizeof(int) + sizeof(long) + bank * (sizeof(int) + sizeof(long));
		lseek(fd, p, SEEK_CUR);
		if(read(fd, cnt, sizeof(int)) <= 0) {
			*cnt = 0;
			close(fd);
			goto end_read_bank_data;
		}
		if(read(fd, pos, sizeof(long)) <= 0) {
			*pos = 0;
			close(fd);
			goto end_read_bank_data;
		}
		close(fd);
		ret = 1;
	}
end_read_bank_data:
//	printf("ret=%d, cnt=%d\n", ret, *cnt);
	return ret;
}

int write_bank_data(int bank, int cnt, unsigned long pos)
{
	int  fd;
	int ret = 0;

	if((fd = open(LOG_FILE_CNT, O_CREAT|O_RDWR)) > 0) {
		long p;
		p = sizeof(int) + sizeof(long) + bank * (sizeof(int) + sizeof(long));
		lseek(fd, p, SEEK_CUR);
		write(fd, &cnt, sizeof(int));
		write(fd, &pos, sizeof(long));
		close(fd);
		ret = 1;
	}
	return ret;
}

int read_event_cnt(int event, int bank, int *cnt)
{
	int  fd;
	int ret = 0;
	long p;

	p = sizeof(int) + sizeof(long) + 2 * (sizeof(int) + sizeof(long));
	p += event * 2 * sizeof(int) + bank * sizeof(int);

	*cnt = 0;

//printf("read_bank_data 1\n") ;
	if((fd = open(LOG_FILE_CNT, O_CREAT|O_RDONLY)) > 0) {
		lseek(fd, p, SEEK_CUR);
		if(read(fd, cnt, sizeof(int)) <= 0) {
			*cnt = 0;
			close(fd);
			goto end_read_bank_data;
		}
		close(fd);
		ret = 1;
	}
end_read_bank_data:
//	printf("ret=%d, cnt=%d\n", ret, *cnt);
	return ret;
}

int write_event_cnt(int event, int bank, int cnt)
{
	int  fd;
	int ret = 0;
	long p;

	p = sizeof(int) + sizeof(long) + 2 * (sizeof(int) + sizeof(long));
	p += event * 2 * sizeof(int) + bank * sizeof(int);

	if((fd = open(LOG_FILE_CNT, O_CREAT|O_RDWR)) > 0) {
		lseek(fd, p, SEEK_CUR);
		write(fd, &cnt, sizeof(int));
		close(fd);
		ret = 1;
	}
	return ret;
}


int set_writebank_index(int bank) {
	int fd;
	int ret = 0;

	if((fd = open(LOG_FILE_CNT, O_CREAT|O_RDWR)) > 0) {
		write(fd, &bank, sizeof(int));
		close(fd);
		ret = 1;
	}
	return ret;
}


int get_writebank_index(int *bank) {
	int fd;
	int ret = 0;

	*bank = 0;
	if((fd = open(LOG_FILE_CNT, O_CREAT|O_RDWR)) > 0) {
		read(fd, bank, sizeof(int));
		close(fd);
		ret = 1;
	}
	return ret;
}


int set_guid(unsigned long guid)
{
	int fd;
	int ret = 0;

	if((fd = open(LOG_FILE_CNT, O_CREAT|O_RDWR)) > 0) {
		long p = sizeof(long);
		lseek(fd, p, SEEK_CUR);
		write(fd, &guid, sizeof(long));
		close(fd);
		ret = 1;
	}
	return ret;
}

int get_guid(unsigned long *guid)
{
	int fd;
	int ret = 0;

	*guid = 0;
	if((fd = open(LOG_FILE_CNT, O_CREAT|O_RDWR)) > 0) {
		long p = sizeof(long);
		lseek(fd, p, SEEK_CUR);
		if(read(fd, guid, sizeof(long)) <= 0)
			*guid = 0;
		close(fd);
		ret = 1;
	}
	return ret;
}

int validate_write_pos(int event, int *cnt, unsigned long *pos, int reclen)
{
	if((*pos + reclen) <= (bank_size * (write_bank + 1)))
		return 0;

//	printf("-------switch bank-------\n");
	// write back original bank's data
	write_bank_data(write_bank, *cnt, *pos);
	*cnt = 0;
	// switch to another bank
	if(write_bank) {
		write_bank = 0;
		*pos = 0;
	}
	else {
		write_bank = 1;
		*pos = bank_size;
	}
	lseek(gfd, *pos, SEEK_SET);
	set_writebank_index(write_bank);
	return 1;
}

void validate_read_bank()
{
	int	cnt = 0;
	unsigned long pos = 0;

	if(write_bank)
		read_bank = 0;
	else
		read_bank = 1;
	if(read_bank == 1)	{	// double check banks are not reused
		if(!read_bank_data(read_bank, &cnt, &pos))
			read_bank = 0;
		if(cnt == -1)
			read_bank = 0;
	}
}

void switch_bank(int *bank)
{
	if(*bank)
		*bank = 0;
	else
		*bank = 1;
}

int Write_Log(char *str, int type)
{
        int fd;
        char *ptr[10];

        fd = Open_Event_Log(1);
        if (fd <= 0)
        {
                return -1;
        }
        ptr[0]=str;
        Report_Event(fd, type, 1, ptr);
        Close_Event_Log(fd);
        return 0;
}
