#include "cfg_vscan.h"

int Is_VSCAN_Supported() {
	char buf[1024];
	int val = GetProfileString(SZ_VSCAN_SECTION, SZ_SUPPORTED_FIELD, "", buf, sizeof(buf));
	if(!val) return 0;
	return !strcmp(buf, "true");
}

int Get_VSCAN_Type(char* type, int buf_size) {
	int val, ret = SUCCESS;
	val = GetProfileString(SZ_VSCAN_SECTION, SZ_TYPE_FIELD, "", type, buf_size);
	if(!val) return ERROR_READ_FILE;
	return ret;	
}

int Get_VSCAN_Server_Address(char* address, int buf_size) {
	int val, ret = SUCCESS;
	val = GetProfileString(SZ_VSCAN_SECTION, SZ_SERVER_FIELD, "", address, buf_size);
	if(!val) return ERROR_READ_FILE;
	return ret;	
}

int Get_VSCAN_Status(char* status, int buf_size) {
	int val, ret = SUCCESS;
	val = GetProfileString(SZ_VSCAN_SECTION, SZ_STATUS_FIELD, "", status, buf_size);
	if(!val) return ERROR_READ_FILE;
	return ret;	
}

int Get_VSCAN_Infected_Action(char* action, int buf_size) {
	int val, ret = SUCCESS;
	val = GetProfileString(SZ_VSCAN_SECTION, SZ_INFECTED_RESPONSE_FIELD, 
		SZ_INFECTED_RESPONSE_DEFAULT, action, buf_size);
	if(!val) return ERROR_READ_FILE;
	return ret;	
}

int Set_VSCAN_Supported(int supported) {
	int val, ret = SUCCESS;
	val = WriteProfileString(SZ_VSCAN_SECTION, SZ_SUPPORTED_FIELD,
			supported?"true":"false");
	if(!val) return ERROR_WRITE_FILE;
	return ret;	
}

int Set_VSCAN_Status(char* status) {
	int val, ret = SUCCESS;
	val = WriteProfileString(SZ_VSCAN_SECTION, SZ_STATUS_FIELD, status);
	if(!val) return ERROR_WRITE_FILE;
	return ret;	
}

int Set_VSCAN_Server_Address(char* address) {
	int val, ret = SUCCESS;
	val = WriteProfileString(SZ_VSCAN_SECTION, SZ_SERVER_FIELD, address);
	if(!val) return ERROR_WRITE_FILE;
	return ret;	
}


int Set_VSCAN_Type(char* type) {
	int val, ret = SUCCESS;
	val = WriteProfileString(SZ_VSCAN_SECTION, SZ_TYPE_FIELD, type);
	if(!val) return ERROR_WRITE_FILE;
	return ret;		
}

int Set_VSCAN_Infected_Action(char* action) {
	int val, ret = SUCCESS;
	val = WriteProfileString(SZ_VSCAN_SECTION, SZ_INFECTED_RESPONSE_FIELD, action);
	if(!val) return ERROR_WRITE_FILE;
	return ret;	
}

void send_virus_alert_mail(char* subject, char* message)
{
	char buf[BUF_SIZE];
	char Ip[BUF_SIZE], Email1[BUF_SIZE], Email2[BUF_SIZE];
	char *ptr = NULL;

	Get_Alert_SMTP_Server_IP(Ip, sizeof(Ip));
	Get_Alert_Mail_Address(buf, sizeof(buf));
	ptr = strtok(buf, ";");
	if (ptr != NULL) {
		strncpy(Email1, ptr, sizeof(Email1));
		ptr = strtok(NULL, ";");
		Send_Mail(subject, message, Email1, Ip, NULL);
		if (ptr != NULL) {
			strncpy(Email2, ptr, sizeof(Email2));
			Send_Mail(subject?subject:"VSCAN ALERT", message, Email2, Ip, NULL);
		}
	}
}

int Start_VSCAN() {
	char cmd[1024];
	if(Enable_Samba(1)) { // vscan needs samba to work
		// disable vscan... can start samba
		Set_VSCAN_Status("disabled"); 
		return 1; 
	}
	sprintf(cmd, "%s start", START_SCRIPT);
	return system(cmd);
}

void Stop_VSCAN() {
	char cmd[1024];
	sprintf(cmd, "%s stop", START_SCRIPT);
	system(cmd);
}
