#include	<stdio.h>
#include	<ctype.h>
#include	<stdlib.h>
#include	<string.h>
#include 	<dirent.h>
#include	<sys/stat.h>
/* NAS include file by john */
#include	<Util.h>
#include	<cfg_nic.h>
#include 	<config.h>
#include 	<timezone.h>
#include 	<Util.h>
#include 	<NAS.h>
#include 	<cfg_fw.h>
//#include 	<cfg_nic.h>
#include        <cfg_system.h>
#include        <cfg_ftp.h>


#include	"naslvm.h"
#include	"nas_quota.h"

#include         "cfg_save_restore.h"
#include 	 "uLinux.h"
#include 	 "timezone.h"
	

//timezone.h............................lala!	
extern char *timezone_Windows[];
extern char *timezone_Linux[];

int do_decode_profile(char* filename);
/* for NasWare 3.00 */
//int do_encode_profile(char* filename, SR_TYPE type);

/* for NasWare 3.00 */
int do_encode_profile(char* filename);

int create_share_dir(char *dirname)
{
	DIR	*dir;
	int	ret=0;

	if ((dir=opendir(dirname))==NULL)
	{
		ret=mkdir(dirname, S_IRWXU | S_IRWXG | S_IRWXO);
		if (ret==0)
			ret=chmod(dirname, S_IRWXU | S_IRWXG | S_IRWXO);
	}
	else
	{
		closedir(dir);
		ret=chmod(dirname, S_IRWXU | S_IRWXG | S_IRWXO);
	}
	return ret;
}

int get_tmp_model_name(char *model_name, int buf_size) 
{
	int val;
	
	val = Get_Private_Profile_String(RESTORE_SYS_SECTION, RESTORE_SYS_MODEL, "", model_name, buf_size, TMP_CONFIG_PATH);
	
	return (!val)?ERROR_READ_FILE:SUCCESS;	
}

int is_sr_model()
{
	char tmp_model[128]={0};
	char nas_model[128]={0};
	
	Get_Model_Name(nas_model,sizeof(nas_model));
	get_tmp_model_name(tmp_model,sizeof(tmp_model));
	
	return (!strcmp(nas_model, tmp_model))?TRUE:FALSE;
}	

char *create_sr_working_directory()
{
	static char update_dir[BUF_SIZE];
	char buf[BUF_SIZE];
	int result = 0;

	// use HardDisk space first
	if(Is_HD_Ready(1)) {
		sprintf(buf, "/bin/rm -rf %s", SR_WORKING_DIR);	
		system(buf);	
		system("/bin/mkdir /mnt/HDA_ROOT/update");	
		sprintf(buf, "ln -s /mnt/HDA_ROOT/update %s", SR_WORKING_DIR);	
		system(buf);	
	}
	else { // no Hard exist, use ram disk
		sprintf(buf, "/sbin/mke2fs -m0 /dev/ram1 > /dev/null; /bin/mount /dev/ram1 %s > /dev/null", SR_WORKING_DIR);
		result = system(buf);
	}
	strcpy(update_dir, SR_WORKING_DIR);
	return update_dir;
}


/* for NasWare v3.00 */
//char* get_sr_type_srt(char** pstr, SR_TYPE type)
//{
//	switch(type){
//		case SR_USR_GRP_CONFIG:
//			*pstr = PC1_USR_GRP_CODE;
//			break;	
//		case SR_DISK_CONFIG:
//			*pstr = PC1_DISK_CODE;
//			break;
//		case SR_NETWORK_CONFIG:
//			*pstr = PC1_NETWORK_CODE;
//			break;
//		case SR_SHARE_CONFIG:
//			*pstr = PC1_SHARE_CODE;
//			break;
//		case SR_HARDWARE_CONFIG:
//			*pstr = PC1_HARDWARE_CODE;
//			break;
//		case SR_SYSTEM_CONFIG:
//			*pstr = PC1_SYSTEM_CODE;
//			break;
//		case SR_ALL_CONFIG:
//			*pstr = PC1_ALL_CODE;
//			break;
//		case SR_NONE_CONFIG:
//			break;
//	}
//	return *pstr;
//}	

int do_decode_profile(char* filename)
{
	char buf[256]={0};	
	int ret = SR_NONE_CONFIG;
	
	// for NasWare v3.01 or later
	sprintf(buf, "%s p %s %s %s.tgz 2>/dev/null 1>/dev/null", ENCRYPT_PROG, PC1_NASWARE_V301, filename, filename);
	system(buf);
	sprintf(buf, "/bin/tar xzf %s.tgz -C /tmp 2>/dev/null 1>/dev/null", filename);
	if (system(buf)==0){
		FILE *fp = NULL;
		int save_no = 0;
        	
		// open a file, "save_no.conf" to store the save_no for restoring reference
		if((fp = fopen("/tmp/etc/save_no.conf", "r")) == NULL) {
			return ERROR_FAIL;
		}
		else {
			fscanf(fp, "%d", &save_no);
			fclose(fp);
			return save_no;
		}
	}
	return ret;
}

/*int do_decode_profile(char* filename)
{
	char buf[256]={0};	
	int ret = SR_NONE_CONFIG;
	
	sprintf(buf, "%s d %s %s %s.tgz 2>/dev/null 1>/dev/null", ENCRYPT_PROG, PC1_DISK_CODE, filename, filename);
	system(buf);
	sprintf(buf, "/bin/tar xzf %s.tgz -C /tmp 2>/dev/null 1>/dev/null", filename);
	if (system(buf)==0){
		ret = SR_DISK_CONFIG;
		return ret;
	}	
	sprintf(buf, "%s d %s %s %s.tgz 2>/dev/null 1>/dev/null", ENCRYPT_PROG, PC1_NETWORK_CODE, filename, filename);
	system(buf);
	sprintf(buf, "/bin/tar xzf %s.tgz -C /tmp 2>/dev/null 1>/dev/null", filename);
	if (system(buf)==0){
		ret = SR_NETWORK_CONFIG;
		return ret;
	}	
	sprintf(buf, "%s d %s %s %s.tgz 2>/dev/null 1>/dev/null", ENCRYPT_PROG, PC1_SHARE_CODE, filename, filename);
	system(buf);
	sprintf(buf, "/bin/tar xzf %s.tgz -C /tmp 2>/dev/null 1>/dev/null", filename);
	if (system(buf)==0){
		ret = SR_SHARE_CONFIG;
		return ret;
	}	
	sprintf(buf, "%s d %s %s %s.tgz 2>/dev/null 1>/dev/null", ENCRYPT_PROG, PC1_HARDWARE_CODE, filename, filename);
	system(buf);
	sprintf(buf, "/bin/tar xzf %s.tgz -C /tmp 2>/dev/null 1>/dev/null", filename);
	if (system(buf)==0){
		ret = SR_HARDWARE_CONFIG;
		return ret;
	}	
	sprintf(buf, "%s d %s %s %s.tgz 2>/dev/null 1>/dev/null", ENCRYPT_PROG, PC1_SYSTEM_CODE, filename, filename);
	system(buf);
	sprintf(buf, "/bin/tar xzf %s.tgz -C /tmp 2>/dev/null 1>/dev/null", filename);
	if (system(buf)==0){
		ret = SR_SYSTEM_CONFIG;
		return ret;
	}	
	sprintf(buf, "%s d %s %s %s.tgz 2>/dev/null 1>/dev/null", ENCRYPT_PROG, PC1_USR_GRP_CODE, filename, filename);
	system(buf);
	sprintf(buf, "/bin/tar xzf %s.tgz -C /tmp 2>/dev/null 1>/dev/null", filename);
	if (system(buf)==0){
		ret = SR_USR_GRP_CONFIG;	
		return ret;
	}

        sprintf(buf, "%s d %s %s %s.tgz 2>/dev/null 1>/dev/null", ENCRYPT_PROG, PC1_ALL_CODE, filename, filename);
        system(buf);
        sprintf(buf, "/bin/tar xzf %s.tgz -C /tmp 2>/dev/null 1>/dev/null", filename);
        if (system(buf)==0){
                ret = SR_ALL_CONFIG;
		return ret;
        }
        
	// for NasWare v3.01 or later
        sprintf(buf, "%s d %s %s %s.tgz 2>/dev/null 1>/dev/null", ENCRYPT_PROG, PC1_NASWARE_V301, filename, filename);
        system(buf);
        sprintf(buf, "/bin/tar xzf %s.tgz -C /tmp 2>/dev/null 1>/dev/null", filename);
        if (system(buf)==0){
        	FILE *fp = NULL;
        	int save_no = 0;
        	
		// open a file, "save_no.conf" to store the save_no for restoring reference
		if((fp = fopen("/tmp/etc/save_no.conf", "r")) == NULL) {
			return ERROR_FAIL;
		}
		else {
			fscanf(fp, "%d", &save_no);
			fclose(fp);
			return save_no;
		}
	}
	return ret;
}*/

/* for NasWare v3.00 */
//int do_encode_profile(char* filename, SR_TYPE nSave_type)
//{
//	char* p = NULL;
//	char buf[256]={0};
//
//	sprintf(buf, "%s e %s /home/httpd/%s 2>/dev/null 1>/dev/null", ENCRYPT_PROG, get_sr_type_srt(&p, nSave_type), filename);
//	return (!system(buf))?TRUE:FALSE;
//}	

/* for NasWare v3.01 or later */
int do_encode_profile(char* filename)
{
	int ret;
	char buf[256]={0};

	sprintf(buf, "%s e %s /home/httpd/%s 2>/dev/null 1>/dev/null", ENCRYPT_PROG, PC1_NASWARE_V301, filename);
	ret = system(buf);
	sprintf(buf, "/sbin/PC2 /home/httpd/%s \"\" \"\" 2>/dev/null 1>/dev/null", filename);
	system(buf);
	return (!ret)?TRUE:FALSE;
}	



int Restore_SYS_Setting()
{
	SR_SYSTEM sys;
	char tzone[256]={0};
	int i;
	
	bzero(&sys, sizeof(sys));
	Get_Private_Profile_String( RESTORE_SYS_SECTION,RESTORE_SYS_SER_COMMENT,"",sys.zSerstr,BUF_SIZE,TMP_CONFIG_PATH);
	Get_Private_Profile_String( RESTORE_SYS_SECTION,RESTORE_SYS_TIMEZONE,"",tzone,BUF_SIZE,TMP_CONFIG_PATH);
	sys.bDayligth = Get_Private_Profile_Boolean(RESTORE_SYS_SECTION, RESTORE_SYS_DAYLIGHT,FALSE,TMP_CONFIG_PATH);
	Get_Private_Profile_String( RESTORE_SYS_SECTION,RESTORE_SYS_WORKGROUP,"",sys.zWorkgrp,BUF_SIZE,TMP_CONFIG_PATH);
	sys.nCodepage = Get_Private_Profile_Integer(RESTORE_SYS_SECTION, RESTORE_SYS_CODEPAGE,0,TMP_CONFIG_PATH);
	Get_Private_Profile_String( RESTORE_SYS_SECTION,RESTORE_SYS_SYS_DEV,"",sys.zSysdev,BUF_SIZE,TMP_CONFIG_PATH);
	sys.bTestmode = Get_Private_Profile_Boolean(RESTORE_SYS_SECTION, RESTORE_SYS_TEST,FALSE,TMP_CONFIG_PATH);
	Get_Private_Profile_String( RESTORE_SYS_SECTION,RESTORE_SYS_AUTO_CRT_RAID,"",sys.zAutoraid,BUF_SIZE,TMP_CONFIG_PATH);
	sys.bWanAccess = Get_Private_Profile_Boolean(RESTORE_SYS_SECTION, RESTORE_SYS_WAN_ACCESS,FALSE,TMP_CONFIG_PATH);
	sys.bLanAccess = Get_Private_Profile_Boolean(RESTORE_SYS_SECTION, RESTORE_SYS_LAN_ACCESS,FALSE,TMP_CONFIG_PATH);	
	sys.nWebport = Get_Private_Profile_Integer(RESTORE_SYS_SECTION, RESTORE_SYS_WEB_PORT,0,TMP_CONFIG_PATH);
	Get_Private_Profile_String( RESTORE_SYS_SECTION,RESTORE_SYS_SER_NAME,"",sys.zServer,BUF_SIZE,TMP_CONFIG_PATH);
	Get_Private_Profile_String( RESTORE_SYS_SECTION,RESTORE_SYS_NETWARE_SER_NAME,"",sys.zNetwareServer,BUF_SIZE,TMP_CONFIG_PATH);
		
	
	Set_Server_Comment(sys.zSerstr);
	for(i=0; i<LINUX_TIMEZONE_MAX; i++){
		if (!strcmp(timezone_Linux[i], tzone)) {
       			strcpy(sys.zTimezone, timezone_Windows[i]);
			break;
       		}
	}	
	Set_System_Time_Zone(sys.zTimezone);
			
	Enable_Day_Light_Saving_Time(sys.bDayligth);
	Set_Workgroup_Name(sys.zWorkgrp);
	Set_System_Codepage(sys.nCodepage);
	Set_Profile_String(RESTORE_SYS_SECTION,RESTORE_SYS_SYS_DEV,sys.zSysdev);
	Set_Profile_Boolean(RESTORE_SYS_SECTION, RESTORE_SYS_TEST,sys.bTestmode);
	Set_Profile_String(RESTORE_SYS_SECTION,RESTORE_SYS_AUTO_CRT_RAID,sys.zAutoraid);
	Set_Profile_Boolean(RESTORE_SYS_SECTION, RESTORE_SYS_WAN_ACCESS,sys.bWanAccess);
	Set_Profile_Boolean(RESTORE_SYS_SECTION, RESTORE_SYS_LAN_ACCESS,sys.bLanAccess);
	Set_Profile_Integer(RESTORE_SYS_SECTION, RESTORE_SYS_WEB_PORT,sys.nWebport);
	Set_Server_Name(sys.zServer, 0);
	Set_Netware_Server_Name(sys.zNetwareServer, 0);
	return SUCCESS;		
}

int Restore_Storage_Setting()
{
	int i;
	char item_driveN[8]; // "Drive N"
	char item_diskNexist[14]; // "Drive N EXIST"
	int disk_no = 0;
	SR_STORAGE stor;
	
	system("cp -a /tmp/etc/raidtab /etc/raidtab 2> /dev/null");
	system("cp -a /tmp/etc/config/storage.conf /etc/config/storage.conf 2> /dev/null");

	disk_no = Get_Profile_Integer(
			NASCONF_STORAGE_SECTION,
			NASCONF_DRIVE_NO_FIELD,
			0);	
	for(i=0; i<disk_no; i++) {
		Create_Hidden_Conf_File(i+1);
	}
	
	stor.bAutoInit = Get_Private_Profile_Boolean(RESTORE_STOR_SECTION, RESTORE_STOR_AUTO_INIT,FALSE,TMP_CONFIG_PATH);
	stor.nDiskNo = Get_Private_Profile_Integer(RESTORE_STOR_SECTION, RESTORE_STOR_DISK_NO,0,TMP_CONFIG_PATH);

	for(i=0; i<stor.nDiskNo; i++) {
		sprintf(item_driveN, "Drive %d", i+1);
		Get_Private_Profile_String(RESTORE_STOR_SECTION, item_driveN, "", stor.zDriveN[i], DISK_NAME_LENGTH, TMP_CONFIG_PATH);
	}	

	Get_Private_Profile_String(RESTORE_STOR_SECTION, RESTORE_STOR_DISK_CHK_ON_BOOT, "", stor.zDiskChkOnBoot, 10, TMP_CONFIG_PATH);
	stor.bAutoFixError = Get_Private_Profile_Boolean(RESTORE_STOR_SECTION, RESTORE_STOR_AUTO_FIX_ERROR,FALSE,TMP_CONFIG_PATH);
	stor.bSupportR5 = Get_Private_Profile_Boolean(RESTORE_STOR_SECTION, RESTORE_STOR_SUPPORT_R5,FALSE,TMP_CONFIG_PATH);
	stor.bSupportLVM = Get_Private_Profile_Boolean(RESTORE_STOR_SECTION, RESTORE_STOR_SUPPORT_LVM,FALSE,TMP_CONFIG_PATH);

	for(i=0; i<stor.nDiskNo; i++) {
		sprintf(item_diskNexist, "Drive %d EXIST", i+1);
		stor.nDriveExist[i] = Get_Private_Profile_Integer(RESTORE_DISK_SECTION, item_diskNexist,0,TMP_CONFIG_PATH);
	}	

	Set_Profile_Boolean(RESTORE_STOR_SECTION, RESTORE_STOR_AUTO_INIT, stor.bAutoInit);
	Set_Profile_Integer(RESTORE_STOR_SECTION, RESTORE_STOR_DISK_NO, stor.nDiskNo);

	for(i=0; i<stor.nDiskNo; i++) {
		sprintf(item_driveN, "Drive %d", i+1);
		Set_Profile_String(RESTORE_STOR_SECTION, item_driveN, stor.zDriveN[i]);
	}	

	Set_Profile_String(RESTORE_STOR_SECTION, RESTORE_STOR_DISK_CHK_ON_BOOT, stor.zDiskChkOnBoot);
	Set_Profile_Boolean(RESTORE_STOR_SECTION, RESTORE_STOR_AUTO_FIX_ERROR, stor.bAutoFixError);
	Set_Profile_Boolean(RESTORE_STOR_SECTION, RESTORE_STOR_SUPPORT_R5, stor.bSupportR5);
	Set_Profile_Boolean(RESTORE_STOR_SECTION, RESTORE_STOR_SUPPORT_LVM, stor.bSupportLVM);

	for(i=0; i<stor.nDiskNo; i++) {
		sprintf(item_diskNexist, "Drive %d EXIST", i+1);
		Set_Profile_Integer(RESTORE_DISK_SECTION, item_diskNexist, stor.nDriveExist[i]);
	}	

	return SUCCESS;		
}

//
// bird 20030320: add FTP_Create_Conf()
//
int Restore_Share_Setting()
{
	char cmd[256]={0};
	
	sprintf(cmd, "%s -avf %s/%s %s/%s 2> /dev/null", SR_CP_PROG, TMP_CONFIG_DIR, SR_SMB_CONFIG_FILE, DEFAULT_CONFIG_DIR, SR_SMB_CONFIG_FILE);
	//printf("cmd = %s<br>\n", cmd);
	if (system(cmd))
		return -1;
	
	Repair_Invalid_NAS_Shares();
	Clear_Invalid_NAS_Shares();
	
       	//Update_Flash_Data(SAMBA_CONF_PATH);
	FTP_Create_Conf();
        return SUCCESS;

}	

int Restore_HW_Setting()
{
	SR_HARDWARE hw;
	BOOL bVal = TRUE;
	char buf[BUF_SIZE];
	
	hw.bSys = Get_Private_Profile_Boolean(RESTORE_HW_SECTION, RESTORE_HW_SYS_START,FALSE,TMP_CONFIG_PATH);
	hw.bConfig = Get_Private_Profile_Boolean(RESTORE_HW_SECTION, RESTORE_HW_CONFIG,FALSE,TMP_CONFIG_PATH);
	hw.bLcdsetting = Get_Private_Profile_Boolean(RESTORE_HW_SECTION, RESTORE_HW_LCD_SETTING,FALSE,TMP_CONFIG_PATH);
	hw.bRestPasswd = Get_Private_Profile_Boolean(RESTORE_HW_SECTION, RESTORE_HW_RESET_PASSWD,FALSE,TMP_CONFIG_PATH);
	hw.nTimeout = Get_Private_Profile_Integer(RESTORE_HW_SECTION, RESTORE_HW_TIMEOUT,0,TMP_CONFIG_PATH);
	hw.bBuzzer = Get_Private_Profile_Boolean(RESTORE_HW_SECTION, RESTORE_HW_BUZZER,FALSE,TMP_CONFIG_PATH);
			
	if(!Set_Profile_Boolean(RESTORE_HW_SECTION, RESTORE_HW_SYS_START,hw.bSys)) {
		bVal = FALSE;
	}
	if(!Set_Profile_Boolean(RESTORE_HW_SECTION, RESTORE_HW_CONFIG,hw.bConfig)) {
		bVal = FALSE;
	}
	if(!Set_Profile_Boolean(RESTORE_HW_SECTION, RESTORE_HW_LCD_SETTING,hw.bLcdsetting)) {
		bVal = FALSE;
	}
	if(!Set_Profile_Boolean(RESTORE_HW_SECTION, RESTORE_HW_RESET_PASSWD,hw.bRestPasswd)) {
		bVal = FALSE;
	}
	if(!Set_Profile_Integer(RESTORE_HW_SECTION, RESTORE_HW_TIMEOUT,hw.nTimeout)) {
		bVal = FALSE;
	}
	if(!Set_Profile_Boolean(RESTORE_HW_SECTION, RESTORE_HW_BUZZER,hw.bBuzzer)) {
		bVal = FALSE;
	}

	if(bVal == TRUE) {
		sprintf(buf, "/sbin/report_log \"Hardware settings have been restored successfully.\" -t information");
		system(buf);
		return SUCCESS;
	}
	else {
		sprintf(buf, "/sbin/report_log \"Failed to restore hardware settings.\" -t error");
		system(buf);
		return ERROR_FAIL;
	}
}		

int Restore_Usr_Grp_Setting()
{
	char buf[512];
	char (*old_user_list)[USER_NAME_LENGTH] = NULL,(*old_group_list)[GROUP_NAME_LENGTH] = NULL;
	char (*new_user_list)[USER_NAME_LENGTH] = NULL,(*new_group_list)[GROUP_NAME_LENGTH] = NULL;
	char (*usr_tmp)[USER_NAME_LENGTH] = NULL, (*grp_tmp)[GROUP_NAME_LENGTH] = NULL;	
	int ret,old_user = 0,old_group = 0,new_user = 0,new_group = 0,i,j,found,count = 0;
	LVM_VOLUME_INFO *config_vol=NULL;
					
	old_user = Get_NAS_User_List_Ex(&old_user_list);
	old_group = Get_NAS_Group_List_Ex(&old_group_list);
			
	sprintf(buf, "cd /tmp/etc;cp -a passwd /etc/passwd;cp -a group /etc/group;cp -a nfs.conf /etc/nfs.conf;cp -a config/nwpwd /etc/config/nwpwd;cp -a config/smbpasswd /etc/config/smbpasswd;cp -a config/smbusers /etc/config/smbusers;cp -a config/usr_quota.conf /etc/config/usr_quota.conf");
	if (!(ret=system(buf))){
		Stop_User_Quota(0);
		j = Get_All_LVM_Configured_Vol_For_Share(&config_vol);
				
		for (i = 0; i < j; i++)
			Enable_User_Quota_Disk(config_vol[i].vol_data.vol_no);

		Release_LVM_Info_List(config_vol, j);
		Start_User_Quota(0);	
				
		new_user = Get_NAS_User_List_Ex(&new_user_list);
		new_group = Get_NAS_Group_List_Ex(&new_group_list);
				
		for (i=0;i<old_user;i++){
			found = 0;
			for (j=0;j<new_user;j++ ){
				if (!strcasecmp(*(old_user_list+i), *(new_user_list+j))){
					found = 1;
					break;
				}	
			}
			if (found == 0){
				count++;
				usr_tmp = (char (*)[USER_NAME_LENGTH]) realloc((void*)usr_tmp,count * USER_NAME_LENGTH * sizeof(char));
						
					if (usr_tmp==NULL) return ERROR_BUFFER_TOO_SMALL;
						
					strncpy((char *) (usr_tmp + count -1), *(old_user_list+i), USER_NAME_LENGTH);
						
			}	
		}
					
		Remove_Multiple_User_Share_Privilege(usr_tmp, count);
		if(usr_tmp != NULL)
			free(usr_tmp);
				
		count = 0;
		for (i=0;i<old_group;i++){
			found = 0;
			for (j=0;j<new_group;j++ ){
				if (!strcasecmp(*(old_group_list+i), *(new_group_list+j))){
					found = 1;
					break;
				}	
			}
			if (!found){
				count++;
				grp_tmp = (char (*)[GROUP_NAME_LENGTH]) realloc((void*)grp_tmp,count * GROUP_NAME_LENGTH * sizeof(char));
						
				if (grp_tmp==NULL) return ERROR_BUFFER_TOO_SMALL;
						
					strncpy((char *) (grp_tmp + count -1), *(old_group_list+i), GROUP_NAME_LENGTH);
			}	
		}
				
		Remove_Multiple_Group_Share_Privilege(grp_tmp, count);
		if (grp_tmp!=NULL)
			free(grp_tmp);
				
	}
	//system("/bin/kill -HUP `/sbin/pidof nasnfsd 2> /dev/null` 2> /dev/null");
	system("/etc/init.d/nfs reexport 1>/dev/null 2>/dev/null");
								
	
	if(ret == SUCCESS){
		sprintf(buf, "/sbin/report_log \"User settings have been restored successfully.\" -t information");
		system(buf);
	}
	else{
		sprintf(buf, "/sbin/report_log \"Failed to restore user settings.\" -t error");
		system(buf);
	}
	if (old_user > 0)
		Release_List(old_user_list);
	if (old_group > 0)
		Release_List(old_group_list);
	if (new_user > 0)
		Release_List(new_user_list);
	if (new_group > 0)
		Release_List(new_group_list);	

	return ret;
}

int Restore_Network_NIC_Setting()
{
	char	buf[255];

// =========================================== uLinux.conf network section =============================================== //

//	if (Conf_Get_Field(TMP_CONFIG_PATH, RESTORE_NIC_SECTION, RESTORE_NIC_INTERFACE_NUM, buf, sizeof(buf))==SUCCESS)
//		Set_Profile_String(RESTORE_NIC_SECTION, RESTORE_NIC_INTERFACE_NUM, buf);
	if (Conf_Get_Field(TMP_CONFIG_PATH, RESTORE_NIC_SECTION, RESTORE_NIC_DNS, buf, sizeof(buf))==SUCCESS)
		Set_Profile_String(RESTORE_NIC_SECTION, RESTORE_NIC_DNS, buf);
//	if (Conf_Get_Field(TMP_CONFIG_PATH, RESTORE_NIC_SECTION, RESTORE_NIC_WAN, buf, sizeof(buf))==SUCCESS)
//        	Set_Profile_String(RESTORE_NIC_SECTION, RESTORE_NIC_WAN, buf);
//	if (Conf_Get_Field(TMP_CONFIG_PATH, RESTORE_NIC_SECTION, RESTORE_NIC_INTERFACE1, buf, sizeof(buf))==SUCCESS)
//        	Set_Profile_String(RESTORE_NIC_SECTION, RESTORE_NIC_INTERFACE1, buf);
//	if (Conf_Get_Field(TMP_CONFIG_PATH, RESTORE_NIC_SECTION, RESTORE_NIC_INTERFACE2, buf, sizeof(buf))==SUCCESS)
//        	Set_Profile_String(RESTORE_NIC_SECTION, RESTORE_NIC_INTERFACE2, buf);
//	if (Conf_Get_Field(TMP_CONFIG_PATH, RESTORE_NIC_SECTION, RESTORE_NIC_WINS_IP, buf, sizeof(buf))==SUCCESS)
//        	Set_Profile_String(RESTORE_NIC_SECTION, RESTORE_NIC_WINS_IP, buf);
//	if (Conf_Get_Field(TMP_CONFIG_PATH, RESTORE_NIC_SECTION, RESTORE_NIC_WINS_ENABLED, buf, sizeof(buf))==SUCCESS)
//        	Set_Profile_String(RESTORE_NIC_SECTION, RESTORE_NIC_WINS_ENABLED, buf);
	if (Conf_Get_Field(TMP_CONFIG_PATH, RESTORE_NIC_SECTION, RESTORE_NIC_WAN_DHCP, buf, sizeof(buf))==SUCCESS)	
        	Set_Profile_String(RESTORE_NIC_SECTION, RESTORE_NIC_WAN_DHCP, buf);
//	if (Conf_Get_Field(TMP_CONFIG_PATH, RESTORE_NIC_SECTION, RESTORE_NIC_SLEEP, buf, sizeof(buf))==SUCCESS)
//        	Set_Profile_String(RESTORE_NIC_SECTION, RESTORE_NIC_SLEEP, buf);
//	if (Conf_Get_Field(TMP_CONFIG_PATH, RESTORE_NIC_SECTION, RESTORE_NIC_BONDING_SUPPORT, buf, sizeof(buf))==SUCCESS)
//        	Set_Profile_String(RESTORE_NIC_SECTION, RESTORE_NIC_BONDING_SUPPORT, buf);
	if (Conf_Get_Field(TMP_CONFIG_PATH, RESTORE_NIC_SECTION, RESTORE_NIC_BONDING01, buf, sizeof(buf))==SUCCESS)
		Set_Profile_String(RESTORE_NIC_SECTION, RESTORE_NIC_BONDING01, buf);
	if (Conf_Get_Field(TMP_CONFIG_PATH, RESTORE_NIC_SECTION, RESTORE_NIC_BONDING02, buf, sizeof(buf))==SUCCESS)
		Set_Profile_String(RESTORE_NIC_SECTION, RESTORE_NIC_BONDING02, buf);

	return SUCCESS;
}

int Restore_Network_NAT_Setting()
{
	char	buf[255];

// =========================================== uLinux.conf NAT section =============================================== //

//	if (Conf_Get_Field(TMP_CONFIG_PATH, RESTORE_NAT_SECTION, RESTORE_NAT_SUPPORT, buf, sizeof(buf))==SUCCESS)
//		Set_Profile_String(RESTORE_NAT_SECTION, RESTORE_NAT_SUPPORT, buf);
	if (Conf_Get_Field(TMP_CONFIG_PATH, RESTORE_NAT_SECTION, RESTORE_NAT_ENABLED, buf, sizeof(buf))==SUCCESS)
		Set_Profile_String(RESTORE_NAT_SECTION, RESTORE_NAT_ENABLED, buf);
	if (Conf_Get_Field(TMP_CONFIG_PATH, RESTORE_NAT_SECTION, RESTORE_NAT_VDMZ, buf, sizeof(buf))==SUCCESS)
		Set_Profile_String(RESTORE_NAT_SECTION, RESTORE_NAT_VDMZ, buf);
	if (Conf_Get_Field(TMP_CONFIG_PATH, RESTORE_NAT_SECTION, RESTORE_NAT_ICMP_REQUEST, buf, sizeof(buf))==SUCCESS)
		Set_Profile_String(RESTORE_NAT_SECTION, RESTORE_NAT_ICMP_REQUEST, buf);

	return SUCCESS;
}

int Restore_Network_EthX_Setting(char *eth_str)
{
	char	buf[255];

// =========================================== uLinux.conf eth# section =============================================== //

	if (Conf_Get_Field(TMP_CONFIG_PATH, eth_str, RESTORE_DEV_CONFIGURE, buf, sizeof(buf))==SUCCESS)
		Set_Profile_String(eth_str, RESTORE_DEV_CONFIGURE, buf);
	if (Conf_Get_Field(TMP_CONFIG_PATH, eth_str, RESTORE_DEV_USE_DHCP, buf, sizeof(buf))==SUCCESS)
		Set_Profile_String(eth_str, RESTORE_DEV_USE_DHCP, buf);
	if (Conf_Get_Field(TMP_CONFIG_PATH, eth_str, RESTORE_DEV_USAGE, buf, sizeof(buf))==SUCCESS)
		Set_Profile_String(eth_str, RESTORE_DEV_USAGE, buf);
	if (Conf_Get_Field(TMP_CONFIG_PATH, eth_str, RESTORE_DEV_IP, buf, sizeof(buf))==SUCCESS)
		Set_Profile_String(eth_str, RESTORE_DEV_IP, buf);
	if (Conf_Get_Field(TMP_CONFIG_PATH, eth_str, RESTORE_DEV_NETMASK, buf, sizeof(buf))==SUCCESS)
		Set_Profile_String(eth_str, RESTORE_DEV_NETMASK, buf);
	if (Conf_Get_Field(TMP_CONFIG_PATH, eth_str, RESTORE_DEV_BROADCAST, buf, sizeof(buf))==SUCCESS)
		Set_Profile_String(eth_str, RESTORE_DEV_BROADCAST, buf);
	if (Conf_Get_Field(TMP_CONFIG_PATH, eth_str, RESTORE_DEV_GATEWAY, buf, sizeof(buf))==SUCCESS)
		Set_Profile_String(eth_str, RESTORE_DEV_GATEWAY, buf);
	if (Conf_Get_Field(TMP_CONFIG_PATH, eth_str, RESTORE_DEV_BONDING, buf, sizeof(buf))==SUCCESS)
		Set_Profile_String(eth_str, RESTORE_DEV_BONDING, buf);
	
	return SUCCESS;
}


int Restore_Network_Setting()
{
	Restore_Network_NIC_Setting();					// [Network]
	Restore_Network_NAT_Setting();					// [NAT]
	
	Restore_Network_EthX_Setting(RESTORE_NIC_DEV01);		// [eth0]
	Restore_Network_EthX_Setting(RESTORE_NIC_DEV02);		// [eth1]
	if(3 == NIC_Count_Interface()) {
		Restore_Network_EthX_Setting(RESTORE_NIC_DEV03);	// [eth2]
	}
	return SUCCESS;
}

int Restore_All_Setting()
{
	system("/bin/rm -fr /etc/config/* 2> /dev/null");
	system("/bin/cp -a /tmp/etc/config/* /etc/config/ 2> /dev/null");
	
	return SUCCESS;					
}	

/*int Restore_All_Setting()
{
	int ret = ERROR_FAIL;
	
	ret = Restore_Usr_Grp_Setting();
	if(ret != SUCCESS) return ERROR_FAIL;
	
	ret = Restore_Storage_Setting();
	if(ret != SUCCESS) return ERROR_FAIL;
	
	ret = Restore_Share_Setting();
	if(ret != SUCCESS) return ERROR_FAIL;
	
	ret = Restore_HW_Setting();
	if(ret != SUCCESS) return ERROR_FAIL;
	
	ret = Restore_SYS_Setting();
	if(ret != SUCCESS) return ERROR_FAIL;
	
	ret = Restore_Network_Setting();
	if(ret != SUCCESS) return ERROR_FAIL;
	
	return SUCCESS;					
}	*/

int Misc_Restore_Profile(char* filename)
{
	int ret = ERROR_FAIL, ret1 = ERROR_FAIL;
	int restart_flag = 0;
	char buf[256]={0};
	int	find=0;

	ret = do_decode_profile(filename);

	if(is_sr_model()) {
		if(ret != ERROR_FAIL) { // Restore settings of NasWare v3.01 or later
			if((ret & 127) == 127) {	// All Settings
				Stop_Services();
				find=1;
				ret1 = Restore_All_Setting();
				if(ret1 != SUCCESS) return ERROR_FAIL;
				else {
					restart_flag = 1;
					goto restart;
				}	
			}
		}
		else {
			return ERROR_FAIL;
		}
	}
	else {
		return ERROR_FAIL;
	}
			
restart:

	if (find)
		Start_Services();
	system("/sbin/init_nas_cache");
	if(restart_flag == 1) {
		ret = SAVE_RESTORE_RESTART;
	}

	sprintf(buf, "/bin/rm -rf /tmp/etc > /dev/null");
	system(buf);
	return ret;	
}

/*int Misc_Restore_Profile(char* filename)
{
	int ret = ERROR_FAIL, ret1 = ERROR_FAIL;
	int restart_flag = 0;
	char buf[256]={0};
	int	find=0;

	ret = do_decode_profile(filename);

	if(is_sr_model()) {
		if(ret > SR_NONE_CONFIG) { // Restore settings of NasWare v3.00
			switch(ret) {
				case SR_USR_GRP_CONFIG:
                                        Stop_Services();
                                        find=1;
					ret = Restore_Usr_Grp_Setting();
					if(ret != SUCCESS) return ERROR_FAIL;
					else
						restart_flag = 1;	
					break;
				case SR_DISK_CONFIG:
	                                if (find==0)
        	                        {
                	                        Stop_Services();
                        	                find=1;
                                	}
					ret = Restore_Storage_Setting();
					if(ret != SUCCESS) return ERROR_FAIL;
					else
						restart_flag = 1;	
					break;
				case SR_NETWORK_CONFIG:
                                        if (find==0)
                                        {
                                                Stop_Services();                                                                                                      find=1;
                                        }
					ret=Restore_Network_Setting();
					if(ret != SUCCESS) return ERROR_FAIL;
					else
						restart_flag = 1;	
					break;
				case SR_SHARE_CONFIG:
                                        if (find==0)
                                        {
                                                Stop_Services();                                                                                                      find=1;
                                        }
					ret = Restore_Share_Setting();
					if(ret != SUCCESS) return ERROR_FAIL;
					else
						restart_flag = 1;	
					break;
				case SR_HARDWARE_CONFIG:
					ret = Restore_HW_Setting();
					if(ret != SUCCESS) return ERROR_FAIL;
					else
						restart_flag = 1;	
					break;
				case SR_SYSTEM_CONFIG:
                                        if (find==0)
                                        {
                                                Stop_Services();                                                                                                      find=1;
                                        }
					ret = Restore_SYS_Setting();
					if(ret != SUCCESS) return ERROR_FAIL;
					else
						restart_flag = 1;	
					break;
				case SR_ALL_CONFIG:
					Stop_Services();
					ret = Restore_All_Setting();
					Start_Services();
					if(ret != SUCCESS) return ERROR_FAIL;
					else
						restart_flag = 1;	
					break;
				default:
					return ERROR_FAIL;
			}
			
		}
		else if(ret != ERROR_FAIL) { // Restore settings of NasWare v3.01 or later
			if((ret & 127) == 127) {	// All Settings
				Stop_Services();
				find=1;
				ret1 = Restore_All_Setting();
				if(ret1 != SUCCESS) return ERROR_FAIL;
				else {
					restart_flag = 1;
					goto restart;
				}	
			}
			if((ret & 64) == 64) {	// Firewall Settings has not been implemented yet.
				      		// So this item will be ignored while restoring.
			}
			if((ret & 32) == 32) {	// Network Configuration
				if (find==0)
				{
					Stop_Services();
					find=1;
				}
				ret1 = Restore_Network_Setting();
				find=1;
				if(ret1 != SUCCESS) return ERROR_FAIL;
				else
					restart_flag = 1;	
			}
			if((ret & 16) == 16) {	// System Settings
				if (find==0)
				{
					Stop_Services();
					find=1;
				}
				ret1 = Restore_SYS_Setting();
				find=1;
				if(ret1 != SUCCESS) return ERROR_FAIL;
				else
					restart_flag = 1;	
			}
			if((ret & 8) == 8) {	// Hardware Settings
				ret1 = Restore_HW_Setting();
				if(ret1 != SUCCESS) return ERROR_FAIL;
				else
					restart_flag = 1;	
			}
			if((ret & 4) == 4) {	// Network Share Settings
				if (find==0)
				{
					Stop_Services();
					find=1;
				}
				ret1 = Restore_Share_Setting();
				if(ret1 != SUCCESS) return ERROR_FAIL;
				else
					restart_flag = 1;	
			}
			if((ret & 2) == 2) {	// Disk Configuration
				if (find==0)
				{
					Stop_Services();
					find=1;
				}
				ret1 = Restore_Storage_Setting();
				if(ret1 != SUCCESS) return ERROR_FAIL;
				else
					restart_flag = 1;	

			}
			if((ret & 1) == 1) {		// User / User Group Settings
				if (find==0)
				{
					Stop_Services();
					find=1;
				}
				ret1 = Restore_Usr_Grp_Setting();
				if(ret1 != SUCCESS) return ERROR_FAIL;
				else
					restart_flag = 1;	
			}
		}
		else {
			return ERROR_FAIL;
		}
	}
	else {
		return ERROR_FAIL;
	}
			
restart:

	if (find)
		Start_Services();
	system("/sbin/init_nas_cache");
	if(restart_flag == 1) {
		ret = SAVE_RESTORE_RESTART;
	}

	sprintf(buf, "/bin/rm -rf /tmp/etc > /dev/null");
	system(buf);
	return ret;	
}*/

int Misc_Save_Profile(int nSave_type)
{
	int save_no = 0, ret = ERROR_FAIL;
	char buf[512];
	FILE *fp = NULL;
	
	sprintf(buf, "/bin/rm -f /home/httpd/%s > /dev/null", BACKUPDATA);
	system(buf);

	sprintf(buf, "/bin/tar czf /home/httpd/%s", BACKUPDATA);
	strcat(buf," /etc/config/*");
	save_no = 127; 
	// open a file, "save_no.conf" to store the save_no for restoring reference
	if((fp = fopen("/etc/save_no.conf", "w+")) == NULL) {
		return ERROR_FAIL;
	}
	else {
		fprintf(fp, "%d\n", save_no);
		fclose(fp);
	}
	
	strcat(buf," /etc/save_no.conf 2>/dev/null 1>/dev/null");
	
	ret = system(buf);
	if(ret != 0) return ERROR_FAIL; 
	
	// for NasWare v3.01 or later 
	ret = do_encode_profile(BACKUPDATA);
	if(!ret) return ERROR_FAIL; 
	
	printf("%s",HTTP_HEAD_STATUS);
	printf("Location: /%s\r\n\r\n", BACKUPDATA);
	return SUCCESS;
}

/*int Misc_Save_Profile(int nSave_type)
{
	int save_no = 0, ret = ERROR_FAIL;
	char buf[512];
	FILE *fp = NULL;
	// The flags of settings :
	int uugflag; // uugflag : User / User Group
	int dskflag; // dskflag : DiSK
	int nwsflag; // nwsflag : NetWork Share
	int hdwflag; // hdwflag : HarDWare
	int sysflag; // sysflag : SYStem
	int nicflag; // nicflag : Network
	int frwflag; // frwflag : FiReWall
	
	uugflag = dskflag = nwsflag = hdwflag = sysflag = nicflag = frwflag = 0;

	sprintf(buf, "/bin/rm -f /home/httpd/%s > /dev/null", BACKUPDATA);
	system(buf);

	sprintf(buf, "/bin/tar czf /home/httpd/%s", BACKUPDATA);
	
	if((nSave_type & 1) == 1) {		// User / User Group Settings
		strcat(buf, " /etc/passwd /etc/group /etc/nfs.conf /etc/config/nwpwd /etc/config/smbpasswd /etc/config/smbusers /etc/config/usr_quota.conf /etc/config/uLinux.conf");
		uugflag = 1;
	}
	if((nSave_type & 2) == 2) {	// Disk Configuration
		strcat(buf," /etc/raidtab /etc/config/uLinux.conf "
			"/etc/config/storage.conf");
		dskflag = 2;
	}
	if((nSave_type & 4) == 4) {	// Network Share Settings
		strcat(buf," /etc/config/smb.conf /etc/config/uLinux.conf");
		nwsflag = 4;
	}
	if((nSave_type & 8) == 8) {	// Hardware Settings
		strcat(buf," /etc/config/uLinux.conf");
		hdwflag = 8;
	}
	if((nSave_type & 16) == 16) {	// System Settings
		strcat(buf," /etc/config/uLinux.conf");
		sysflag = 16;
	}
	if((nSave_type & 32) == 32) {	// Network Configuration
		strcat(buf," /etc/config/uLinux.conf");
		nicflag = 32;
	}

	frwflag = 64; // Firewall Settings has not been implemented yet.
		      // So this item will be ignored while restoring.

//	if((nSave_type & 64) == 64) {	// Firewall Settings
//		// Not been implemented yet
//		frwflag = 64;
//	}
	
	save_no = uugflag + dskflag + nwsflag + hdwflag + sysflag + nicflag + frwflag; 
	// open a file, "save_no.conf" to store the save_no for restoring reference
	if((fp = fopen("/etc/save_no.conf", "w+")) == NULL) {
		return ERROR_FAIL;
	}
	else {
		fprintf(fp, "%d\n", save_no);
		fclose(fp);
	}
	
	strcat(buf," /etc/save_no.conf 2>/dev/null 1>/dev/null");
	
	ret = system(buf);
	if(ret != 0) return ERROR_FAIL; 
	
	// for NasWare v3.00 
	//do_encode_profile(BACKUPDATA, nSave_type);
	
	// for NasWare v3.01 or later 
	ret = do_encode_profile(BACKUPDATA);
	if(!ret) return ERROR_FAIL; 
	
	printf("%s",HTTP_HEAD_STATUS);
	printf("Location: /%s\r\n\r\n", BACKUPDATA);
	return SUCCESS;
}*/

void clear_update_tmp_data()
{
	char buf[BUF_SIZE];

	if(Is_HD_Ready(1)){
		sprintf(buf, "/bin/rm -rf /mnt/HDA_ROOT/update");
		system(buf);	
	}
	else {
		sprintf(buf, "/bin/umount %s > /dev/null", BACKUP_UPLOAD_WORKING_DIR);
		system(buf);	
	}
}

