//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		cfg_samba.c
//
//	Abstract: 
//		System configuration Access Functions.
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		12/06/00	kw lee created
//		08/18/01	Check network enabled first Is_Samba_Enable()
//
//**************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include "Util.h"
#include "cfg_samba.h"
#include "nas_quota.h"
#include "NAS.h"
#include "naspdc.h"

/* ------------------------------------------------------------------------- **
 * Build options...
 */

//#define CFG_SYSTEM_TEST		// Build as a standalone program (with main), for testing only...



/* ------------------------------------------------------------------------- **
 * Constants...
 */



/* ------------------------------------------------------------------------- **
 * Variables...
 *
 *  bufr        - pointer to a global buffer.  This is probably a kludge,
 *                but it was the nicest kludge I could think of (for now).
 *  bSize       - The size of the global buffer <bufr>.
 */






/* ------------------------------------------------------------------------- */
/*         		Function Implementation                              */
/* ------------------------------------------------------------------------- */

// 2001/5/2 Louis Tsai mark redefine constant
#ifndef SAMBA_CONF_PATH
	#define	SAMBA_CONF_PATH			"/etc/config/smb.conf"
#endif
#define SAMBA3

#define	SZ_SAMBA_SECTION		"Samba"
#define	SZ_ENABLE_FIELD			"Enable"

BOOL is_samba_started();
int restart_samba();
int stop_samba();
int set_samba_netbios_name(char *name);
int set_samba_wrokgroup_name(char *workgroup);
int set_samba_codepage(char *cp_str);
int set_samba_server_string(char *svr_str);
int set_samba_WINS_server(char *wins_ip);
int set_samba_WINS_support(int bEnable);
int get_samba_WINS_support();

/*
 * Check Samba enabled
 * Return:
 *	true	Enabled			
 *	false	Disabled
 */
BOOL Is_Samba_Enabled()
{
	char buf[BUF_SIZE];

	// network disabled, samba will disable by default
	if(!Is_Network_Started())
		return FALSE;
	GetProfileString(SZ_SAMBA_SECTION, SZ_ENABLE_FIELD, "TRUE", buf, sizeof(buf));
	return NOT_FALSE(buf);
}

/*
 * Enable Samba
 * Return:
 *	0		pass	
 *  ERROR_WRITE_FILE	can not write to config file
 *	others	fail, according to samba's report
 */
int Enable_Samba(int bEnable)
{
	int val, ret = SUCCESS;

	val = WriteProfileString(SZ_SAMBA_SECTION, SZ_ENABLE_FIELD, BOOL2STR(bEnable));
	if(!val)
		return ERROR_WRITE_FILE;
	if (bEnable) {
		//John modified 2001-10-18:
		//if (!is_samba_started()) ret = restart_samba();	 
		if(!is_samba_started())
			if(!restart_samba())	ret = ERROR_FAIL;
	}
	else {
		//John modified 2001-10-18:
		//ret = stop_samba();
		if(!stop_samba())	ret = ERROR_FAIL;
	}
	return ret;
}

// Add by DavidYang 2001/8/24
/*
 * Refresh Samba
 * Return:
 *	0		pass	
 *	others	fail, according to system report
 */
 int Refresh_Samba()
{
	int ret = system("/bin/kill -HUP `/sbin/pidof smbd` 2>/dev/null 1>/dev/null");
	ret = system("/bin/kill -HUP `/sbin/pidof nmbd` 2>/dev/null 1>/dev/null");
	return ret;
}
// End of Add

BOOL is_samba_started()
{
 	return ((system("/sbin/pidof smbd > /dev/null") == 0) && (system("/sbin/pidof smbd > /dev/null") == 0));
}

int restart_samba()
{
	int ret = system("/etc/init.d/smb.sh restart");
	//John modified 2001-10-18:
	//return ret;
	return (ret == 0);
}

int stop_samba()
{
	int ret = system("/etc/init.d/smb.sh stop");
	//John modified 2001-10-18:
	//return ret;
	return (ret == 0);
}


int set_samba_netbios_name(char *name)
{
#ifdef SAMBA3
	return 0;
#else
	int ret = WritePrivateProfileString("global", "Netbios name", name, SAMBA_CONF_PATH);
	// if samba not started, leave it untouched
	if(!is_samba_started())
		return ret;
	// restart samba to make the change effective...
	if (Is_Samba_Enabled()) restart_samba();
	return ret;
#endif
}


int set_samba_wrokgroup_name(char *workgroup)
{
#ifdef SAMBA3
	return 0;
#else
	int ret = WritePrivateProfileString("global", "workgroup", workgroup, SAMBA_CONF_PATH);
	// restart samba to make the change effective...
	if (Is_Samba_Enabled()) restart_samba();
	return ret;
#endif
}

int set_samba_codepage(char *cp_str)
{
	char character_set[20]={""};

#ifdef SAMBA3
	int ret = 0;

	if (!strcmp(cp_str, "999"))
		ret = WritePrivateProfileString("global", "dos charset", "UTF8", SAMBA_CONF_PATH);
	else if (!strcmp(cp_str, "437"))
		ret = WritePrivateProfileString("global", "dos charset", "ASCII", SAMBA_CONF_PATH);
	else if (!strcmp(cp_str, "852"))
		ret = WritePrivateProfileString("global", "dos charset", "ISO8859-2", SAMBA_CONF_PATH);
	else if (!strcmp(cp_str, "737"))
		ret = WritePrivateProfileString("global", "dos charset", "ISO8859-7", SAMBA_CONF_PATH);
	else if (!strcmp(cp_str, "861") || !strcmp(cp_str, "850"))
		ret = WritePrivateProfileString("global", "dos charset", "ISO8859-1", SAMBA_CONF_PATH);
	else
	{
		sprintf(character_set, "CP%s", cp_str);
		ret = WritePrivateProfileString("global", "dos charset", character_set, SAMBA_CONF_PATH);
	}

	if (Is_Samba_Enabled())
		Refresh_Samba();
	return ret;
#else
	int ret = WritePrivateProfileString("global", "client code page", cp_str, SAMBA_CONF_PATH);

// add by Kent 2003/08/11
        if (!strcmp(cp_str, "850"))
                strcpy(character_set, "ISO8859-1");
        else
        if (!strcmp(cp_str, "852"))
                strcpy(character_set, "ISO8859-2");
        else
        if (!strcmp(cp_str, "866"))
                strcpy(character_set, "ISO8859-5");
        else
        if (!strcmp(cp_str, "737"))
                strcpy(character_set, "ISO8859-7");
        WritePrivateProfileString("global", "character set", character_set, SAMBA_CONF_PATH);
// end
#endif
	// restart samba to make the change effective...
	if (Is_Samba_Enabled()) restart_samba();
	return ret;
}

int set_samba_server_string(char *svr_str)
{
#ifdef SAMBA3
	return 0;
#else
	int ret = WritePrivateProfileString("global", "server string", svr_str, SAMBA_CONF_PATH);
	// restart samba to make the change effective...
	if (Is_Samba_Enabled()) restart_samba();
	return ret;
#endif
}


int set_samba_WINS_server(char *wins_ip)
{
#ifdef SAMBA3
	return 0;
#else
	int	ret;

	if (*wins_ip==0x0)
	{	/* disable wins server, so remove wins field	*/
		ret=Conf_Remove_Field(SAMBA_CONF_PATH, "global", "wins server");
		return ret;
	}
	ret=WritePrivateProfileString("global", "wins server", wins_ip, SAMBA_CONF_PATH);
	// restart samba to make the change effective...
	if (Is_Samba_Enabled())
		restart_samba();
	Refresh_Samba();
	return ret;
#endif
}

int set_samba_WINS_support(int bEnable)
{
#ifdef SAMBA3
	return 0;
#else
	int	ret;

	if (bEnable)
		ret=WritePrivateProfileString("global", "wins support", "yes", SAMBA_CONF_PATH);
	else
		ret=WritePrivateProfileString("global", "wins support", "no", SAMBA_CONF_PATH);
	ret=WriteProfileString("Network", "WINS Support", BOOL2STR(bEnable));
	// restart samba to make the change effective...
	if (Is_Samba_Enabled())
		restart_samba();
	Refresh_Samba();
	return ret;
#endif
}

int get_samba_WINS_support()
{
	int	ret;
	char	buf[80];

	ret=GetProfileString("Network", "WINS Support", "FALSE", buf, 80);
	if (!strcasecmp(buf, "TRUE"))
		return 1;
	else
		return 0;
}

int Run_Samba3(MS_Net_Type type, char* Domain_Name, char* username, char* passwd)
{
	char	ms_cmdline[256];
	int	ret = SMB3_SUCCESS;

	switch (type) {
		case	STANDALONE:
			sprintf(ms_cmdline, "%s ALONE \"%s\" 1>/dev/null 2>/dev/null", SETUP_SMB_SH, Domain_Name);
			ret = system(ms_cmdline) >> 8;
			// 2004.12.09, Johnson Cheng
			// Remove all domain users privilege from share folders
			if (Remove_Domain_User_Share_Privilege() < 0)
						fprintf(stderr, "Remove all domain users and groups failed !\n");
			break;
		case	ADDM:
			sprintf(ms_cmdline, "%s ADM \"%s\" \"%s\" \"%s\" 1>/dev/null 2>/dev/null", 
					SETUP_SMB_SH, Domain_Name, username, passwd);
			ret = system(ms_cmdline) >> 8;
			break;
		case	NTDC:
			break;
		case	NTDM:
			sprintf(ms_cmdline, "%s NTM \"%s\" \"%s\" \"%s\" 1>/dev/null 2>/dev/null", 
					SETUP_SMB_SH, Domain_Name, username, passwd);
			ret = system(ms_cmdline) >> 8;
			break;
		default:
			ret = SMB3_USAGE_ERROR;
	}
	return ret;
}

int Get_Samba3_WINS_Srv(BOOL *Srv_Enable)
{
//#if 0
	char	buf[9];
	
	Get_Private_Profile_String("global", "wins support", "no", buf, 9, SAMBA_CONF_PATH);
	if ( !strcasecmp(buf,"yes") )
		*Srv_Enable = TRUE;
	else
		*Srv_Enable = FALSE;
//#else
//	*Srv_Enable = FALSE;
//#endif
	return 0;
}

int Set_Samba3_WINS_Srv(BOOL Srv_Enable)
{
//#if 0
	if ( Srv_Enable ) {
		Set_Private_Profile_String("global", "wins support", "yes", SAMBA_CONF_PATH);
		Conf_Remove_Field(SAMBA_CONF_PATH, "global", "wins server");
	} else
		Set_Private_Profile_String("global", "wins support", "no", SAMBA_CONF_PATH);
//#endif
	return 0;
}

int Get_Samba3_WINS(BOOL *checked, char *WINS_IP)
{
//#if 0
	char	buf[16];
	BOOL	Srv_Enable = FALSE;
	BOOL	WinsEnable = FALSE;
	
	Get_Samba3_WINS_Srv(&Srv_Enable);
	if ( Conf_Get_Field(SAMBA_CONF_PATH, "global", "wins server", buf, 16) != ERROR_NOT_FOUND ) WinsEnable = TRUE;
	Get_Private_Profile_String("global", "wins server", "0.0.0.0", buf, 16, SAMBA_CONF_PATH);
	if ((Srv_Enable==FALSE) && (WinsEnable==TRUE)) *checked = TRUE;
	else *checked = FALSE;
	strcpy(WINS_IP, buf);
//#else
//	strcpy(WINS_IP, "0.0.0.0");
//	*checked = FALSE;
//#endif
	return 0;
}

int Set_Samba3_WINS(BOOL checked, char *WINS_IP)
{
//#if 0
	if ( checked ) {
		Set_Private_Profile_String("global", "wins support", "no", SAMBA_CONF_PATH);
		Set_Private_Profile_String("global", "wins server", WINS_IP, SAMBA_CONF_PATH);
	} else {
//		Set_Private_Profile_String("global", "wins support", "yes", SAMBA_CONF_PATH);
		Conf_Remove_Field(SAMBA_CONF_PATH, "global", "wins server");
	}
//#endif
	return 0;
}

#if 0
// Not necessary, since smb.conf has no section to record them
int Get_Samba3_Domain_User_Passwd(char *Uname, char *Passwd)
{
	char	buf[129];
	int	ret = SMB3_SUCCESS;
	
	if ( (ret = GetProfileString("System", "Domain User Name", "", buf, 129)) >= 0 )
		strcpy(Uname, buf);
	else {
		*Uname = '\0';
		return ret;
	}
	
	if ( (ret = GetProfileString("System", "Domain User Password", "", buf, 129)) >= 0 )
		strcpy(Passwd, buf);
	else {
		*Passwd = '\0';
		return ret;
	}
	
	return ret;
}

int Set_Samba3_Domain_User_Passwd(char *Uname, char *Passwd)
{
	int	ret = SMB3_SUCCESS;

	if ( (ret = WriteProfileString("System", "Domain User Name", Uname)) == 0 )
		ret = WriteProfileString("System", "Domain User Password", Passwd);

	return ret;

}
#endif

int Get_Samba3_Domain_Name(char *Dname)
{
	char	buf[BUF_SIZE];
	int	ret = SMB3_SUCCESS;
	
	if ( (ret = Get_Private_Profile_String("global", "realm", "", buf, BUF_SIZE, SAMBA_CONF_PATH)) >= 0 )
		strcpy(Dname, buf);
	else
		*Dname = '\0';
	
	return ret;
}

int Set_Samba3_Domain_Name(char *Dname)
{
	//return Set_Private_Profile_String("global", "realm", Dname, SAMBA_CONF_PATH);
	return 0;
}

int Get_Samba3_Workgroup_Name(char *Wname)
{
	char	buf[BUF_SIZE];
	int	ret = SMB3_SUCCESS;
	
	if ( (ret = Get_Private_Profile_String("global", "workgroup", "", buf, BUF_SIZE, SAMBA_CONF_PATH)) >= 0 )
		strcpy(Wname, buf);
	else
		*Wname = '\0';
	
	return ret;
}

int Set_Samba3_Workgroup_Name(char *Wname)
{
	//return Set_Private_Profile_String("global", "workgroup", Wname, SAMBA_CONF_PATH);
	return 0;
}

int Get_Samba3_Description(char *Dstr)
{
	char	buf[BUF_SIZE];
	int	ret = SMB3_SUCCESS;
	
	if ( (ret = Get_Private_Profile_String("global", "server string", "", buf, BUF_SIZE, SAMBA_CONF_PATH)) >= 0 )
		strcpy(Dstr, buf);
	else
		*Dstr = '\0';
	
	return ret;
}

int Set_Samba3_Description(char *Dstr)
{
	/* Add by Nike Chen 07/07/2004 */
	Set_Private_Profile_String("system", "Server comment", Dstr, "/etc/config/uLinux.conf");
	return Set_Private_Profile_String("global", "server string", Dstr, SAMBA_CONF_PATH);
}

int Get_MS_Server_Type(MS_Net_Type *type)
{
	char	buf[32];
	int	ret = SMB3_SUCCESS;
#if 0	
	if ( (ret = GetProfileString("System", "Server Type", "", buf, 32)) >= 0 ) {
		if ( !strcmp(buf, MS_TYPE_STANDALONE) )
			*type = STANDALONE;
		else if ( !strcmp(buf, MS_TYPE_NTDC) )
			*type = NTDC;
		else if ( !strcmp(buf, MS_TYPE_NTDM) )
			*type = NTDM;
		else if ( !strcmp(buf, MS_TYPE_ADDM) )
			*type = ADDM;
		else
			*type = STANDALONE;
	} else
		*type = STANDALONE;
#endif
	if ( (ret = Get_Private_Profile_String("global", "security", "", buf, 32, SAMBA_CONF_PATH)) >= 0 ) {
		if ( !strcasecmp(buf, "USER") )
			*type = STANDALONE;
		/*
		else if ( !strcmp(buf, MS_TYPE_NTDC) )
			*type = NTDC;
		*/
		else if ( !strcasecmp(buf, "DOMAIN") )
			*type = NTDM;
		else if ( !strcasecmp(buf, "ADS") )
			*type = ADDM;
	}

	return ret;
}

int Set_MS_Server_Type(MS_Net_Type type)
{
	char	buf[64];
	
	switch (type) {
		case	STANDALONE:
			strcpy(buf, "USER");
			break;
		case	NTDC:
			strcpy(buf, MS_TYPE_NTDC);
			break;
		case	NTDM:
			strcpy(buf, "DOMAIN");
			break;
		case	ADDM:
			strcpy(buf, "ADS");
			break;
		default:
			return -1;
	}
	//return Set_Private_Profile_String("global", "security", buf, SAMBA_CONF_PATH);
	return 0;
}

int Set_AD_User_Quota()
{
	int i=0,j,qenable;
	unsigned long quota;
	char (*user_list)[USER_NAME_LENGTH];
	
	qenable = Is_User_Quota_Enabled(&quota);
	i = Get_NAS_User_List_Ex(&user_list);

	for (j=0; j<i; j++) {
		if(!IsLocalUser(user_list[j]))
		{
			Set_One_User_Quota(user_list[j], quota, 0, 0);
		}
	}
	free(user_list);
	return i;
}
