#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/mount.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
/* include NAS */
#include <eventlog.h>
#include <NAS.h>
#include "cfg_rsync.h"
#include "backup.h"
#include "Util.h"
#include "cfg_system.h"
#define	MAX_BUF_SIZE	1500

#define __dbg(format, arg...)            \
        do {\
	        FILE *fp; \
	        fprintf(stdout,format , ## arg); \
	        fp = fopen("/debug","a+"); \
	        fprintf(fp, format , ## arg); \
	        fclose(fp); \
	} while (0);


static char	RSYNC_CMD[32]="/usr/bin/rsync ";

void rsync_cleanup_tmp_crontab(char* tmpfile)
{
	char	cmd[1024]="", file[32]="";
	int	ret = 0;
	
	sprintf(file, "/tmp/%u.%lu", (unsigned)getpid(), (unsigned long)time(NULL));
	sprintf(cmd, "/bin/sed -e '/Schedule/d' /etc/config/crontab > %s", file);
	ret = system(cmd) >> 8;
	if ( ret == 0 )
		strcpy(tmpfile, file);
}

void rsync_update_crontab(char* tmpfile)
{
	char	cmd[1024]="";
	int	ret = 0;
	
	sprintf(cmd, "/bin/cp -f %s /etc/config/crontab 1>/dev/null 2>/dev/null", tmpfile);
	ret = system(cmd) >> 8;
	unlink(tmpfile);
}

void rsync_write_tmp_crontab(BACKUP_SCHEDULE *schedule, char* tmpfile)
{
	char	cmd[256]="";
	int	min=0, hour=0, dom=1, dow=0;
	int	ret = 0;

	switch(schedule->t_type) {
		case	BK_IMMEDIATELY:
			return;
			break;
		case	BK_DAY:
			//m h dom mon dow user command
			min = schedule->t_min;
			hour = schedule->t_hour;
			sprintf(cmd, "echo \"%d %d * * * /etc/init.d/rsyncRR.sh Schedule%d 2>/dev/null\" >> %s 2>/dev/null", 
				min, 
				hour, 
				schedule->bk_pid, 
				tmpfile);
			break;
		case	BK_WEEK:
			//m h dom mon dow user command
			min = schedule->t_min;
			hour = schedule->t_hour;
			dow = (schedule->week)%7;
			sprintf(cmd, "echo \"%d %d * * %d /etc/init.d/rsyncRR.sh Schedule%d 2>/dev/null\" >> %s 2>/dev/null", 
				min, 
				hour, 
				dow, 
				schedule->bk_pid, 
				tmpfile);
			break;
		case	BK_MONTH:
			//m h dom mon dow user command
			min = schedule->t_min;
			hour = schedule->t_hour;
			dom = schedule->month;
			sprintf(cmd, "echo \"%d %d %d * * /etc/init.d/rsyncRR.sh Schedule%d 2>/dev/null\" >> %s 2>/dev/null", 
				min, 
				hour, 
				dom, 
				schedule->bk_pid, 
				tmpfile);
			break;
	}
	ret = system(cmd) >> 8;
}

void DEBUG_rsync_Schedule(BACKUP_SCHEDULE *schedule)
{
	while (schedule!=NULL)
	{
		fprintf(stdout, "#######################<br>\n");fflush(stdout);
		fprintf(stdout, "schedule->name=[%s]<br>\n", schedule->name);fflush(stdout);
		fprintf(stdout, "schedule->bk_pid=[%d]<br>\n", schedule->bk_pid);fflush(stdout);
		fprintf(stdout, "schedule->policy=[%d]<br>\n", schedule->policy);fflush(stdout);
		fprintf(stdout, "schedule->usage=[%d]<br>\n", schedule->usage);fflush(stdout);
		fprintf(stdout, "schedule->remote.volume=[%s]<br>\n", schedule->remote.volume);fflush(stdout);
		fprintf(stdout, "schedule->remote.path=[%s]<br>\n", schedule->remote.path);fflush(stdout);
		fprintf(stdout, "schedule->local.volume=[%s]<br>\n", schedule->local.volume);fflush(stdout);
		fprintf(stdout, "schedule->local.path=[%s]<br>\n", schedule->local.path);fflush(stdout);
		fprintf(stdout, "schedule->cifs.server.location=[%s]<br>\n", schedule->cifs.server.location);fflush(stdout);
		fprintf(stdout, "schedule->cifs.user.name=[%s]<br>\n", schedule->cifs.user.name);fflush(stdout);
		fprintf(stdout, "schedule->cifs.user.passwd=[%s]<br>\n", schedule->cifs.user.passwd);fflush(stdout);
		fprintf(stdout, "schedule->nfs.server.location=[%s]<br>\n", schedule->nfs.server.location);fflush(stdout);
		fprintf(stdout, "schedule->t_type=[%d]<br>\n", schedule->t_type);fflush(stdout);
		fprintf(stdout, "schedule->week=[%d]<br>\n", schedule->week);fflush(stdout);
		fprintf(stdout, "schedule->month=[%d]<br>\n", schedule->month);fflush(stdout);
		fprintf(stdout, "schedule->t_hour=[%d]<br>\n", schedule->t_hour);fflush(stdout);
		fprintf(stdout, "schedule->t_min=[%d]<br>\n", schedule->t_min);fflush(stdout);
		fprintf(stdout, "schedule->status=[%d]<br>\n", schedule->status);fflush(stdout);
		fprintf(stdout, "schedule->latest_time=[%ld]<br>\n", schedule->latest_time);fflush(stdout);
		schedule=(BACKUP_SCHEDULE *)schedule->next;
	}
}

int rsync_get_remote_server_share_list(char *server_ip, int port, char ***share_list)
{
	char		buf[1024];
	char		line[1024];
	FILE		*fp, *tmpfp;
	int		count = 0;
	int		error_num;
	char		**tmp_list = NULL;
	
	if ( *share_list ) {
		free(*share_list);
		*share_list=NULL;
	}
	
	sprintf(buf, "%s --port=%d %s:: 2>/dev/null || echo \"**$?\"", 
		RSYNC_CMD, port, server_ip);
	fp = popen(buf, "r");
	tmpfp = tmpfile();

	while (1)
	{
		fgets(line, 1024, fp);
		fputs(line, tmpfp);
		count++;
		line[0] = 0;
		if ( feof(fp) )
			break;
	}
	
	pclose(fp);
	rewind(tmpfp);
	tmp_list = (char **)calloc(count, sizeof(char*));
	count = 0;

	while (1)
	{
		int	i=0;
		int	ret = 0;

		bzero(line, 1024);
		fgets(line, 1024, tmpfp);
		if ( line[0] == 0 )
			break;

		if ( line[0] == '*' ) {
			//Error happens
			error_num = atoi((char*)&line[2]);
			goto err_return;
		}

		//translate_str(line);
		i = strlen(line);
		
		while( 1 ) {
			if ( i >= 1 && (line[i-1] == ' ' || line[i-1] == '\n' || line[i-1] == '\r' || line[i-1] == '\t') ) {
				i--;
			} else {
				line[i] = 0;
				break;
			}
		}
		
		sprintf(buf, "%s --port=%d --dry-run %s::\"%s\" 1>>/dev/null 2>/dev/null", 
			RSYNC_CMD, port, server_ip, line);
		ret = system(buf);
		ret = ret >> 8;
		if ( ret )
			continue;

		tmp_list[count] = (char *)calloc(i+2, sizeof(char));
		/*if (!tmp_list[count])
			printf("Failed!!! %s:%d<br>\n", __FILE__, __LINE__);
		*/
		strcpy(tmp_list[count], line);

		count ++;
		if ( feof(tmpfp) )
			break;
	}
	fclose(tmpfp);
	*share_list=tmp_list;

	return count;
err_return:
	fclose(tmpfp);
	return -1;
	
}

// 2005.11.30, Johnson Cheng
// Nerver need it because of no nasrpc file
/*int rsync_Get_Server(char *ipaddr, int len, char *source)
{
        char            nasrpc[]={"/usr/local/samba/sbin/nasrpc"};
        char            output[]={"/tmp/smbserver"};
        char            cmd[256], *ptr1, *ptr2;
        FILE            *fptr;
        struct in_addr  inp;

        if (inet_aton(source, &inp)!=0)
        {
                strcpy(ipaddr, source);
                return 1;
        }
        ipaddr[0]=0x0;
        sprintf(cmd, "%s -7 -s %s > %s", nasrpc, source, output);
        system(cmd);
        if ((fptr=fopen(output, "rb"))==NULL)
                return 0;
        fgets(ipaddr, len, fptr);
        if (strstr(ipaddr, "@@error@@")!=NULL)
        {
                ipaddr[0]=0x0;
                fclose(fptr);
                return 0;
        }
        fclose(fptr);
	ipaddr[strlen(ipaddr)-3]=0x0;
	ptr1=ipaddr+2;
	ptr2=ipaddr;
	while (*ptr1!=0x0)
		*ptr2++=*ptr1++;
	*ptr2=0x0;
        return 1;
}*/


int rsync_Update_Status(BACKUP_SCHEDULE *schedule, int status)
{
	char	buf[32]="";
	char	schname[32]="";
	//BACKUP_SCHEDULE new;
	//int		ret;

	//memcpy(&new, schedule, sizeof(BACKUP_SCHEDULE));
	//new.status=status;
	//ret=rsync_Ren_Schedule(&new, schedule);
	schedule->status=status;
	sprintf(schname, "Schedule%d", schedule->bk_pid);
	sprintf(buf, "%d", status);
	Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Status", buf);
	return 1;
}

int backup_via_rsync(BACKUP_SCHEDULE *schedule)
{
	char	buf[128];
	char	cmd[2048];
	int	ret=BACKUP_SUCCESS;

#if 0
	char	options[64]="";
	char	local_path[1024], remote_path[1024];
	char	buf[MAX_BUF_SIZE]="";

	Conf_Get_Field(SAMBA_CONF_PATH, schedule->local.volume, "path", buf, MAX_BUF_SIZE);
	if ( strlen(buf) < 16 )
		return BACKUP_FAIL;
	buf[15]='\0';	// /share/XXX_DATA/
	if ( chdir(buf) )
		return BACKUP_FAIL;

	if ( strlen(schedule->local.path) > 1 ) {
		if ( chdir(schedule->local.volume) )
			return BACKUP_FAIL;
		sprintf(local_path, "%s", schedule->local.path);
	} else {
		sprintf(local_path, "%s", schedule->local.volume);
	}

	if ( strlen(schedule->remote.path) > 1 ) {
		sprintf(remote_path, "%s%s", schedule->remote.volume, schedule->remote.path);
	} else {
		sprintf(remote_path, "%s", schedule->remote.volume);
	}

//        if (rsync_Get_Server(server, 256, schedule->cifs.server.location)==0)
//                return BK_SERVER_NOT_FOUND;

	if ( schedule->option & BACKUP_COPY_COMPRESS ) {
		strcat(options, "--compress ");
	} else if ( schedule->option & BACKUP_COPY_SYNC ) {
		strcat(options, "--delete ");	
	} else if ( schedule->option & BACKUP_COPY_STOP_SERVICE ) {
		Stop_Services();
	} else if ( !(schedule->option & BACKUP_COPY_TIMESTAMP) ) {
		strcat(options, "--whole-file ");
	}

	sprintf(cmd, "%s -a %s --timeout=30 --port=%d \"%s\" %s::\"%s\" 1>/dev/null 2>/dev/null", 
		RSYNC_CMD, 
		options, 
		873, 
		local_path, 
		schedule->cifs.server.location, 
		remote_path
		);
#else
	sprintf(cmd, "/etc/init.d/rsyncRR.sh Schedule%d", schedule->bk_pid);
#endif
/*{
	char	XXX[2048];
	
	sprintf(XXX, "echo \"cmd=%s.%s:%s:%d<br>\" >>/tmp/a.txt", cmd, __FILE__, __FUNCTION__, __LINE__);
	system(XXX);
}*/
	ret = system(cmd);
	ret = ( ret >> 8 );	// let /etc/init.d/rsyncRR.sh do the job, so always ignore ret
	schedule->latest_time = time(NULL);
	
	if ( schedule->option & BACKUP_COPY_STOP_SERVICE )
		Start_Services();

	sprintf(buf, "Schedule%d", schedule->bk_pid);
	return Get_Private_Profile_Integer(buf, "status", 0, RSYNC_SCHEDULE_CONF);
}

BACKUP_SCHEDULE *rsync_Get_Schedule()
{
        BACKUP_SCHEDULE		*start=NULL, *schedule=NULL;
	int			count = 0, no = 0;
	char			buf[MAX_BUF_SIZE]="";
	
	Conf_Get_Field(RSYNC_SCHEDULE_CONF, "Global", "Schedule Number", buf, MAX_BUF_SIZE);
	count = atoi(buf);

        while ( no < count )
	{
		char	schname[20]="";

		sprintf(schname, "Schedule%d", no);
		if ( no == 0 ) {
			schedule=calloc(1, sizeof(BACKUP_SCHEDULE));
			start=schedule;
		} else {
			schedule->next=calloc(1, sizeof(BACKUP_SCHEDULE));
			schedule=(BACKUP_SCHEDULE *)schedule->next;
		}
		
		Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "ID", buf, MAX_BUF_SIZE);
		schedule->bk_pid=atoi(buf);

                Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Name", buf, MAX_BUF_SIZE);
                strcpy(schedule->name, buf);
                Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Remote Volume", buf, MAX_BUF_SIZE);
                strcpy(schedule->remote.volume, buf);
                Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Remote Path", buf, MAX_BUF_SIZE);
                strcpy(schedule->remote.path, buf);
                Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Local Volume", buf, MAX_BUF_SIZE);
                strcpy(schedule->local.volume, buf);
                Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Local Path", buf, MAX_BUF_SIZE);
                strcpy(schedule->local.path, buf);
                
		Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Protocol", buf, MAX_BUF_SIZE);
		schedule->usage=atoi(buf);

		Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Remote IP", buf, MAX_BUF_SIZE);
		strcpy(schedule->cifs.server.location, buf);
                Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "User Name", buf, MAX_BUF_SIZE);
                strcpy(schedule->cifs.user.name, buf);
                Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Password", buf, MAX_BUF_SIZE);
                strcpy(schedule->cifs.user.passwd, buf);
               
                Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Schedule Type", buf, MAX_BUF_SIZE);
                schedule->t_type = atoi(buf);
                Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Week", buf, MAX_BUF_SIZE);
                schedule->week = atoi(buf);
                Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Month", buf, MAX_BUF_SIZE);
                schedule->month = atoi(buf);
                Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Hour", buf, MAX_BUF_SIZE);
                schedule->t_hour = atoi(buf);
                Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Minute", buf, MAX_BUF_SIZE);
                schedule->t_min = atoi(buf);

                Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Compressed", buf, MAX_BUF_SIZE);
                if ( !strcasecmp(buf, "True") )
                	schedule->option |= BACKUP_COPY_COMPRESS;
                Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Incremental", buf, MAX_BUF_SIZE);
                if ( !strcasecmp(buf, "True") )
                	schedule->option |= BACKUP_COPY_TIMESTAMP;
                Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Delete Extra", buf, MAX_BUF_SIZE);
                if ( !strcasecmp(buf, "True") )
                	schedule->option |= BACKUP_COPY_SYNC;
                Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Stop Net", buf, MAX_BUF_SIZE);
                if ( !strcasecmp(buf, "True") )
                	schedule->option |= BACKUP_COPY_STOP_SERVICE;

		Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Status", buf, MAX_BUF_SIZE);
		schedule->status = atoi(buf);
		Conf_Get_Field(RSYNC_SCHEDULE_CONF, schname, "Finished Time", buf, MAX_BUF_SIZE);
		schedule->latest_time = (time_t)atol(buf);
		
		no ++;
	}
	
	//DEBUG_rsync_Schedule(start);
	
	return start;
}

void rsync_write_schedule(BACKUP_SCHEDULE *schedule)
{
	BACKUP_SCHEDULE		*tmp=schedule;
	FILE			*fp = NULL;
	struct stat conf;
	char			buf[64]="";
	int			no = 0, fstat = 0;
	char			tmp_file[32]="";

	rsync_cleanup_tmp_crontab(tmp_file);

//	DEBUG_rsync_Schedule(schedule);

	//if RSYNC_SCHEDULE_CONF is not exist ; create it
	fstat=stat(RSYNC_SCHEDULE_CONF, &conf);
	if (fstat==-1)
	{
		fp=fopen(RSYNC_SCHEDULE_CONF, "w+");
		fclose(fp);
	}

        while (tmp!=NULL)
	{
		char	buf[MAX_BUF_SIZE]="", schname[20]="";

		sprintf(schname, "Schedule%d", no);
		sprintf(buf, "%d", no);
		tmp->bk_pid = no;
		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "ID", buf);
                Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Name", tmp->name);
		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Remote Volume", tmp->remote.volume);
		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Remote Path", tmp->remote.path);
		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Local Volume", tmp->local.volume);
		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Local Path", tmp->local.path);
		sprintf(buf, "%d", tmp->usage);
		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Protocol", buf);

		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Remote IP", tmp->cifs.server.location);
		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "User Name", tmp->cifs.user.name);
		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Password", tmp->cifs.user.passwd);

		sprintf(buf, "%d", tmp->t_type);
		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Schedule Type", buf);
		sprintf(buf, "%d", tmp->week);
		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Week", buf);
		sprintf(buf, "%d", tmp->month);
		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Month", buf);
		sprintf(buf, "%d", tmp->t_hour);
		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Hour", buf);
		sprintf(buf, "%d", tmp->t_min);
		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Minute", buf);

		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Compressed", 
			(tmp->option&BACKUP_COPY_COMPRESS?"True":"False"));
		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Incremental", 
			(tmp->option&BACKUP_COPY_TIMESTAMP)?"True":"False");
		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Delete Extra", 
			(tmp->option&BACKUP_COPY_SYNC)?"True":"False");
		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Stop Net", 
			(tmp->option&BACKUP_COPY_STOP_SERVICE)?"True":"False");

		sprintf(buf, "%d", tmp->status);
		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Status", buf);
		sprintf(buf, "%lu", (unsigned long)tmp->latest_time);
		Conf_Set_Field(RSYNC_SCHEDULE_CONF, schname, "Finished Time", buf);
		
		rsync_write_tmp_crontab(tmp, tmp_file);

		tmp=(BACKUP_SCHEDULE *)tmp->next;
		no ++;
	}
	sprintf(buf, "%d", no);
	Conf_Set_Field(RSYNC_SCHEDULE_CONF, "Global", "Schedule Number", buf);
	
	rsync_update_crontab(tmp_file);
}

int rsync_comp_schedule(BACKUP_SCHEDULE *schedule1, BACKUP_SCHEDULE *schedule2)
{
	if (!strcmp(schedule1->name, schedule2->name))
		return 0;
	else
		return 1;
}

int rsync_fcomp_schedule(BACKUP_SCHEDULE *schedule1, BACKUP_SCHEDULE *schedule2)
{
	if ( !strcmp(schedule1->name, schedule2->name) )
		return 0;
	else
		return 1;
}

void rsync_Free_Schedule(BACKUP_SCHEDULE *schedule)
{
	BACKUP_SCHEDULE	*tmp;

        tmp=schedule;
        while (schedule!=NULL)
        {
                tmp=(BACKUP_SCHEDULE *)schedule->next;
                free(schedule);
                schedule=tmp;
        }
        return;
}

int rsync_Add_Schedule(BACKUP_SCHEDULE *new)
{
	BACKUP_SCHEDULE	*schedule=NULL, *tmp=NULL;
	int		ssize;


        schedule=rsync_Get_Schedule();

        ssize=sizeof(BACKUP_SCHEDULE);
        if (schedule==NULL)
        {
                schedule=calloc(1, ssize);
                memcpy(schedule, new, ssize);
                schedule->next=NULL;
        }
        else
        {
                tmp=schedule;
                while (tmp!=NULL)
                {
                        if (!rsync_comp_schedule(tmp, new))
                        {
                                rsync_Free_Schedule(schedule);
                                return ERROR_SCHEDULE_DUPLICATE;
                        }
                        if (tmp->next==NULL)
                                break;
                        else
                                tmp=(BACKUP_SCHEDULE *)tmp->next;
                }
                tmp->next=calloc(1, ssize);
                tmp=(BACKUP_SCHEDULE *)tmp->next;
                memcpy(tmp, new, ssize);
                tmp->next=NULL;
        }
        rsync_write_schedule(schedule);
	if(tmp != NULL)
		new->bk_pid=tmp->bk_pid;
        rsync_Free_Schedule(schedule);

        if ( new->t_type == BK_IMMEDIATELY ) {
        	pid_t pid=fork();
		switch (pid) {
			case	0:
			// 2005.12.30, Johnson Cheng
			// We get wrong error code that different to rsync reported if we don't close 1 & 2.
				//close(1);
				//close(2);					
				rsync_Now(new);
				free(new);
				exit(0);
				break;
			case	-1:	//error, do it without fork?
				rsync_Now(new);
				break;
			default:
				;// nothing
			}
        }

	return BACKUP_SUCCESS;
}

int rsync_Ren_Schedule(BACKUP_SCHEDULE *new, BACKUP_SCHEDULE *old)
{
        BACKUP_SCHEDULE		*schedule, *tmp, *check;
        int                     ssize;

        if (!rsync_fcomp_schedule(new, old))
	{
		if (new->status==old->status)
	                return BACKUP_SUCCESS;
	}
        schedule=rsync_Get_Schedule();
        ssize=sizeof(BACKUP_SCHEDULE);
        if (schedule==NULL)
                return ERROR_SCHEDULE_NOT_FOUND;
        else
        {
                tmp=schedule;
                while (tmp!=NULL)
                {
                        if (!rsync_comp_schedule(tmp, old))
                        {
                                /* check if duplicate */
                                check=schedule;
                                while (check!=NULL)
                                {
                                        if (tmp!=check)
                                        {
                                                if (!rsync_comp_schedule(check, new))
                                                {
                                                        rsync_Free_Schedule(schedule);
                                                        return ERROR_SCHEDULE_DUPLICATE;
                                                }
                                        }
                                        check=(BACKUP_SCHEDULE *)check->next;
                                }

                                /* copy new to tmp */
                                new->next=tmp->next;
                                new->bk_pid=tmp->bk_pid;
                                memcpy(tmp, new, sizeof(BACKUP_SCHEDULE));

                                rsync_write_schedule(schedule);
                                rsync_Free_Schedule(schedule);
                                goto ren_success;
                        }
                        tmp=(BACKUP_SCHEDULE *)tmp->next;
                }
        }

ren_success:

        if ( new->t_type == BK_IMMEDIATELY ) {
	pid_t pid=fork();
	switch (pid) {
		case	0:
			// 2005.12.30, Johnson Cheng
			// We get wrong error code that different to rsync reported if we don't close 1 & 2.
			//close(1);
			//close(2);					
			rsync_Now(new);
			free(new);
			exit(0);
		break;
			case	-1:	//error, do it without fork?
			rsync_Now(new);
			break;
		}
        }
        
	return BACKUP_SUCCESS;
}

int rsync_Del_Schedule(BACKUP_SCHEDULE *del)
{
	BACKUP_SCHEDULE		*schedule, *tmp, *parent;
        int			ssize;

        schedule=rsync_Get_Schedule();
        ssize=sizeof(BACKUP_SCHEDULE);
        if (schedule==NULL)
                return ERROR_SCHEDULE_NOT_FOUND;
        else
        {
                tmp=schedule;
                parent=schedule;

                while (tmp!=NULL)
                {
                        if (!rsync_comp_schedule(tmp, del))
                        {
                                char	buf[32] = "";
                                
                                del->bk_pid = tmp->bk_pid;
                                if (tmp==schedule)
                                {
                                        schedule=(BACKUP_SCHEDULE *)schedule->next;
                                        free(tmp);
                                }
                                else
                                {
                                        parent->next=tmp->next;
                                        free(tmp);
                                }
                                rsync_write_schedule(schedule);
                                Conf_Get_Field(RSYNC_SCHEDULE_CONF, "Global", "Schedule Number", buf, MAX_BUF_SIZE);
                                sprintf(buf, "Schedule%d", atoi(buf) );
                                Conf_Remove_Section(RSYNC_SCHEDULE_CONF, buf);
                                /*
                                Conf_Get_Field(RSYNC_SCHEDULE_CONF, "Global", "Schedule Number", buf, MAX_BUF_SIZE);
				count = atoi(buf) - 1;
				sprintf(buf, "%d", count);
                                Conf_Set_Field(RSYNC_SCHEDULE_CONF, "Global", "Schedule Number", buf);
                                */
                                rsync_Free_Schedule(schedule);
                                return BACKUP_SUCCESS;

                        }
                        parent=tmp;
                        tmp=(BACKUP_SCHEDULE *)tmp->next;
                }
        }
        rsync_Free_Schedule(schedule);
        return ERROR_SCHEDULE_NOT_FOUND;
}

int rsync_Now(BACKUP_SCHEDULE *schedule)
{
	int	ret=BACKUP_SUCCESS;

	/* if none schedule, then return		*/
	if (schedule==NULL) {
		return BACKUP_SUCCESS;
	}
	//rsync_Update_Status(schedule, BK_NOW);

	if (schedule->usage==BK_VIA_RSYNC)
		ret=backup_via_rsync(schedule);
	/* backup finish
	all logs are recorded by /etc/init.d/rsyncRR.sh
	*/
	if (ret==BACKUP_SUCCESS)
	{
		rsync_Update_Status(schedule, BK_NONE_ACTION);
		schedule->status=BK_NONE_ACTION;
	} else {
		rsync_Update_Status(schedule, ret);
		schedule->status=ret;
	}

	return ret;
}

int convert_conf_backup_to_rsync()
{
	BACKUP_SCHEDULE * schedules = NULL;


	schedules = Backup_Get_Schedule();

	if ( schedules ) {
		rsync_write_schedule(schedules);
		Backup_Free_Schedule(schedules);
	}
	return 0;
}

static void modify_rsync_fields(BACKUP_SCHEDULE *schedule)
{
	while (schedule!=NULL)
	{
		schedule->policy = BACKUP_PUT;
		schedule->usage = BK_VIA_CIFS;
		schedule->bk_pid = 0;
		schedule->status = BK_NONE_ACTION;
		schedule->latest_time = time(NULL);
		schedule->bcompress = (schedule->option & BACKUP_COPY_COMPRESS);
		schedule=(BACKUP_SCHEDULE *)schedule->next;
	}
}

int convert_conf_rsync_to_backup()
{
	BACKUP_SCHEDULE * schedules = NULL;

	schedules = rsync_Get_Schedule();
	if ( schedules ) {
		char	tmp_file[32]="";
		
		modify_rsync_fields(schedules);
		backup_write_schedule(schedules);
		rsync_cleanup_tmp_crontab(tmp_file);
		rsync_update_crontab(tmp_file);
		rsync_Free_Schedule(schedules);
	}
	return 0;
}

void rsync_refresh_crontab()
{
	BACKUP_SCHEDULE *	schedules = NULL;

	schedules = rsync_Get_Schedule();
	if ( schedules ) {
		rsync_write_schedule(schedules);
		rsync_Free_Schedule(schedules);
	}
}

int Start_QRAID1(char *dev_name, int progress)
{
//	int cmd[128];
	char cmd[128];
	system("/sbin/insmod /lib/modules/misc/qraid1.ko");

	if(progress)
		sprintf(cmd, "/sbin/qraid1 -p %s", dev_name);
	else
		sprintf(cmd, "/sbin/qraid1 %s", dev_name);
	system(cmd);

	//WriteProfileString("QRAID1", "device name", dev_name);
	return 0;
}

int Stop_QRAID1()
{
	system("/usr/bin/killall qraid1");
	system("/sbin/rmmod qraid1");
	system("kill -9 `cat /var/run/rsync-qraid1.pid`");

	WriteProfileString("QRAID1", "device name", "");
	return 0;
}

