//**************************************************************************
//
//	FILE:
//		cfg_qphoto.c
//
//	Abstract: 
//		Qphoto configuration Access Functions.
//
//	FUNCTIONS:	.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		09/19/2005	Ken Chen created
//
//**************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include "Util.h"
#include "cfg_qphoto.h"


/*
 * Check photo station enabled
 * Return:
 *	true	Enabled			
 *	false	Disabled
 */
BOOL Is_Qphoto_Enabled()
{
	char buf[BUF_SIZE];
	GetProfileString(SZ_QPHOTO_SECTION, SZ_ENABLE_FIELD, "FALSE", buf, sizeof(buf));
	return NOT_FALSE(buf);
}

/*
 * Enable photo station system
 * Return:
 *	0	pass			
 *	ERROR_WRITE_FILE	can not write to config file
 */
int Enable_Qphoto(int bEnable)
{
	int val, ret = SUCCESS;

	val = WriteProfileString(SZ_QPHOTO_SECTION, SZ_ENABLE_FIELD, BOOL2STR(bEnable));
	
	if(!val)
		return ERROR_WRITE_FILE;

	return ret;
}
