//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		cfg_nfs.c
//
//	Abstract: 
//		System configuration Access Functions.
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		12/06/00	kw lee created
//
//**************************************************************************

#define DEBUG

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netinet/in.h>	// for in_addr
#include <arpa/inet.h>	// for inet_aton
#include "config.h"
#include "Util.h"


/* ------------------------------------------------------------------------- **
 * Build options...
 */

//#define CFG_SYSTEM_TEST		// Build as a standalone program (with main), for testing only...



/* ------------------------------------------------------------------------- **
 * Constants...
 */



/* ------------------------------------------------------------------------- **
 * Variables...
 *
 *  bufr        - pointer to a global buffer.  This is probably a kludge,
 *                but it was the nicest kludge I could think of (for now).
 *  bSize       - The size of the global buffer <bufr>.
 */






/* ------------------------------------------------------------------------- */
/*         		Function Implementation                              */
/* ------------------------------------------------------------------------- */



#define	SZ_NFS_SECTION			"NFS"
#define	SZ_ENABLE_FIELD			"Enable"
#define SZ_ENABLE_PORT_FIELD            "Mount Port Enable"
#define SZ_PORT_NUMBER_FIELD		"Port Number"
#define SZ_ENABLE_SET_PORT_FIELD	"Port Setting Enable"

BOOL is_NFS_started();
int restart_NFS();
int stop_NFS();

/*
 * Check NFS enabled
 * Return:
 *	true	Enabled			
 *	false	Disabled
 */
BOOL Is_NFS_Enabled()
{
	char buf[BUF_SIZE];
	GetProfileString(SZ_NFS_SECTION, SZ_ENABLE_FIELD, "FALSE", buf, sizeof(buf));
	return IS_TRUE(buf);
}

BOOL Is_NFS_Port_Enabled()
{
        char buf[BUF_SIZE];
        GetProfileString(SZ_NFS_SECTION, SZ_ENABLE_PORT_FIELD, "FALSE", buf, sizeof(buf));
        return IS_TRUE(buf);
}

BOOL Is_NFS_Port_Set_Enabled()
{
        char buf[BUF_SIZE];
        GetProfileString(SZ_NFS_SECTION, SZ_ENABLE_SET_PORT_FIELD, "0", buf, sizeof(buf));
        	
        if(!strcmp(buf, "0"))
        {
        	WriteProfileString(SZ_NFS_SECTION, SZ_ENABLE_SET_PORT_FIELD, "TRUE");
        	return TRUE;
        }
        return IS_TRUE(buf);
}

char* Get_NFS_Port()
{
        static char buf[BUF_SIZE];
        GetProfileString(SZ_NFS_SECTION, SZ_PORT_NUMBER_FIELD, "2049", buf, sizeof(buf));
        return buf;
}

int Set_NFS_Port(char *port_number)
{
	int val, ret = SUCCESS;

	val = WriteProfileString(SZ_NFS_SECTION, SZ_PORT_NUMBER_FIELD, port_number);
	if(!val)
		return ERROR_WRITE_FILE;
		
	return ret;
}

/*
 * Enable NFS
 * Return:
 *	0		pass			
 *  ERROR_WRITE_FILE	can not write to config file
 *	others	fail, according to NFS report
 */
int Enable_NFS(int bEnable)
{
	int val, ret = SUCCESS;

	val = WriteProfileString(SZ_NFS_SECTION, SZ_ENABLE_FIELD, BOOL2STR(bEnable));
	if(!val)
		return ERROR_WRITE_FILE;
	if (bEnable) {
		//John modified 2001-10-18:
		//if (!is_NFS_started()) ret = restart_NFS();	 
		if(!is_NFS_started()){
			if(!restart_NFS())	ret = ERROR_FAIL;
		}
		else
		{
			system("/etc/init.d/nfs remountd");
		}
	}
	else {
		//John modified 2001-10-18:
		//ret = stop_NFS();
		if(!stop_NFS())	ret = ERROR_FAIL;	
	}
	return ret;
}

int Enable_NFS_PORT(int bEnable)
{
	int val, ret = SUCCESS;

	val = WriteProfileString(SZ_NFS_SECTION, SZ_ENABLE_PORT_FIELD, BOOL2STR(bEnable));
	if(!val)
		return ERROR_WRITE_FILE;

	return ret;
}

BOOL is_NFS_started()
{
 	//return (system("/sbin/pidof nasnfsd > /dev/null") == 0);
 	return (system("/sbin/pidof nfsd > /dev/null") == 0);
}

int restart_NFS()
{
	int ret = system("/etc/init.d/nfs restart");
	//John modified 2001-10-18:
	//return ret;
	return (ret == 0);
}

int stop_NFS()
{
	int ret = system("/etc/init.d/nfs stop");
	//John modified 2001-10-18:
	//return ret;
	return (0 == ret);
}

