//**************************************************************************
//
//	Copyright (c) 2000-2001  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		cfg_netware.c
//
//	Abstract: 
//		System configuration Access Functions.
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		07/27/01	kw lee created
//
//**************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include "Util.h"


/* ------------------------------------------------------------------------- **
 * Build options...
 */

//#define CFG_SYSTEM_TEST		// Build as a standalone program (with main), for testing only...



/* ------------------------------------------------------------------------- **
 * Constants...
 */



/* ------------------------------------------------------------------------- **
 * Variables...
 *
 *  bufr        - pointer to a global buffer.  This is probably a kludge,
 *                but it was the nicest kludge I could think of (for now).
 *  bSize       - The size of the global buffer <bufr>.
 */






/* ------------------------------------------------------------------------- */
/*         		Function Implementation                              */
/* ------------------------------------------------------------------------- */


BOOL is_netware_started();
BOOL restart_netware();
BOOL stop_netware();

#define	SZ_NETWARE_SECTION		"Netware"
#define	SZ_ENABLE_FIELD			"Enable"

/*
 * Check Netware enabled
 * Return:
 *	true	Enabled			
 *	false	Disabled
 */
BOOL Is_Netware_Enabled()
{
	char buf[BUF_SIZE];
	GetProfileString(SZ_NETWARE_SECTION, SZ_ENABLE_FIELD, "TRUE", buf, sizeof(buf));
	return NOT_FALSE(buf);
}

/*
 * Enable Netware
 * Return:
 *	0		pass			
 *  ERROR_WRITE_FILE	can not write to config file
 *	others	fail, according to mars-nwe report
 */
int Enable_Netware(int bEnable)
{
	int val, ret = SUCCESS;

	val = WriteProfileString(SZ_NETWARE_SECTION, SZ_ENABLE_FIELD, BOOL2STR(bEnable));
	if(!val)
		return ERROR_WRITE_FILE;

	if (bEnable) {
		//John modified 2001-10-18:
		//if (!is_netware_started()) ret = restart_netware();	 
		if(!is_netware_started())
			if(!restart_netware())	ret = ERROR_FAIL;
	}
	else {
		//John modified 2001-10-18:
		//ret = stop_netware();
		if(!stop_netware())	ret = ERROR_FAIL;
	}
	return ret;
}



BOOL is_netware_started()
{
	if(system("/sbin/pidof nwserv > /dev/null"))
		return FALSE;
	return TRUE;
}

BOOL restart_netware()
{
	int ret = system("/etc/init.d/mars-nwe restart > /dev/null 2> /dev/null");
	return (ret == 0);
}

BOOL stop_netware()
{
	int ret = system("/etc/init.d/mars-nwe stop > /dev/null");
	return (0 == ret);
}

BOOL Reset_Netware()
{
	int ret = system("/sbin/nwutils -r > /dev/null");
	return (0 == ret);
}
