//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		cfg_misc.c
//
//	Abstract: 
//		Misc. Functions.
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		04/11/2001	Ethan Wang -- Created
//
//**************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <storage.h>
#include <qnap_pic_user.h>
//#include <sys/io.h>
#include "config.h"
#include "Util.h"

#include <msg.h>
#include <sysmgrd.h>


int is_netstop_enabled(){
        return Get_Profile_Boolean(MISC_SECTION, MISC_NETSTOP, TRUE);
}

int set_netstop_enable(int value){
        return Set_Profile_Boolean(MISC_SECTION, MISC_NETSTOP, value);
}

// Meiji: 04-26-01 when sysmond is not running, calling sysmond with -1 ... -2 ... to show the message directly
int Show_LCD_Message(char **message, int msg_count)
{
	int i;
	char buf[BUF_SIZE];	// WARNING: this buffer may overrun if too much data...
	sprintf(buf, "/sbin/pidof %s > /dev/null", LCD_DAEMON_PROGRAM_NAME);
	if (system(buf) == 0) 
		return SendMultipleMessage(LCD_DAEMON_PROGRAM_NAME, MSG_SYSMGR, SYSMGR_SHOW_MESSAGE, msg_count, message);
	strcpy(buf, LCD_DAEMON_PROGRAM_PATH);
	for (i = 0; i < msg_count; i++) {
		if (message[i] != NULL) {	// WARNING: this buffer may overrun here if too much data...
			char tmp[BUF_SIZE];
			sprintf(tmp, " -%d \"%s\" > /dev/null", i+1, message[i]);
			strcat(buf, tmp);
		}	
	}
	return (system(buf));
}

int Hide_LCD_Message()
{
	return SendMessage(LCD_DAEMON_PROGRAM_NAME, MSG_SYSMGR, SYSMGR_HIDE_MESSAGE, 0);
}

int Switch_LCD_Main_Display()
{
	return SendMessage(LCD_DAEMON_PROGRAM_NAME, MSG_SYSMGR, SYSMGR_MAIN_DISPLAY, 0);
}

void Enable_Check_HD_Size(int sec, long max_avail_size){
//	char cmd[128];
	
	if(sec<0)
		return;
	
	Util_Send_Message(DISABLE_CHECK_FREE_SIZE,NULL,0,NULL);
	sleep(1);
	Util_Send_Message(ENABLE_CHECK_FREE_SIZE,NULL,0,NULL);
}

void Disable_Check_HD_Size(){
	char cmd[128];

	sprintf(cmd, "/sbin/daemon_mgr check_hds_size stop /sbin/check_hds_size");
	system(cmd);
	sprintf(cmd, "/sbin/daemon_mgr check_hds_size start \"%s -s 3600 -m %s -d\"", "/sbin/check_hds_size", "/share/HDA_DATA");
        system(cmd);
}

int IsStandbyEnable()
{
        char buf[BUF_SIZE];
        GetProfileString(MISC_SECTION, MISC_KEYNAME_DISK_TIMEOUT_ENABLE, "FALSE", buf, sizeof(buf));
        return NOT_FALSE(buf);
}
int GetStandbyTimeout()
{
        return Get_Profile_Integer(MISC_SECTION, MISC_KEYNAME_DISK_TIMEOUT, 0);
}

int  SetStandbyTimeout(char *device_name, int timeout){
        int ret=0, tick=0;
        char cmd[HD_DEVICE_NAME_LENGTH];
        if(timeout == 0)
                tick=0;
        else if(timeout > 0 && timeout <= 20) {
                tick = timeout * 12;
        }
        else {
                tick = timeout / 30 + 240;
        }
        sprintf(cmd, "/sbin/hdparm -S %d %s 1>/dev/null 2>/dev/null", tick, device_name);
        ret = system(cmd);
        return ret;
}

void Set_Speaker(BOOL bEnable)
{
//	int	counter;
// johnson for cross compile
/*
	if ( ioperm(0x61, 1, 1) || ioperm(0x42, 1, 1) || ioperm(0x43, 1, 1) )
		return;

	if ( bEnable )
	{
		outb(inb(0x61) | 3, 0x61);
		counter = 1193180 / 2000;
		outb(0xb6, 0x43);
		outb(counter & 0xff, 0x42);
		outb((counter >> 8) & 0xff, 0x42);
	}
	else
	{
		outb(inb(0x61) & 0xfc, 0x61);
	}
*/
}

#if 0
void Set_System_Event()
{
	SendMessage(LCD_DAEMON_PROGRAM_NAME, MSG_SYSMGR, SYSMGR_SET_SYSTEM_EVENT, 0);
}

void Clear_System_Event()
{
	SendMessage(LCD_DAEMON_PROGRAM_NAME, MSG_SYSMGR, SYSMGR_CLEAR_SYSTEM_EVENT, 0);
}
#endif

