//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		cfg_logo.c
//
//	Abstract: 
//		LOGO configuration Access Functions.
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//	02/04/2002	Johnson Hsu created
//	2002/02/23	Kent re-formated, change algorithm of logo function
//
//**************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include "config.h"
#include "Util.h"

#include "cfg_logo.h"

/* ------------------------------------------------------------------------- */
/*         Set and Get functions of all fields in LOGO session               */
/* ------------------------------------------------------------------------- */

BOOL LOGO_Start()
{
	int	ret;

	ret=system(LOGO_SHELL);
	return ret;
}

BOOL logo_get_full_path(char *fullpath, int length, char *filename)
{
	if ((strlen(filename)+strlen(FLASH_IMG_LOC)+10)>length)
		return 0;
	sprintf(fullpath, "%s/%s", FLASH_IMG_LOC, filename);
	return 1;
}

int LOGO_Init()
{
	char	fullpath[PATH_STR_LEN], tmp[PATH_STR_LEN];
	int	counter=1, index;

	LOGO_Set_Index("0");
	LOGO_Set_Counter(10);
	LOGO_Set_Limit(LOGO_FILESIZE_DEFAULT);

	logo_get_full_path(fullpath, PATH_STR_LEN, DEFAULT_IMG);
	LOGO_Set_Default(fullpath);

	logo_get_full_path(fullpath, PATH_STR_LEN, UPLOAD_IMG);
	LOGO_Set_Upload(fullpath);

	for (index=1;index<7;index++)
	{
		snprintf(tmp, PATH_STR_LEN, LOGO_IMG, counter*index);
		logo_get_full_path(fullpath, PATH_STR_LEN, tmp);
		LOGO_Set_PIC(fullpath, index);
	}

	return 1;
}

int LOGO_Get_Preview_PIC(char *filename, int length, int index)
{
	char	buf[PATH_STR_LEN], *ptr;

	LOGO_Get_PIC(buf, PATH_STR_LEN, index);
	ptr=buf+strlen(buf);
	while (*ptr!='/')
		ptr--;
	if ((strlen(HTTPD_IMG_LOC)+strlen(ptr+1)+2)>length)
		return 0;
	sprintf(filename, "%s/%s", HTTPD_IMG_LOC, ptr+1);
	return 1;
}

int LOGO_Get_PIC(char *filename, int length, int index)
{
	switch (index)
	{
		case 0:	//0 is upload image
			Conf_Get_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_UPLOAD_FIELD, filename, length);
			break;
		case 1:
			Conf_Get_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_PIC1_FIELD, filename, length);
			break;
		case 2:
			Conf_Get_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_PIC2_FIELD, filename, length);
			break;
		case 3:
			Conf_Get_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_PIC3_FIELD, filename, length);
			break;
		case 4:
			Conf_Get_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_PIC4_FIELD, filename, length);
			break;
		case 5:
			Conf_Get_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_PIC5_FIELD, filename, length);
			break;
		case 6:
			Conf_Get_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_PIC6_FIELD, filename, length);
			break;
	}
	return 1;
}

int LOGO_Set_PIC(char *filename, int index)
{
	switch (index)
	{
		case 0:
			Conf_Set_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_UPLOAD_FIELD, filename);
			break;
		case 1:
			Conf_Set_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_PIC1_FIELD, filename);
			break;
		case 2:
			Conf_Set_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_PIC2_FIELD, filename);
			break;
		case 3:
			Conf_Set_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_PIC3_FIELD, filename);
			break;
		case 4:
			Conf_Set_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_PIC4_FIELD, filename);
			break;
		case 5:
			Conf_Set_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_PIC5_FIELD, filename);
			break;
		case 6:
			Conf_Set_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_PIC6_FIELD, filename);
			break;
	}
	return 1;
}

void mount_flash()
{
	char buf[80];
	char cmd[255];

	Conf_Get_Field(ULINUX_CONF_LOC, "System", "System Device", buf, sizeof(buf));
	sprintf(cmd, "/bin/mount %s2 %s 2>/dev/null 1>/dev/null", buf, FLASH_IMG_LOC);
	system(cmd);
}

void umount_flash()
{
	char cmd[255];

	sprintf(cmd, "/bin/umount FLASH_IMG_LOC");
	system(cmd);
}

void LOGO_Remove(int index)
{
	char	prev[1024], command[1024];

	/* remove /mnt/config/uploadxxxxx			*/
	sync();
	//mount_flash();
	LOGO_Get_PIC(prev, 1024, index);
	sprintf(command, "/bin/rm -f %s %s", prev, DEVNULL);
	system(command);

	/* remove /home/httpd/v2_menu/images/uploadxxxxx	*/
	LOGO_Get_Preview_PIC(prev, 1024, index);
	sprintf(command, "/bin/rm -f /home/httpd%s %s", prev, DEVNULL);
	system(command);
	//umount_flash();
	return;
}

void LOGO_Replace_PIC()
{
	char	pic[1024], new[1024], command[1024];
	int	counter;

	/* first, get upload image */
	sync();
	//mount_flash();
	LOGO_Get_PIC(pic, 1024, 0);

	counter=LOGO_Get_Counter();
	snprintf(new, 1024, LOGO_IMG, counter+1);

	/* replace /mnt/config/xxxxxx			*/
	sprintf(command, "/bin/cp -f %s %s/%s %s", pic, FLASH_IMG_LOC, new, DEVNULL);
	system(command);

	/* replace /home/httpd/v2_menu/images/xxxxxxx	*/
	sprintf(command, "/bin/cp -f %s /home/httpd%s/%s %s", pic, HTTPD_IMG_LOC, new, DEVNULL);
	system(command);
	//umount_flash();
}

BOOL LOGO_Check_Session_Exist()
{
        int	logo_ret = 0;
	char	tmp[255], buf[255];

        strcpy(tmp, CONFIG_FILE_PATH);
        strcat(tmp, "/");
        strcat(tmp, CONFIG_FILE_NAME);
	logo_ret = Conf_Get_Field(tmp, LOGO_SESSION_NAME, "UPLOAD LOGO Image Path", buf, sizeof(buf));
	if (logo_ret == 0)
                return TRUE; //exist
        else
		return FALSE; //non-exist
}

int LOGO_Get_Counter()
{
	char	buf[20];
	int	counter;

	Conf_Get_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_PIC_COUNTER_FIELD, buf, sizeof(buf));
	counter=atoi(buf);
	if (counter<10)
		counter=10;
	return counter;
}

int LOGO_Set_Counter(int value)
{
	char	buf[20];

	sprintf(buf, "%d", value);
	return Conf_Set_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_PIC_COUNTER_FIELD, buf);
}

int LOGO_Get_Index()
{
	int	index;
	char	buf[80];

	Conf_Get_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_SHOW_PIC_IDX_FIELD, buf, sizeof(buf));
	index=atoi(buf);
	return index;
}

int LOGO_Set_Index(char *value)
{
	return Conf_Set_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_SHOW_PIC_IDX_FIELD, value);
}

//Set Default LOGO Image Path
int LOGO_Set_Default(char *value)
{
	return Conf_Set_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_DEFAULT_FIELD, value);
}

//Set Upload LOGO Image Path
int LOGO_Set_Upload(char *value)
{
	return Conf_Set_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_UPLOAD_FIELD, value);
}

//Set LOGO Image Size Limitation
int LOGO_Set_Limit(char *value)
{
	return Conf_Set_Field(ULINUX_CONF_LOC, LOGO_SESSION_NAME, LOGO_IMG_LIMIT_FIELD, value);
}

BOOL Is_Logo_Support(){
	int ret;
	char buf[BUF_SIZE];
	ret=GetProfileString("System", "ChangeLogo Support", "TRUE", buf, sizeof(buf));
	return NOT_FALSE(buf);
}
