#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <ctype.h>

/* include NAS lib */
#include <NAS.h>
#include <Util.h>
#include <nas_lib_common.h>

/* include local file */
#include <cfg_ftp.h>

#include "cfg_samba.h"	// For Get_Samba3_Workgroup_Name()
#include "naspdc.h"			// For DOMAIN_NAME_LEN

//#define DEBUG_CONF		1

#ifndef NAS_SMB_LIB
#if 0
void erase_char(char *origin)
{
        char *start, *ptr;

        if (strlen(origin)==0)
                return;
        start=ptr=origin;
        ptr=origin+strlen(origin);
        while (*start==' ' || *start=='	' || *start==0x0d || *start==0x0a)
                start++;
        ptr--;
        while (*ptr==' ' || *ptr=='	' || *ptr==0x0d || *ptr==0x0a)
                ptr--;
        *(ptr+1)=0x0;
        ptr=origin;
        while (*start)
                *ptr++=*start++;
        *ptr=0x0;
}
#endif

char *get_token_value(char *inputstr, char *token)
{
	char *value;

	value=strtok(inputstr, token);
	if (value==NULL)
		return NULL;
	erase_char(value);
	value=strtok(NULL,"\t\n");
	if (value==NULL)
		return NULL;
	erase_char(value);
	return value;
}

USER_GROUP_LIST *smb_get_userlist(char *str)
{
	USER_GROUP_LIST	*start=NULL, *userlist=NULL;
	char 		*value;
	int 		count=0;

	value=strtok(str, ",\n");
	while (value!=NULL)
	{
		if (count==0)
		{
			if ((userlist=calloc(1, sizeof(USER_GROUP_LIST)))==NULL)
				return NULL;
			start=userlist;
			count++;
		}
		else
		{
			if ((userlist->next=calloc(1, sizeof(USER_GROUP_LIST)))==NULL)
				return start;
			userlist=(USER_GROUP_LIST *)userlist->next;
		}
		strcpy(userlist->name, value);
		value=strtok(NULL, ",\n");
	}
	return start;
}

SMB_SHARE_INFO *SMB_Get_Share_Info()
{
	FILE 		*fptr;
	char		line[LINE], *ptr, tmp[LINE], *value;
	SMB_SHARE_INFO	*start=NULL, *smb=NULL;
	int		count=0;

	if ((fptr=fopen("/etc/config/smb.conf", "rb"))==NULL)
		return NULL;
	fgets(line, LINE, fptr);
	erase_char(line);
	while (!feof(fptr))
	{
		if (line[0]=='[' && line[strlen(line)-1]==']')	/* section start */
		{
			while (1)
			{
				if (line[0]=='[' && line[strlen(line)-1]==']')
				{
					ptr=line+1;
					line[strlen(line)-1]=0x0;
					strcpy(tmp, ptr);
				}
				else
				if (!strncmp(line, "path", 4))
				{
					if (count==0)
					{
						if ((smb=calloc(1, sizeof(SMB_SHARE_INFO)))==NULL) {
							fclose(fptr);
							return NULL;
						}
						start=smb;
						count++;
					}
					else
					{
						if ((smb->next=calloc(1, sizeof(SMB_SHARE_INFO)))==NULL) {
							fclose(fptr);
							return start;
						}
						smb=(SMB_SHARE_INFO *)smb->next;
					}
					strcpy(smb->sharename, tmp);
					value=get_token_value(line, "=");
					strcpy(smb->path, value);
				}
				else
				if (!strncmp(line, "invalid users", 13))
				{
					value=get_token_value(line, "=");
					if (value!=NULL)
						smb->invalid=smb_get_userlist(value);
				}
				else
				if (!strncmp(line, "read list", 9))
				{
					value=get_token_value(line, "=");
					if (value!=NULL)
						smb->read=smb_get_userlist(value);
				}
				else
				if (!strncmp(line, "write list", 10))
				{
					value=get_token_value(line, "=");
					if (value!=NULL)
						smb->write=smb_get_userlist(value);
				}
				fgets(line, LINE, fptr);
				erase_char(line);
				if ((line[0]=='[' && line[strlen(line)-1]==']') || feof(fptr))
				{
					break;
				}
			}
		}
		else
			fgets(line, LINE, fptr);
	}
	fclose(fptr);
	return start;
}

void SMB_Free_Share_Info(SMB_SHARE_INFO *smb_share_info)
{
        SMB_SHARE_INFO  *tmp_share_info;
        USER_GROUP_LIST       *userlist, *tmp_userlist;

        if (smb_share_info!=NULL)
        {
                while (smb_share_info!=NULL)
                {
			userlist=smb_share_info->invalid;
                        while (userlist!=NULL)
			{
				tmp_userlist=userlist;
                                userlist=(USER_GROUP_LIST *)userlist->next;
				free(tmp_userlist);
			}
                        userlist=smb_share_info->read;
                        while (userlist!=NULL)
			{
				tmp_userlist=userlist;
                                userlist=(USER_GROUP_LIST *)userlist->next;
				free(tmp_userlist);
			}
                        userlist=smb_share_info->write;
                        while (userlist!=NULL)
			{
				tmp_userlist=userlist;
                                userlist=(USER_GROUP_LIST *)userlist->next;
				free(tmp_userlist);
			}

			tmp_share_info=smb_share_info;
                        smb_share_info=(SMB_SHARE_INFO *)smb_share_info->next;
			free(tmp_share_info);
                }
        }
}
#endif

int Ftp_Read_Tag(TAG_FTP *ftp)
{
	char buf[20];

	GetProfileString (SZ_FTP_SECTION, "ServerName", "proftpd", ftp->servername, sizeof(ftp->servername));
	GetProfileString (SZ_FTP_SECTION, SZ_ENABLE_FIELD, "True", buf, sizeof(buf));
	if (!strcasecmp(buf, "True"))
		ftp->enable=1;
	else
		ftp->enable=0;
	GetProfileString (SZ_FTP_SECTION, "AllowAnonymous", "True", buf, sizeof(buf));
	if (!strcasecmp(buf, "True"))
		ftp->allowanonymous=1;
	else
		ftp->allowanonymous=0;
	GetProfileString (SZ_FTP_SECTION, "Port", "21", buf, sizeof(buf));
	ftp->port=atoi(buf);
	GetProfileString (SZ_FTP_SECTION, "MaxInstances", "30", buf, sizeof(buf));
	ftp->maxinstances=atoi(buf);
	GetProfileString (SZ_FTP_SECTION, "MaxAnonymous", "10", buf, sizeof(buf));
	ftp->maxanonymous=atoi(buf);
	GetProfileString (SZ_FTP_SECTION, "User", "ftp", ftp->user, sizeof(ftp->user));
	GetProfileString (SZ_FTP_SECTION, "Group", "ftp", ftp->group, sizeof(ftp->group));
	GetProfileString (SZ_FTP_SECTION, "DefaultRoot", "/share", ftp->defaultroot, sizeof(ftp->defaultroot));
	GetProfileString (SZ_FTP_SECTION, "Unicode", "0", buf, sizeof(buf));
	ftp->unicode = atoi(buf);
	if (!ftp->unicode) {
		GetProfileString ("System", "Code Page", "999", buf, sizeof(buf));
		ftp->charsetremote = atoi(buf);
	} else {
		ftp->charsetremote = 999;
	}
	//GetProfileString ("System", "Code Page", "999", buf, sizeof(buf));
	//ftp->charsetlocal = atoi(buf);
	return FTP_SUCCESS;
}

int Ftp_Write_Tag(TAG_FTP *ftp)
{
	char buf[20];

	WriteProfileString(SZ_FTP_SECTION, "ServerName", ftp->servername);
	WriteProfileString(SZ_FTP_SECTION, SZ_ENABLE_FIELD, (ftp->enable)?"True":"False");
	WriteProfileString(SZ_FTP_SECTION, "AllowAnonymous", (ftp->allowanonymous)?"True":"False");
	if (ftp->port<1 || ftp->port>65534)
		ftp->port=21;
	sprintf(buf, "%d", ftp->port);
	WriteProfileString(SZ_FTP_SECTION, "Port", buf);
	if (ftp->maxinstances<1)
		ftp->maxinstances=30;
	sprintf(buf, "%d", ftp->maxinstances);
	WriteProfileString(SZ_FTP_SECTION, "MaxInstances", buf);
	if (ftp->maxanonymous<1)
		ftp->maxanonymous=1;
	sprintf(buf, "%d", ftp->maxanonymous);
	WriteProfileString(SZ_FTP_SECTION, "MaxAnonymous", buf);
	WriteProfileString(SZ_FTP_SECTION, "User", ftp->user);
	WriteProfileString(SZ_FTP_SECTION, "Group", ftp->group);
	WriteProfileString(SZ_FTP_SECTION, "DefaultRoot", ftp->defaultroot);
	sprintf(buf, "%d", ftp->unicode);
	WriteProfileString(SZ_FTP_SECTION, "Unicode", buf);
	sprintf(buf, "%d", ftp->charsetremote);
	WriteProfileString(SZ_FTP_SECTION, "CharsetRemote", buf);
	return FTP_SUCCESS;
}

void set_ftp_codepage(FILE *fp, char *field, int cp)
{
	char character_set[20]={""};

	if (cp == 999)
	{
		sprintf(character_set, "%s", "UTF-8");
	}
	else if (cp == 437)
	{
		sprintf(character_set, "%s", "ASCII");
	}
	else
	if (cp == 852)
	{
		sprintf(character_set, "%s", "ISO8859-2");
	}
	else
	if (cp == 737)
	{
		sprintf(character_set, "%s", "ISO8859-7");
	}
	else
	if (cp == 861 || cp == 850)
	{
		sprintf(character_set, "%s", "ISO8859-1");
	}
	else {
		sprintf(character_set, "CP%d", cp);
	}
	fprintf(fp, "%s			%s\n", field, character_set);
}

int ftp_create_conf_global(FILE *fptr, TAG_FTP *ftp)
{
	fprintf(fptr, "ServerName		\"%s\"\n", ftp->servername);
	fprintf(fptr, "ServerType		standalone\n");
	fprintf(fptr, "DefaultServer		%s\n", (ftp->enable)?"on":"off");
	fprintf(fptr, "RootLogin		on\n");
	fprintf(fptr, "Port			%d\n", ftp->port);
	fprintf(fptr, "MaxInstances		%d\n", ftp->maxinstances);
	fprintf(fptr, "User			%s\n", ftp->user);
	fprintf(fptr, "Group			%s\n", ftp->group);
	fprintf(fptr, "DefaultRoot		%s\n", ftp->defaultroot);
	fprintf(fptr, "Umask			000\n");
	fprintf(fptr, "ShowSymlinks		off\n");
	fprintf(fptr, "AllowOverwrite		on\n");
// 2004.12.09, Johnson Cheng Add
// 2005.09.06, Johnson Cheng marked for TS-101
//	fprintf(fptr, "AuthPAM		on\n");
//	fprintf(fptr, "AuthPAMAuthoritative		off\n");
//	fprintf(fptr, "AuthPAMConfig		proftpd\n");
// 2004.12.09, End
	fprintf(fptr, "TimesGMT			off\n");
	fprintf(fptr, "UseReverseDNS		off\n");
	fprintf(fptr, "WtmpLog			off\n");
	fprintf(fptr, "AllowStoreRestart	on\n");
// add by Kent 2005/12/19
// to disable /var/log/xferlog
	fprintf(fptr, "TransferLog		NONE\n");
// end
	fprintf(fptr, "UseReverseDNS            off\n"); 
       	fprintf(fptr, "IdentLookups             off\n"); 

// Paul
	//set_ftp_codepage(fptr, "CharsetLocal", ftp->charsetlocal);
	set_ftp_codepage(fptr, "CharsetLocal", 999); /*always use unicode*/
	set_ftp_codepage(fptr, "CharsetRemote", ftp->charsetremote);
// Paul
	return FTP_SUCCESS;
}

int trans_directory(char *buf, int len, char *directory)
{
	char	*origin, *dest;
	int	count=1;

	origin=directory;
	dest=buf;
	while (*origin!=0x0)
	{
		if (*origin=='\\')
			*dest++='\\';
		*dest++=*origin++;
		count++;
		if (count>len)
			return FTP_FAIL;
	}
	*dest=0x0;
	return FTP_SUCCESS;
}

int ftp_write_deny_dir(FILE *fptr, char *directory)
{
	char	buf[512];

	if (trans_directory(buf, sizeof(buf), directory)==FTP_FAIL)
		return FTP_FAIL;
	fprintf(fptr, "<Directory \"%s\">\n", buf);
        fprintf(fptr, "	<Limit ALL>\n");
        fprintf(fptr, "		DenyAll\n");
        fprintf(fptr, "	</Limit>\n");
	fprintf(fptr, "</Directory>\n\n");
	return FTP_SUCCESS;
}

int ftp_write_userlist(FILE *fptr, USER_GROUP_LIST *userlist, int type)
{
	char *ptr;
//	char workgroup[DOMAIN_NAME_LEN];

	while (userlist!=NULL)
	{
		if (userlist->name[0]=='@')
		{
			ptr=userlist->name+1;
			if (type==FTP_READLIST || type==FTP_WRITELIST)
				fprintf(fptr, "		AllowGroup	\"%s\"\n", ptr);
			else
			if (type==FTP_DENYLIST)
				fprintf(fptr, "		DenyGroup	\"%s\"\n", ptr);
		}
		else
		{		
			// 2004.12.09, Johnson Cheng
			// For AD version supporting multi-domain, the format
			// of AD user name is domain+user. ex: ADTEST+Johnson 
			// 2004.11.3, Johnson Cheng
			// For AD users or NTDomain users, it should be two slash between workgroup and username,
			// for example: ADTEST\\Johnson
			if (type==FTP_READLIST || type==FTP_WRITELIST)
			{
				//Get_Samba3_Workgroup_Name(workgroup);
			  //if(strncmp(userlist->name, workgroup, strlen(workgroup)) == 0)
				//	fprintf(fptr, "		AllowUser	\"%s\\\\%s\"\n", workgroup, (char*)(userlist->name + strlen(workgroup)+1));
				//else
				  fprintf(fptr, "		AllowUser	\"%s\"\n", userlist->name);
			}
			else
			{
				//Get_Samba3_Workgroup_Name(workgroup);
				//if(strncmp(userlist->name, workgroup, strlen(workgroup)) == 0)
				//	fprintf(fptr, "		DenyUser	\"%s\\\\%s\"\n", workgroup, (char*)(userlist->name + strlen(workgroup)+1));
				//else
				  fprintf(fptr, "		DenyUser	\"%s\"\n", userlist->name);
			}
		}
		userlist=(USER_GROUP_LIST *)userlist->next;
	}
	return FTP_SUCCESS;
}

int ftp_write_normal_dir(FILE *fptr, char *directory, TAG_FTP *ftp, SMB_SHARE_INFO *smb_share_info)
{
	SMB_SHARE_INFO	*pshare_info;
	USER_GROUP_LIST	*userlist;
	char		buf[512];

	pshare_info=smb_share_info;
	while (pshare_info!=NULL)
	{
		if (!strcasecmp(pshare_info->sharename, "printers"))
		{
		}
		else
		if (!strcmp(pshare_info->sharename, directory))
		{
			if (trans_directory(buf, sizeof(buf), directory)==FTP_FAIL)
				goto write_continue;
			fprintf(fptr, "<Directory \"%s/%s\">\n", ftp->defaultroot, buf);
			fprintf(fptr, "	<Limit READ DIRS>\n");
			fprintf(fptr, "		Order		Deny, Allow\n");
			/* output read list */
			userlist=pshare_info->read;
			ftp_write_userlist(fptr, userlist, FTP_READLIST);
			userlist=pshare_info->write;
			ftp_write_userlist(fptr, userlist, FTP_WRITELIST);
			userlist=pshare_info->invalid;
			ftp_write_userlist(fptr, userlist, FTP_DENYLIST);
			fprintf(fptr, "	</Limit>\n");

			/* output write list */
			fprintf(fptr, "	<Limit ALL>\n");
			fprintf(fptr, "		Order		Deny, Allow\n");
			userlist=pshare_info->write;
			ftp_write_userlist(fptr, userlist, FTP_WRITELIST);
        		fprintf(fptr, "	</Limit>\n");
			fprintf(fptr, "</Directory>\n\n");
		}
write_continue:
		pshare_info=(SMB_SHARE_INFO *)pshare_info->next;
	}
	return FTP_SUCCESS;
}

int ftp_create_conf_body(FILE *fptr, TAG_FTP *ftp, SMB_SHARE_INFO *smb_share_info)
{
	struct dirent 	*dir;
	DIR 		*share;
	char 		path[LINE], value[LINE];
	int 		ret;

	share=opendir(ftp->defaultroot);
	while ((dir=readdir(share)))
	{
		if (!strcmp(dir->d_name, ".") || !strcmp(dir->d_name, ".."))
			continue;
		sprintf(path, "%s/%s", ftp->defaultroot, dir->d_name);
		//memset(value, 0x0, LINE);
		ret=readlink(path, value, LINE);
		if (ret==-1)
		{	/* not a link, and we need to deny to access it */
			ftp_write_deny_dir(fptr, path);
		}
		else
		{	/* it is NAS share folder */
			/* check if guest can access ? */
			value[ret]=0x0;
			ftp_write_normal_dir(fptr, path+strlen(ftp->defaultroot)+1, ftp, smb_share_info);
		}
	}
	closedir(share);
	return FTP_SUCCESS;
}

int ftp_create_conf_anonymous(FILE *fptr, TAG_FTP *ftp, SMB_SHARE_INFO *smb_share_info)
{

	fprintf(fptr, "<Anonymous %s>\n", ftp->defaultroot);
	fprintf(fptr, "	User			%s\n", ftp->user);
	fprintf(fptr, "	Group			%s\n", ftp->group);
	fprintf(fptr, "	UserAlias		anonymous %s\n", ftp->user);
	fprintf(fptr, "	RequireValidShell	off\n");
	fprintf(fptr, "	MaxClients		%d\n", ftp->maxanonymous);
	ftp_create_conf_body(fptr, ftp, smb_share_info);
	fprintf(fptr, "</Anonymous>\n");
	return FTP_SUCCESS;
}

#ifdef DEBUG_CONF
void DEBUG_Smb_Share_Info(SMB_SHARE_INFO *smb_share_info)
{
        SMB_SHARE_INFO  *pshare_info;
        USER_GROUP_LIST       *userlist;

	printf("DEBUG_SHARE_INFO<br>\n");
        if (smb_share_info!=NULL)
        {
                pshare_info=smb_share_info;
                while (pshare_info!=NULL)
                {
                        printf("share name=%s<br>\n", pshare_info->sharename);
                        printf("        share path=%s<br>\n", pshare_info->path);
                        printf("        invalid user=");
                        userlist=pshare_info->invalid;
                        while (userlist!=NULL)
                        {
                                printf("%s:", userlist->name);
                                userlist=(USER_LIST *)userlist->next;
                        }
                        printf("<br>\n        read user=");
                        userlist=pshare_info->read;
                        while (userlist!=NULL)
                        {
                                printf("%s:", userlist->name);
                                userlist=(USER_LIST *)userlist->next;
                        }
                        printf("<br>\n        write user=");
                        userlist=pshare_info->write;
                        while (userlist!=NULL)
                        {
                                printf("%s:", userlist->name);
                                userlist=(USER_LIST *)userlist->next;
                        }
                        printf("<br>\n<br>\n");
                        pshare_info=(SMB_SHARE_INFO *)pshare_info->next;
                }
        }
}
#endif

int ftp_link_valid(char *share, char *link, SMB_SHARE_INFO *smb_share_info)
{
	SMB_SHARE_INFO	*pshare_info;

	pshare_info=smb_share_info;
	while (pshare_info!=NULL)
	{
		if (!strcmp(share, pshare_info->sharename) && !strcmp(link, pshare_info->path))
			return FTP_SUCCESS;
		pshare_info=(SMB_SHARE_INFO *)pshare_info->next;
	}
	return FTP_FAIL;
}

void ftp_remove_invalid_link(TAG_FTP *ftp, SMB_SHARE_INFO *smb_share_info)
{
        struct dirent   *dir;
        DIR             *share;
        char            path[LINE], value[LINE], command[LINE];
        int             ret;

        share=opendir(ftp->defaultroot);
        while ((dir=readdir(share)))
        {
                if (!strcmp(dir->d_name, ".") || !strcmp(dir->d_name, ".."))
                        continue;
                sprintf(path, "%s/%s", ftp->defaultroot, dir->d_name);
		//value[0]=0x0;
		//memset(value, 0x0, LINE);
                ret=readlink(path, value, LINE);
                if (ret==-1)
                {       /* not a link, and we need to deny to access it */
                }
                else
                {       /* it is NAS share folder */
			value[0]=0x0;
			sprintf(command, "%s/%s", ftp->defaultroot, value);
			//if (ftp_link_valid(dir->d_name, command, smb_share_info)==FTP_FAIL)
			{
				//sprintf(command, "rm '%s'", path);
				//system(command);
				unlink(path);
			}
                }
        }
        closedir(share);
}

int ftp_share_link_exist(TAG_FTP *ftp, SMB_SHARE_INFO *smb_share_info)
{
        struct dirent   *dir;
        DIR             *share;
        char            path[LINE], value[LINE], command[LINE];
        int             ret;

        share=opendir(ftp->defaultroot);
        while ((dir=readdir(share)))
        {
                if (!strcmp(dir->d_name, ".") || !strcmp(dir->d_name, ".."))
                        continue;
                sprintf(path, "%s/%s", ftp->defaultroot, dir->d_name);
                //value[0]=0x0;
                //memset(value, 0x0, LINE);
                ret=readlink(path, value, LINE);
                if (ret==-1)
                {       /* not a link, and we need to deny to access it */
                }
                else
                {       /* it is NAS share folder */
			value[0]=0x0;
			sprintf(command, "%s/%s", ftp->defaultroot, value);
			if (!strcmp(dir->d_name, smb_share_info->sharename) && !strcmp(command, smb_share_info->path))
			{
				closedir(share);
				return FTP_SUCCESS;
			}
                }
        }
        closedir(share);
	return FTP_FAIL;
}

void ftp_create_valid_link(TAG_FTP *ftp, SMB_SHARE_INFO *smb_share_info)
{
	SMB_SHARE_INFO	*pshare_info;
	char		command[LINE], *ptr;

	pshare_info=smb_share_info;
	while (pshare_info!=NULL)
	{
		//if (ftp_share_link_exist(ftp, pshare_info)==FTP_FAIL)
		{
			ptr=pshare_info->path+strlen(ftp->defaultroot)+1;
			//sprintf(command, "ln -sf '%s' '%s/%s'", ptr, ftp->defaultroot, pshare_info->sharename);
			//system(command);
			sprintf(command, "%s/%s", ftp->defaultroot, pshare_info->sharename);
			symlink(ptr, command);
		}
		pshare_info=(SMB_SHARE_INFO *)pshare_info->next;
	}
}

void ftp_send_signal()
{
	struct dirent *dir;
	DIR *proc;
	int ret, pid;
	char path[LINE], buf[LINE];

	proc=opendir("/proc");
	while ((dir=readdir(proc))!=NULL)
	{
		if (!strcmp(dir->d_name, ".") || !strcmp(dir->d_name, "..") || !isdigit(*dir->d_name))
			continue;
		sprintf(path, "/proc/%s/exe", dir->d_name);
		//memset(buf, 0x0, LINE);
		ret=readlink(path, buf, LINE);
		if (ret==-1)
		{
		}
		else
		{
			if (strstr(buf, "proftpd"))
			{
				pid=atol(dir->d_name);
				kill(pid, SIGHUP);
			}
		}
	}
	closedir(proc);
}

int FTP_Create_Conf()
{
	FILE *fptr;
	SMB_SHARE_INFO	*smb_share_info;
	TAG_FTP ftp;

	/* read information */
#ifdef DEBUG
	printf("FTP_Create_Conf: step1\n");
#endif
	Ftp_Read_Tag(&ftp);
#ifdef DEBUG
	printf("FTP_Create_Conf: step2\n");
#endif
	smb_share_info=SMB_Get_Share_Info();

	/* create and remove link under default ftproot */
#ifdef DEBUG
	printf("FTP_Create_Conf: step3\n");
#endif
	ftp_remove_invalid_link(&ftp, smb_share_info);
#ifdef DEBUG
	printf("FTP_Create_Conf: step4\n");
#endif
	ftp_create_valid_link(&ftp, smb_share_info);

#ifdef DEBUG_CONF
	DEBUG_Smb_Share_Info(smb_share_info);
#endif

	/* create proftpd.conf */
	fptr=fopen(FTP_CONF_PATH, "wb");
	ftp_create_conf_global(fptr, &ftp);
	ftp_create_conf_body(fptr, &ftp, smb_share_info);
	ftp_create_conf_anonymous(fptr, &ftp, smb_share_info);
	fclose(fptr);
#ifdef DEBUG
	printf("FTP_Create_Conf: step5\n");
#endif
	/* free memory */
	SMB_Free_Share_Info(smb_share_info);
#ifdef DEBUG
	printf("FTP_Create_Conf: step6\n");
#endif
	/* send signal */
	if (ftp.enable==1)
		ftp_send_signal();
	return FTP_SUCCESS;
}

int FTP_First_Create_Conf()
{
	FILE *fptr;
	SMB_SHARE_INFO  *smb_share_info;
	TAG_FTP ftp;

	/* read information */
	Ftp_Read_Tag(&ftp);
	smb_share_info=SMB_Get_Share_Info();

	/* create and remove link under default ftproot */
	ftp_remove_invalid_link(&ftp, smb_share_info);
	ftp_create_valid_link(&ftp, smb_share_info);

#ifdef DEBUG_CONF
	DEBUG_Smb_Share_Info(smb_share_info);
#endif

	/* create proftpd.conf */
	fptr=fopen(FTP_CONF_PATH, "wb");
	ftp_create_conf_global(fptr, &ftp);
	ftp_create_conf_body(fptr, &ftp, smb_share_info);
	ftp_create_conf_anonymous(fptr, &ftp, smb_share_info);
	fclose(fptr);

	/* free memory */
	SMB_Free_Share_Info(smb_share_info);
	return FTP_SUCCESS;
}

int Restart_Ftp()
{
	int	ret;

	ret=system("/etc/init.d/ftp.sh restart");
	return ret;
}

int Start_Ftp()
{
	int	ret;

	ret=system("/etc/init.d/ftp.sh start");
	return ret;
}

int Stop_Ftp()
{
	int	ret;

	ret=system("/etc/init.d/ftp.sh stop");
	return ret;
}

int Reconfig_Ftp()
{
	int	ret;

	ret=system("/etc/init.d/ftp.sh reconfig");
	return ret;
}

BOOL Is_Ftp_Enabled()
{
	char buf[20];

	GetProfileString(SZ_FTP_SECTION, SZ_ENABLE_FIELD, "TRUE", buf, sizeof(buf));
	return NOT_FALSE(buf);
}

BOOL Is_Ftp_Started()
{
	if (system("/sbin/pidof /usr/local/sbin/proftpd 2>/dev/null 1>/dev/null"))
		return FALSE;
	return TRUE;
}

int Enable_Ftp(int bEnable)
{
	int	val, ret=SUCCESS;

	val=WriteProfileString(SZ_FTP_SECTION, SZ_ENABLE_FIELD, BOOL2STR(bEnable));
	if (!val)
		return ERROR_WRITE_FILE;
	if (bEnable)
	{
		if (!Is_Ftp_Started())
			ret=Restart_Ftp();
	}
	else
	{
		ret = Stop_Ftp();
	}
	return ret;
}

int FTP_Reset()
{
	TAG_FTP	ftp;

	ftp.enable=1;
	ftp.port=21;
	ftp.maxanonymous=10;
	ftp.maxinstances=30;
	ftp.allowanonymous=0;
	ftp.charsetremote=999;
	ftp.unicode=0;
	strcpy(ftp.servername, "ProFTPD");
	strcpy(ftp.user, "guest");
	strcpy(ftp.group, "guest");
	strcpy(ftp.defaultroot, "/share");
	Ftp_Write_Tag(&ftp);
	FTP_Create_Conf();
	Restart_Ftp();
	return TRUE;
}

