//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		cfg_display.c
//
//	Abstract: 
//		System display update Functions.
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		03/06/00	Meiji Chang created
//
//**************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include "Util.h"

#include "msg.h"
#include "sysmgrd.h"

/* ------------------------------------------------------------------------- **
 * Build options...
 */




/* ------------------------------------------------------------------------- **
 * Constants...
 */

#define DEST_PROG				"sysmond"

#define SZ_MISC_SECTION				"Misc"

#define SZ_CONFIGURED_FIELD			"Configured"
#define	SZ_LCD_PANEL_SETTING_CONTROL_FIELD	"LCD Panel Setting Control"
#define	SZ_RESET_PASSWORD_SWITCH_FIELD		"Reset Password Switch"

#define	SZ_SECURITY_SECTION			"Security"
#define	SZ_GUEST_ACCESS_FIELD			"Guest Access"
#define	SZ_QUOTA_LIMIT_FIELD			"Quota Limit"
#define	SZ_CREATE_PRIVATE_HOME_FIELD		"Create Private Home"
#define	SZ_PRIVATE_HOME_ROOT_FIELD		"Private Home Root"





/* ------------------------------------------------------------------------- **
 * Variables...
 *
 *  bufr        - pointer to a global buffer.  This is probably a kludge,
 *                but it was the nicest kludge I could think of (for now).
 *  bSize       - The size of the global buffer <bufr>.
 */






/* ------------------------------------------------------------------------- */
/*         		Function Implementation                              */
/* ------------------------------------------------------------------------- */




/*
 * Update_LCD_Display
 * Return:
 *	0			pass
 */
int Update_LCD_Display()
{
	int ret = SUCCESS; 

	system("/bin/kill -HUP `/sbin/pidof sysmond`");
//	system("/sbin/sysmond");
	
	return ret;
}


/*
 * Update_System_Display
 * Return:
 *	0			pass
 *	ERROR_READ_FILE	can not read config file
 */
int Update_System_Display()
{
	int ret = SUCCESS; 
	ret = Update_LCD_Display();
	return ret;
}

BOOL Get_Admin_Configured_Status()
{
	char buf[BUF_SIZE];
	GetProfileString(SZ_MISC_SECTION, SZ_CONFIGURED_FIELD, "FALSE", buf, sizeof(buf));
	return IS_TRUE(buf);
}

int Set_Admin_Configured_Status(BOOL bConfigured)
{
	int ret = SUCCESS;
	ret = WriteProfileString(SZ_MISC_SECTION, SZ_CONFIGURED_FIELD, BOOL2STR(bConfigured));
	return ret;
}

/*
#define	SZ_READ_ONLY				"Read Only"
#define	SZ_FULL_ACCESS				"Full Access"
#define	SZ_NO_ACCESS				"No Access"


int Get_Guest_Access_Right()
{
	char buf[BUF_SIZE];
	GetProfileString(SZ_SECURITY_SECTION, SZ_GUEST_ACCESS_FIELD, "No Access", buf, sizeof(buf));
	if (strcasecmp(buf, SZ_READ_ONLY) == 0) 
		return SECURITY_READ_ONLY;
	if (strcasecmp(buf, SZ_FULL_ACCESS) == 0) 
		return SECURITY_FULL_ACCESS;
	return SECURITY_NO_ACCESS;
}


int Set_Guest_Access_Right(int right)
{
	int ret;
	char *p = SZ_NO_ACCESS;
	switch (right) {
		case SECURITY_READ_ONLY:
			p = SZ_READ_ONLY;
			break;
		case SECURITY_FULL_ACCESS:
			p = SZ_FULL_ACCESS;
			break;
		default:
			p = SZ_NO_ACCESS;
			break;
	}
	ret = WriteProfileString(SZ_SECURITY_SECTION, SZ_GUEST_ACCESS_FIELD, p);

	return ret;
}

int Get_Quota_Limit()
{
	char buf[BUF_SIZE];
	GetProfileString(SZ_SECURITY_SECTION, SZ_QUOTA_LIMIT_FIELD, "0", buf, sizeof(buf));
	if (EMPTY_STRING(buf)) return 0;
	return atoi(buf);
}

int Set_Quota_Limit(int quota)
{
	int ret;
	char buf[BUF_SIZE];
	sprintf(buf, "%d", quota);
	ret = WriteProfileString(SZ_SECURITY_SECTION, SZ_QUOTA_LIMIT_FIELD, buf);
	return ret;
}
*/

// Return TRUE if "CREATE PRIVATE HOME" option is enabled, the root path will be put in 'path'.
BOOL Get_Private_Home_Root_Path(char *path, int buf_size)
{
	char buf[BUF_SIZE];
	GetProfileString(SZ_SECURITY_SECTION, SZ_CREATE_PRIVATE_HOME_FIELD, "FALSE", buf, sizeof(buf));
	if (IS_TRUE(buf)) {
		GetProfileString(SZ_SECURITY_SECTION, SZ_PRIVATE_HOME_ROOT_FIELD, "", path, buf_size);
		return TRUE;
	}
	else 
		return FALSE;
}

// If "CREATE PRIVATE HOME" option is disabled, pass the path as NULL or empty string.
int Set_Private_Home_Root_Path(char *path)
{
	int ret;
	BOOL bEnable = !EMPTY_STRING(path);
	ret = WriteProfileString(SZ_SECURITY_SECTION, SZ_CREATE_PRIVATE_HOME_FIELD, BOOL2STR(bEnable));
	if (bEnable) {
		ret = WriteProfileString(SZ_SECURITY_SECTION, SZ_PRIVATE_HOME_ROOT_FIELD, path);
	}
	return ret;
}

BOOL Is_LCD_Panel_Setting_Control_Enabled()
{
	char buf[BUF_SIZE];
	GetProfileString(SZ_MISC_SECTION, SZ_LCD_PANEL_SETTING_CONTROL_FIELD, "TRUE", buf, sizeof(buf));
	return NOT_FALSE(buf);
}

int Enable_LCD_Panel_Setting_Control(BOOL bEnable)
{
	int ret = SUCCESS;
	ret = WriteProfileString(SZ_MISC_SECTION, SZ_LCD_PANEL_SETTING_CONTROL_FIELD, BOOL2STR(bEnable));

	if ( Open_Message_Engine() < 0 )
		return ret;

	SendMessage(DEST_PROG, MSG_LCD_PANEL_SETTING, bEnable, 0);

	Close_Message_Engine();
	return ret;
}

BOOL Is_Reset_Password_Switch_Enabled()
{
	char buf[BUF_SIZE];
	GetProfileString(SZ_MISC_SECTION, SZ_RESET_PASSWORD_SWITCH_FIELD, "TRUE", buf, sizeof(buf));
	return NOT_FALSE(buf);
}

int Enable_Reset_Password_Switch(BOOL bEnable)
{
	int ret = SUCCESS;
	ret = WriteProfileString(SZ_MISC_SECTION, SZ_RESET_PASSWORD_SWITCH_FIELD, BOOL2STR(bEnable));
	return ret;
}



