//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		cfg_alert.c
//
//	Abstract: 
//		System configuration Access Functions.
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		12/06/00	kw lee created
//
//**************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "config.h"
#include "Util.h"


/* ------------------------------------------------------------------------- **
 * Build options...
 */

//#define CFG_SYSTEM_TEST		// Build as a standalone program (with main), for testing only...



/* ------------------------------------------------------------------------- **
 * Constants...
 */



/* ------------------------------------------------------------------------- **
 * Variables...
 *
 *  bufr        - pointer to a global buffer.  This is probably a kludge,
 *                but it was the nicest kludge I could think of (for now).
 *  bSize       - The size of the global buffer <bufr>.
 */






/* ------------------------------------------------------------------------- */
/*         		Function Implementation                              */
/* ------------------------------------------------------------------------- */



#define	SZ_ALERT_SECTION	"Alert"
#define	SZ_ALERT_LEVEL_FIELD	"Alert Level"
#define	SZ_ALERT_LEVEL_DEFAULT	"0"
#define	SZ_SMTP_IP_FIELD	"SMTP IP"
#define	SZ_ALERT_MAIL_FIELD	"Alert Mail"

// Shone added 2005,09,29
#define SZ_ALERT_SMTP_AUTH      "SMTP Authentication"
#define SZ_ALERT_SMTP_USERNAME  "SMTP User Name"
#define SZ_ALERT_SMTP_PASSWORD  "SMTP Password"


/*
 * Get Alert Level
 * Return:
 *	0			pass
 *	ERROR_READ_FILE	can not read config file
 */
int Get_Alert_Level(int *alert_level)
{
	int val, i, buf_size = 128, ret = SUCCESS; 
	char str[128];
	
	*alert_level = 0;
	val = GetProfileString(SZ_ALERT_SECTION, SZ_ALERT_LEVEL_FIELD, SZ_ALERT_LEVEL_DEFAULT, str, buf_size);
	if(!val)
		return ERROR_READ_FILE;
	for(i = 0; i < strlen(str); i++) {
		if(!isdigit(str[i]))
			return ERROR_READ_FILE;
	}
	*alert_level = atoi(str);
	return ret;
}

/*
 * Ser Alert Level
 * Return:
 *	0			pass
 *	ERROR_WRITE_FILE	can not write config file
 */
int Set_Alert_Level(int alert_level)
{
	int val, ret = SUCCESS; 
	char str[128];

	sprintf(str, "%d", alert_level);
	val = WriteProfileString(SZ_ALERT_SECTION, SZ_ALERT_LEVEL_FIELD, str);
	if(!val)
		return ERROR_WRITE_FILE;
	return ret;
}

/*
 * Get SMTP Server IP when Alert
 * Return:
 *	0			pass
 *	ERROR_READ_FILE	can not read config file
 */
int Get_Alert_SMTP_Server_IP(char *smtp_ip, int buf_size)
{
	int val, ret = SUCCESS; 

	val = GetProfileString(SZ_ALERT_SECTION, SZ_SMTP_IP_FIELD, "", smtp_ip, buf_size);
	if(!val)
		return ERROR_READ_FILE;
	return ret;
}

/*
 * Set alert SMTP Server IP
 * Return:
 *	0			pass
 *	ERROR_WRITE_FILE	can not write config file
 */
int Set_Alert_SMTP_Server_IP(char *smtp_ip)
{
	int val, ret = SUCCESS; 

	val = WriteProfileString(SZ_ALERT_SECTION, SZ_SMTP_IP_FIELD, smtp_ip);
	if(!val)
		return ERROR_WRITE_FILE;
	return ret;
}

/*
 * Get Alert email address
 * Return:
 *	0			pass
 *	ERROR_READ_FILE	can not read config file
 */
int Get_Alert_Mail_Address(char *alert_mail, int buf_size)
{
	int val, ret = SUCCESS; 

	val = GetProfileString(SZ_ALERT_SECTION, SZ_ALERT_MAIL_FIELD, "", alert_mail, buf_size);
	if(!val)
		return ERROR_READ_FILE;
	return ret;
}

/*
 * Set Alert email address
 * Return:
 *	0			pass
 *	ERROR_WRITE_FILE	can not read config file
 */
int Set_Alert_Mail_Address(char *alert_mail)
{
	int val, ret = SUCCESS; 

	val = WriteProfileString(SZ_ALERT_SECTION, SZ_ALERT_MAIL_FIELD, alert_mail);
	if(!val)
		return ERROR_WRITE_FILE;
	return ret;
}

/*
 * Send alert mail
 * Return:
 *	0			pass
 *	others	 fail, according to Send_Mail's report 
 */

int Send_Alert_Mail(char *Subject, char *Msg, char *Level)
{
	int ret = SUCCESS;
	char smtp_ip[512];
	char alert_mailaddr[512];

	// 2005.11.17, Johnson Cheng
	// Send mail immediately, not keep it in /etc/logs/mailog anymore.
	/*int alert_level;
	ret = Get_Alert_Level(&alert_level);
	if (ret < 0 || alert_level <1)
		return SUCCESS;
	ret = Send_Alert_Mail_To_Queue(Subject,Msg,Level);*/
    	ret = Get_Alert_SMTP_Server_IP(smtp_ip, sizeof(smtp_ip));
	if(strcasecmp(smtp_ip,"")==0) return 0;
	Get_Alert_Mail_Address(alert_mailaddr, sizeof(alert_mailaddr));
	if(strcasecmp(alert_mailaddr,"")==0) return 0;
	Send_Mail(Subject, Msg, alert_mailaddr, smtp_ip, Level);
	return ret;
}

int lock_queue(void)
{
	int file_desc;
    	int retry = 3;

   	file_desc = open(MAILOG_LCK, O_RDWR | O_CREAT | O_EXCL, 0444);
    	if (file_desc == -1) {
    		while(retry--) {
    			file_desc = open(MAILOG_LCK, O_RDWR | O_CREAT | O_EXCL, 0444);
    			if(file_desc != -1) {
    				close(file_desc);
    				return SUCCESS;
    			}
    			sleep(1);
    		}
    		return ERROR_FAIL;
    	}
    	else 
    		close(file_desc);
    		
    		return ERROR_FAIL;
}

void unlock_queue(void)
{
	unlink(MAILOG_LCK);
}

int Send_Alert_Mail_To_Queue(char *Subject, char *Msg, char *Level)
{
	FILE *fp = NULL;
	MAILINFO m_mail;
	int log_cnt = 0;
	int ret = SUCCESS;
	
	if(!lock_queue()) return ERROR_FAIL;
	
	//if mail log not exist,initialize it!
	if((fp = fopen(MAILOG,"r")) == NULL) {
		fp=fopen(MAILOG,"w");
		fwrite(&log_cnt,sizeof(int),1,fp);	
		fclose(fp);
		
	}
	else
		fclose(fp);
	
	//write mail info to log
	if((fp = fopen(MAILOG,"rb+")) != NULL) {
		
		//set log cnt 
		rewind(fp);
		fread(&log_cnt,sizeof(int),1,fp);
		
		log_cnt++;
		rewind(fp);
		fwrite(&log_cnt,sizeof(int),1,fp);

		fseek(fp,0L,SEEK_END);
		
		//put mail data in MAILINFO structure
		if(strlen(Subject) < MAIL_SUBJECT_MAX)
			strcpy(m_mail.Subject,Subject);
		else {
			strncpy(m_mail.Subject,Subject,MAIL_SUBJECT_MAX-1);
			m_mail.Subject[MAIL_SUBJECT_MAX-1] = '\0';
		}
		
		if(strlen(Msg) < MAIL_MSG_MAX)
			strcpy(m_mail.Msg,Msg);
		else {
			strncpy(m_mail.Msg,Msg,MAIL_MSG_MAX-1);
			m_mail.Msg[MAIL_MSG_MAX-1] = '\0';
		}
		
		if(strlen(Level) < MAIL_LEVEL_MAX)
			strcpy(m_mail.Level,Level);
		else {
			strncpy(m_mail.Level,Level,MAIL_LEVEL_MAX-1);
			m_mail.Level[MAIL_LEVEL_MAX-1] = '\0';
		}	
		
		fwrite((const void *) &m_mail,sizeof(MAILINFO),1,fp);
		fclose(fp);
		ret = SUCCESS;
	}
    	else 
    		ret = ERROR_FAIL;
    		
    	unlock_queue();
	return ret;
}


//return value is read mail log cnt,so return =0 indicates no mail logs in queue;

int Read_Alert_Mail_From_Queue(MAILINFO *mail_info_list,int list_cnt)
{
	FILE *fp = NULL, *tmpfp = NULL;
	MAILINFO m_mail;
	int log_cnt;
	int ret = SUCCESS;
	
	if(!lock_queue()) return ERROR_FAIL;
	
	if((fp = fopen(MAILOG,"rb+")) != NULL) {
		rewind(fp);
		ret = fread(&log_cnt,sizeof(int),1,fp);
		if(ret == 0) {
			fclose(fp);
			unlink(MAILOG);
			unlock_queue();
			return ERROR_FAIL;
		}

		if(list_cnt == 0) {
			fclose(fp);
			unlock_queue();
			return log_cnt;
		}
		
			
		if(list_cnt <= log_cnt) {
			tmpfp = tmpfile();
			if((ret=fread((void *)mail_info_list,sizeof(MAILINFO),list_cnt,fp))== list_cnt) {
				log_cnt = log_cnt - list_cnt;
				rewind(tmpfp);
				while(fread((void *)&m_mail,sizeof(MAILINFO),1,fp)>0)
					fwrite(&m_mail,sizeof(MAILINFO),1,tmpfp);
				
				fclose(fp);
				
				fp = fopen(MAILOG,"w");
				fwrite(&log_cnt,sizeof(int),1,fp);
				rewind(tmpfp);
				while(fread((void *)&m_mail,sizeof(MAILINFO),1,tmpfp)>0)
					fwrite(&m_mail,sizeof(MAILINFO),1,fp);
					
			}
			else
				ret = ERROR_FAIL;
			fclose(tmpfp);
		}
		else {
			if((ret=fread((void *)mail_info_list,sizeof(MAILINFO),log_cnt,fp))== log_cnt) {
				fclose(fp);
				fp = fopen(MAILOG,"w");
				log_cnt = 0;
				fwrite(&log_cnt,sizeof(int),1,fp);
			}
			else
				ret = ERROR_FAIL;
		}
		fclose(fp);
		ret = SUCCESS;
	}
	else 
		ret = ERROR_FAIL;
	
	unlock_queue();	
	return ret;
}

/* Shone ported from Model TS-401 2005,09,29
 * Get Alert SMTP Authentication
 * Return:
 *      0     pass
 *      ERROR_READ_FILE can not read config file
 */
int Get_Alert_SMTP_Auth(char *buf, int buf_size)
{
	int val, ret = SUCCESS;

	val = GetProfileString(SZ_ALERT_SECTION, SZ_ALERT_SMTP_AUTH, "OFF", buf, buf_size);
	if(!val)
		return ERROR_READ_FILE;
	return ret;
}

/* Shone ported from Model TS-401 2005,09,29
 * Set Alert SMTP Authentication
 * Return:
 *      0                       pass
 *      ERROR_WRITE_FILE        can not write config file
 */
int Set_Alert_SMTP_Auth(char *buf)
{
	int val, ret = SUCCESS;

	val = WriteProfileString(SZ_ALERT_SECTION, SZ_ALERT_SMTP_AUTH, buf);
	if(!val)
		return ERROR_WRITE_FILE;
	return ret;
}

/* Shone ported from Model TS-401 2005,09,29
 * Get Alert SMTP User Name
 * Return:
 *      0                       pass
 *      ERROR_READ_FILE can not read config file
 */
int Get_Alert_SMTP_Username(char *buf, int buf_size)
{
	int val, ret = SUCCESS;

	val = GetProfileString(SZ_ALERT_SECTION, SZ_ALERT_SMTP_USERNAME, "", buf, buf_size);
	if(!val)
		return ERROR_READ_FILE;
	return ret;
}

/* Shone ported from Model TS-401 2005,09,29
 * Set Alert SMTP User Name
 * Return:
 *      0                       pass
 *      ERROR_WRITE_FILE        can not write config file
 */
int Set_Alert_SMTP_Username(char *buf)
{
	int val, ret = SUCCESS;

	val = WriteProfileString(SZ_ALERT_SECTION, SZ_ALERT_SMTP_USERNAME, buf);
	if(!val)
		return ERROR_WRITE_FILE;
	return ret;
}

/* Shone ported from Model TS-401 2005,09,29
 * Get Alert SMTP Password
 * Return:
 *      0                       pass
 *      ERROR_READ_FILE can not read config file
 */
int Get_Alert_SMTP_Password(char *buf, int buf_size)
{
	int val, ret = SUCCESS;

	val = GetProfileString(SZ_ALERT_SECTION, SZ_ALERT_SMTP_PASSWORD, "", buf, buf_size);
	if(!val)
		return ERROR_READ_FILE;
	return ret;
}

/* Shone ported from Model TS-401 2005,09,29
 * Set Alert SMTP Password
 * Return:
 *      0                       pass
 *      ERROR_WRITE_FILE        can not write config file
 */
int Set_Alert_SMTP_Password(char *buf)
{
	int val, ret = SUCCESS;

	val = WriteProfileString(SZ_ALERT_SECTION, SZ_ALERT_SMTP_PASSWORD, buf);
	if(!val)
		return ERROR_WRITE_FILE;
	return ret;
}


