#include <stdio.h>
#include <string.h>
#include <termios.h>

#include "NAS.h"
#include "Util.h"


char	input_buf[16][BUF_SIZE];
int	return_value;
char	*return_string;

char	group_list[MAX_GROUP_NUMBER][GROUP_NAME_LENGTH];

void pressanykey(void);

void dump_group_list(int count)
{
	int i;
	for (i = 0; i < count; i++) {
		if (i != 0) printf(",");
		printf("%s", group_list[i]);
	}
	if (i != 0) printf(".\n");
}

int get_parameters_number(int function_no)
{
	switch (function_no) {
		case 1:
			return 2;
		case 2:
			return 1;
		case 3:
			return 1;
		case 4:
			return 2;
		case 5:
			return 2;
		case 6:
			return 2;
	        case 7:
			return 1;		
	        case 8:
			return 1;				
	        case 9:
			return 2;
		case 10:
			return 1;
		case 11:
			return 1;
		case 12:
			return 2;
		case 13:
		case 14:
		case 15:
			return 0;
		case 16:
			return 3;
		case 17:
			return 3;
		case 18:
		case 19:
			return 0;
		case 20: 
		case 21:
			return 1;
		case 22:
		case 23:
			return 0;
		case 24:
		case 25:
			return 1;	
		case 26:
			return 1;
		case 27: 
			return 2;				
	}
}

void exec_and_show_result(int function_no)
{
  	NAS_SHARE_INFO share_ptr;   
  	char tmp_usr_name[USER_NAME_LENGTH];    
  	int i;
  	SECTION_INFO section_ptr[MAX_SECTION_NUMBER];
  	SHARE_NAME_LIST share_name_list[MAX_SHARE_NUMBER];

	switch (function_no) {
		case 1:
			return_value = Create_NAS_User(input_buf[0], input_buf[1]);
			printf("return value = %d\n", return_value);
			break;
		case 2:	
			printf("------2------\n");
			return_value = Remove_NAS_User(input_buf[0]);
			printf("return value = %d\n", return_value);
			break;
		case 3:
			return_value = Get_NAS_Group_List_Of_User(input_buf[0], group_list, MAX_GROUP_NUMBER);
			if (return_value > 0) dump_group_list(return_value);
			printf("return value = %d\n", return_value);
			break;
		case 4:
			return_value = Add_NAS_User_To_Group(input_buf[0], input_buf[1]);
			printf("return value = %d\n", return_value);
			break;
		case 5:
			return_value = Remove_NAS_User_From_Group(input_buf[0], input_buf[1]);
			printf("return value = %d\n", return_value);
			break;
		case 6:
			return_value = Get_NAS_User_Security_For_Share(input_buf[0], input_buf[1]);
			printf("return value = %d\n", return_value);
			break;
                case 7:
		        
		        strcpy(share_ptr.share_name,input_buf[0]); 
                        share_ptr.read_list_cnt = 0;       
			share_ptr.read_list_ptr = NULL;       
			share_ptr.write_list_cnt = 0;     
			share_ptr.read_list_ptr = NULL;       

                        return_value = Get_NAS_Share_Info(&share_ptr);
			if ( return_value ==0 ) {
			  int  i;
			  printf("Share Name=%s \n",share_ptr.share_name);
			  printf("Comment   =%s \n",share_ptr.comment);
			  printf("Path      =%s \n",share_ptr.path);
	
			}
			else printf("return value = %d \n",return_value);
			
			break;
		case 8:
			return_value = Get_NAS_User_Accessible_Share_List(input_buf[0], share_name_list,sizeof(share_name_list)/sizeof(SHARE_NAME_LIST));
			
			if ( return_value > 0 ) {
                           int i;

			   for(i=0; i<return_value; i++) {
			     printf("section_name[%02d]=%s \n",i,
				    share_name_list[i].share_name);
			   }
			   
			}
			else printf("return value = %d\n", return_value);

			break;	
		case 9:
			return_value = User_Belongs_To_Group(input_buf[0], input_buf[1]);
			printf("return value = %d\n", return_value);
			break;
		case 10:
			if(TRUE) {
				char read_list[3][USER_NAME_LENGTH];
				char write_list[3][USER_NAME_LENGTH];
				int i;
				for (i=0;i<3;i++) {
					sprintf(read_list[i],"user%d",i);	
					sprintf(write_list[i],"user%d",i);
				}
				strcpy(share_ptr.share_name,input_buf[0]);
				strcpy(share_ptr.comment,"This is test");
				strcpy(share_ptr.path,"/home/louis");
				share_ptr.read_list_cnt=3;
				share_ptr.write_list_cnt=3;
				share_ptr.read_list_ptr = read_list;	
				share_ptr.write_list_ptr = write_list;	
			        printf("ret = %d\n",Create_NAS_Share(&share_ptr));
			}
		        break;
		case 11:
			printf("ret = %d",Remove_NAS_Share(input_buf[0]));
			break;
		case 12:
			{
				int ret;
				if ( (ret=Get_NAS_User_List_For_Share(input_buf[0],input_buf[1][0],NULL,0))>0) {
					char member[ret][USER_NAME_LENGTH];
					int i=0;
					ret = Get_NAS_User_List_For_Share(input_buf[0],input_buf[1][0],member,ret);
					printf("ret = %d\n",ret);
					printf("[Test] read list = ");
					for(i=0;i<ret;i++)
						printf("%s ",member[i]);
					printf("\n");
				}
				else 
					printf("ret = %d\n",ret);
			break;
			}
		case 13:
			if(TRUE) {
				char read_list[3][USER_NAME_LENGTH];
				char write_list[3][USER_NAME_LENGTH];
				char share_name[20];
				int i;
				
				for (i=0;i<3;i++) {
					sprintf(read_list[i],"add%d",i);	
					sprintf(write_list[i],"add%d",i);
				}
			printf("ret= %d\n",Add_NAS_User_List_For_Share("test",'r',read_list,3));
			}
			break;
		case 14:
			if(TRUE) {
				char read_list[3][USER_NAME_LENGTH];
				char write_list[3][USER_NAME_LENGTH];
				int i;
				for (i=0;i<3;i++) {
					sprintf(read_list[i],"add%d",i);	
					sprintf(write_list[i],"add%d",i);
				}
			printf("ret= %d\n",Remove_NAS_User_List_For_Share("test",'r',read_list,3));
			}
			break;
		case 15:
			{
				SECTION_INFO list[20];
				int i,ret;
				ret = Get_NAS_Share_List(list,20);
				printf("ret =%d\nSection Name list :",ret);
				for(i=0;i<ret;i++)
					printf("%s\n",list[i].section_name);
			}
			break;
		case 16:
			return_value = Add_NAS_User_For_Share(input_buf[0], input_buf[1][0],input_buf[2]);
			printf("return value = %d\n", return_value);
			break;
		case 17:
			return_value = Remove_NAS_User_For_Share(input_buf[0], input_buf[1][0],input_buf[2]);
			printf("return value = %d\n", return_value);
			break;
		case 18:
			for(i=0;i<100;i++) {
				sprintf(tmp_usr_name,"user%d",i);
				return_value = Create_System_User(tmp_usr_name,"","everyone", NULL);
				printf("%dreturn value = %d\n", i,return_value);
			}
			break;
		case 19:
			for(i=0;i<100;i++) {
				sprintf(tmp_usr_name,"user%d",i);
				return_value = Remove_System_User(tmp_usr_name);
				printf("%dreturn value = %d\n", i,return_value);
			}
			break;
		case 20:
			for(i=0;i<100;i++) {
				sprintf(tmp_usr_name,"user%d",i);
				if( Is_System_Group(input_buf[0]) == FALSE )
					Create_System_Group(input_buf[0]);
				return_value = Add_NAS_User_To_Group(tmp_usr_name,input_buf[0]);
				printf("%dreturn value = %d\n", i,return_value);
				if(return_value <0) break;
				usleep(100);
			}
			break;
		case 21:
			for(i=100;i>=0;i--) {
				sprintf(tmp_usr_name,"user%d",i);
				
				return_value=Remove_NAS_User_From_Group(tmp_usr_name,input_buf[0]);
				printf("%dreturn value = %d\n", i,return_value);
				usleep(100);	
			}
			break;
		case 22:
			{
				SAMBA_STATUS_INFO u_list[20];
				return_value = Get_Samba_Status(u_list,20);
				printf("%d\n",return_value);	
				for (i=0;i<return_value;i++)
					printf("%s %s %s(%s) %s\n",u_list[i].service,u_list[i].user_name,u_list[i].from_name,u_list[i].ip,u_list[i].login_time);
				
				
			}
			break;
		case 23:
			{
				char u_list[1024][USER_NAME_LENGTH];
				int count;
				count=Get_NAS_User_List(u_list,1024);
				for(i=0;i<count;i++)
					printf("%s\n",u_list[i]);
			}
			break;
		case 24:
			return_value =Remove_User_Share_Privilege(input_buf[0]);
			printf("return value = %d\n",return_value);
			break;
		case 25:
			return_value =Remove_Group_Share_Privilege(input_buf[0]);
			printf("return value = %d\n",return_value);
			break;
		case 26:
			{
			char u_list[20][USER_NAME_LENGTH];
			return_value = Get_Active_Connection_For_Nas_Share(input_buf[0],u_list,20);
			for(i = 0;i<return_value;i++)
				printf("user name %d = %s\n",i,u_list[i]);
			printf("return value = %d\n",return_value);
			return_value = Get_Active_Connection_For_Nas_Share(input_buf[0],NULL,0);
			printf("return value = %d\n",return_value);
			}
			break;
		case 27:
			{
				int cnt = Get_Nas_Share_List_For_Path(input_buf[0],NULL,0,atoi(input_buf[1]));				
				if(cnt>0){
					SHARE_NAME_LIST sh_name_list[cnt];
					int i;
					return_value = Get_Nas_Share_List_For_Path(input_buf[0],sh_name_list,cnt,atoi(input_buf[1]));	
					for(i=0;i<return_value;i++)
						printf("[%s]\n",sh_name_list[i].share_name);
				}
				else
					return_value = cnt;
				printf("return value = %d\n",return_value);
			}
		default:
			printf("--------default----\n");
		
	}
}

void print_menu()
{
	printf("===============================================================\n");
	printf("0. Quit\n");
	printf("1. int Create_NAS_User(char *user_name, char *pass_wd);\n");
	printf("2. int Remove_NAS_User(char *user_name);\n");
	printf("3. int Get_NAS_Group_List_Of_User(char *user_name, char (*group_list)[GROUP_NAME_LENGTH], int list_cnt);\n");
	printf("4. int Add_NAS_User_To_Group(char *user_name, char *grp_name);\n");
	printf("5. int Remove_NAS_User_From_Group(char *user_name, char *grp_name);\n");
	printf("6. int Get_NAS_User_Security_For_Share(char *user_name, char *share_name);\n");
	printf("7. int Get_NAS_Share_Info(NAS_SHARE_INFO *), I/P Share Name;\n");
	printf("8. int Get_NAS_User_Accessible_Share_List(char *user_name, SESSION_INFO *section_ptr, int section_cnt), I/P User Name;\n");
	printf("9. BOOL User_Belongs_To_Group(char *user_name, char *group_name);\n");
	printf("10. Create_NAS_Share()\n");
	printf("11. Remove_NAS_Share()\n");
	printf("12. Get_NAS_User_List_For_Share()\n");
	printf("13. Add_NAS_User_List_For_Share()\n");
	printf("14. Remove_NAS_User_List_For_Share()\n");
	printf("15. Get_NAS_Share_List()\n");
	printf("16. Add_NAS_User_For_Share()\n");
	printf("17. Remove_NAS_User_For_Share()\n");
	printf("18. Add 5000 new user - user0 ~ user5000 (belong to everyone)\n");
	printf("19. Remove 5000 system(user0~user5000)\n");
	printf("20. Add 5000 system user to a group(user0~user5000)\n");
	printf("21. remove 5000 system user to a group(user0~user5000)\n");
	printf("22. Get active samba user.\n");
	printf("23. Get_NAS_User_List().\n");
	printf("24. Remove_User_Share_Privilege(char *usr_name) \n");
	printf("25. Remove_Group_Share_Privilege(char *grp_name) \n");
	printf("26. Get_Active_Connection_For_Nas_Share(char *share_name, char (*user_list)[USER_NAME_LENGTH],int list_cnt)\n");
	printf("27. Get_Nas_Share_List_For_Path(char *path, char *share_name_list,int list_cnt,int file_flag)\n");
	printf("===============================================================\n");
}
 


main()
{
	int i, j, f;
	char ch;
	for (;;) {
		print_menu();
		scanf("%d", &f);
		if (f == 0) break;
		j = get_parameters_number(f);
		for (i = 0; i < j; i++) {
			printf("Parameter %d = ", i+1);
			scanf("%s", input_buf[i]);
		}
		exec_and_show_result(f);
		pressanykey();
	}


 PRG_END:
  exit (0);
}



void pressanykey(void)
{
    FILE *input;
    struct termios initial_settings, new_settings;
    char choice;

    if (!isatty(fileno(stdout))) {
        fprintf(stderr,"You are not a terminal, OK.\n");
    }

    input = fopen("/dev/tty", "r");
    if(!input) {
        fprintf(stderr, "Unable to open /dev/tty\n");
        exit(1);
    }

    tcgetattr(fileno(input),&initial_settings);
    new_settings = initial_settings;
    new_settings.c_lflag &= ~ICANON;
    new_settings.c_lflag &= ~ECHO;
    new_settings.c_cc[VMIN] = 1;
    new_settings.c_cc[VTIME] = 0;
    new_settings.c_lflag &= ~ISIG;
    if(tcsetattr(fileno(input), TCSANOW, &new_settings) != 0) {
        fprintf(stderr,"could not set attributes\n");
    }
    
    printf("press any key to continue");
    
    do {
	  fgetc(input);
    } while (choice == "");
    tcsetattr(fileno(input),TCSANOW,&initial_settings);
}




