#!/bin/sh

# Create by Kent 2005/09/19

HIDDEN_CONF_FILE=/mnt/HDA_ROOT/.conf
HIDDEN_CONF_DIR=/mnt/HDA_ROOT/.config
TS_CONF_DIR=/etc/config
HIDDEN_LOG_DIR=/mnt/HDA_ROOT/.logs
TS_LOG_DIR=/etc/logs


case "$1" in
    start)
	/sbin/storage_boot_init 1
	# create config symbolic link and event log symbolic link
	if [ -f $HIDDEN_CONF_FILE ] && [ -d $HIDDEN_CONF_DIR ]; then
        	echo config hidden config directory exist, create symbolic link $TS_CONF_DIR... [OK]
		# create $TS_CONF_DIR
        	/bin/rm -rf $TS_CONF_DIR
	        /bin/ln -sf $HIDDEN_CONF_DIR $TS_CONF_DIR
		/bin/cp -a ${HIDDEN_CONF_DIR}/TZ /etc/
		/sbin/hwclock --hctosys
		TS_MODEL=`/sbin/getcfg System "Internal Model" -f /etc/default_config/uLinux.conf`
		/sbin/setcfg System "Internal Model" $TS_MODEL
		TS_VERSION=`/sbin/getcfg System Version -f /etc/default_config/uLinux.conf`
		/sbin/setcfg System Version $TS_VERSION
		TS_BUILDNUM=`/sbin/getcfg System "Build Number" -f /etc/default_config/uLinux.conf`
		/sbin/setcfg System "Build Number" $TS_BUILDNUM
	fi

	if [ -f $HIDDEN_CONF_FILE ] && [ -d $HIDDEN_LOG_DIR ]; then
		# create $TS_LOG_DIR
		if [ ! -f $HIDDEN_LOG_DIR/nas4000.log ]; then
			echo log file not found, create symboloc link $TS_LOG_DIR and initial 1M log file... [OK]
			/bin/cp $TS_LOG_DIR/nas4000.* $HIDDEN_LOG_DIR
			/bin/dd if=/dev/zero of=$HIDDEN_LOG_DIR/nas4000_1.log bs=1014k count=1 2>/dev/null 1>/dev/null
			/bin/cat $HIDDEN_LOG_DIR/nas4000_1.log >> $HIDDEN_LOG_DIR/nas4000.log
			/bin/rm $HIDDEN_LOG_DIR/nas4000_1.log
			/bin/rm -rf $TS_LOG_DIR
			/bin/ln -sf $HIDDEN_LOG_DIR $TS_LOG_DIR
		else
			/usr/bin/readlink $TS_LOG_DIR 2> /dev/null 1>/dev/null
			if [ $? != 0 ]; then
				# TS_LOG_DIR link not exist
				echo log hidden config directory exist, create symboloc link $TS_LOG_DIR... [OK]
				/bin/ln -sf $HIDDEN_LOG_DIR $TS_LOG_DIR
			fi
		fi
	else
		echo log hidden config directory not exist, initial 10K log file... [OK]
		/bin/mkdir $TS_LOG_DIR
		/bin/dd if=/dev/zero of=$TS_LOG_DIR/nas4000.log bs=10k count=1 2>/dev/null 1>/dev/null
	fi
	;;
    stop)
	# nothing to do
	;;
    restart)
	$0 stop
	$0 start
	;;
    *)
	echo "Usage: /etc/init.d/sysinit.sh {start|stop|restart}"
	exit 1
esac

exit 0
