#!/bin/sh
if [ `/sbin/getcfg "RTRR" "Support" -u -d FALSE` = FALSE ];
then
	echo "RTRR function is not supported in the model."
	exit 1 
fi

[ -f /usr/bin/rsyncd ] || exit -1

case "$1" in
    start)
	[ -s /etc/rsyncd.conf ] || exit -1
    	echo "Starting rsyncd daemon:"
	
	if [ `/sbin/getcfg "RTRR" "Enable" -u -d FALSE` = FALSE ];
	then
		echo "Rsyncd server is not enabled now..."
		exit 0 
	fi

	port=`/sbin/getcfg "RTRR" "Port" -d 873`
	echo Port = ${port}
	[ -z "`/sbin/pidof rsyncd`" ] && \
		/sbin/daemon_mgr rsyncd start "/usr/bin/rsyncd --daemon --port=${port}"
	echo " rsyncd start"	
	;;
    stop)
	echo "Shutting down rsyncd daemon:"
	/sbin/daemon_mgr rsyncd stop "/usr/bin/rsyncd"
	echo " rsyncd stop"	
	;;
    restart)
	$0 stop
	$0 start
	;;	
  *)
        echo "Usage: /etc/init.d/rsyncd.sh {start|stop|restart}"
        exit 1
esac

exit 0

