#!/bin/sh
#
# Copyright @ 2005 QNAP Systems Inc.
#
# network	This script start/stop/restart network.
#
# Version	1.0.0
#
# Author	Paul Chen
#

GETCFG="/sbin/getcfg"
SETCFG="/sbin/setcfg"
DAEMON_MGR="/sbin/daemon_mgr"

use_default()
{
	/sbin/ifconfig $1 169.254.100.100 up
	/sbin/route add -host 255.255.255.255 $1
	/sbin/route del -net 169.254.0.0 netmask 255.255.0.0 dev $1
	/sbin/route add -net 169.254.0.0 netmask 255.255.0.0 dev $1
}

write_hosts()
{
	local ip
	local hostname

	echo "127.0.0.1		localhost		localhost" > /etc/hosts
	ip=`/sbin/ifconfig $1 | grep "inet addr" | cut -f 2 -d ':' | cut -f 1 -d ' '`
	if [ $ip != "" ]; then
		hostname=`/bin/hostname`
		echo "$ip		$hostname		$hostname" >> /etc/hosts
	fi
}

add_dns()
{
	local nas_dns
	local myflag=0
	local i

#	[ -f /etc/resolv.conf ] && /bin/cp /etc/resolv.conf /etc/resolv.bak -f
#
#	nas_dns=`/sbin/getcfg "Network" DNS -d 0.0.0.0`
#	if [ "$nas_dns" != "0.0.0.0" ]; then
#		/bin/echo "nameserver $nas_dns" >> /etc/resolv.conf
#		myflag=1
#	fi

	if [ "$1" = "STATIC" ]; then
		/bin/rm -f /etc/resolv.conf
	fi

	for i in 2 1
	do
		nas_dns=`/sbin/getcfg "Network" "Domain Name Server $i" -d 0.0.0.0`
		if [ "$nas_dns" != "0.0.0.0" ]; then
			[ -f /etc/resolv.conf ] && /bin/mv /etc/resolv.conf /etc/resolv.conf.bak
			/bin/echo "nameserver $nas_dns" > /etc/resolv.conf
			if [ -f /etc/resolv.conf.bak ]; then
				/bin/cat /etc/resolv.conf.bak >> /etc/resolv.conf
				/bin/rm -f /etc/resolv.conf.bak
			fi
			myflag=1
		fi
	done

	if [ $myflag = 0 ]; then
		/bin/echo "nameserver 0.0.0.0" >> /etc/resolv.conf
	fi
}

remove_dns()
{
	rm -f /etc/resolv.conf
}

set_mtu()
{
	sleep 3
	/sbin/eth_util -s eth0
	SPEED=`$GETCFG eth0 Speed -d 100`
	echo "Speed: $SPEED"
	if [ "$SPEED" = "1000" ]; then
		MTU=`$GETCFG eth0 MTU -d 1500`
		/sbin/ifconfig eth0 mtu $MTU
	else
		/sbin/setcfg eth0 MTU 1500
		/sbin/ifconfig eth0 mtu 1500
	fi
}

start() 
{
 	echo -n "Starting network..."

	local ifdev_num=`$GETCFG "Network" "Interface Number" -d "1"`
        local ipaddress=`$GETCFG "eth0" "IP Address" -d "169.254.100.100"`
        local netmask=`$GETCFG "eth0" "Subnet Mask" -d "255.255.0.0"`
        local broadcast=`$GETCFG "eth0" "Broadcast" -d "169.254.255.255"`
        local gateway=`$GETCFG "eth0" "Gateway" -d "0.0.0.0"`
	
	if [ "$ifdev_num" = "1" ]; then
		if [ `$GETCFG "eth0" "Use DHCP" -u -d "TRUE"` = "TRUE" ]; then
			echo "DHCP"
			use_default eth0
			add_dns "STATIC"
			rm -f /etc/dhcpc/dhcpcd-eth0.pid
			/sbin/dhcpcd -t 30 eth0 &
			#if [ $? != 0 ]; then #if get dhcp fail, use default ip
			#	use_default eth0
			#	add_dns "STATIC"
			#else
			#	add_dns
			#fi
		else
			echo "STATIC"
			if [ "$gateway" = "0.0.0.0" ]; then
				gateway=$ipaddress
			fi
			/sbin/ifconfig eth0 $ipaddress netmask $netmask broadcast $broadcast up
			/sbin/route add -host $ipaddress eth0
			/sbin/route add default gw $gateway metric 1 eth0
			add_dns "STATIC"
		fi
	fi
}
	
stop() 
{
	echo -n "Stopping network..."
	local pid

	remove_dns
	/sbin/ifconfig eth0 down
	pid=`pidof dhcpcd`
	if [ ! -z $pid ]; then 
		kill $pid
	fi
	echo "Stopped."
}

restart() 
{
	stop
	start
}	

case "$1" in
	start)
		$0 stop 
		start
		write_hosts eth0
		/etc/init.d/gen_issue.sh
		set_mtu
		;;

	stop)
		stop
		;;

	restart)
		restart
		write_hosts eth0
		set_mtu
		;;

	setdns)
		add_dns
		;;

	*)
		echo $"Usage: $0 {start|stop|restart}"
		exit 1
esac

exit 0

